# TransmissionRelationshipTypeCode - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **TransmissionRelationshipTypeCode**

## CodeSystem: TransmissionRelationshipTypeCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-TransmissionRelationshipTypeCode | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:TransmissionRelationshipTypeCode |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1111 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:**A code specifying the meaning and purpose of every TransmissionRelationship instance. Each of its values implies specific constraints to what kinds of Transmission objects can be related and in which way. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TransmissionRelationshipTypeCode](ValueSet-v3-TransmissionRelationshipTypeCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-TransmissionRelationshipTypeCode",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-TransmissionRelationshipTypeCode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1111"
    }
  ],
  "version" : "3.0.0",
  "name" : "TransmissionRelationshipTypeCode",
  "title" : "TransmissionRelationshipTypeCode",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:**A code specifying the meaning and purpose of every TransmissionRelationship instance. Each of its values implies specific constraints to what kinds of Transmission objects can be related and in which way.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "SEQL",
      "display" : "sequence",
      "definition" : "**Description:**A transmission relationship indicating that the source transmission follows the target transmission.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22039"
        }
      ]
    }
  ]
}

```
