# TelecommunicationCapabilities - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **TelecommunicationCapabilities**

## CodeSystem: TelecommunicationCapabilities 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-TelecommunicationCapabilities | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:TelecommunicationCapabilities |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1118 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:** Concepts that define the telecommunication capabilities of a particular device. Used to identify the expected capabilities to be found at a particular telecommunication address. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TelecommunicationCapabilities](ValueSet-v3-TelecommunicationCapabilities.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-TelecommunicationCapabilities",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-TelecommunicationCapabilities",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1118"
    }
  ],
  "version" : "3.0.0",
  "name" : "TelecommunicationCapabilities",
  "title" : "TelecommunicationCapabilities",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:** Concepts that define the telecommunication capabilities of a particular device. Used to identify the expected capabilities to be found at a particular telecommunication address.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "data",
      "display" : "data",
      "definition" : "**Description:** This device can receive data calls (i.e. modem).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22725"
        }
      ]
    },
    {
      "code" : "fax",
      "display" : "fax",
      "definition" : "**Description:** This device can receive faxes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22724"
        }
      ]
    },
    {
      "code" : "sms",
      "display" : "sms",
      "definition" : "**Description:** This device can receive SMS messages.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22727"
        }
      ]
    },
    {
      "code" : "tty",
      "display" : "text",
      "definition" : "**Description:** This device is a text telephone.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22726"
        }
      ]
    },
    {
      "code" : "voice",
      "display" : "voice",
      "definition" : "**Description:** This device can receive voice calls (i.e. talking to another person, or a recording device, or a voice activated computer).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22723"
        }
      ]
    }
  ]
}

```
