# TargetAwareness - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **TargetAwareness**

## CodeSystem: TargetAwareness 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-TargetAwareness | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:TargetAwareness |
| *Other Identifiers:*OID:2.16.840.1.113883.5.137 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A code specifying the extent to which the Entity playing the participating Role (usually as a target Participation) is aware of the associated Act. 
**Examples:** For diagnostic observations, is the patient, family member or other participant aware of his terminal illness? 
**Discussion:** If the awareness, denial, unconsciousness, etc. is the subject of medical considerations (e.g., part of the problem list), one should use explicit observations in these matters as well, and should not solely rely on this simple attribute in the Participation. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TargetAwareness](ValueSet-v3-TargetAwareness.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-TargetAwareness",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-TargetAwareness",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.137"
    }
  ],
  "version" : "3.0.0",
  "name" : "TargetAwareness",
  "title" : "TargetAwareness",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A code specifying the extent to which the Entity playing the participating Role (usually as a target Participation) is aware of the associated Act.\r\n\r\n*Examples:* For diagnostic observations, is the patient, family member or other participant aware of his terminal illness?\r\n\r\n*Discussion:* If the awareness, denial, unconsciousness, etc. is the subject of medical considerations (e.g., part of the problem list), one should use explicit observations in these matters as well, and should not solely rely on this simple attribute in the Participation.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "D",
      "display" : "denying",
      "definition" : "Target person has been informed about the issue but currently denies it.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10313"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "full awareness",
      "definition" : "Target person is fully aware of the issue.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10311"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "incapable",
      "definition" : "Target person is not capable of comprehending the issue.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10316"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "marginal",
      "definition" : "Target person is marginally aware of the issue.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10315"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "partial",
      "definition" : "Target person is partially aware of the issue.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10314"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "uninformed",
      "definition" : "Target person has not yet been informed of the issue.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10312"
        }
      ]
    }
  ]
}

```
