# QueryQuantityUnit - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QueryQuantityUnit**

## CodeSystem: QueryQuantityUnit 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-QueryQuantityUnit | *Version*:2.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*Health Level 7 | *Computable Name*:QueryQuantityUnit |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1066 | | |

 
Values in this domain specify the units of a query quantity limited request. 
**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. This is a holdover. It is not referenced. It is superseded by QueryRequestLimit. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-QueryQuantityUnit",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-QueryQuantityUnit",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1066"
    }
  ],
  "version" : "2.0.1",
  "name" : "QueryQuantityUnit",
  "title" : "QueryQuantityUnit",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level 7",
  "contact" : [
    {
      "name" : "Health Level Seven"
    }
  ],
  "description" : "Values in this domain specify the units of a query quantity limited request.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. This is a holdover. It is not referenced. It is superseded by QueryRequestLimit.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "CH",
      "display" : "Characters",
      "definition" : "Used where size of input buffer has limitations.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16016"
        }
      ]
    },
    {
      "code" : "LI",
      "display" : "Lines",
      "definition" : "Used where lines of respone has limitations.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16017"
        }
      ]
    },
    {
      "code" : "PG",
      "display" : "Pages",
      "definition" : "Used where pages of response has limitations.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16018"
        }
      ]
    },
    {
      "code" : "RD",
      "display" : "Records",
      "definition" : "Used where number of records or instances of items in the query response result set has limitations.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16019"
        }
      ]
    }
  ]
}

```
