# PersonDisabilityType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PersonDisabilityType**

## CodeSystem: PersonDisabilityType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-PersonDisabilityType | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PersonDisabilityType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.93 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A code identifying a person's disability. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MobilityImpaired](ValueSet-v3-MobilityImpaired.md)
* [PersonDisabilityType](ValueSet-v3-PersonDisabilityType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-PersonDisabilityType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-PersonDisabilityType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.93"
    }
  ],
  "version" : "3.0.0",
  "name" : "PersonDisabilityType",
  "title" : "PersonDisabilityType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A code identifying a person's disability.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "1",
      "display" : "Vision impaired",
      "definition" : "Vision impaired",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10182"
        }
      ]
    },
    {
      "code" : "2",
      "display" : "Hearing impaired",
      "definition" : "Hearing impaired",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10183"
        }
      ]
    },
    {
      "code" : "3",
      "display" : "Speech impaired",
      "definition" : "Speech impaired",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10184"
        }
      ]
    },
    {
      "code" : "4",
      "display" : "Mentally impaired",
      "definition" : "Mentally impaired",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10185"
        }
      ]
    },
    {
      "code" : "5",
      "display" : "Mobility impaired",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10186"
        }
      ],
      "concept" : [
        {
          "code" : "CB",
          "display" : "Requires crib",
          "definition" : "A crib is required to move the person",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15951"
            }
          ]
        },
        {
          "code" : "CR",
          "display" : "Requires crutches",
          "definition" : "Person requires crutches to ambulate",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15947"
            }
          ]
        },
        {
          "code" : "G",
          "display" : "Requires gurney",
          "definition" : "A gurney is required to move the person",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15950"
            }
          ]
        },
        {
          "code" : "WC",
          "display" : "Requires wheelchair",
          "definition" : "Person requires a wheelchair to be ambulatory",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15949"
            }
          ]
        },
        {
          "code" : "WK",
          "display" : "Requires walker",
          "definition" : "Person requires a walker to ambulate",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15948"
            }
          ]
        }
      ]
    }
  ]
}

```
