# HtmlLinkType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HtmlLinkType**

## CodeSystem: HtmlLinkType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-HtmlLinkType | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:HtmlLinkType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.58 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HtmlLinkType values are drawn from HTML 4.0 and describe the relationship between the current document and the anchor that is the target of the link 

 This Code system is referenced in the content logical definition of the following value sets: 

* [HtmlLinkType](ValueSet-v3-HtmlLinkType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-HtmlLinkType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-HtmlLinkType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.58"
    }
  ],
  "version" : "3.0.0",
  "name" : "HtmlLinkType",
  "title" : "HtmlLinkType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HtmlLinkType values are drawn from HTML 4.0 and describe the relationship between the current document and the anchor that is the target of the link",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "alternate",
      "display" : "alternate",
      "definition" : "Designates substitute versions for the document in which the link occurs. When used together with the lang attribute, it implies a translated version of the document. When used together with the media attribute, it implies a version designed for a different medium (or media).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11018"
        }
      ]
    },
    {
      "code" : "appendix",
      "display" : "appendix",
      "definition" : "Refers to a document serving as an appendix in a collection of documents.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11030"
        }
      ]
    },
    {
      "code" : "bookmark",
      "display" : "bookmark",
      "definition" : "Refers to a bookmark. A bookmark is a link to a key entry point within an extended document. The title attribute may be used, for example, to label the bookmark. Note that several bookmarks may be defined in each document.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11032"
        }
      ]
    },
    {
      "code" : "chapter",
      "display" : "chapter",
      "definition" : "Refers to a document serving as a chapter in a collection of documents.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11027"
        }
      ]
    },
    {
      "code" : "contents",
      "display" : "contents",
      "definition" : "Refers to a document serving as a table of contents. Some user agents also support the synonym ToC (from \"Table of Contents\").",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11023"
        }
      ]
    },
    {
      "code" : "copyright",
      "display" : "copyright",
      "definition" : "Refers to a copyright statement for the current document.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11026"
        }
      ]
    },
    {
      "code" : "glossary",
      "display" : "glossary",
      "definition" : "Refers to a document providing a glossary of terms that pertain to the current document.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11025"
        }
      ]
    },
    {
      "code" : "help",
      "display" : "help",
      "definition" : "Refers to a document offering help (more information, links to other sources of information, etc.).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11031"
        }
      ]
    },
    {
      "code" : "index",
      "display" : "index",
      "definition" : "Refers to a document providing an index for the current document.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11024"
        }
      ]
    },
    {
      "code" : "next",
      "display" : "next",
      "definition" : "Refers to the next document in a linear sequence of documents. User agents may choose to preload the \"next\" document, to reduce the perceived load time.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11021"
        }
      ]
    },
    {
      "code" : "prev",
      "display" : "prev",
      "definition" : "Refers to the previous document in an ordered series of documents. Some user agents also support the synonym \"Previous\".",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11022"
        }
      ]
    },
    {
      "code" : "section",
      "display" : "section",
      "definition" : "Refers to a document serving as a section in a collection of documents.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11028"
        }
      ]
    },
    {
      "code" : "start",
      "display" : "start",
      "definition" : "Refers to the first document in a collection of documents. This link type tells search engines which document is considered by the author to be the starting point of the collection.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11020"
        }
      ]
    },
    {
      "code" : "stylesheet",
      "display" : "stylesheet",
      "definition" : "Refers to an external style sheet. See the section on external style sheets for details. This is used together with the link type \"Alternate\" for user-selectable alternate style sheets.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11019"
        }
      ]
    },
    {
      "code" : "subsection",
      "display" : "subsection",
      "definition" : "Refers to a document serving as a subsection in a collection of documents.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11029"
        }
      ]
    }
  ]
}

```
