# Charset - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Charset**

## CodeSystem: Charset 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-Charset | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Charset |
| *Other Identifiers:*OID:2.16.840.1.113883.5.21 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Internet Assigned Numbers Authority (IANA) Charset Types 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Charset](ValueSet-v3-Charset.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-Charset",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-Charset",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.21"
    }
  ],
  "version" : "3.0.0",
  "name" : "Charset",
  "title" : "Charset",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Internet Assigned Numbers Authority (IANA) Charset Types",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "EBCDIC",
      "display" : "EBCDIC",
      "definition" : "HL7 is indifferent to the use of this Charset.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14863"
        }
      ]
    },
    {
      "code" : "ISO-10646-UCS-2",
      "display" : "ISO-10646-UCS-2",
      "definition" : "Deprecated for HL7 use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14856"
        }
      ]
    },
    {
      "code" : "ISO-10646-UCS-4",
      "display" : "ISO-10646-UCS-4",
      "definition" : "Deprecated for HL7 use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14857"
        }
      ]
    },
    {
      "code" : "ISO-8859-1",
      "display" : "ISO-8859-1",
      "definition" : "HL7 is indifferent to the use of this Charset.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14859"
        }
      ]
    },
    {
      "code" : "ISO-8859-2",
      "display" : "ISO-8859-2",
      "definition" : "HL7 is indifferent to the use of this Charset.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14860"
        }
      ]
    },
    {
      "code" : "ISO-8859-5",
      "display" : "ISO-8859-5",
      "definition" : "HL7 is indifferent to the use of this Charset.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14861"
        }
      ]
    },
    {
      "code" : "JIS-2022-JP",
      "display" : "JIS-2022-JP",
      "definition" : "HL7 is indifferent to the use of this Charset.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14862"
        }
      ]
    },
    {
      "code" : "US-ASCII",
      "display" : "US-ASCII",
      "definition" : "Required for HL7 use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14854"
        }
      ]
    },
    {
      "code" : "UTF-7",
      "display" : "UTF-7",
      "definition" : "HL7 is indifferent to the use of this Charset.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14858"
        }
      ]
    },
    {
      "code" : "UTF-8",
      "display" : "UTF-8",
      "definition" : "Required for Unicode support.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14855"
        }
      ]
    }
  ]
}

```
