# AcknowledgementCondition - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AcknowledgementCondition**

## CodeSystem: AcknowledgementCondition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-AcknowledgementCondition | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AcknowledgementCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1050 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The codes identify the conditions under which accept acknowledgements are required to be returned in response to this message. Note that accept acknowledgement address two different issues at the same time: reliable transport as well as syntactical correctness 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AcknowledgementCondition](ValueSet-v3-AcknowledgementCondition.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-AcknowledgementCondition",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-AcknowledgementCondition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1050"
    }
  ],
  "version" : "3.0.0",
  "name" : "AcknowledgementCondition",
  "title" : "AcknowledgementCondition",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The codes identify the conditions under which accept acknowledgements are required to be returned in response to this message. Note that accept acknowledgement address two different issues at the same time: reliable transport as well as syntactical correctness",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AL",
      "display" : "Always",
      "definition" : "Always send an acknowledgement.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10126"
        }
      ]
    },
    {
      "code" : "ER",
      "display" : "Error/reject only",
      "definition" : "Send an acknowledgement for error/reject conditions only.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10128"
        }
      ]
    },
    {
      "code" : "NE",
      "display" : "Never",
      "definition" : "Never send an acknowledgement.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10127"
        }
      ]
    },
    {
      "code" : "SU",
      "display" : "Successful only",
      "definition" : "Send an acknowledgement for successful completions only.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "10129"
        }
      ]
    }
  ]
}

```
