# onlineVerificationResult - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **onlineVerificationResult**

## CodeSystem: onlineVerificationResult 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0970 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OnlineVerificationResult |
| *Other Identifiers:*OID:2.16.840.1.113883.18.453 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code values used to indicate the result of an online verification of insurance data. 

 
Underlying Master Code System for V2 table 0970 (Online Verification Result) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSOnlineVerificationResult](ValueSet-v2-0970.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0970",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0970",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.453"
    }
  ],
  "version" : "3.0.0",
  "name" : "OnlineVerificationResult",
  "title" : "onlineVerificationResult",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code values used to indicate the result of an online verification of insurance data.",
  "purpose" : "Underlying Master Code System for V2 table 0970 (Online Verification Result)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0970",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6788",
      "code" : "1",
      "display" : "Update performed",
      "definition" : "English: Update of insurance information on card\r\n\r\nGerman: Aktualisierung VSD auf eGK durchgeführt",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "6789",
      "code" : "2",
      "display" : "update not necessary",
      "definition" : "English: update of insurance information on card not necessary\r\n\r\nGerman: Keine Aktualisierung VSD auf eGK erforderlich",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "6790",
      "code" : "3",
      "display" : "Error",
      "definition" : "English: An unrecoverable error occurred during the update or verification of the insurance information\r\n\r\nGerman: Aktualisierung VSD auf eGK war nicht möglich",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    }
  ]
}

```
