# orderControlCodeReason - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **orderControlCodeReason**

## CodeSystem: orderControlCodeReason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0949 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OrderControlCodeReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.449 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts that describe reasons for the chosen order control codes. Used in HL7 Version 2 messaging in the ORC segment. 

 
Underlying Master Code System for V2 table 0949 (Order Control Code Reason) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSOrderControlCodeReason](ValueSet-v2-0949.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0949",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0949",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.449"
    }
  ],
  "version" : "3.0.0",
  "name" : "OrderControlCodeReason",
  "title" : "orderControlCodeReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that describe reasons for the chosen order control codes. Used in HL7 Version 2 messaging in the ORC segment.",
  "purpose" : "Underlying Master Code System for V2 table 0949 (Order Control Code Reason)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0949",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6769",
      "code" : "CO",
      "display" : "Cost",
      "definition" : "Order changed based on cost",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "In an order replacement context, this would accompany proposal of a similar but lower cost order"
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "6770",
      "code" : "ST",
      "display" : "Specimen Type",
      "definition" : "Incorrect specimen type submitted for the requested test",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Order placer may accept, cancel and replace, or choose other testing."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Recommend testing that can use the submitted specimen type"
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "6771",
      "code" : "SV",
      "display" : "Specimen Volume",
      "definition" : "Provided specimen volume inadequate for testing",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "The question is how to use the available specimen. The Order Placer may choose a different subset of tests."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Recommend a subset of ordered tests appropriate for volume"
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "6772",
      "code" : "UN",
      "display" : "Unavailable test",
      "definition" : "Requested test not available",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "In an order replacement context, an alternative might be proposed."
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    }
  ]
}

```
