# collectionEvent - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **collectionEvent**

## CodeSystem: collectionEvent 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0938 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CollectionEvent |
| *Other Identifiers:*OID:2.16.840.1.113883.18.441 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying the limit for the collection event or process step. Used in HL7 Version 2.x messaging in the OMC segment. 

 
Underlying Master Code System for V2 table 0938 (Collection Event/Process Step Limit) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSVSCollectionEvent](ValueSet-v2-0938.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0938",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0938",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.441"
    }
  ],
  "version" : "3.0.0",
  "name" : "CollectionEvent",
  "title" : "collectionEvent",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the limit for the collection event or process step.  Used in HL7 Version 2.x messaging in the OMC segment.",
  "purpose" : "Underlying Master Code System for V2 table 0938 (Collection Event/Process Step Limit)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0938",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6722",
      "code" : "ORD",
      "display" : "Placing the order",
      "definition" : "Placing the order",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "At time of placing the order"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "At time of placing the order"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6723",
      "code" : "DRW",
      "display" : "Collecting the specimen",
      "definition" : "Collecting the specimen",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "When the specimen is collected (e.g. fasting status)"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "When the specimen is collected (e.g. fasting status)"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
