# payeeType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **payeeType**

## CodeSystem: payeeType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0557 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PayeeType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.361 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to specify the type of payee (e.g., organization, person). Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0557 (Payee Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSPayeeType](ValueSet-v2-0557.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0557",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0557",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.361"
    }
  ],
  "version" : "3.0.0",
  "name" : "PayeeType",
  "title" : "payeeType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the type of payee (e.g., organization, person).  Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0557 (Payee Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0557",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6178",
      "code" : "ORG",
      "display" : "Payee Organization",
      "definition" : "Payee Organization",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "The payee is not a person/individual/being, but an entity commonly identified as an organization.  Examples could be a country healthcare payer, or an insurance company responsible for payment."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "The payee is not a person/individual/being, but an entity commonly identified as an organization.  Examples could be a country healthcare payer, or an insurance company responsible for payment."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6179",
      "code" : "PERS",
      "display" : "Person",
      "definition" : "Person",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "A person/individual/being."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "A person/individual/being."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6180",
      "code" : "PPER",
      "display" : "Pay Person",
      "definition" : "Pay Person",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Person/individual/being responsible for payment."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Person/individual/being responsible for payment."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6181",
      "code" : "EMPL",
      "display" : "Employer",
      "definition" : "Employer",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "A legal entity that controls and directs a worker under an express or implied contract of employment and a salary or wages in compensation.\r\n\r\nIn worker’s compensation cases, the Employer may be the “organization” responsible for paying the healthcare charges for employment related illness or injury."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "A legal entity that controls and directs a worker under an express or implied contract of employment and a salary or wages in compensation.\r\n\r\nIn worker’s compensation cases, the Employer may be the “organization” responsible for paying the healthcare charges for employment related illness or injury."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
