# invoiceReason - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **invoiceReason**

## CodeSystem: invoiceReason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0554 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:InvoiceReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.358 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to specify the reason for this invoice. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0554 (Invoice Reason Codes) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSInvoiceReasonCodes](ValueSet-v2-0554.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0554",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0554",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.358"
    }
  ],
  "version" : "3.0.0",
  "name" : "InvoiceReason",
  "title" : "invoiceReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the reason for this invoice.  Used in the Invoice (IVC) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0554 (Invoice Reason Codes)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0554",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6163",
      "code" : "LATE",
      "display" : "Late Invoice",
      "definition" : "Late Invoice",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Over the Payer's published time limit for this invoice"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Over the Payer's published time limit for this invoice"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6164",
      "code" : "NORM",
      "display" : "Normal submission",
      "definition" : "Normal submission",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6165",
      "code" : "SUB",
      "display" : "Subscriber coverage problem",
      "definition" : "Subscriber coverage problem",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
