# consentStatus - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **consentStatus**

## CodeSystem: consentStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0498 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ConsentStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.322 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-code system of concepts specifying whether the consent has been sought and granted. Used in HL7 Version 2.x messaging in the TXA and CON segments. 

 
Underlying Master Code System for V2 table 0498 (Consent Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSConsentStatus](ValueSet-v2-0498.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0498",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sd"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0498",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.322"
    }
  ],
  "version" : "3.0.0",
  "name" : "ConsentStatus",
  "title" : "consentStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-code system of concepts specifying whether the consent has been sought and granted.  Used in HL7 Version 2.x messaging in the TXA and CON segments.",
  "purpose" : "Underlying Master Code System for V2 table 0498 (Consent Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0498",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "5494",
      "code" : "A",
      "display" : "Active - Consent has been granted",
      "definition" : "Active - Consent has been granted",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5495",
      "code" : "L",
      "display" : "Limited - Consent has been granted with limitations",
      "definition" : "Limited - Consent has been granted with limitations",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5496",
      "code" : "R",
      "display" : "Refused - Consent has been refused",
      "definition" : "Refused - Consent has been refused",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5497",
      "code" : "P",
      "display" : "Pending - Consent has not yet been sought",
      "definition" : "Pending - Consent has not yet been sought",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5498",
      "code" : "X",
      "display" : "Rescinded - Consent was initially granted, but was subsequently revoked or ended.",
      "definition" : "Rescinded - Consent was initially granted, but was subsequently revoked or ended.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5499",
      "code" : "B",
      "display" : "Bypassed (Consent not sought)",
      "definition" : "Bypassed (Consent not sought)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
