# remoteControlCommand - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **remoteControlCommand**

## CodeSystem: remoteControlCommand 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0368 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RemoteControlCommand |
| *Other Identifiers:*OID:2.16.840.1.113883.18.226 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts that identify the comment the component is to initiate. Used in the Equipment Command (ECD) and Interaction Status Detail (ISD) segments in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0368 (Remote Control Command) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSRemoteControlCommand](ValueSet-v2-0368.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0368",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0368",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.226"
    }
  ],
  "version" : "3.0.0",
  "name" : "RemoteControlCommand",
  "title" : "remoteControlCommand",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts that identify the comment the component is to initiate.  Used in the Equipment Command (ECD) and Interaction Status Detail (ISD) segments in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0368 (Remote Control Command)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0368",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "3693",
      "code" : "SA",
      "display" : "Sampling",
      "definition" : "Sampling",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3694",
      "code" : "LO",
      "display" : "Load",
      "definition" : "Load",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3695",
      "code" : "UN",
      "display" : "Unload",
      "definition" : "Unload",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3696",
      "code" : "LK",
      "display" : "Lock",
      "definition" : "Lock",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3697",
      "code" : "UC",
      "display" : "Unlock",
      "definition" : "Unlock",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3698",
      "code" : "TT",
      "display" : "Transport To",
      "definition" : "Transport To",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3699",
      "code" : "CN",
      "display" : "Clear Notification",
      "definition" : "Clear Notification",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3700",
      "code" : "IN",
      "display" : "Initialize/Initiate",
      "definition" : "Initialize/Initiate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3701",
      "code" : "SU",
      "display" : "Setup",
      "definition" : "Setup",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3702",
      "code" : "CL",
      "display" : "Clear",
      "definition" : "Clear",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3703",
      "code" : "PA",
      "display" : "Pause",
      "definition" : "Pause",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3704",
      "code" : "RE",
      "display" : "Resume",
      "definition" : "Resume",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3705",
      "code" : "ES",
      "display" : "Emergency -stop",
      "definition" : "Emergency -stop",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3706",
      "code" : "LC",
      "display" : "Local Control Request",
      "definition" : "Local Control Request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3707",
      "code" : "RC",
      "display" : "Remote Control Request",
      "definition" : "Remote Control Request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3708",
      "code" : "AB",
      "display" : "Abort",
      "definition" : "Abort",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3709",
      "code" : "EN",
      "display" : "Enable Sending Events",
      "definition" : "Enable Sending Events",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3710",
      "code" : "DI",
      "display" : "Disable Sending Events",
      "definition" : "Disable Sending Events",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3711",
      "code" : "EX",
      "display" : "Execute (command specified in field Parameters (ST) 01394)",
      "definition" : "Execute (command specified in field Parameters (ST) 01394)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3712",
      "code" : "AF",
      "display" : "Aliquot From container",
      "definition" : "Aliquot From container",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "See desc. below"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "See desc. below"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3713",
      "code" : "AT",
      "display" : "Aliquot To container",
      "definition" : "Aliquot To container",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "See desc. below"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "See desc. below"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
