# subtypeOfReferencedData - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **subtypeOfReferencedData**

## CodeSystem: subtypeOfReferencedData 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0291 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SubtypeOfReferencedData |
| *Other Identifiers:*OID:2.16.840.1.113883.18.181 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of a subset of the media subtypes of binary data that are encoded in an ascii structure or stream. Used in Version 2 messaging ED and RP datatypes, but only in standard 2.5.1 and earlier; after that, it was recommended that the IANA media types be used instead of this short list of HL7-defined codes. More information on the standard media types and subtypes may be found at http://www.iana.org/assignments/media-types/media-types.xhtml. 

 
Underlying Master Code System for V2 table 0291 (Subtype of Referenced Data) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSSubtypeOfReferencedData](ValueSet-v2-notAllCodes-0291.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0291",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0291",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.181"
    }
  ],
  "version" : "3.0.0",
  "name" : "SubtypeOfReferencedData",
  "title" : "subtypeOfReferencedData",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of a subset of the media subtypes of binary data that are encoded in an ascii structure or stream.  Used in Version 2 messaging  ED and RP datatypes, but only in standard 2.5.1 and earlier; after that, it was recommended that the IANA media types be used instead of this short list of HL7-defined codes.   More information on the standard media types and subtypes may be found at http://www.iana.org/assignments/media-types/media-types.xhtml.",
  "purpose" : "Underlying Master Code System for V2 table 0291 (Subtype of Referenced Data)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0291",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "2813",
      "code" : "BASIC",
      "display" : "ISDN PCM audio data",
      "definition" : "ISDN PCM audio data",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2814",
      "code" : "...",
      "display" : "Source RFC 2046",
      "definition" : "Source RFC 2046",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2815",
      "code" : "…",
      "display" : "Source RFC 2046",
      "definition" : "Source RFC 2046",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2816",
      "code" : "DICOM",
      "display" : "Digital Imaging and Communications in Medicine",
      "definition" : "Digital Imaging and Communications in Medicine",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2817",
      "code" : "FAX",
      "display" : "Facsimile data",
      "definition" : "Facsimile data",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2818",
      "code" : "GIF",
      "display" : "Graphics Interchange Format",
      "definition" : "Graphics Interchange Format",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2819",
      "code" : "HTML",
      "display" : "Hypertext Markup Language",
      "definition" : "Hypertext Markup Language",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2820",
      "code" : "JOT",
      "display" : "Electronic ink data (Jot 1.0 standard)",
      "definition" : "Electronic ink data (Jot 1.0 standard)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2821",
      "code" : "JPEG",
      "display" : "Joint Photographic Experts Group",
      "definition" : "Joint Photographic Experts Group",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2822",
      "code" : "Octet-stream",
      "display" : "Uninterpreted binary data",
      "definition" : "Uninterpreted binary data",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2823",
      "code" : "PICT",
      "display" : "PICT format image data",
      "definition" : "PICT format image data",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2824",
      "code" : "PostScript",
      "display" : "PostScript program",
      "definition" : "PostScript program",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2825",
      "code" : "RTF",
      "display" : "Rich Text Format",
      "definition" : "Rich Text Format",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2826",
      "code" : "SGML",
      "display" : "Standard Generalized Markup Language (HL7 V2.3.1 and later)",
      "definition" : "Standard Generalized Markup Language (HL7 V2.3.1 and later)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2827",
      "code" : "TIFF",
      "display" : "TIFF image data",
      "definition" : "TIFF image data",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2828",
      "code" : "XML",
      "display" : "Extensible Markup Language (HL7 V2.3.1 and later)",
      "definition" : "Extensible Markup Language (HL7 V2.3.1 and later)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "2829",
      "code" : "x-hl7-cda-level-one",
      "display" : "HL7 Clinical Document Architecture Level One document",
      "definition" : "HL7 Clinical Document Architecture Level One document",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Retained for backwards compatibility only as of v2.6 and CDA R 2. Preferred value is text/xml."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Retained for backwards compatibility only as of v2.6 and CDA R 2. Preferred value is text/xml."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
