# patientOutcome - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **patientOutcome**

## CodeSystem: patientOutcome 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0241 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PatientOutcome |
| *Other Identifiers:*OID:2.16.840.1.113883.18.140 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to describe the overall state of a patient as a result of patient care. Used in HL7 Version 2.x messaging in the PEO segment. 

 
Underlying Master Code System for V2 table 0241 (Patient Outcome) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSPatientOutcome](ValueSet-v2-0241.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0241",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0241",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.140"
    }
  ],
  "version" : "3.0.0",
  "name" : "PatientOutcome",
  "title" : "patientOutcome",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to describe the overall state of a patient as a result of patient care.  Used in HL7 Version 2.x messaging in the PEO segment.",
  "purpose" : "Underlying Master Code System for V2 table 0241 (Patient Outcome)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0241",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2324",
      "code" : "D",
      "display" : "Died",
      "definition" : "Died",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2325",
      "code" : "R",
      "display" : "Recovering",
      "definition" : "Recovering",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2326",
      "code" : "N",
      "display" : "Not recovering/unchanged",
      "definition" : "Not recovering/unchanged",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2327",
      "code" : "W",
      "display" : "Worsening",
      "definition" : "Worsening",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2328",
      "code" : "S",
      "display" : "Sequelae",
      "definition" : "Sequelae",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2329",
      "code" : "F",
      "display" : "Fully recovered",
      "definition" : "Fully recovered",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2330",
      "code" : "U",
      "display" : "Unknown",
      "definition" : "Unknown",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
