# hospitalService - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **hospitalService**

## CodeSystem: hospitalService 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0069 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:HospitalService |
| *Other Identifiers:*OID:2.16.840.1.113883.18.27 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the treatment or type of surgery the patient is scheduled to receive. Used in HL7 Version 2.x messaging in the PV1 segment. 

 
Underlying Master Code System for V2 table 0069 (Hospital Service) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSHospitalService](ValueSet-v2-0069.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0069",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0069",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.27"
    }
  ],
  "version" : "3.0.0",
  "name" : "HospitalService",
  "title" : "hospitalService",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the treatment or type of surgery the patient is scheduled to receive.   Used in HL7 Version 2.x messaging in the PV1 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0069 (Hospital Service)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0069",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "894",
      "code" : "MED",
      "display" : "Medical Service",
      "definition" : "Medical Service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "895",
      "code" : "SUR",
      "display" : "Surgical Service",
      "definition" : "Surgical Service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "896",
      "code" : "URO",
      "display" : "Urology Service",
      "definition" : "Urology Service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "897",
      "code" : "PUL",
      "display" : "Pulmonary Service",
      "definition" : "Pulmonary Service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "898",
      "code" : "CAR",
      "display" : "Cardiac Service",
      "definition" : "Cardiac Service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
