# Test script operation code - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Test script operation code**

## CodeSystem: Test script operation code 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/testscript-operation-codes | *Version*:1.0.0 | | |
| Draft as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:TestScriptOperationCode |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1195 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
This value set defines a set of codes that are used to indicate the supported operations of a testing engine or tool. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TestScriptOperationCode](ValueSet-testscript-operation-codes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "testscript-operation-codes",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1195"
    }
  ],
  "version" : "1.0.0",
  "name" : "TestScriptOperationCode",
  "title" : "Test script operation code",
  "status" : "draft",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines a set of codes that are used to indicate the supported operations of a testing engine or tool.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/testscript-operation-codes",
  "content" : "complete",
  "concept" : [
    {
      "code" : "read",
      "display" : "Read",
      "definition" : "Read the current state of the resource."
    },
    {
      "code" : "vread",
      "display" : "Version Read",
      "definition" : "Read the state of a specific version of the resource."
    },
    {
      "code" : "update",
      "display" : "Update",
      "definition" : "Update an existing resource by its id."
    },
    {
      "code" : "updateCreate",
      "display" : "Create using Update",
      "definition" : "Update an existing resource by its id (or create it if it is new)."
    },
    {
      "code" : "patch",
      "display" : "Patch",
      "definition" : "Patch an existing resource by its id."
    },
    {
      "code" : "delete",
      "display" : "Delete",
      "definition" : "Delete a resource."
    },
    {
      "code" : "deleteCondSingle",
      "display" : "Conditional Delete Single",
      "definition" : "Conditionally delete a single resource based on search parameters."
    },
    {
      "code" : "deleteCondMultiple",
      "display" : "Conditional Delete Multiple",
      "definition" : "Conditionally delete one or more resources based on search parameters."
    },
    {
      "code" : "history",
      "display" : "History",
      "definition" : "Retrieve the change history for a particular resource or resource type."
    },
    {
      "code" : "create",
      "display" : "Create",
      "definition" : "Create a new resource with a server assigned id."
    },
    {
      "code" : "search",
      "display" : "Search",
      "definition" : "Search based on some filter criteria."
    },
    {
      "code" : "batch",
      "display" : "Batch",
      "definition" : "Update, create or delete a set of resources as independent actions."
    },
    {
      "code" : "transaction",
      "display" : "Transaction",
      "definition" : "Update, create or delete a set of resources as a single transaction."
    },
    {
      "code" : "capabilities",
      "display" : "Capabilities",
      "definition" : "Get a capability statement for the system."
    },
    {
      "code" : "apply",
      "display" : "$apply",
      "definition" : "Realizes an ActivityDefinition in a specific context"
    },
    {
      "code" : "closure",
      "display" : "$closure",
      "definition" : "Closure Table Maintenance"
    },
    {
      "code" : "find-matches",
      "display" : "$find-matches",
      "definition" : "Finding Codes based on supplied properties"
    },
    {
      "code" : "conforms",
      "display" : "$conforms",
      "definition" : "Compare two systems CapabilityStatements"
    },
    {
      "code" : "data-requirements",
      "display" : "$data-requirements",
      "definition" : "Aggregates and returns the parameters and data requirements for a resource and all its dependencies as a single module definition"
    },
    {
      "code" : "document",
      "display" : "$document",
      "definition" : "Generate a Document"
    },
    {
      "code" : "evaluate",
      "display" : "$evaluate",
      "definition" : "Request clinical decision support guidance based on a specific decision support module"
    },
    {
      "code" : "evaluate-measure",
      "display" : "$evaluate-measure",
      "definition" : "Invoke an eMeasure and obtain the results"
    },
    {
      "code" : "everything",
      "display" : "$everything",
      "definition" : "Return all the related information as described in the Encounter or Patient"
    },
    {
      "code" : "expand",
      "display" : "$expand",
      "definition" : "Value Set Expansion"
    },
    {
      "code" : "find",
      "display" : "$find",
      "definition" : "Find a functional list"
    },
    {
      "code" : "graphql",
      "display" : "$graphql",
      "definition" : "Invoke a GraphQL query"
    },
    {
      "code" : "implements",
      "display" : "$implements",
      "definition" : "Test if a server implements a client's required operations"
    },
    {
      "code" : "lastn",
      "display" : "$lastn",
      "definition" : "Last N Observations Query"
    },
    {
      "code" : "lookup",
      "display" : "$lookup",
      "definition" : "Concept Look Up and Decomposition"
    },
    {
      "code" : "match",
      "display" : "$match",
      "definition" : "Find patient matches using MPI based logic"
    },
    {
      "code" : "meta",
      "display" : "$meta",
      "definition" : "Access a list of profiles, tags, and security labels"
    },
    {
      "code" : "meta-add",
      "display" : "$meta-add",
      "definition" : "Add profiles, tags, and security labels to a resource"
    },
    {
      "code" : "meta-delete",
      "display" : "$meta-delete",
      "definition" : "Delete profiles, tags, and security labels for a resource"
    },
    {
      "code" : "populate",
      "display" : "$populate",
      "definition" : "Populate Questionnaire"
    },
    {
      "code" : "populatehtml",
      "display" : "$populatehtml",
      "definition" : "Generate HTML for Questionnaire"
    },
    {
      "code" : "populatelink",
      "display" : "$populatelink",
      "definition" : "Generate a link to a Questionnaire completion webpage"
    },
    {
      "code" : "process-message",
      "display" : "$process-message",
      "definition" : "Process a message according to the defined event"
    },
    {
      "code" : "questionnaire",
      "display" : "$questionnaire",
      "definition" : "Build Questionnaire"
    },
    {
      "code" : "stats",
      "display" : "$stats",
      "definition" : "Observation Statistics"
    },
    {
      "code" : "subset",
      "display" : "$subset",
      "definition" : "Fetch a subset of the CapabilityStatement resource"
    },
    {
      "code" : "subsumes",
      "display" : "$subsumes",
      "definition" : "CodeSystem Subsumption Testing"
    },
    {
      "code" : "transform",
      "display" : "$transform",
      "definition" : "Model Instance Transformation"
    },
    {
      "code" : "translate",
      "display" : "$translate",
      "definition" : "Concept Translation"
    },
    {
      "code" : "validate",
      "display" : "$validate",
      "definition" : "Validate a resource"
    },
    {
      "code" : "validate-code",
      "display" : "$validate-code",
      "definition" : "ValueSet based Validation"
    }
  ]
}

```
