# Supply Item Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Supply Item Type**

## CodeSystem: Supply Item Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/supply-item-type | *Version*:1.0.0 | | |
| Draft as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SupplyItemType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1194 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
This value sets refers to a specific supply item. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SupplyItemType](ValueSet-supplydelivery-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "supply-item-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/supply-item-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1194"
    }
  ],
  "version" : "1.0.0",
  "name" : "SupplyItemType",
  "title" : "Supply Item Type",
  "status" : "draft",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value sets refers to a specific supply item.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/supplydelivery-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "medication",
      "display" : "Medication",
      "definition" : "Supply is a kind of medication."
    },
    {
      "code" : "device",
      "display" : "Device",
      "definition" : "What is supplied (or requested) is a device."
    }
  ]
}

```
