# SubscriptionStatusAtEvent - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SubscriptionStatusAtEvent**

## CodeSystem: SubscriptionStatusAtEvent 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/subscription-status-at-event | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SubscriptionStatusAtEvent |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1465 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A status code for the state of the Subscription. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SubscriptionStatusAtEvent](ValueSet-subscription-status-at-event.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "subscription-status-at-event",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/subscription-status-at-event",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1465"
    }
  ],
  "version" : "1.0.0",
  "name" : "SubscriptionStatusAtEvent",
  "title" : "SubscriptionStatusAtEvent",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A status code for the state of the Subscription.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/subscription-status-at-event",
  "content" : "complete",
  "concept" : [
    {
      "code" : "requested",
      "display" : "Requested",
      "definition" : "The client has requested the subscription, and the server has not yet set it up."
    },
    {
      "code" : "active",
      "display" : "Active",
      "definition" : "The subscription is active."
    },
    {
      "code" : "error",
      "display" : "Error",
      "definition" : "The server has an error executing the notification."
    },
    {
      "code" : "off",
      "display" : "Off",
      "definition" : "Too many errors have occurred or the subscription has expired."
    }
  ]
}

```
