# StateChangeReason - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **StateChangeReason**

## CodeSystem: StateChangeReason 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/state-change-reason | *Version*:1.0.0 | | |
| Draft as of 2020-04-09 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:StateChangeReason |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.0 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
Indicates why the state of the subject changed. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [StateChangeReason](ValueSet-state-change-reason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "state-change-reason",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "brr"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/state-change-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.0"
    }
  ],
  "version" : "1.0.0",
  "name" : "StateChangeReason",
  "title" : "StateChangeReason",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Indicates why the state of the subject changed.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/state-change-reason",
  "content" : "complete",
  "concept" : [
    {
      "code" : "adverseEvent",
      "display" : "adverse event",
      "definition" : "adverse event."
    },
    {
      "code" : "death",
      "display" : "death (adverse event)",
      "definition" : "death (adverse event)."
    },
    {
      "code" : "notEligible",
      "display" : "did not meet eligibility criteria",
      "definition" : "did not meet eligibility criteria."
    },
    {
      "code" : "eligibleButNo",
      "display" : "eligible but unwilling or unable to participate",
      "definition" : "eligible but unwilling or unable to participate."
    },
    {
      "code" : "enrolled",
      "display" : "enrolled or registered",
      "definition" : "enrolled or registered."
    },
    {
      "code" : "exclusion",
      "display" : "exclusion",
      "definition" : "exclusion."
    },
    {
      "code" : "followUpComplete",
      "display" : "follow-up complete",
      "definition" : "follow-up complete."
    },
    {
      "code" : "inclusion",
      "display" : "inclusion",
      "definition" : "inclusion."
    },
    {
      "code" : "informedConsentSigned",
      "display" : "Informed consent signed",
      "definition" : "Informed consent signed."
    },
    {
      "code" : "intOrObsComplete",
      "display" : "intervention or observation complete",
      "definition" : "intervention or observation complete."
    },
    {
      "code" : "nonCompliance",
      "display" : "non-compliance",
      "definition" : "non-compliance."
    },
    {
      "code" : "preReg",
      "display" : "pre-registered or slot reserved",
      "definition" : "pre-registered or slot reserved."
    },
    {
      "code" : "refuseConsent",
      "display" : "refuse consent",
      "definition" : "refuse consent."
    },
    {
      "code" : "screenFailure",
      "display" : "screen failure",
      "definition" : "screen failure."
    },
    {
      "code" : "studyClosed",
      "display" : "study permanently closed to accrual",
      "definition" : "study permanently closed to accrual."
    },
    {
      "code" : "studyTerminated",
      "display" : "study terminated",
      "definition" : "study terminated."
    },
    {
      "code" : "subjectRefusal",
      "display" : "subject refusal",
      "definition" : "subject refusal."
    },
    {
      "code" : "unwillingOrUnable",
      "display" : "unwilling or unable to participate",
      "definition" : "unwilling or unable to participate."
    },
    {
      "code" : "withdrawnConsent",
      "display" : "withdrawn consent",
      "definition" : "withdrawn consent."
    }
  ]
}

```
