# ReferralMethod - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ReferralMethod**

## CodeSystem: ReferralMethod 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/service-referral-method | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ReferralMethod |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1142 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
The methods of referral can be used when referring to a specific HealthCareService resource. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ReferralMethod](ValueSet-service-referral-method.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "service-referral-method",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/service-referral-method",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1142"
    }
  ],
  "version" : "1.0.1",
  "name" : "ReferralMethod",
  "title" : "ReferralMethod",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The methods of referral can be used when referring to a specific HealthCareService resource.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/service-referral-method",
  "content" : "complete",
  "concept" : [
    {
      "code" : "fax",
      "display" : "Fax",
      "definition" : "Referrals may be accepted by fax."
    },
    {
      "code" : "phone",
      "display" : "Phone",
      "definition" : "Referrals may be accepted over the phone."
    },
    {
      "code" : "elec",
      "display" : "Secure Messaging",
      "definition" : "Referrals may be accepted via a secure messaging system. To determine the types of secure messaging systems supported, refer to the identifiers collection. Callers will need to understand the specific identifier system used to know that they are able to transmit messages."
    },
    {
      "code" : "semail",
      "display" : "Secure Email",
      "definition" : "Referrals may be accepted via a secure email. To send please encrypt with the services public key."
    },
    {
      "code" : "mail",
      "display" : "Mail",
      "definition" : "Referrals may be accepted via regular postage (or hand delivered)."
    },
    {
      "code" : "self",
      "display" : "Self-referral",
      "definition" : "Referrals may be accepted via self-referral."
    }
  ]
}

```
