# StrengthOfRecommendationRating - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **StrengthOfRecommendationRating**

## CodeSystem: StrengthOfRecommendationRating 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/recommendation-strength | *Version*:1.0.1 | |
| Active as of 2024-04-24 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:StrengthOfRecommendationRating |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1268 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
A rating system that describes the strength of the recommendation, such as the GRADE, DynaMed, or HGPS systems. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [StrengthOfRecommendationRating](ValueSet-recommendation-strength.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "recommendation-strength",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/recommendation-strength",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1268"
    }
  ],
  "version" : "1.0.1",
  "name" : "StrengthOfRecommendationRating",
  "title" : "StrengthOfRecommendationRating",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A rating system that describes the strength of the recommendation, such as the GRADE, DynaMed, or HGPS systems.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/recommendation-strength",
  "content" : "complete",
  "concept" : [
    {
      "code" : "strong",
      "display" : "Strong",
      "definition" : "Strong recommendation."
    },
    {
      "code" : "weak",
      "display" : "Weak",
      "definition" : "Weak recommendation."
    }
  ]
}

```
