# Push-type-available - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Push-type-available**

## CodeSystem: Push-type-available 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/push-type-available | *Version*:1.0.1 | |
| Active as of 2024-04-24 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Push_type_available |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.899 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
Type of alerts/updates the primary source can send 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Push_type_available](ValueSet-verificationresult-push-type-available.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "push-type-available",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/push-type-available",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.899"
    }
  ],
  "version" : "1.0.1",
  "name" : "Push_type_available",
  "title" : "Push-type-available",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Type of alerts/updates the primary source can send",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/verificationresult-push-type-available",
  "content" : "complete",
  "concept" : [
    {
      "code" : "specific",
      "display" : "Specific requested changes"
    },
    {
      "code" : "any",
      "display" : "Any changes"
    },
    {
      "code" : "source",
      "display" : "As defined by source"
    }
  ]
}

```
