# PlanDefinitionType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PlanDefinitionType**

## CodeSystem: PlanDefinitionType 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/plan-definition-type | *Version*:2.0.0 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PlanDefinitionType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1245 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The type of PlanDefinition. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PlanDefinitionType](ValueSet-plan-definition-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "plan-definition-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/plan-definition-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1245"
    }
  ],
  "version" : "2.0.0",
  "name" : "PlanDefinitionType",
  "title" : "PlanDefinitionType",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of PlanDefinition.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/plan-definition-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "order-set",
      "display" : "Order Set",
      "definition" : "A pre-defined and approved group of orders related to a particular clinical condition (e.g. hypertension treatment and monitoring) or stage of care (e.g. hospital admission to Coronary Care Unit). An order set is used as a checklist for the clinician when managing a patient with a specific condition. It is a structured collection of orders relevant to that condition and presented to the clinician in a computerized provider order entry (CPOE) system."
    },
    {
      "code" : "protocol",
      "display" : "Protocol",
      "definition" : "Defines a desired/typical sequence of activities including preconditions, triggers and temporal relationships."
    },
    {
      "code" : "clinical-protocol",
      "display" : "Clinical Protocol",
      "definition" : "Defines a desired/typical sequence of clinical activities including preconditions, triggers and temporal relationships."
    },
    {
      "code" : "eca-rule",
      "display" : "ECA Rule",
      "definition" : "A decision support rule of the form [on Event] if Condition then Action. It is intended to be a shareable, computable definition of actions that should be taken whenever some condition is met in response to a particular event or events."
    },
    {
      "code" : "workflow-definition",
      "display" : "Workflow Definition",
      "definition" : "Defines the steps for a group of one or more systems in an event flow process along with the step constraints, sequence, pre-conditions and decision points to complete a particular objective."
    }
  ]
}

```
