# Observation Category Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation Category Codes**

## CodeSystem: Observation Category Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/observation-category | *Version*:2.0.0 | |
| Active as of 2026-01-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ObservationCategoryCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1125 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
Observation Category codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ObservationCategoryCodes](ValueSet-observation-category.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "observation-category",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/observation-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1125"
    }
  ],
  "version" : "2.0.0",
  "name" : "ObservationCategoryCodes",
  "title" : "Observation Category Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Observation Category codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/observation-category",
  "content" : "complete",
  "concept" : [
    {
      "code" : "social-history",
      "display" : "Social History",
      "definition" : "Social History Observations define the patient's occupational, personal (e.g., lifestyle), social, familial, and environmental history and health risk factors that may impact the patient's health."
    },
    {
      "code" : "vital-signs",
      "display" : "Vital Signs",
      "definition" : "Clinical observations measure the body's basic functions such as blood pressure, heart rate, respiratory rate, height, weight, body mass index, head circumference, pulse oximetry, temperature, and body surface area."
    },
    {
      "code" : "imaging",
      "display" : "Imaging",
      "definition" : "Observations generated by imaging. The scope includes observations regarding plain x-ray, ultrasound, CT, MRI, angiography, echocardiography, and nuclear medicine."
    },
    {
      "code" : "laboratory",
      "display" : "Laboratory",
      "definition" : "The results of observations generated by laboratories.  Laboratory results are typically generated by laboratories providing analytic services in areas such as chemistry, hematology, serology, histology, cytology, anatomic pathology (including digital pathology), microbiology, and/or virology. These observations are based on analysis of specimens obtained from the patient and submitted to the laboratory."
    },
    {
      "code" : "procedure",
      "display" : "Procedure",
      "definition" : "Observations generated by other procedures.  This category includes observations resulting from interventional and non-interventional procedures excluding laboratory and imaging (e.g., cardiology catheterization, endoscopy, electrodiagnostics, etc.).  Procedure results are typically generated by a clinician to provide more granular information about component observations made during a procedure.  An example would be when a gastroenterologist reports the size of a polyp observed during a colonoscopy."
    },
    {
      "code" : "survey",
      "display" : "Survey",
      "definition" : "Observations from survey instruments (e.g., patient experience surveys), questionnaires, forms (e.g., patient admission forms) and assessment tools (e.g., Apgar Scores, Montreal Cognitive Assessment [MoCA])."
    },
    {
      "code" : "exam",
      "display" : "Exam",
      "definition" : "Observations generated by physical exam findings, including direct observations made by a clinician using simple instruments or as the result of simple maneuvers performed directly on the patient's body (e.g., signs)."
    },
    {
      "code" : "therapy",
      "display" : "Therapy",
      "definition" : "Observations generated by non-interventional treatment protocols (e.g. occupational, physical, radiation, nutritional and medication therapy)."
    },
    {
      "code" : "activity",
      "display" : "Activity",
      "definition" : "Observations that measure or record any bodily activity that enhances or maintains physical fitness and overall health and wellness."
    },
    {
      "code" : "symptom",
      "display" : "Symptom",
      "definition" : "Observations which record a manifestation of a disease that is apparent to and has been communicated by the patient."
    }
  ]
}

```
