# Nutrition Intake Status Reason Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nutrition Intake Status Reason Codes**

## CodeSystem: Nutrition Intake Status Reason Codes 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/nutritionintake-status-reason | *Version*:1.0.0 |
| Active as of 2026-01-26 | *Computable Name*:NutritionIntakeStatusReason |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.4.2129 | |

 
Nutrition Intake Status Reason Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "nutritionintake-status-reason",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/nutritionintake-status-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.4.2129"
    }
  ],
  "version" : "1.0.0",
  "name" : "NutritionIntakeStatusReason",
  "title" : "Nutrition Intake Status Reason Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "description" : "Nutrition Intake Status Reason Codes",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "concept" : [
    {
      "code" : "incomplete-data",
      "display" : "Incomplete Data",
      "definition" : "Data needed to safely act on the intake which was expected to become available independent of the intake is not yet available."
    },
    {
      "code" : "unable-to-provide-care",
      "display" : "Unable to provide care",
      "definition" : "Fulfiller not able to provide appropriate care associated with fulfilling the intake."
    },
    {
      "code" : "request-clarification",
      "display" : "Request requires clarification",
      "definition" : "Clarification is required before the intake can be acted upon."
    },
    {
      "code" : "allergy",
      "display" : "Allergy",
      "definition" : "The patient/subject is believed to be allergic to a substance that is part of the therapy and the therapy is being temporarily withdrawn to confirm."
    },
    {
      "code" : "suspected-intolerance",
      "display" : "Suspected intolerance",
      "definition" : "The patient/subject is believed to have an intolerance to a substance that is part of the therapy and the therapy is being temporarily withdrawn to confirm."
    },
    {
      "code" : "scheduled-for-surgery",
      "display" : "Patient/subject scheduled for surgery",
      "definition" : "Patient/subject is receiving surgery and/or the subject is scheduled to be admitted for surgery in the near future. The intake will be resumed when the subject has sufficiently recovered from the surgery."
    },
    {
      "code" : "product-not-available",
      "display" : "Product not available",
      "definition" : "Cannot supply product."
    }
  ]
}

```
