# Digital Media Category - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Digital Media Category**

## CodeSystem: Digital Media Category 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/media-category | *Version*:4.0.0 | |
| Draft as of 2019-05-17 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DigitalMediaCategory |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.326 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes for high level media types - whether the media is an image, video, or audio. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "media-category",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/media-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.326"
    }
  ],
  "version" : "4.0.0",
  "name" : "DigitalMediaCategory",
  "title" : "Digital Media Category",
  "status" : "draft",
  "experimental" : false,
  "date" : "2019-05-17",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for high level media types - whether the media is an image, video, or audio.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "image",
      "display" : "Image",
      "definition" : "The media consists of one or more unmoving images, including photographs, computer-generated graphs and charts, and scanned documents"
    },
    {
      "code" : "video",
      "display" : "Video",
      "definition" : "The media consists of a series of frames that capture a moving image"
    },
    {
      "code" : "audio",
      "display" : "Audio",
      "definition" : "The media consists of a sound recording"
    },
    {
      "code" : "STYLESHEET",
      "display" : "Stylesheet",
      "definition" : "The stylesheet for use"
    },
    {
      "code" : "WORKFLOW_DEFINITION",
      "display" : "Workflow Definitions",
      "definition" : "The workflow definition"
    }
  ]
}

```
