# List Order Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **List Order Codes**

## CodeSystem: List Order Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/list-order | *Version*:2.0.0 | |
| Active as of 2026-01-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ListOrderCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1107 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
Base values for the order of item lists in resources. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ListOrderCodes](ValueSet-list-order.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "list-order",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sd"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/list-order",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1107"
    }
  ],
  "version" : "2.0.0",
  "name" : "ListOrderCodes",
  "title" : "List Order Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Base values for the order of item lists in resources.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/list-order",
  "content" : "complete",
  "concept" : [
    {
      "code" : "user",
      "display" : "Sorted by User",
      "definition" : "The list was sorted by a user. The criteria the user used are not specified."
    },
    {
      "code" : "system",
      "display" : "Sorted by System",
      "definition" : "The list was sorted by the system. The criteria the user used are not specified; define additional codes to specify a particular order (or use other defined codes)."
    },
    {
      "code" : "event-date",
      "display" : "Sorted by Event Date",
      "definition" : "The list is sorted by the data of the event. This can be used when the list has items which are dates with past or future events."
    },
    {
      "code" : "entry-date",
      "display" : "Sorted by Item Date",
      "definition" : "The list is sorted by the date the item was added to the list. Note that the date added to the list is not explicit in the list itself."
    },
    {
      "code" : "priority",
      "display" : "Sorted by Priority",
      "definition" : "The list is sorted by priority. The exact method in which priority has been determined is not specified."
    },
    {
      "code" : "alphabetic",
      "display" : "Sorted Alphabetically",
      "definition" : "The list is sorted alphabetically by an unspecified property of the items in the list."
    },
    {
      "code" : "category",
      "display" : "Sorted by Category",
      "definition" : "The list is sorted categorically by an unspecified property of the items in the list."
    },
    {
      "code" : "patient",
      "display" : "Sorted by Patient",
      "definition" : "The list is sorted by patient, with items for each patient grouped together."
    },
    {
      "code" : "publication-date",
      "display" : "Sorted by Publication Date",
      "definition" : "The list is sorted by the date the item was published or made publicly available. This is distinct from when an event occurred (event-date) or when the item was added to the list (entry-date)."
    }
  ]
}

```
