# HL7Workgroup - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7Workgroup**

## CodeSystem: HL7Workgroup 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/hl7-work-group | *Version*:9.0.0 | |
| Active as of 2025-07-17 | *Responsible:*[Health Level Seven International](http://hl7.org/) | *Computable Name*:HL7Workgroup |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1277 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
An HL7 administrative unit that owns artifacts in the FHIR specification. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [HL7Workgroup](ValueSet-hl7-work-group.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "hl7-work-group",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/hl7-work-group",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1277"
    }
  ],
  "version" : "9.0.0",
  "name" : "HL7Workgroup",
  "title" : "HL7Workgroup",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-07-17",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "An HL7 administrative unit that owns artifacts in the FHIR specification.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/hl7-work-group",
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "aid",
      "display" : "Application Implementation and Design",
      "definition" : "Application Implementation and Design (http://www.hl7.org/Special/committees/java/index.cfm)."
    },
    {
      "code" : "arden",
      "display" : "Arden Syntax",
      "definition" : "Arden Syntax (http://www.hl7.org/Special/committees/arden/index.cfm)"
    },
    {
      "code" : "att",
      "display" : "Clinical Attachments",
      "definition" : "Clinical Attachments Workgroup (inactive since mid-2018; work subsumed by Structured Documents and Financial Management).  Retained for backwards-compatibility only."
    },
    {
      "code" : "brr",
      "display" : "Biomedical Research and Regulation",
      "definition" : "Biomedical Research and Regulation (http://www.hl7.org/Special/committees/rcrim/index.cfm)."
    },
    {
      "code" : "cbcc",
      "display" : "Community Based Collaborative Care",
      "definition" : "Community Based Collaborative Care (http://www.hl7.org/Special/committees/cbcc/index.cfm)."
    },
    {
      "code" : "cdamg",
      "display" : "CDA Management Group",
      "definition" : "CDA Management Group (http://www.hl7.org/Special/committees/cdamg/index.cfm)"
    },
    {
      "code" : "cds",
      "display" : "Clinical Decision Support",
      "definition" : "Clinical Decision Support (http://www.hl7.org/Special/committees/dss/index.cfm)."
    },
    {
      "code" : "cg",
      "display" : "Clinical Genomics",
      "definition" : "Clinical Genomics (http://www.hl7.org/Special/committees/clingenomics/index.cfm)."
    },
    {
      "code" : "cgp",
      "display" : "Cross-Group Projects",
      "definition" : "Cross-Group Projects (http://www.hl7.org/Special/committees/cgp/index.cfm)"
    },
    {
      "code" : "cic",
      "display" : "Clinical Interoperability Council",
      "definition" : "Clinical Interoperability Council (http://www.hl7.org/Special/committees/cic/index.cfm)."
    },
    {
      "code" : "cimi",
      "display" : "Clinical Information Modeling Initiative",
      "definition" : "Clinical Information Modeling Initiative (http://www.hl7.org/Special/committees/cimi/index.cfm)"
    },
    {
      "code" : "claims",
      "display" : "Payer/Provider Information Exchange Work Group",
      "definition" : "Payer/Provider Information Exchange Work Group (http://www.hl7.org/Special/committees/claims/index.cfm)"
    },
    {
      "code" : "cqi",
      "display" : "Clinical Quality Information",
      "definition" : "Clinical Quality Information (http://www.hl7.org/Special/committees/cqi/index.cfm)."
    },
    {
      "code" : "dev",
      "display" : "Health Care Devices",
      "definition" : "Health Care Devices (http://www.hl7.org/Special/committees/healthcaredevices/index.cfm)."
    },
    {
      "code" : "education",
      "display" : "Education",
      "definition" : "Education (http://www.hl7.org/Special/committees/education/index.cfm)."
    },
    {
      "code" : "ehr",
      "display" : "Electronic Health Records",
      "definition" : "Electronic Health Records (http://www.hl7.org/special/committees/ehr/index.cfm)."
    },
    {
      "code" : "ec",
      "display" : "Emergency Care",
      "definition" : "Emergency Care (http://www.hl7.org/Special/committees/emergencycare/index.cfm)"
    },
    {
      "code" : "fhir",
      "display" : "FHIR Infrastructure",
      "definition" : "FHIR Infrastructure (http://www.hl7.org/Special/committees/fiwg/index.cfm)."
    },
    {
      "code" : "fmg",
      "display" : "FHIR Management Group",
      "definition" : "FHIR Management Group (http://www.hl7.org/Special/committees/fhirmg/index.cfm)"
    },
    {
      "code" : "fm",
      "display" : "Financial Management",
      "definition" : "Financial Management (http://www.hl7.org/Special/committees/fm/index.cfm)."
    },
    {
      "code" : "hsi",
      "display" : "Health Standards Integration",
      "definition" : "Health Standards Integration (http://www.hl7.org/Special/committees/hsi/index.cfm)."
    },
    {
      "code" : "hsswg",
      "display" : "Human and Social Services",
      "definition" : "Human and Social Services (http://www.hl7.org/Special/committees/hsswg/index.cfm)"
    },
    {
      "code" : "hta",
      "display" : "Terminology Authority",
      "definition" : "Terminology Authority (http://www.hl7.org/Special/committees/termauth/index.cfm)"
    },
    {
      "code" : "ictc",
      "display" : "Conformance",
      "definition" : "Conformance (http://www.hl7.org/Special/committees/ictc/index.cfm)"
    },
    {
      "code" : "ii",
      "display" : "Imaging Integration",
      "definition" : "Imaging Integration (http://www.hl7.org/Special/committees/imagemgt/index.cfm)."
    },
    {
      "code" : "inm",
      "display" : "Infrastructure And Messaging",
      "definition" : "Infrastructure And Messaging (http://www.hl7.org/special/committees/inm/index.cfm)."
    },
    {
      "code" : "its",
      "display" : "Implementable Technology Specifications",
      "definition" : "Implementable Technology Specifications (http://www.hl7.org/special/committees/xml/index.cfm)."
    },
    {
      "code" : "lhs",
      "display" : "Learning Health Systems",
      "definition" : "Learning Health Systems (http://www.hl7.org/Special/committees/lhs/index.cfm)"
    },
    {
      "code" : "mnm",
      "display" : "Modeling and Methodology",
      "definition" : "Modeling and Methodology (http://www.hl7.org/Special/committees/mnm/index.cfm)."
    },
    {
      "code" : "mobile",
      "display" : "Mobile Health",
      "definition" : "Mobile Health (http://www.hl7.org/Special/committees/mobile/index.cfm)"
    },
    {
      "code" : "oo",
      "display" : "Orders and Observations",
      "definition" : "Orders and Observations (http://www.hl7.org/Special/committees/orders/index.cfm)."
    },
    {
      "code" : "pa",
      "display" : "Patient Administration",
      "definition" : "Patient Administration (http://www.hl7.org/Special/committees/pafm/index.cfm)."
    },
    {
      "code" : "pc",
      "display" : "Patient Care",
      "definition" : "Patient Care (http://www.hl7.org/Special/committees/patientcare/index.cfm)."
    },
    {
      "code" : "pe",
      "display" : "Patient Empowerment",
      "definition" : "Patient Empowerment (https://www.hl7.org/Special/committees/patientempowerment/index.cfm)."
    },
    {
      "code" : "pher",
      "display" : "Public Health and Emergency Response",
      "definition" : "Public Health and Emergency Response (http://www.hl7.org/Special/committees/pher/index.cfm)."
    },
    {
      "code" : "phx",
      "display" : "Pharmacy",
      "definition" : "Pharmacy (http://www.hl7.org/Special/committees/medication/index.cfm)."
    },
    {
      "code" : "sd",
      "display" : "Structured Documents",
      "definition" : "Structured Documents (http://www.hl7.org/Special/committees/structure/index.cfm)."
    },
    {
      "code" : "sec",
      "display" : "Security",
      "definition" : "Security (http://www.hl7.org/Special/committees/secure/index.cfm)."
    },
    {
      "code" : "soa",
      "display" : "Orchestration, Services, and Architecture",
      "definition" : "Orchestration, Services, and Architecture (http://www.hl7.org/Special/committees/soa/index.cfm)"
    },
    {
      "code" : "ti",
      "display" : "Terminology Infrastructure",
      "definition" : "Terminology Infrastructure (http://www.hl7.org/Special/committees/Vocab/index.cfm)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        }
      ]
    },
    {
      "code" : "tsmg",
      "display" : "Terminology Services Management Group (TSMG)",
      "definition" : "Terminology Services Management Group (TSMG) (http://www.hl7.org/Special/committees/tsmg/index.cfm)"
    },
    {
      "code" : "us",
      "display" : "US Realm Steering Committee",
      "definition" : "US Realm Taskforce (http://www.hl7.org/Special/committees/usrealm/index.cfm)."
    },
    {
      "code" : "v2",
      "display" : "V2 Management Group",
      "definition" : "V2 Management Group (http://www.hl7.org/Special/committees/v2management/index.cfm)"
    },
    {
      "code" : "vocab",
      "display" : "Terminology Infrastructure",
      "definition" : "Terminology Infrastructure (http://www.hl7.org/Special/committees/Vocab/index.cfm)."
    }
  ]
}

```
