# Security Role Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Security Role Type**

## CodeSystem: Security Role Type (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/extra-security-role-type | *Version*:1.0.1 | |
| Active as of 2024-04-24 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SecurityRoleType |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
This CodeSystem contains Additional FHIR-defined Security Role types not defined elsewhere 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "extra-security-role-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "url" : "http://terminology.hl7.org/CodeSystem/extra-security-role-type",
  "version" : "1.0.1",
  "name" : "SecurityRoleType",
  "title" : "Security Role Type",
  "status" : "active",
  "experimental" : true,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This CodeSystem contains Additional FHIR-defined Security Role types not defined elsewhere",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "authserver",
      "display" : "Authorization Server",
      "definition" : "An entity providing authorization services to enable the electronic sharing of health-related information based on resource owner's preapproved permissions. For example, an UMA Authorization Server[UMA]"
    },
    {
      "code" : "datacollector",
      "display" : "Data Collector",
      "definition" : "An entity that collects information over which the data subject may have certain rights under policy or law to control that information's management and distribution by data collectors, including the right to access, retrieve, distribute, or delete that information."
    },
    {
      "code" : "dataprocessor",
      "display" : "Data Processor",
      "definition" : "An entity that processes collected information over which the data subject may have certain rights under policy or law to control that information's management and distribution by data processors, including the right to access, retrieve, distribute, or delete that information."
    },
    {
      "code" : "datasubject",
      "display" : "Data Subject",
      "definition" : "A person whose personal information is collected or processed, and who may have certain rights under policy or law to control that information's management and distribution by data collectors or processors, including the right to access, retrieve, distribute, or delete that information."
    },
    {
      "code" : "humanuser",
      "display" : "Human User",
      "definition" : "The human user that has participated."
    }
  ]
}

```
