# Device Alert Activation State - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Device Alert Activation State**

## CodeSystem: Device Alert Activation State 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/devicealert-activationState | *Version*:1.0.0 | | |
| * Standards status: *[Draft](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DeviceAlertActivationState |

 
Describes the activation state of a DeviceAlert. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DeviceAlertActivationStateCodes](ValueSet-devicealert-activationState.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "devicealert-activationState",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "dev"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/devicealert-activationState",
  "version" : "1.0.0",
  "name" : "DeviceAlertActivationState",
  "title" : "Device Alert Activation State",
  "status" : "draft",
  "experimental" : false,
  "date" : "2023-12-10T10:01:24+11:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Describes the activation state of a DeviceAlert.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/devicealert-activationState",
  "content" : "complete",
  "concept" : [
    {
      "code" : "on",
      "display" : "On",
      "definition" : "The signal will be announciated during an alert condition"
    },
    {
      "code" : "off",
      "display" : "Off",
      "definition" : "The signal will not be announciated during an alert condition"
    },
    {
      "code" : "paused",
      "display" : "Paused",
      "definition" : "Annunciation of the signal during an alert condition has been suppressed temporarily"
    }
  ]
}

```
