# CoverageEligibilityResponse Auth Support Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CoverageEligibilityResponse Auth Support Codes**

## CodeSystem: CoverageEligibilityResponse Auth Support Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/coverageeligibilityresponse-ex-auth-support | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CoverageEligibilityResponseAuthSupportCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1394 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes CoverageEligibilityResponse Auth Support codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CoverageEligibilityResponseAuthSupportCodes](ValueSet-coverageeligibilityresponse-ex-auth-support.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "coverageeligibilityresponse-ex-auth-support",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/coverageeligibilityresponse-ex-auth-support",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1394"
    }
  ],
  "version" : "1.0.1",
  "name" : "CoverageEligibilityResponseAuthSupportCodes",
  "title" : "CoverageEligibilityResponse Auth Support Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes CoverageEligibilityResponse Auth Support codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/coverageeligibilityresponse-ex-auth-support",
  "content" : "complete",
  "concept" : [
    {
      "code" : "laborder",
      "display" : "Lab Order",
      "definition" : "A request or authorization for laboratory diagnostic tests."
    },
    {
      "code" : "labreport",
      "display" : "Lab Report",
      "definition" : "A report on laboratory diagnostic test(s)."
    },
    {
      "code" : "diagnosticimageorder",
      "display" : "Diagnostic Image Order",
      "definition" : "A request or authorization for diagnostic imaging."
    },
    {
      "code" : "diagnosticimagereport",
      "display" : "Diagnostic Image Report",
      "definition" : "A report on diagnostic image(s)."
    },
    {
      "code" : "professionalreport",
      "display" : "Professional Report",
      "definition" : "A report from a licensed professional regarding the siutation, condition or proposed treatment."
    },
    {
      "code" : "accidentreport",
      "display" : "Accident Report",
      "definition" : "A formal accident report as would be filed with police or a simlar official body."
    },
    {
      "code" : "model",
      "display" : "Model",
      "definition" : "A physical model of the affected area."
    },
    {
      "code" : "picture",
      "display" : "Picture",
      "definition" : "A photograph of the affected area."
    }
  ]
}

```
