# ContractDataMeaning - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ContractDataMeaning**

## CodeSystem: ContractDataMeaning 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/contract-data-meaning | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ContractDataMeaning |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1205 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
How a resource reference is interpreted when evaluating contract offers. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ContractDataMeaning](ValueSet-contract-data-meaning.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "contract-data-meaning",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/contract-data-meaning",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1205"
    }
  ],
  "version" : "1.0.0",
  "name" : "ContractDataMeaning",
  "title" : "ContractDataMeaning",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "How a resource reference is interpreted when evaluating contract offers.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/contract-data-meaning",
  "content" : "complete",
  "concept" : [
    {
      "code" : "instance",
      "display" : "Instance",
      "definition" : "The consent applies directly to the instance of the resource."
    },
    {
      "code" : "related",
      "display" : "Related",
      "definition" : "The consent applies directly to the instance of the resource and instances it refers to."
    },
    {
      "code" : "dependents",
      "display" : "Dependents",
      "definition" : "The consent applies directly to the instance of the resource and instances that refer to it."
    },
    {
      "code" : "authoredby",
      "display" : "AuthoredBy",
      "definition" : "The consent applies to instances of resources that are authored by."
    }
  ]
}

```
