# Condition Category Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition Category Codes**

## CodeSystem: Condition Category Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/condition-category | *Version*:2.0.0 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ConditionCategoryCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1073 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Preferred value set for Condition Categories. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ConditionCategoryCodes](ValueSet-condition-category.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "condition-category",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/condition-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1073"
    }
  ],
  "version" : "2.0.0",
  "name" : "ConditionCategoryCodes",
  "title" : "Condition Category Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Preferred value set for Condition Categories.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/condition-category",
  "content" : "complete",
  "concept" : [
    {
      "code" : "problem-list-item",
      "display" : "Problem List Item",
      "definition" : "An item on a problem list that can be managed over time and can be expressed by a practitioner (e.g. physician, nurse), patient, or related person."
    },
    {
      "code" : "encounter-diagnosis",
      "display" : "Encounter Diagnosis",
      "definition" : "A point in time diagnosis (e.g. from a physician or nurse) in context of an encounter."
    },
    {
      "code" : "diagnostic-report-impression",
      "display" : "Diagnostic Report Impression",
      "definition" : "A diagnosis or differential diagnosis item that is expressed in a diagnostic report."
    }
  ]
}

```
