# CharacteristicMethod - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CharacteristicMethod**

## CodeSystem: CharacteristicMethod 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/characteristic-method | *Version*:1.0.0 | | |
| Draft as of 2020-04-09 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CharacteristicMethod |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1453 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
The method used to determine the characteristic(s) of the variable. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CharacteristicMethod](ValueSet-characteristic-method.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "characteristic-method",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/characteristic-method",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1453"
    }
  ],
  "version" : "1.0.0",
  "name" : "CharacteristicMethod",
  "title" : "CharacteristicMethod",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The method used to determine the characteristic(s) of the variable.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/characteristic-method",
  "content" : "complete",
  "concept" : [
    {
      "code" : "Default",
      "display" : "Default",
      "definition" : "Default."
    }
  ]
}

```
