# CDS Hooks Card Types - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CDS Hooks Card Types**

## CodeSystem: CDS Hooks Card Types 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/cdshooks-card-type | *Version*:1.0.0 | | |
| Active as of 2025-10-16 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CDSHooksCardType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.176 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Codes defining types of cards that can potentially be returned by a decision support service. The initial set of codes is biased towards those related to insurance coverage, but all types of response types are acceptable in the code system. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cdshooks-card-type",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/cdshooks-card-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.176"
    }
  ],
  "version" : "1.0.0",
  "name" : "CDSHooksCardType",
  "title" : "CDS Hooks Card Types",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes defining types of cards that can potentially be returned by a decision support service.  The initial set of codes is biased towards those related to insurance coverage, but all types of response types are acceptable in the code system.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "concept" : [
    {
      "code" : "coverage-info",
      "display" : "Coverage Information",
      "definition" : "Information related to the patient's coverage, including whether a service is covered, requires prior authorization, is approved without seeking prior authorization, and/or requires additional documentation or data collection",
      "concept" : [
        {
          "code" : "unsolicited-determ",
          "display" : "Unsolicited Determination",
          "definition" : "An unsolicited approval of the service as having prior authorization requirements met without a formal submission of a prior authorization request"
        }
      ]
    },
    {
      "code" : "claim",
      "display" : "Claim",
      "definition" : "Information about what steps need to be taken to submit a claim for the service"
    },
    {
      "code" : "insurance",
      "display" : "Insurance",
      "definition" : "Allows a provider to update the patient's coverage information with additional details from the payer (e.g. expiry date, coverage extensions)"
    },
    {
      "code" : "limits",
      "display" : "Limits",
      "definition" : "Messages warning about the patient approaching or exceeding their limits for a particular type of coverage or expiry date for coverage in general"
    },
    {
      "code" : "network",
      "display" : "Network",
      "definition" : "Providing information about in-network providers that could deliver the order (or in-network alternatives for an order directed out-of-network)"
    },
    {
      "code" : "appropriate-use",
      "display" : "Appropriate Use",
      "definition" : "Guidance on whether appropriate-use documentation is needed"
    },
    {
      "code" : "cost",
      "display" : "Cost",
      "definition" : "What is the anticipated cost to the patient based on their coverage"
    },
    {
      "code" : "therapy-alternatives-opt",
      "display" : "Optional Therapy Alternatives",
      "definition" : "Are there alternative therapies that have better coverage and/or are lower-cost for the patient"
    },
    {
      "code" : "therapy-alternatives-req",
      "display" : "Required Therapy Alternatives",
      "definition" : "Are there alternative therapies that must be tried first prior to coverage being available for the proposed therapy"
    },
    {
      "code" : "clinical-reminder",
      "display" : "Clinical Reminder",
      "definition" : "Reminders that a patient is due for certain screening or other therapy (based on payer recorded date of last intervention)"
    },
    {
      "code" : "duplicate-therapy",
      "display" : "Duplicate Therapy",
      "definition" : "Notice that the proposed intervention has already recently occurred with a different provider when that information isn't already available in the provider system"
    },
    {
      "code" : "contraindication",
      "display" : "Contraindication",
      "definition" : "Notice that the proposed intervention may be contraindicated based on information the payer has in their record that the provider doesn't have in theirs"
    },
    {
      "code" : "guideline",
      "display" : "Guideline",
      "definition" : "Indication that there is a guideline available for the proposed therapy (with an option to view)"
    },
    {
      "code" : "off-guideline",
      "display" : "Off Guideline",
      "definition" : "Notice that the proposed therapy may be contrary to best-practice guidelines, typically with an option to view the relevant guideline"
    }
  ]
}

```
