# Artifact Contribution Instance Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Artifact Contribution Instance Type**

## CodeSystem: Artifact Contribution Instance Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/artifact-contribution-instance-type | *Version*:1.0.0 | | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:ArtifactContributionInstanceType |

 
Artifact Contribution Instance Type 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ArtifactContributionInstanceType](ValueSet-artifact-contribution-instance-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "artifact-contribution-instance-type",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/artifact-contribution-instance-type",
  "version" : "1.0.0",
  "name" : "ArtifactContributionInstanceType",
  "title" : "Artifact Contribution Instance Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T10:55:11.085+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Artifact Contribution Instance Type",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/artifact-contribution-instance-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "reviewed",
      "display" : "Reviewed",
      "definition" : "Reviewed"
    },
    {
      "code" : "approved",
      "display" : "Approved",
      "definition" : "Approved"
    },
    {
      "code" : "edited",
      "display" : "Edited",
      "definition" : "Edited"
    }
  ]
}

```
