# Admit source - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Admit source**

## CodeSystem: Admit source 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/admit-source | *Version*:1.0.1 | |
| Active as of 2026-01-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdmitSource |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1092 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
This value set defines a set of codes that can be used to indicate from where the patient came in. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AdmitSource](ValueSet-encounter-admit-source.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "admit-source",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/admit-source",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1092"
    }
  ],
  "version" : "1.0.1",
  "name" : "AdmitSource",
  "title" : "Admit source",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines a set of codes that can be used to indicate from where the patient came in.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/encounter-admit-source",
  "content" : "complete",
  "concept" : [
    {
      "code" : "hosp-trans",
      "display" : "Transferred from other hospital",
      "definition" : "The Patient has been transferred from another hospital for this encounter."
    },
    {
      "code" : "emd",
      "display" : "From accident/emergency department",
      "definition" : "The patient has been transferred from the emergency department within the hospital. This is typically used in the transition to an inpatient encounter"
    },
    {
      "code" : "outp",
      "display" : "From outpatient department",
      "definition" : "The patient has been transferred from an outpatient department within the hospital."
    },
    {
      "code" : "born",
      "display" : "Born in hospital",
      "definition" : "The patient is a newborn and the encounter will track the baby related activities (as opposed to the Mothers encounter - that may be associated using the newborn encounters partof property)"
    },
    {
      "code" : "gp",
      "display" : "General Practitioner referral",
      "definition" : "The patient has been admitted due to a referred from a General Practitioner."
    },
    {
      "code" : "mp",
      "display" : "Medical Practitioner/physician referral",
      "definition" : "The patient has been admitted due to a referred from a Specialist (as opposed to a General Practitioner)."
    },
    {
      "code" : "nursing",
      "display" : "From nursing home",
      "definition" : "The patient has been transferred from a nursing home."
    },
    {
      "code" : "psych",
      "display" : "From psychiatric hospital",
      "definition" : "The patient has been transferred from a psychiatric facility."
    },
    {
      "code" : "rehab",
      "display" : "From rehabilitation facility",
      "definition" : "The patient has been transferred from a rehabilitation facility or clinic."
    },
    {
      "code" : "other",
      "display" : "Other",
      "definition" : "The patient has been admitted from a source otherwise not specified here."
    }
  ]
}

```
