# Changes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* **Changes**

## Changes

 This page contains a list of JIRA tickets that have been implemented in this release. As well as the following new features: 

### What's New in 7.0.1?

 This was a patch release to correct versions for v2 code systems, which should have been updated as a result of implementing a fix to undefined status concept properties. 

### What's New in 7.0.0?

 This was a regularly scheduled release with several major improvments to THO's functionality. 

1. Placed all external terminology content under one section of THO "External Content".
1. Replaced code system resources for metadata records with HTML pages
1. Made accessing information on external code systems simpler by having it all accessible from a single page, and having the URI and/or OID accessible directly on that page.
1. Added the capability to filter HL7 Code Systems, Value Sets, and External Identifier Systems. Filtering External Code Systems will occur in a later release

 The following JIRA tickets in the UP JIRA project have been implemented: 

| | | |
| :--- | :--- | :--- |
| Pro Forma | Request to deprecate the concept PHDSCSOPT in the HL7 THO coding System | [UP-698](https://jira.hl7.org/browse/UP-698) |
| Change Request | Rename v2 table 0003 to disambiguate from table 0450 | [UP-714](https://jira.hl7.org/browse/UP-714) |
| Change Request | Add new UMB code to v2-0203 | [UP-666](https://jira.hl7.org/browse/UP-666) |
| Change Request | Update USEncounterDischarge Disposition for US Core | [UP-747](https://jira.hl7.org/browse/UP-747) |
| Pro Forma | Remove "Specializes" and "Generalizes" properties from v3 code systems | [UP-730](https://jira.hl7.org/browse/UP-730) |
| Pro Forma | Move OO CodeSystems to THO | [UP-752](https://jira.hl7.org/browse/UP-752) |
| Change Request | Add transmitter concept to provenance participant type | [UP-748](https://jira.hl7.org/browse/UP-748) |
| Change Request | Create an ISO-8601 Derived Periods Code System | [UP-709](https://jira.hl7.org/browse/UP-709) |
| Change Request | Create a CDSHooksCard code system | [UP-669](https://jira.hl7.org/browse/UP-669) |
| Change Request | Remove duplicate terms in artifact-relationship-type valueSet | [UP-711](https://jira.hl7.org/browse/UP-711) |
| Change Request | Add publication-date to list order | [UP-739](https://jira.hl7.org/browse/UP-739) |
| Change Request | Add a new Coverage Detail code system to THO | [UP-670](https://jira.hl7.org/browse/UP-670) |
| Change Request | Provide guidance for accessing the codes | [UP-627](https://jira.hl7.org/browse/UP-627) |
| Change Request | Add artifact version policy codes | [UP-716](https://jira.hl7.org/browse/UP-716) |
| Change Request | Change the ResearchSubjectMilestone ValueSet to use NCIT | [UP-696](https://jira.hl7.org/browse/UP-696) |
| Pro Forma | Change UK spellings to US for service-category codes | [UP-744](https://jira.hl7.org/browse/UP-744) |
| Change Request | Add diagnostic-report-impression to CodeSystem-condition-category | [UP-635](https://jira.hl7.org/browse/UP-635) |
| Pro Forma | Create a Study Design value set from Scientific Evidence Code System (SEVCO) | [UP-757](https://jira.hl7.org/browse/UP-757) |
| Change Request | Update Observation Category Codes | [UP-738](https://jira.hl7.org/browse/UP-738) |
| Pro Forma | Create THO Value Set for FHIR Immunization.performer.function | [UP-743](https://jira.hl7.org/browse/UP-743) |
| Pro Forma | Add Group Code code system to THO | [UP-740](https://jira.hl7.org/browse/UP-740) |
| Change Request | Retire of EvidenceVariableRole ValueSet and CodeSystem from THO | [UP-675](https://jira.hl7.org/browse/UP-675) |
| Pro Forma | SOPT - Additional Identifier and Other Changes | [UP-631](https://jira.hl7.org/browse/UP-631) |
| Change Request | add additional format codes for IPS | [UP-697](https://jira.hl7.org/browse/UP-697) |
| Pro Forma | Additional concepts for the HL7 Workgroup code system | [UP-712](https://jira.hl7.org/browse/UP-712) |
| Change Request | Add a ValueSet for ImagingSelectionReferenceType | [UP-741](https://jira.hl7.org/browse/UP-741) |
| Pro Forma | Clarify ICD-9 Identifiers on "Using ICD with HL7 Standards" Page | [UP-718](https://jira.hl7.org/browse/UP-718) |
| Pro Forma | Add FEvIR Object Identifier (FOI) Identifier System per TSMG | [UP-723](https://jira.hl7.org/browse/UP-723) |
| Pro Forma | Overhaul External Code System Representation in THO | [UP-742](https://jira.hl7.org/browse/UP-742) |
| Change Request | Make explicit that IRI identifiers are not intended to be used in Identifier.system or Coding.system | [UP-465](https://jira.hl7.org/browse/UP-465) |
| Pro Forma | Move Research Study Party Role Code System and ValueSet from FHIR to THO | [UP-753](https://jira.hl7.org/browse/UP-753) |
| Pro Forma | Move the Research Study Status CodeSystem and ValueSet to THO | [UP-758](https://jira.hl7.org/browse/UP-758) |

### What's New in 6.5.0?

 This was a regularly scheduled release with no significant changes to the structure of THO. 

 The following JIRA tickets in the UP JIRA project have been implemented: 

| | | |
| :--- | :--- | :--- |
| Change Request | Create CodeSystem and ValueSet to replace Ex-ProcedureType | [UP-686](https://jira.hl7.org/browse/UP-686) |
| Change Request | Create CodeSystem and ValueSet to indicate Medical Management Types | [UP-689](https://jira.hl7.org/browse/UP-689) |
| Change Request | Create CodeSystem and ValueSet to replace Ex-DiagnosisType | [UP-688](https://jira.hl7.org/browse/UP-688) |
| Change Request | Update Network Type Codes CodeSystem to incorporate the code negotiated | [UP-692](https://jira.hl7.org/browse/UP-692) |
| Change Request | Move three DeviceAlert related CodeSystems and their attendant ValueSets from FHIR core to THO | [UP-656](https://jira.hl7.org/browse/UP-656) |
| Change Request | Add codes 25, 26 to https://terminology.hl7.org/CodeSystem-object-role.html | [UP-621](https://jira.hl7.org/browse/UP-621) |
| Change Request | Add payment related identifier types to CodeSystem v2-0203 | [UP-699](https://jira.hl7.org/browse/UP-699) |
| Pro Forma | Change to OHDSI Standardized Vocabularies HTA record Publisher metadata | [UP-703](https://jira.hl7.org/browse/UP-703) |

### What's New in 6.4.0?

 This was an interim release to address issues needed for US Core, C-CDA, and FHIR Clinical Documents publications. 

 The following JIRA tickets in the UP JIRA project have been implemented: 

| | | |
| :--- | :--- | :--- |
| Pro Forma | Update MDC CodeSystem with copyright statement | [UP-667](https://jira.hl7.org/browse/UP-667) |
| Pro Forma | Fix erroneous codes in table 0550 | [UP-681](https://jira.hl7.org/browse/UP-681) |
| Change Request | Valuesets for FHIR Clinical Documents | [UP-665](https://jira.hl7.org/browse/UP-665) |
| Pro Forma | All codes value set for USPS code system | [UP-695](https://jira.hl7.org/browse/UP-695) |
| Pro Forma | Add all codes value set for CMS POS code system | [UP-680](https://jira.hl7.org/browse/UP-680) |
| Pro Forma | Add USPS State Codes per TSMG | [UP-684](https://jira.hl7.org/browse/UP-684) |
| Pro Forma | Add National Association of Insurance Commissioners (NAIC) Company Codes Identifier System per TSMG | [UP-683](https://jira.hl7.org/browse/UP-683) |

### What's New in 6.3.0?

1. Added a Changes page to start tracking changes within the IG.

 The following JIRA tickets in the UP JIRA project have been implemented: 

| | | |
| :--- | :--- | :--- |
| Change Request | Add NCIT code to v2 0396 | [UP-586](https://jira.hl7.org/browse/UP-586) |
| Change Request | add identifier type for "Kassensitz-IK" to identifier type (table 0203) | [UP-561](https://jira.hl7.org/browse/UP-561) |
| Change Request | add codes to v2-0203 for use in German profiles | [UP-339](https://jira.hl7.org/browse/UP-339) |
| Change Request | Merge and migrate US Core and C-CDA discharge disposition value sets to THO | [UP-578](https://jira.hl7.org/browse/UP-578) |
| Change Request | Update v3 DocumentFormatCodes to align with C-CDA versions in use | [UP-626](https://jira.hl7.org/browse/UP-626) |
| Change Request | Add topic and jurisdiction codes to | [UP-401](https://jira.hl7.org/browse/UP-401) |
| Change Request | MeasureSupplementalData code system and value set should be active | [UP-651](https://jira.hl7.org/browse/UP-651) |
| Change Request | Move terminologies from FHIR to THO for EBMonFHIR Resources | [UP-633](https://jira.hl7.org/browse/UP-633) |
| Change Request | Create a new combined CodeSystem within THO that will support the replacement of Composition.relatesTo when RelatedArtifact datatype is deprecated | [UP-644](https://jira.hl7.org/browse/UP-644) |
| Change Request | The narrative definition of the code "complete" is not consistent with the usage in immunizationRecommendation. | [UP-580](https://jira.hl7.org/browse/UP-580) |
| Change Request | Create a THO Valueset for Y/N/NA/UNK | [UP-642](https://jira.hl7.org/browse/UP-642) |
| Change Request | Add "protocol" to PlanDefinitionType | [UP-655](https://jira.hl7.org/browse/UP-655) |
| Pro Forma | Add Links to Versioning Policy and Release Notes | [UP-654](https://jira.hl7.org/browse/UP-654) |
| Change Request | Create a US Realm language value set | [UP-636](https://jira.hl7.org/browse/UP-636) |
| Pro Forma | Add Scientific Evidence Code System (SEVCO) per TSMG | [UP-650](https://jira.hl7.org/browse/UP-650) |
| Pro Forma | Add URIs for V2 Tables Code Systems and Value Sets | [UP-648](https://jira.hl7.org/browse/UP-648) |
| Pro Forma | Add Temporary uri for ICH Context of Use | [UP-632](https://jira.hl7.org/browse/UP-632) |
| Pro Forma | Add Vaccine Information Statements per TSMG | [UP-649](https://jira.hl7.org/browse/UP-649) |
| Pro Forma | Add ICH Context of Use per TSMG | [UP-663](https://jira.hl7.org/browse/UP-663) |
| Pro Forma | Add UniProt Identifier System per TSMG | [UP-664](https://jira.hl7.org/browse/UP-664) |
| Pro Forma | Create a convenience copy of the CMS POS code system | [UP-590](https://jira.hl7.org/browse/UP-590) |

