#  - HL7 Terminology (THO) v7.0.1

## : 



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "hxutg1-1-0-12",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-bluetooth-address-identifier-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-bluetooth-address-identifier-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-bluetooth-address-identifier-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-bluetooth-address-identifier-ns-3-0-12</b></p><a name=\"hx3l-bluetooth-address-identifier-ns-3-0-12\"> </a><a name=\"hchx3l-bluetooth-address-identifier-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-bluetooth-address-identifier.html\">NamingSystem Bluetooth Address as a device identifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/bluetooth-address-identifier"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-usb-address-identifier-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-usb-address-identifier-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-usb-address-identifier-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-usb-address-identifier-ns-3-0-12</b></p><a name=\"hx3l-usb-address-identifier-ns-3-0-12\"> </a><a name=\"hchx3l-usb-address-identifier-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-usb-address-identifier.html\">NamingSystem USB VID and PID as a device identifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/usb-address-identifier"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-zigbee-address-identifier-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-zigbee-address-identifier-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-zigbee-address-identifier-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-zigbee-address-identifier-ns-3-0-12</b></p><a name=\"hx3l-zigbee-address-identifier-ns-3-0-12\"> </a><a name=\"hchx3l-zigbee-address-identifier-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-zigbee-address-identifier.html\">NamingSystem ZigBee Address as a device identifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/zigbee-address-identifier"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-uri-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-uri-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-uri-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-uri-ns-3-0-12</b></p><a name=\"hx3l-uri-ns-3-0-12\"> </a><a name=\"hchx3l-uri-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-uri.html\">NamingSystem Uniform Resource Identifier (URI)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/uri"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-ssn-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-ssn-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-ssn-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-ssn-ns-3-0-12</b></p><a name=\"hx3l-ssn-ns-3-0-12\"> </a><a name=\"hchx3l-ssn-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-ssn.html\">NamingSystem United States Social Security Number</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ssn"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-dui-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-dui-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-dui-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-dui-ns-3-0-12</b></p><a name=\"hx3l-dui-ns-3-0-12\"> </a><a name=\"hchx3l-dui-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-dui.html\">NamingSystem DICOM Unique Id</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/dui"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-medicareHIC-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-medicareHIC-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-medicareHIC-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-medicareHIC-ns-3-0-12</b></p><a name=\"hx3l-medicareHIC-ns-3-0-12\"> </a><a name=\"hchx3l-medicareHIC-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-medicareHIC.html\">NamingSystem United States Medicare Number</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/medicareHIC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-npi-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-npi-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-npi-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-npi-ns-3-0-12</b></p><a name=\"hx3l-npi-ns-3-0-12\"> </a><a name=\"hchx3l-npi-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-npi.html\">NamingSystem United States National Provider Identifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/npi"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-cmsMBI-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-cmsMBI-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-cmsMBI-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-cmsMBI-ns-3-0-12</b></p><a name=\"hx3l-cmsMBI-ns-3-0-12\"> </a><a name=\"hchx3l-cmsMBI-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-cmsMBI.html\">NamingSystem Medicare Beneficiary Identifier (United States)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/cmsMBI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-gtin-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-gtin-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-gtin-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-gtin-ns-3-0-12</b></p><a name=\"hx3l-gtin-ns-3-0-12\"> </a><a name=\"hchx3l-gtin-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-gtin.html\">NamingSystem GTIN Global Trade Item Number</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/gtin"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-AlaskaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-AlaskaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-AlaskaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-AlaskaDLN-ns-3-0-12</b></p><a name=\"hx3l-AlaskaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-AlaskaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-AlaskaDLN.html\">NamingSystem Alaska Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/AlaskaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-AlabamaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-AlabamaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-AlabamaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-AlabamaDLN-ns-3-0-12</b></p><a name=\"hx3l-AlabamaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-AlabamaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-AlabamaDLN.html\">NamingSystem Alabama Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/AlabamaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-ArkansasDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-ArkansasDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-ArkansasDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-ArkansasDLN-ns-3-0-12</b></p><a name=\"hx3l-ArkansasDLN-ns-3-0-12\"> </a><a name=\"hchx3l-ArkansasDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-ArkansasDLN.html\">NamingSystem Arkansas Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ArkansasDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-ArizonaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-ArizonaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-ArizonaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-ArizonaDLN-ns-3-0-12</b></p><a name=\"hx3l-ArizonaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-ArizonaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-ArizonaDLN.html\">NamingSystem Arizona Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ArizonaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-CaliforniaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-CaliforniaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-CaliforniaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-CaliforniaDLN-ns-3-0-12</b></p><a name=\"hx3l-CaliforniaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-CaliforniaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-CaliforniaDLN.html\">NamingSystem California Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CaliforniaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-ColoradoDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-ColoradoDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-ColoradoDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-ColoradoDLN-ns-3-0-12</b></p><a name=\"hx3l-ColoradoDLN-ns-3-0-12\"> </a><a name=\"hchx3l-ColoradoDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-ColoradoDLN.html\">NamingSystem Colorado Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ColoradoDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-ConnecticutDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-ConnecticutDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-ConnecticutDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-ConnecticutDLN-ns-3-0-12</b></p><a name=\"hx3l-ConnecticutDLN-ns-3-0-12\"> </a><a name=\"hchx3l-ConnecticutDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-ConnecticutDLN.html\">NamingSystem Connecticut Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ConnecticutDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-DCDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-DCDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-DCDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-DCDLN-ns-3-0-12</b></p><a name=\"hx3l-DCDLN-ns-3-0-12\"> </a><a name=\"hchx3l-DCDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-DCDLN.html\">NamingSystem DC Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DCDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-DelawareDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-DelawareDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-DelawareDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-DelawareDLN-ns-3-0-12</b></p><a name=\"hx3l-DelawareDLN-ns-3-0-12\"> </a><a name=\"hchx3l-DelawareDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-DelawareDLN.html\">NamingSystem Delaware Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/DelawareDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-FloridaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-FloridaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-FloridaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-FloridaDLN-ns-3-0-12</b></p><a name=\"hx3l-FloridaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-FloridaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-FloridaDLN.html\">NamingSystem Florida Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/FloridaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-GeorgiaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-GeorgiaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-GeorgiaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-GeorgiaDLN-ns-3-0-12</b></p><a name=\"hx3l-GeorgiaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-GeorgiaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-GeorgiaDLN.html\">NamingSystem Georgia Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/GeorgiaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-HawaiiDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-HawaiiDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-HawaiiDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-HawaiiDLN-ns-3-0-12</b></p><a name=\"hx3l-HawaiiDLN-ns-3-0-12\"> </a><a name=\"hchx3l-HawaiiDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-HawaiiDLN.html\">NamingSystem Hawaii Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/HawaiiDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-IndianaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-IndianaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-IndianaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-IndianaDLN-ns-3-0-12</b></p><a name=\"hx3l-IndianaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-IndianaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-IndianaDLN.html\">NamingSystem Indiana Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/IndianaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-IowaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-IowaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-IowaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-IowaDLN-ns-3-0-12</b></p><a name=\"hx3l-IowaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-IowaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-IowaDLN.html\">NamingSystem Iowa Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/IowaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-IdahoDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-IdahoDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-IdahoDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-IdahoDLN-ns-3-0-12</b></p><a name=\"hx3l-IdahoDLN-ns-3-0-12\"> </a><a name=\"hchx3l-IdahoDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-IdahoDLN.html\">NamingSystem Idaho Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/IdahoDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-IllinoisDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-IllinoisDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-IllinoisDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-IllinoisDLN-ns-3-0-12</b></p><a name=\"hx3l-IllinoisDLN-ns-3-0-12\"> </a><a name=\"hchx3l-IllinoisDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-IllinoisDLN.html\">NamingSystem Illinois Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/IllinoisDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-KansasDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-KansasDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-KansasDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-KansasDLN-ns-3-0-12</b></p><a name=\"hx3l-KansasDLN-ns-3-0-12\"> </a><a name=\"hchx3l-KansasDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-KansasDLN.html\">NamingSystem Kansas Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:38-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/KansasDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:38-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-KentuckyDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-KentuckyDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-KentuckyDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-KentuckyDLN-ns-3-0-12</b></p><a name=\"hx3l-KentuckyDLN-ns-3-0-12\"> </a><a name=\"hchx3l-KentuckyDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-KentuckyDLN.html\">NamingSystem Kentucky Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/KentuckyDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-LouisianaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-LouisianaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-LouisianaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-LouisianaDLN-ns-3-0-12</b></p><a name=\"hx3l-LouisianaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-LouisianaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-LouisianaDLN.html\">NamingSystem Louisiana Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/LouisianaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-MassachusettsDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-MassachusettsDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-MassachusettsDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-MassachusettsDLN-ns-3-0-12</b></p><a name=\"hx3l-MassachusettsDLN-ns-3-0-12\"> </a><a name=\"hchx3l-MassachusettsDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-MassachusettsDLN.html\">NamingSystem Massachusetts Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MassachusettsDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-MarylandDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-MarylandDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-MarylandDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-MarylandDLN-ns-3-0-12</b></p><a name=\"hx3l-MarylandDLN-ns-3-0-12\"> </a><a name=\"hchx3l-MarylandDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-MarylandDLN.html\">NamingSystem Maryland Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MarylandDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-MaineDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-MaineDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-MaineDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-MaineDLN-ns-3-0-12</b></p><a name=\"hx3l-MaineDLN-ns-3-0-12\"> </a><a name=\"hchx3l-MaineDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-MaineDLN.html\">NamingSystem Maine Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MaineDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-MichiganDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-MichiganDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-MichiganDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-MichiganDLN-ns-3-0-12</b></p><a name=\"hx3l-MichiganDLN-ns-3-0-12\"> </a><a name=\"hchx3l-MichiganDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-MichiganDLN.html\">NamingSystem Michigan Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MichiganDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-MinnesotaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-MinnesotaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-MinnesotaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-MinnesotaDLN-ns-3-0-12</b></p><a name=\"hx3l-MinnesotaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-MinnesotaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-MinnesotaDLN.html\">NamingSystem Minnesota Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MinnesotaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-MissouriDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-MissouriDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-MissouriDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-MissouriDLN-ns-3-0-12</b></p><a name=\"hx3l-MissouriDLN-ns-3-0-12\"> </a><a name=\"hchx3l-MissouriDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-MissouriDLN.html\">NamingSystem Missouri Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MissouriDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-MississippiDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-MississippiDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-MississippiDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-MississippiDLN-ns-3-0-12</b></p><a name=\"hx3l-MississippiDLN-ns-3-0-12\"> </a><a name=\"hchx3l-MississippiDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-MississippiDLN.html\">NamingSystem Mississippi Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MississippiDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-MontanaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-MontanaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-MontanaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-MontanaDLN-ns-3-0-12</b></p><a name=\"hx3l-MontanaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-MontanaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-MontanaDLN.html\">NamingSystem Montana Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MontanaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-NewYorkDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-NewYorkDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-NewYorkDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-NewYorkDLN-ns-3-0-12</b></p><a name=\"hx3l-NewYorkDLN-ns-3-0-12\"> </a><a name=\"hchx3l-NewYorkDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-NewYorkDLN.html\">NamingSystem New York Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NewYorkDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-NorthCarolinaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-NorthCarolinaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-NorthCarolinaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-NorthCarolinaDLN-ns-3-0-12</b></p><a name=\"hx3l-NorthCarolinaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-NorthCarolinaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-NorthCarolinaDLN.html\">NamingSystem North Carolina Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NorthCarolinaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-NorthDakotaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-NorthDakotaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-NorthDakotaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-NorthDakotaDLN-ns-3-0-12</b></p><a name=\"hx3l-NorthDakotaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-NorthDakotaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-NorthDakotaDLN.html\">NamingSystem North Dakota Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NorthDakotaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-NebraskaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-NebraskaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-NebraskaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-NebraskaDLN-ns-3-0-12</b></p><a name=\"hx3l-NebraskaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-NebraskaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-NebraskaDLN.html\">NamingSystem Nebraska Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NebraskaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-NewHampshireDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-NewHampshireDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-NewHampshireDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-NewHampshireDLN-ns-3-0-12</b></p><a name=\"hx3l-NewHampshireDLN-ns-3-0-12\"> </a><a name=\"hchx3l-NewHampshireDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-NewHampshireDLN.html\">NamingSystem New Hampshire Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NewHampshireDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-NewJerseyDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-NewJerseyDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-NewJerseyDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-NewJerseyDLN-ns-3-0-12</b></p><a name=\"hx3l-NewJerseyDLN-ns-3-0-12\"> </a><a name=\"hchx3l-NewJerseyDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-NewJerseyDLN.html\">NamingSystem New Jersey Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NewJerseyDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-NewMexicoDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-NewMexicoDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-NewMexicoDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-NewMexicoDLN-ns-3-0-12</b></p><a name=\"hx3l-NewMexicoDLN-ns-3-0-12\"> </a><a name=\"hchx3l-NewMexicoDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-NewMexicoDLN.html\">NamingSystem NewMexico Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NewMexicoDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-NevadaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-NevadaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-NevadaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-NevadaDLN-ns-3-0-12</b></p><a name=\"hx3l-NevadaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-NevadaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-NevadaDLN.html\">NamingSystem Nevada Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/NevadaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-OhioDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-OhioDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-OhioDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-OhioDLN-ns-3-0-12</b></p><a name=\"hx3l-OhioDLN-ns-3-0-12\"> </a><a name=\"hchx3l-OhioDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-OhioDLN.html\">NamingSystem Ohio Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/OhioDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-OklahomaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-OklahomaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-OklahomaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-OklahomaDLN-ns-3-0-12</b></p><a name=\"hx3l-OklahomaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-OklahomaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-OklahomaDLN.html\">NamingSystem Oklahoma Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/OklahomaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-OregonDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-OregonDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-OregonDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-OregonDLN-ns-3-0-12</b></p><a name=\"hx3l-OregonDLN-ns-3-0-12\"> </a><a name=\"hchx3l-OregonDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-OregonDLN.html\">NamingSystem Oregon Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/OregonDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-PennsylvaniaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-PennsylvaniaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-PennsylvaniaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-PennsylvaniaDLN-ns-3-0-12</b></p><a name=\"hx3l-PennsylvaniaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-PennsylvaniaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-PennsylvaniaDLN.html\">NamingSystem Pennsylvania Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/PennsylvaniaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-RhodeIslandDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-RhodeIslandDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-RhodeIslandDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-RhodeIslandDLN-ns-3-0-12</b></p><a name=\"hx3l-RhodeIslandDLN-ns-3-0-12\"> </a><a name=\"hchx3l-RhodeIslandDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-RhodeIslandDLN.html\">NamingSystem Rhode Island Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/RhodeIslandDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-SouthCarolinaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-SouthCarolinaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-SouthCarolinaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-SouthCarolinaDLN-ns-3-0-12</b></p><a name=\"hx3l-SouthCarolinaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-SouthCarolinaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-SouthCarolinaDLN.html\">NamingSystem South Carolina Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/SouthCarolinaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-SouthDakotaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-SouthDakotaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-SouthDakotaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-SouthDakotaDLN-ns-3-0-12</b></p><a name=\"hx3l-SouthDakotaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-SouthDakotaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-SouthDakotaDLN.html\">NamingSystem South Dakota Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/SouthDakotaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-TennesseeDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-TennesseeDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-TennesseeDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-TennesseeDLN-ns-3-0-12</b></p><a name=\"hx3l-TennesseeDLN-ns-3-0-12\"> </a><a name=\"hchx3l-TennesseeDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-TennesseeDLN.html\">NamingSystem Tennessee Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/TennesseeDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-TexasDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-TexasDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-TexasDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-TexasDLN-ns-3-0-12</b></p><a name=\"hx3l-TexasDLN-ns-3-0-12\"> </a><a name=\"hchx3l-TexasDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-TexasDLN.html\">NamingSystem Texas Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/TexasDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-UtahDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-UtahDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-UtahDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-UtahDLN-ns-3-0-12</b></p><a name=\"hx3l-UtahDLN-ns-3-0-12\"> </a><a name=\"hchx3l-UtahDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-UtahDLN.html\">NamingSystem Utah Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/UtahDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-VirginiaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-VirginiaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-VirginiaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-VirginiaDLN-ns-3-0-12</b></p><a name=\"hx3l-VirginiaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-VirginiaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-VirginiaDLN.html\">NamingSystem Virginia Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/VirginiaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-VermontDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-VermontDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-VermontDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-VermontDLN-ns-3-0-12</b></p><a name=\"hx3l-VermontDLN-ns-3-0-12\"> </a><a name=\"hchx3l-VermontDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-VermontDLN.html\">NamingSystem Vermont Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/VermontDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-WashingtonDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-WashingtonDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-WashingtonDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-WashingtonDLN-ns-3-0-12</b></p><a name=\"hx3l-WashingtonDLN-ns-3-0-12\"> </a><a name=\"hchx3l-WashingtonDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-WashingtonDLN.html\">NamingSystem Washington Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/WashingtonDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-WisconsinDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-WisconsinDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-WisconsinDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-WisconsinDLN-ns-3-0-12</b></p><a name=\"hx3l-WisconsinDLN-ns-3-0-12\"> </a><a name=\"hchx3l-WisconsinDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-WisconsinDLN.html\">NamingSystem Wisconsin Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/WisconsinDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-WestVirginiaDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-WestVirginiaDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-WestVirginiaDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-WestVirginiaDLN-ns-3-0-12</b></p><a name=\"hx3l-WestVirginiaDLN-ns-3-0-12\"> </a><a name=\"hchx3l-WestVirginiaDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-WestVirginiaDLN.html\">NamingSystem West Virginia Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/WestVirginiaDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-WyomingDLN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-WyomingDLN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-WyomingDLN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-WyomingDLN-ns-3-0-12</b></p><a name=\"hx3l-WyomingDLN-ns-3-0-12\"> </a><a name=\"hchx3l-WyomingDLN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-WyomingDLN.html\">NamingSystem Wyoming Driver's License</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/WyomingDLN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-AFG-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-AFG-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-AFG-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-AFG-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-AFG-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-AFG-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-AFG.html\">NamingSystem Passport Numbers Namespace for AFGHANISTAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-AFG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ALA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ALA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ALA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ALA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ALA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ALA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ALA.html\">NamingSystem Passport Numbers Namespace for ALAND ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ALA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ALB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ALB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ALB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ALB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ALB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ALB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ALB.html\">NamingSystem Passport Numbers Namespace for ALBANIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ALB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-DZA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-DZA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-DZA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-DZA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-DZA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-DZA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-DZA.html\">NamingSystem Passport Numbers Namespace for ALGERIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-DZA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ASM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ASM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ASM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ASM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ASM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ASM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ASM.html\">NamingSystem Passport Numbers Namespace for AMERICAN SAMOA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ASM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-AND-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-AND-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-AND-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-AND-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-AND-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-AND-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-AND.html\">NamingSystem Passport Numbers Namespace for ANDORRA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-AND"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-AGO-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-AGO-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-AGO-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-AGO-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-AGO-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-AGO-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-AGO.html\">NamingSystem Passport Numbers Namespace for ANGOLA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-AGO"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-AIA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-AIA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-AIA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-AIA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-AIA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-AIA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-AIA.html\">NamingSystem Passport Numbers Namespace for ANGUILLA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-AIA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ATA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ATA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ATA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ATA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ATA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ATA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ATA.html\">NamingSystem Passport Numbers Namespace for ANTARCTICA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ATA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ATG-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ATG-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ATG-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ATG-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ATG-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ATG-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ATG.html\">NamingSystem Passport Numbers Namespace for ANTIGUA AND BARBUDA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ATG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ARG-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ARG-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ARG-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ARG-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ARG-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ARG-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ARG.html\">NamingSystem Passport Numbers Namespace for ARGENTINA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ARG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ARM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ARM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ARM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ARM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ARM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ARM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ARM.html\">NamingSystem Passport Numbers Namespace for ARMENIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ARM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ABW-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ABW-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ABW-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ABW-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ABW-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ABW-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ABW.html\">NamingSystem Passport Numbers Namespace for ARUBA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ABW"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-AUS-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-AUS-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-AUS-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-AUS-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-AUS-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-AUS-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-AUS.html\">NamingSystem Passport Numbers Namespace for AUSTRALIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-AUS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-AUT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-AUT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-AUT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-AUT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-AUT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-AUT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-AUT.html\">NamingSystem Passport Numbers Namespace for AUSTRIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-AUT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-AZE-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-AZE-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-AZE-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-AZE-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-AZE-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-AZE-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-AZE.html\">NamingSystem Passport Numbers Namespace for AZERBAIJAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-AZE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BHS-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BHS-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BHS-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BHS-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BHS-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BHS-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BHS.html\">NamingSystem Passport Numbers Namespace for BAHAMAS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BHS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BHR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BHR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BHR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BHR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BHR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BHR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BHR.html\">NamingSystem Passport Numbers Namespace for BAHRAIN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BHR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BGD-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BGD-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BGD-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BGD-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BGD-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BGD-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BGD.html\">NamingSystem Passport Numbers Namespace for BANGLADESH</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BGD"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BRB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BRB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BRB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BRB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BRB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BRB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BRB.html\">NamingSystem Passport Numbers Namespace for BARBADOS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BRB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BLR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BLR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BLR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BLR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BLR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BLR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BLR.html\">NamingSystem Passport Numbers Namespace for BELARUS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BLR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BEL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BEL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BEL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BEL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BEL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BEL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BEL.html\">NamingSystem Passport Numbers Namespace for BELGIUM</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BEL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BLZ-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BLZ-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BLZ-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BLZ-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BLZ-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BLZ-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BLZ.html\">NamingSystem Passport Numbers Namespace for BELIZE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BLZ"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BEN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BEN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BEN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BEN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BEN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BEN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BEN.html\">NamingSystem Passport Numbers Namespace for BENIN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BEN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BMU-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BMU-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BMU-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BMU-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BMU-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BMU-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BMU.html\">NamingSystem Passport Numbers Namespace for BERMUDA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BMU"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BTN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BTN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BTN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BTN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BTN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BTN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BTN.html\">NamingSystem Passport Numbers Namespace for BHUTAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BTN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BOL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BOL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BOL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BOL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BOL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BOL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BOL.html\">NamingSystem Passport Numbers Namespace for BOLIVIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BOL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BIH-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BIH-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BIH-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BIH-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BIH-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BIH-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BIH.html\">NamingSystem Passport Numbers Namespace for BOSNIA AND HERZEGOVINA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BIH"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BWA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BWA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BWA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BWA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BWA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BWA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BWA.html\">NamingSystem Passport Numbers Namespace for BOTSWANA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BWA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BVT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BVT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BVT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BVT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BVT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BVT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BVT.html\">NamingSystem Passport Numbers Namespace for BOUVET ISLAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BVT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BRA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BRA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BRA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BRA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BRA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BRA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BRA.html\">NamingSystem Passport Numbers Namespace for BRAZIL</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BRA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-IOT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-IOT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-IOT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-IOT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-IOT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-IOT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-IOT.html\">NamingSystem Passport Numbers Namespace for BRITISH INDIAN OCEAN TERRITORY</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-IOT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BRN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BRN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BRN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BRN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BRN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BRN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BRN.html\">NamingSystem Passport Numbers Namespace for BRUNEI DARUSSALAM</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BRN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BGR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BGR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BGR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BGR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BGR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BGR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BGR.html\">NamingSystem Passport Numbers Namespace for BULGARIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BGR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BFA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BFA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BFA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BFA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BFA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BFA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BFA.html\">NamingSystem Passport Numbers Namespace for BURKINA FASO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BFA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BDI-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BDI-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BDI-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BDI-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BDI-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BDI-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BDI.html\">NamingSystem Passport Numbers Namespace for BURUNDI</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BDI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-KHM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-KHM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-KHM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-KHM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-KHM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-KHM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-KHM.html\">NamingSystem Passport Numbers Namespace for CAMBODIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-KHM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CMR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CMR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CMR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CMR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CMR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CMR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CMR.html\">NamingSystem Passport Numbers Namespace for CAMEROON</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CMR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CAN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CAN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CAN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CAN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CAN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CAN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CAN.html\">NamingSystem Passport Numbers Namespace for CANADA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CAN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CPV-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CPV-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CPV-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CPV-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CPV-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CPV-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CPV.html\">NamingSystem Passport Numbers Namespace for CAPE VERDE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CPV"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CYM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CYM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CYM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CYM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CYM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CYM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CYM.html\">NamingSystem Passport Numbers Namespace for CAYMAN ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CYM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CAF-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CAF-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CAF-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CAF-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CAF-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CAF-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CAF.html\">NamingSystem Passport Numbers Namespace for CENTRAL AFRICAN REPUBLIC</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CAF"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TCD-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TCD-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TCD-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TCD-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TCD-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TCD-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TCD.html\">NamingSystem Passport Numbers Namespace for CHAD</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TCD"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CHL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CHL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CHL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CHL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CHL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CHL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CHL.html\">NamingSystem Passport Numbers Namespace for CHILE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CHL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CHN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CHN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CHN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CHN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CHN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CHN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CHN.html\">NamingSystem Passport Numbers Namespace for CHINA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CHN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CXR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CXR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CXR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CXR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CXR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CXR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CXR.html\">NamingSystem Passport Numbers Namespace for CHRISTMAS ISLAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CXR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CCK-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CCK-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CCK-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CCK-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CCK-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CCK-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CCK.html\">NamingSystem Passport Numbers Namespace for COCOS (KEELING) ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CCK"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-COL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-COL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-COL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-COL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-COL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-COL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-COL.html\">NamingSystem Passport Numbers Namespace for COLOMBIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-COL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-COM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-COM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-COM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-COM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-COM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-COM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-COM.html\">NamingSystem Passport Numbers Namespace for COMOROS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-COM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-COG-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-COG-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-COG-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-COG-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-COG-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-COG-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-COG.html\">NamingSystem Passport Numbers Namespace for CONGO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-COG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-COD-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-COD-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-COD-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-COD-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-COD-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-COD-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-COD.html\">NamingSystem Passport Numbers Namespace for CONGO, THE DEMOCRATIC REPUBLIC OF THE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-COD"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-COK-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-COK-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-COK-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-COK-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-COK-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-COK-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-COK.html\">NamingSystem Passport Numbers Namespace for COOK ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-COK"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CRI-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CRI-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CRI-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CRI-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CRI-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CRI-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CRI.html\">NamingSystem Passport Numbers Namespace for COSTA RICA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CRI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CIV-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CIV-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CIV-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CIV-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CIV-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CIV-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CIV.html\">NamingSystem Passport Numbers Namespace for COTE D'IVOIRE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CIV"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-HRV-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-HRV-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-HRV-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-HRV-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-HRV-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-HRV-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-HRV.html\">NamingSystem Passport Numbers Namespace for CROATIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-HRV"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CUB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CUB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CUB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CUB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CUB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CUB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CUB.html\">NamingSystem Passport Numbers Namespace for CUBA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CUB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CYP-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CYP-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CYP-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CYP-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CYP-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CYP-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CYP.html\">NamingSystem Passport Numbers Namespace for CYPRUS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CYP"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CZE-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CZE-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CZE-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CZE-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CZE-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CZE-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CZE.html\">NamingSystem Passport Numbers Namespace for CZECH REPUBLIC</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CZE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-DNK-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-DNK-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-DNK-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-DNK-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-DNK-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-DNK-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-DNK.html\">NamingSystem Passport Numbers Namespace for DENMARK</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-DNK"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-DJI-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-DJI-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-DJI-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-DJI-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-DJI-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-DJI-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-DJI.html\">NamingSystem Passport Numbers Namespace for DJIBOUTI</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-DJI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-DMA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-DMA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-DMA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-DMA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-DMA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-DMA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-DMA.html\">NamingSystem Passport Numbers Namespace for DOMINICA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-DMA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-DOM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-DOM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-DOM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-DOM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-DOM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-DOM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-DOM.html\">NamingSystem Passport Numbers Namespace for DOMINICAN REPUBLIC</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-DOM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ECU-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ECU-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ECU-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ECU-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ECU-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ECU-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ECU.html\">NamingSystem Passport Numbers Namespace for ECUADOR</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:39-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ECU"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:39-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-EGY-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-EGY-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-EGY-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-EGY-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-EGY-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-EGY-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-EGY.html\">NamingSystem Passport Numbers Namespace for EGYPT</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-EGY"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SLV-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SLV-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SLV-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SLV-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SLV-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SLV-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SLV.html\">NamingSystem Passport Numbers Namespace for EL SALVADOR</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SLV"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GNQ-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GNQ-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GNQ-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GNQ-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GNQ-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GNQ-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GNQ.html\">NamingSystem Passport Numbers Namespace for EQUATORIAL GUINEA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GNQ"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ERI-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ERI-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ERI-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ERI-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ERI-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ERI-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ERI.html\">NamingSystem Passport Numbers Namespace for ERITREA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ERI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-EST-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-EST-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-EST-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-EST-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-EST-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-EST-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-EST.html\">NamingSystem Passport Numbers Namespace for ESTONIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-EST"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ETH-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ETH-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ETH-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ETH-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ETH-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ETH-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ETH.html\">NamingSystem Passport Numbers Namespace for ETHIOPIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ETH"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-FLK-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-FLK-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-FLK-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-FLK-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-FLK-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-FLK-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-FLK.html\">NamingSystem Passport Numbers Namespace for FALKLAND ISLANDS (MALVINAS)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-FLK"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-FRO-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-FRO-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-FRO-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-FRO-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-FRO-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-FRO-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-FRO.html\">NamingSystem Passport Numbers Namespace for FAROE ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-FRO"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-FJI-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-FJI-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-FJI-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-FJI-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-FJI-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-FJI-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-FJI.html\">NamingSystem Passport Numbers Namespace for FIJI</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-FJI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-FIN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-FIN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-FIN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-FIN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-FIN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-FIN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-FIN.html\">NamingSystem Passport Numbers Namespace for FINLAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-FIN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-FRA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-FRA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-FRA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-FRA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-FRA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-FRA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-FRA.html\">NamingSystem Passport Numbers Namespace for FRANCE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-FRA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GUF-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GUF-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GUF-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GUF-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GUF-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GUF-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GUF.html\">NamingSystem Passport Numbers Namespace for FRENCH GUIANA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GUF"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PYF-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PYF-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PYF-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PYF-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PYF-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PYF-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PYF.html\">NamingSystem Passport Numbers Namespace for FRENCH POLYNESIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PYF"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ATF-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ATF-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ATF-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ATF-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ATF-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ATF-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ATF.html\">NamingSystem Passport Numbers Namespace for FRENCH SOUTHERN TERRITORIES</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ATF"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GAB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GAB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GAB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GAB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GAB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GAB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GAB.html\">NamingSystem Passport Numbers Namespace for GABON</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GAB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GMB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GMB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GMB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GMB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GMB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GMB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GMB.html\">NamingSystem Passport Numbers Namespace for GAMBIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GMB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GEO-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GEO-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GEO-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GEO-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GEO-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GEO-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GEO.html\">NamingSystem Passport Numbers Namespace for GEORGIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GEO"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-DEU-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-DEU-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-DEU-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-DEU-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-DEU-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-DEU-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-DEU.html\">NamingSystem Passport Numbers Namespace for GERMANY</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-DEU"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GHA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GHA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GHA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GHA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GHA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GHA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GHA.html\">NamingSystem Passport Numbers Namespace for GHANA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GHA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GIB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GIB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GIB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GIB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GIB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GIB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GIB.html\">NamingSystem Passport Numbers Namespace for GIBRALTAR</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GIB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GRC-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GRC-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GRC-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GRC-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GRC-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GRC-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GRC.html\">NamingSystem Passport Numbers Namespace for GREECE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GRC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GRL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GRL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GRL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GRL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GRL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GRL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GRL.html\">NamingSystem Passport Numbers Namespace for GREENLAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GRL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GRD-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GRD-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GRD-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GRD-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GRD-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GRD-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GRD.html\">NamingSystem Passport Numbers Namespace for GRENADA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GRD"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GLP-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GLP-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GLP-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GLP-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GLP-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GLP-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GLP.html\">NamingSystem Passport Numbers Namespace for GUADELOUPE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GLP"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GUM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GUM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GUM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GUM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GUM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GUM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GUM.html\">NamingSystem Passport Numbers Namespace for GUAM</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GUM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GTM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GTM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GTM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GTM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GTM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GTM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GTM.html\">NamingSystem Passport Numbers Namespace for GUATEMALA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GTM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GGY-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GGY-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GGY-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GGY-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GGY-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GGY-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GGY.html\">NamingSystem Passport Numbers Namespace for GUERNSEY</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GGY"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GIN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GIN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GIN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GIN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GIN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GIN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GIN.html\">NamingSystem Passport Numbers Namespace for GUINEA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GIN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GNB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GNB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GNB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GNB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GNB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GNB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GNB.html\">NamingSystem Passport Numbers Namespace for GUINEA-BISSAU</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GNB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GUY-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GUY-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GUY-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GUY-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GUY-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GUY-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GUY.html\">NamingSystem Passport Numbers Namespace for GUYANA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GUY"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-HTI-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-HTI-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-HTI-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-HTI-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-HTI-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-HTI-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-HTI.html\">NamingSystem Passport Numbers Namespace for HAITI</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-HTI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-HMD-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-HMD-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-HMD-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-HMD-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-HMD-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-HMD-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-HMD.html\">NamingSystem Passport Numbers Namespace for HEARD ISLAND AND MCDONALD ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-HMD"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-VAT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-VAT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-VAT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-VAT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-VAT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-VAT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-VAT.html\">NamingSystem Passport Numbers Namespace for HOLY SEE (VATICAN CITY STATE)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-VAT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-HND-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-HND-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-HND-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-HND-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-HND-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-HND-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-HND.html\">NamingSystem Passport Numbers Namespace for HONDURAS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-HND"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-HKG-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-HKG-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-HKG-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-HKG-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-HKG-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-HKG-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-HKG.html\">NamingSystem Passport Numbers Namespace for HONG KONG</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-HKG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-HUN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-HUN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-HUN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-HUN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-HUN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-HUN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-HUN.html\">NamingSystem Passport Numbers Namespace for HUNGARY</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-HUN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ISL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ISL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ISL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ISL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ISL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ISL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ISL.html\">NamingSystem Passport Numbers Namespace for ICELAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ISL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-IND-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-IND-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-IND-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-IND-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-IND-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-IND-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-IND.html\">NamingSystem Passport Numbers Namespace for INDIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-IND"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-IDN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-IDN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-IDN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-IDN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-IDN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-IDN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-IDN.html\">NamingSystem Passport Numbers Namespace for INDONESIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-IDN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-IRN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-IRN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-IRN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-IRN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-IRN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-IRN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-IRN.html\">NamingSystem Passport Numbers Namespace for IRAN (ISLAMIC REPUBLIC OF)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-IRN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-IRQ-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-IRQ-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-IRQ-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-IRQ-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-IRQ-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-IRQ-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-IRQ.html\">NamingSystem Passport Numbers Namespace for IRAQ</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-IRQ"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-IRL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-IRL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-IRL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-IRL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-IRL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-IRL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-IRL.html\">NamingSystem Passport Numbers Namespace for IRELAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-IRL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-IMM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-IMM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-IMM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-IMM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-IMM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-IMM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-IMM.html\">NamingSystem Passport Numbers Namespace for ISLE OF MAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-IMM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ISR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ISR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ISR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ISR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ISR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ISR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ISR.html\">NamingSystem Passport Numbers Namespace for ISRAEL</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ISR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ITA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ITA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ITA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ITA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ITA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ITA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ITA.html\">NamingSystem Passport Numbers Namespace for ITALY</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ITA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-JAM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-JAM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-JAM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-JAM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-JAM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-JAM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-JAM.html\">NamingSystem Passport Numbers Namespace for JAMAICA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-JAM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-JPN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-JPN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-JPN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-JPN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-JPN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-JPN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-JPN.html\">NamingSystem Passport Numbers Namespace for JAPAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-JPN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-JEY-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-JEY-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-JEY-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-JEY-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-JEY-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-JEY-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-JEY.html\">NamingSystem Passport Numbers Namespace for JERSEY</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-JEY"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-JOR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-JOR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-JOR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-JOR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-JOR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-JOR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-JOR.html\">NamingSystem Passport Numbers Namespace for JORDAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-JOR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-KAZ-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-KAZ-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-KAZ-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-KAZ-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-KAZ-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-KAZ-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-KAZ.html\">NamingSystem Passport Numbers Namespace for KAZAKHSTAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-KAZ"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-KEN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-KEN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-KEN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-KEN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-KEN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-KEN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-KEN.html\">NamingSystem Passport Numbers Namespace for KENYA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-KEN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-KIR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-KIR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-KIR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-KIR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-KIR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-KIR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-KIR.html\">NamingSystem Passport Numbers Namespace for KIRIBATI</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-KIR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PRK-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PRK-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PRK-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PRK-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PRK-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PRK-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PRK.html\">NamingSystem Passport Numbers Namespace for KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PRK"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-KOR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-KOR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-KOR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-KOR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-KOR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-KOR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-KOR.html\">NamingSystem Passport Numbers Namespace for KOREA, REPUBLIC OF</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-KOR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-KWT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-KWT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-KWT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-KWT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-KWT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-KWT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-KWT.html\">NamingSystem Passport Numbers Namespace for KUWAIT</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-KWT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-KGZ-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-KGZ-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-KGZ-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-KGZ-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-KGZ-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-KGZ-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-KGZ.html\">NamingSystem Passport Numbers Namespace for KYRGYZSTAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-KGZ"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-LAO-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-LAO-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-LAO-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-LAO-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-LAO-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-LAO-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-LAO.html\">NamingSystem Passport Numbers Namespace for LAO PEOPLE'S DEMOCRATIC REPUBLIC</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-LAO"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-LVA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-LVA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-LVA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-LVA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-LVA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-LVA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-LVA.html\">NamingSystem Passport Numbers Namespace for LATVIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-LVA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-LBN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-LBN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-LBN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-LBN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-LBN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-LBN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-LBN.html\">NamingSystem Passport Numbers Namespace for LEBANON</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-LBN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-LSO-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-LSO-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-LSO-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-LSO-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-LSO-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-LSO-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-LSO.html\">NamingSystem Passport Numbers Namespace for LESOTHO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-LSO"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-LBR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-LBR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-LBR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-LBR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-LBR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-LBR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-LBR.html\">NamingSystem Passport Numbers Namespace for LIBERIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-LBR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-LBY-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-LBY-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-LBY-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-LBY-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-LBY-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-LBY-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-LBY.html\">NamingSystem Passport Numbers Namespace for LIBYAN ARAB JAMAHIRIYA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-LBY"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-LIE-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-LIE-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-LIE-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-LIE-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-LIE-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-LIE-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-LIE.html\">NamingSystem Passport Numbers Namespace for LIECHTENSTEIN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-LIE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-LTU-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-LTU-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-LTU-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-LTU-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-LTU-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-LTU-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-LTU.html\">NamingSystem Passport Numbers Namespace for LITHUANIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-LTU"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-LUX-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-LUX-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-LUX-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-LUX-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-LUX-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-LUX-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-LUX.html\">NamingSystem Passport Numbers Namespace for LUXEMBOURG</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-LUX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MAC-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MAC-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MAC-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MAC-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MAC-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MAC-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MAC.html\">NamingSystem Passport Numbers Namespace for MACAO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MAC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MKD-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MKD-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MKD-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MKD-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MKD-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MKD-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MKD.html\">NamingSystem Passport Numbers Namespace for MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MKD"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MDG-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MDG-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MDG-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MDG-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MDG-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MDG-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MDG.html\">NamingSystem Passport Numbers Namespace for MADAGASCAR</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MDG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MWI-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MWI-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MWI-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MWI-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MWI-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MWI-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MWI.html\">NamingSystem Passport Numbers Namespace for MALAWI</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MWI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MYS-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MYS-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MYS-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MYS-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MYS-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MYS-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MYS.html\">NamingSystem Passport Numbers Namespace for MALAYSIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MYS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MDV-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MDV-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MDV-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MDV-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MDV-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MDV-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MDV.html\">NamingSystem Passport Numbers Namespace for MALDIVES</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MDV"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MLI-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MLI-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MLI-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MLI-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MLI-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MLI-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MLI.html\">NamingSystem Passport Numbers Namespace for MALI</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MLI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MLT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MLT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MLT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MLT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MLT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MLT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MLT.html\">NamingSystem Passport Numbers Namespace for MALTA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MLT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MHL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MHL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MHL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MHL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MHL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MHL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MHL.html\">NamingSystem Passport Numbers Namespace for MARSHALL ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MHL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MTQ-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MTQ-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MTQ-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MTQ-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MTQ-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MTQ-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MTQ.html\">NamingSystem Passport Numbers Namespace for MARTINIQUE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MTQ"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MRT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MRT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MRT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MRT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MRT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MRT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MRT.html\">NamingSystem Passport Numbers Namespace for MAURITANIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MRT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MUS-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MUS-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MUS-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MUS-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MUS-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MUS-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MUS.html\">NamingSystem Passport Numbers Namespace for MAURITIUS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MUS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MYT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MYT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MYT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MYT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MYT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MYT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MYT.html\">NamingSystem Passport Numbers Namespace for MAYOTTE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MYT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MEX-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MEX-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MEX-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MEX-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MEX-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MEX-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MEX.html\">NamingSystem Passport Numbers Namespace for MEXICO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MEX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-FSM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-FSM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-FSM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-FSM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-FSM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-FSM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-FSM.html\">NamingSystem Passport Numbers Namespace for MICRONESIA, FEDERATED STATES OF</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-FSM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MDA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MDA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MDA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MDA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MDA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MDA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MDA.html\">NamingSystem Passport Numbers Namespace for MOLDOVA, REPUBLIC OF</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MDA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MCO-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MCO-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MCO-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MCO-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MCO-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MCO-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MCO.html\">NamingSystem Passport Numbers Namespace for MONACO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MCO"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MNG-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MNG-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MNG-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MNG-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MNG-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MNG-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MNG.html\">NamingSystem Passport Numbers Namespace for MONGOLIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MNG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MNE-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MNE-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MNE-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MNE-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MNE-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MNE-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MNE.html\">NamingSystem Passport Numbers Namespace for MONTENEGRO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MNE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MSR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MSR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MSR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MSR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MSR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MSR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MSR.html\">NamingSystem Passport Numbers Namespace for MONTSERRAT</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MSR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MAR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MAR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MAR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MAR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MAR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MAR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MAR.html\">NamingSystem Passport Numbers Namespace for MOROCCO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MAR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MOZ-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MOZ-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MOZ-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MOZ-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MOZ-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MOZ-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MOZ.html\">NamingSystem Passport Numbers Namespace for MOZAMBIQUE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MOZ"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MMR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MMR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MMR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MMR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MMR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MMR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MMR.html\">NamingSystem Passport Numbers Namespace for MYANMAR</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MMR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NAM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NAM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NAM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NAM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NAM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NAM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NAM.html\">NamingSystem Passport Numbers Namespace for NAMIBIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NAM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NRU-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NRU-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NRU-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NRU-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NRU-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NRU-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NRU.html\">NamingSystem Passport Numbers Namespace for NAURU</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NRU"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NPL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NPL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NPL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NPL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NPL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NPL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NPL.html\">NamingSystem Passport Numbers Namespace for NEPAL</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NPL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NLD-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NLD-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NLD-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NLD-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NLD-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NLD-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NLD.html\">NamingSystem Passport Numbers Namespace for NETHERLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NLD"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ANT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ANT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ANT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ANT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ANT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ANT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ANT.html\">NamingSystem Passport Numbers Namespace for NETHERLANDS ANTILLES</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ANT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NCL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NCL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NCL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NCL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NCL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NCL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NCL.html\">NamingSystem Passport Numbers Namespace for NEW CALEDONIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NCL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NZL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NZL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NZL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NZL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NZL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NZL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NZL.html\">NamingSystem Passport Numbers Namespace for NEW ZEALAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NZL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NIC-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NIC-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NIC-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NIC-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NIC-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NIC-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NIC.html\">NamingSystem Passport Numbers Namespace for NICARAGUA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NIC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NER-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NER-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NER-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NER-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NER-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NER-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NER.html\">NamingSystem Passport Numbers Namespace for NIGER</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NER"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NGA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NGA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NGA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NGA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NGA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NGA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NGA.html\">NamingSystem Passport Numbers Namespace for NIGERIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NGA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NIU-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NIU-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NIU-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NIU-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NIU-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NIU-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NIU.html\">NamingSystem Passport Numbers Namespace for NIUE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NIU"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NFK-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NFK-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NFK-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NFK-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NFK-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NFK-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NFK.html\">NamingSystem Passport Numbers Namespace for NORFOLK ISLAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NFK"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MNP-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MNP-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MNP-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MNP-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MNP-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MNP-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MNP.html\">NamingSystem Passport Numbers Namespace for NORTHERN MARIANA ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MNP"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-NOR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-NOR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-NOR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-NOR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-NOR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-NOR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-NOR.html\">NamingSystem Passport Numbers Namespace for NORWAY</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-NOR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-OMN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-OMN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-OMN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-OMN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-OMN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-OMN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-OMN.html\">NamingSystem Passport Numbers Namespace for OMAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-OMN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PAK-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PAK-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PAK-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PAK-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PAK-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PAK-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PAK.html\">NamingSystem Passport Numbers Namespace for PAKISTAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:40-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PAK"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:40-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PLW-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PLW-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PLW-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PLW-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PLW-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PLW-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PLW.html\">NamingSystem Passport Numbers Namespace for PALAU</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PLW"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PSE-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PSE-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PSE-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PSE-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PSE-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PSE-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PSE.html\">NamingSystem Passport Numbers Namespace for PALESTINIAN TERRITORY, OCCUPIED</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PSE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PAN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PAN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PAN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PAN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PAN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PAN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PAN.html\">NamingSystem Passport Numbers Namespace for PANAMA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PAN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PNG-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PNG-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PNG-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PNG-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PNG-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PNG-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PNG.html\">NamingSystem Passport Numbers Namespace for PAPUA NEW GUINEA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PNG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PRY-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PRY-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PRY-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PRY-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PRY-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PRY-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PRY.html\">NamingSystem Passport Numbers Namespace for PARAGUAY</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PRY"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PER-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PER-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PER-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PER-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PER-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PER-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PER.html\">NamingSystem Passport Numbers Namespace for PERU</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PER"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PHL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PHL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PHL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PHL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PHL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PHL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PHL.html\">NamingSystem Passport Numbers Namespace for PHILIPPINES</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PHL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PCN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PCN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PCN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PCN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PCN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PCN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PCN.html\">NamingSystem Passport Numbers Namespace for PITCAIRN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PCN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-POL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-POL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-POL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-POL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-POL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-POL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-POL.html\">NamingSystem Passport Numbers Namespace for POLAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-POL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PRT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PRT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PRT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PRT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PRT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PRT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PRT.html\">NamingSystem Passport Numbers Namespace for PORTUGAL</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PRT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-PRI-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-PRI-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-PRI-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-PRI-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-PRI-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-PRI-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-PRI.html\">NamingSystem Passport Numbers Namespace for PUERTO RICO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-PRI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-QAT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-QAT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-QAT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-QAT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-QAT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-QAT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-QAT.html\">NamingSystem Passport Numbers Namespace for QATAR</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-QAT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-REU-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-REU-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-REU-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-REU-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-REU-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-REU-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-REU.html\">NamingSystem Passport Numbers Namespace for REUNION</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-REU"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ROU-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ROU-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ROU-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ROU-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ROU-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ROU-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ROU.html\">NamingSystem Passport Numbers Namespace for ROMANIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ROU"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-RUS-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-RUS-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-RUS-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-RUS-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-RUS-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-RUS-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-RUS.html\">NamingSystem Passport Numbers Namespace for RUSSIAN FEDERATION</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-RUS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-RWA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-RWA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-RWA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-RWA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-RWA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-RWA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-RWA.html\">NamingSystem Passport Numbers Namespace for RWANDA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-RWA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-BLM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-BLM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-BLM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-BLM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-BLM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-BLM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-BLM.html\">NamingSystem Passport Numbers Namespace for SAINT BARTHELEMY</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-BLM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SHN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SHN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SHN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SHN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SHN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SHN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SHN.html\">NamingSystem Passport Numbers Namespace for SAINT HELENA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SHN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-KNA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-KNA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-KNA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-KNA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-KNA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-KNA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-KNA.html\">NamingSystem Passport Numbers Namespace for SAINT KITTS AND NEVIS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-KNA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-LCA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-LCA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-LCA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-LCA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-LCA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-LCA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-LCA.html\">NamingSystem Passport Numbers Namespace for SAINT LUCIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-LCA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-MAF-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-MAF-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-MAF-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-MAF-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-MAF-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-MAF-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-MAF.html\">NamingSystem Passport Numbers Namespace for SAINT MARTIN (FRENCH PART)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-MAF"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SPM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SPM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SPM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SPM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SPM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SPM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SPM.html\">NamingSystem Passport Numbers Namespace for SAINT PIERRE AND MIQUELON</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SPM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-VCT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-VCT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-VCT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-VCT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-VCT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-VCT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-VCT.html\">NamingSystem Passport Numbers Namespace for SAINT VINCENT AND THE GRENADINES</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-VCT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-WSM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-WSM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-WSM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-WSM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-WSM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-WSM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-WSM.html\">NamingSystem Passport Numbers Namespace for SAMOA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-WSM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SMR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SMR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SMR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SMR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SMR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SMR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SMR.html\">NamingSystem Passport Numbers Namespace for SAN MARINO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SMR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-STP-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-STP-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-STP-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-STP-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-STP-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-STP-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-STP.html\">NamingSystem Passport Numbers Namespace for SAO TOME AND PRINCIPE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-STP"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SAU-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SAU-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SAU-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SAU-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SAU-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SAU-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SAU.html\">NamingSystem Passport Numbers Namespace for SAUDI ARABIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SAU"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SEN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SEN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SEN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SEN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SEN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SEN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SEN.html\">NamingSystem Passport Numbers Namespace for SENEGAL</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SEN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SRB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SRB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SRB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SRB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SRB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SRB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SRB.html\">NamingSystem Passport Numbers Namespace for SERBIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SRB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SYC-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SYC-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SYC-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SYC-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SYC-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SYC-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SYC.html\">NamingSystem Passport Numbers Namespace for SEYCHELLES</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SYC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SLE-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SLE-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SLE-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SLE-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SLE-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SLE-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SLE.html\">NamingSystem Passport Numbers Namespace for SIERRA LEONE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SLE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SGP-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SGP-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SGP-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SGP-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SGP-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SGP-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SGP.html\">NamingSystem Passport Numbers Namespace for SINGAPORE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SGP"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SVK-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SVK-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SVK-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SVK-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SVK-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SVK-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SVK.html\">NamingSystem Passport Numbers Namespace for SLOVAKIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SVK"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SVN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SVN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SVN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SVN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SVN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SVN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SVN.html\">NamingSystem Passport Numbers Namespace for SLOVENIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SVN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SLB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SLB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SLB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SLB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SLB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SLB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SLB.html\">NamingSystem Passport Numbers Namespace for SOLOMON ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SLB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SOM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SOM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SOM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SOM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SOM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SOM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SOM.html\">NamingSystem Passport Numbers Namespace for SOMALIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SOM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ZAF-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ZAF-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ZAF-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ZAF-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ZAF-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ZAF-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ZAF.html\">NamingSystem Passport Numbers Namespace for SOUTH AFRICA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ZAF"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SGS-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SGS-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SGS-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SGS-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SGS-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SGS-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SGS.html\">NamingSystem Passport Numbers Namespace for SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SGS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ESP-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ESP-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ESP-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ESP-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ESP-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ESP-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ESP.html\">NamingSystem Passport Numbers Namespace for SPAIN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ESP"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-LKA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-LKA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-LKA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-LKA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-LKA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-LKA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-LKA.html\">NamingSystem Passport Numbers Namespace for SRI LANKA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-LKA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SDN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SDN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SDN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SDN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SDN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SDN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SDN.html\">NamingSystem Passport Numbers Namespace for SUDAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SDN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SUR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SUR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SUR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SUR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SUR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SUR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SUR.html\">NamingSystem Passport Numbers Namespace for SURINAME</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SUR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SJM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SJM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SJM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SJM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SJM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SJM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SJM.html\">NamingSystem Passport Numbers Namespace for SVALBARD AND JAN MAYEN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SJM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SWZ-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SWZ-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SWZ-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SWZ-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SWZ-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SWZ-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SWZ.html\">NamingSystem Passport Numbers Namespace for SWAZILAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SWZ"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SWE-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SWE-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SWE-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SWE-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SWE-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SWE-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SWE.html\">NamingSystem Passport Numbers Namespace for SWEDEN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SWE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-CHE-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-CHE-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-CHE-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-CHE-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-CHE-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-CHE-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-CHE.html\">NamingSystem Passport Numbers Namespace for SWITZERLAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-CHE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-SYR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-SYR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-SYR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-SYR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-SYR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-SYR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-SYR.html\">NamingSystem Passport Numbers Namespace for SYRIAN ARAB REPUBLIC</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-SYR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TWN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TWN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TWN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TWN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TWN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TWN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TWN.html\">NamingSystem Passport Numbers Namespace for TAIWAN, PROVINCE OF CHINA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TWN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TJK-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TJK-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TJK-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TJK-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TJK-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TJK-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TJK.html\">NamingSystem Passport Numbers Namespace for TAJIKISTAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TJK"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TZA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TZA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TZA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TZA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TZA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TZA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TZA.html\">NamingSystem Passport Numbers Namespace for TANZANIA, UNITED REPUBLIC OF</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TZA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-THA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-THA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-THA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-THA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-THA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-THA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-THA.html\">NamingSystem Passport Numbers Namespace for THAILAND</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-THA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TLS-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TLS-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TLS-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TLS-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TLS-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TLS-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TLS.html\">NamingSystem Passport Numbers Namespace for TIMOR-LESTE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TLS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TGO-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TGO-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TGO-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TGO-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TGO-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TGO-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TGO.html\">NamingSystem Passport Numbers Namespace for TOGO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TGO"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TKL-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TKL-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TKL-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TKL-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TKL-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TKL-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TKL.html\">NamingSystem Passport Numbers Namespace for TOKELAU</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TKL"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TON-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TON-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TON-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TON-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TON-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TON-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TON.html\">NamingSystem Passport Numbers Namespace for TONGA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TON"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TTO-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TTO-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TTO-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TTO-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TTO-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TTO-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TTO.html\">NamingSystem Passport Numbers Namespace for TRINIDAD AND TOBAGO</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TTO"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TUN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TUN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TUN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TUN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TUN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TUN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TUN.html\">NamingSystem Passport Numbers Namespace for TUNISIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TUN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TUR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TUR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TUR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TUR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TUR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TUR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TUR.html\">NamingSystem Passport Numbers Namespace for TURKEY</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TUR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TKM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TKM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TKM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TKM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TKM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TKM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TKM.html\">NamingSystem Passport Numbers Namespace for TURKMENISTAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TKM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TCA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TCA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TCA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TCA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TCA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TCA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TCA.html\">NamingSystem Passport Numbers Namespace for TURKS AND CAICOS ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TCA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-TUV-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-TUV-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-TUV-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-TUV-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-TUV-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-TUV-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-TUV.html\">NamingSystem Passport Numbers Namespace for TUVALU</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-TUV"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-UGA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-UGA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-UGA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-UGA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-UGA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-UGA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-UGA.html\">NamingSystem Passport Numbers Namespace for UGANDA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-UGA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-UKR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-UKR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-UKR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-UKR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-UKR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-UKR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-UKR.html\">NamingSystem Passport Numbers Namespace for UKRAINE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-UKR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ARE-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ARE-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ARE-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ARE-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ARE-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ARE-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ARE.html\">NamingSystem Passport Numbers Namespace for UNITED ARAB EMIRATES</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ARE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-GBR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-GBR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-GBR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-GBR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-GBR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-GBR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-GBR.html\">NamingSystem Passport Numbers Namespace for UNITED KINGDOM</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-GBR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-USA-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-USA-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-USA-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-USA-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-USA-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-USA-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-USA.html\">NamingSystem Passport Numbers Namespace for UNITED STATES</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-USA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-UMI-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-UMI-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-UMI-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-UMI-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-UMI-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-UMI-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-UMI.html\">NamingSystem Passport Numbers Namespace for UNITED STATES MINOR OUTLYING ISLANDS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-UMI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-URY-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-URY-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-URY-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-URY-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-URY-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-URY-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-URY.html\">NamingSystem Passport Numbers Namespace for URUGUAY</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-URY"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-UZB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-UZB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-UZB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-UZB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-UZB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-UZB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-UZB.html\">NamingSystem Passport Numbers Namespace for UZBEKISTAN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-UZB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-VUT-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-VUT-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-VUT-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-VUT-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-VUT-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-VUT-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-VUT.html\">NamingSystem Passport Numbers Namespace for VANUATU</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-VUT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-VEN-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-VEN-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-VEN-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-VEN-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-VEN-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-VEN-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-VEN.html\">NamingSystem Passport Numbers Namespace for VENEZUELA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-VEN"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-VNM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-VNM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-VNM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-VNM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-VNM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-VNM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-VNM.html\">NamingSystem Passport Numbers Namespace for VIET NAM</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-VNM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-VGB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-VGB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-VGB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-VGB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-VGB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-VGB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-VGB.html\">NamingSystem Passport Numbers Namespace for VIRGIN ISLANDS (BRITISH)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-VGB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-VIR-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-VIR-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-VIR-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-VIR-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-VIR-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-VIR-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-VIR.html\">NamingSystem Passport Numbers Namespace for VIRGIN ISLANDS (U.S.)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-VIR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-WLF-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-WLF-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-WLF-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-WLF-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-WLF-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-WLF-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-WLF.html\">NamingSystem Passport Numbers Namespace for WALLIS AND FUTUNA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-WLF"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ESH-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ESH-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ESH-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ESH-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ESH-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ESH-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ESH.html\">NamingSystem Passport Numbers Namespace for WESTERN SAHARA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ESH"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-YEM-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-YEM-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-YEM-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-YEM-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-YEM-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-YEM-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-YEM.html\">NamingSystem Passport Numbers Namespace for YEMEN</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-YEM"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-YUG-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-YUG-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-YUG-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-YUG-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-YUG-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-YUG-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-YUG.html\">NamingSystem Passport Numbers Namespace for YUGOSLAVIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-YUG"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ZMB-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ZMB-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ZMB-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ZMB-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ZMB-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ZMB-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ZMB.html\">NamingSystem Passport Numbers Namespace for ZAMBIA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ZMB"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx3l-passportNumNS-ZWE-ns-3-0-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx3l-passportNumNS-ZWE-ns-3-0-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx3l-passportNumNS-ZWE-ns-3-0-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx3l-passportNumNS-ZWE-ns-3-0-12</b></p><a name=\"hx3l-passportNumNS-ZWE-ns-3-0-12\"> </a><a name=\"hchx3l-passportNumNS-ZWE-ns-3-0-12\"> </a><p>Provenance for <a href=\"NamingSystem-passportNumNS-ZWE.html\">NamingSystem Passport Numbers Namespace for ZIMBABWE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-15</td></tr><tr><td>Recorded</td><td>2022-02-15 16:23:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/passportNumNS-ZWE"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-15"
        },
        "recorded" : "2022-02-15T16:23:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Identifier system moved from FHIR core to THO; UP-285"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    }
  ]
}

```
