#  - HL7 Terminology (THO) v7.0.1

## : 



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "hxutg1-1-0-1",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-ActCode-cs-1-0-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-ActCode-cs-1-0-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-ActCode-cs-1-0-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-ActCode-cs-1-0-1</b></p><a name=\"hx1c-v3-ActCode-cs-1-0-1\"> </a><a name=\"hchx1c-v3-ActCode-cs-1-0-1\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActCode.html\">CodeSystem ActCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2000-08-03 15:28:56+1000</td></tr><tr><td>Recorded</td><td>2010-01-01 12:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Woody Beeler</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>MnM WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2000-08-03T15:28:56+10:00"
        },
        "recorded" : "2010-01-01T12:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Originated prior to this dateTime; exact date not available."
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Woody Beeler"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "MnM WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-ActClass-vs-1-0-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-ActClass-vs-1-0-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-ActClass-vs-1-0-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-ActClass-vs-1-0-1</b></p><a name=\"hx1c-v3-ActClass-vs-1-0-1\"> </a><a name=\"hchx1c-v3-ActClass-vs-1-0-1\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActClass.html\">ValueSet ActClass</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2000-08-03 15:28:56+1000</td></tr><tr><td>Recorded</td><td>2010-01-01 12:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Woody Beeler</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>MnM WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActClass"
          }
        ],
        "occurredPeriod" : {
          "end" : "2000-08-03T15:28:56+10:00"
        },
        "recorded" : "2010-01-01T12:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Originated prior to this."
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Woody Beeler"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "MnM WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-ActClass-cs-1-0-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-ActClass-cs-1-0-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-ActClass-cs-1-0-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-ActClass-cs-1-0-1</b></p><a name=\"hx1c-v3-ActClass-cs-1-0-1\"> </a><a name=\"hchx1c-v3-ActClass-cs-1-0-1\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActClass.html\">CodeSystem ActClass</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2000-08-03 15:28:56+1000</td></tr><tr><td>Recorded</td><td>2010-01-01 12:00:00+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Woody Beeler</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>MnM WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActClass"
          }
        ],
        "occurredPeriod" : {
          "end" : "2000-08-03T15:28:56+10:00"
        },
        "recorded" : "2010-01-01T12:00:00+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Originated prior to this."
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Woody Beeler"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "MnM WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-IECColourManagement-ns-3-0-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-IECColourManagement-ns-3-0-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-IECColourManagement-ns-3-0-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-IECColourManagement-ns-3-0-9</b></p><a name=\"hx1c-IECColourManagement-ns-3-0-9\"> </a><a name=\"hchx1c-IECColourManagement-ns-3-0-9\"> </a><p>Provenance for <a href=\"NamingSystem-IECColourManagement.html\">NamingSystem IEC 61966-2-1: Colour measurement and management - Part 2-1: Colour management - Default RGB colour space - sRGB</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-11</td></tr><tr><td>Recorded</td><td>2022-02-11 15:19:19-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/IECColourManagement"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-11"
        },
        "recorded" : "2022-02-11T15:19:19-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add IEC Colour Measurement and Management per HTA; UP-274"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-MEDRT-ns-3-0-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-MEDRT-ns-3-0-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-MEDRT-ns-3-0-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-MEDRT-ns-3-0-11</b></p><a name=\"hx1c-MEDRT-ns-3-0-11\"> </a><a name=\"hchx1c-MEDRT-ns-3-0-11\"> </a><p>Provenance for <a href=\"NamingSystem-MEDRT.html\">NamingSystem Medication Reference Terminology (MED-RT)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-17</td></tr><tr><td>Recorded</td><td>2022-02-17 14:06:10-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MEDRT"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-17"
        },
        "recorded" : "2022-02-17T14:06:10-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add Medication Reference Terminology (MED-RT) per HTA; UP-291"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-payeetype-cs-4-0-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-payeetype-cs-4-0-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-payeetype-cs-4-0-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-payeetype-cs-4-0-14</b></p><a name=\"hx1c-payeetype-cs-4-0-14\"> </a><a name=\"hchx1c-payeetype-cs-4-0-14\"> </a><p>Provenance for <a href=\"CodeSystem-payeetype.html\">CodeSystem Payee Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-29</td></tr><tr><td>Recorded</td><td>2022-08-29 16:20:06-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Corey Spears</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Financial Management</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/payeetype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-29"
        },
        "recorded" : "2022-08-29T16:20:06-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix Payee type display for 'other' code; up-246"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Corey Spears"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Financial Management"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-RadLex-ns-4-0-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-RadLex-ns-4-0-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-RadLex-ns-4-0-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-RadLex-ns-4-0-1</b></p><a name=\"hx1c-RadLex-ns-4-0-1\"> </a><a name=\"hchx1c-RadLex-ns-4-0-1\"> </a><p>Provenance for <a href=\"NamingSystem-RadLex.html\">NamingSystem RadLex radiology lexicon</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-04-26</td></tr><tr><td>Recorded</td><td>2022-04-26 14:06:10-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/RadLex"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-04-26"
        },
        "recorded" : "2022-04-26T14:06:10-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Remove Hanging Backslash from RadLex URL; UP-302"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-CMSPlaceofServiceCodes-cs-4-0-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-CMSPlaceofServiceCodes-cs-4-0-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-CMSPlaceofServiceCodes-cs-4-0-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-CMSPlaceofServiceCodes-cs-4-0-2</b></p><a name=\"hx1c-CMSPlaceofServiceCodes-cs-4-0-2\"> </a><a name=\"hchx1c-CMSPlaceofServiceCodes-cs-4-0-2\"> </a><p>Provenance for <a href=\"CodeSystem-CMSPlaceofServiceCodes.html\">CodeSystem CMS Place of Service Codes (POS)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-04-28</td></tr><tr><td>Recorded</td><td>2022-04-28 13:38:59-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/CMSPlaceofServiceCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-04-28"
        },
        "recorded" : "2022-04-28T13:38:59-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Remove Version Specific Information from CMS Place of Service Description; UP-307"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-CMSPlaceofServiceCodes-ns-4-0-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-CMSPlaceofServiceCodes-ns-4-0-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-CMSPlaceofServiceCodes-ns-4-0-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-CMSPlaceofServiceCodes-ns-4-0-2</b></p><a name=\"hx1c-CMSPlaceofServiceCodes-ns-4-0-2\"> </a><a name=\"hchx1c-CMSPlaceofServiceCodes-ns-4-0-2\"> </a><p>Provenance for <a href=\"NamingSystem-CMSPlaceofServiceCodes.html\">NamingSystem CMS Place of Service Codes (POS)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-04-28</td></tr><tr><td>Recorded</td><td>2022-04-28 13:42:48-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CMSPlaceofServiceCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-04-28"
        },
        "recorded" : "2022-04-28T13:42:48-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Remove Version Specific Information from CMS Place of Service Description; UP-307"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ADAUniversalToothDesignationSystem-cs-4-0-3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ADAUniversalToothDesignationSystem-cs-4-0-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ADAUniversalToothDesignationSystem-cs-4-0-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ADAUniversalToothDesignationSystem-cs-4-0-3</b></p><a name=\"hx1c-ADAUniversalToothDesignationSystem-cs-4-0-3\"> </a><a name=\"hchx1c-ADAUniversalToothDesignationSystem-cs-4-0-3\"> </a><p>Provenance for <a href=\"CodeSystem-ADAUniversalToothDesignationSystem.html\">CodeSystem ADA Universal Tooth Designation System</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-04-28</td></tr><tr><td>Recorded</td><td>2022-04-28 17:42:05-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ADAUniversalToothDesignationSystem"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-04-28"
        },
        "recorded" : "2022-04-28T17:42:05-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add ADA Universal Tooth Designation System per HTA; UP-305"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ADAUniversalToothDesignationSystem-ns-4-0-3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ADAUniversalToothDesignationSystem-ns-4-0-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ADAUniversalToothDesignationSystem-ns-4-0-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ADAUniversalToothDesignationSystem-ns-4-0-3</b></p><a name=\"hx1c-ADAUniversalToothDesignationSystem-ns-4-0-3\"> </a><a name=\"hchx1c-ADAUniversalToothDesignationSystem-ns-4-0-3\"> </a><p>Provenance for <a href=\"NamingSystem-ADAUniversalToothDesignationSystem.html\">NamingSystem ADA Universal Tooth Designation System</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-04-28</td></tr><tr><td>Recorded</td><td>2022-04-28 17:43:52-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ADAUniversalToothDesignationSystem"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-04-28"
        },
        "recorded" : "2022-04-28T17:43:52-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add ADA Universal Tooth Designation System per HTA; UP-305"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ADAAreaOralCavitySystem-ns-4-0-4",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ADAAreaOralCavitySystem-ns-4-0-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ADAAreaOralCavitySystem-ns-4-0-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ADAAreaOralCavitySystem-ns-4-0-4</b></p><a name=\"hx1c-ADAAreaOralCavitySystem-ns-4-0-4\"> </a><a name=\"hchx1c-ADAAreaOralCavitySystem-ns-4-0-4\"> </a><p>Provenance for <a href=\"NamingSystem-ADAAreaOralCavitySystem.html\">NamingSystem American Dental Association Area of Oral Cavity System</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-04-28</td></tr><tr><td>Recorded</td><td>2022-04-28 23:11:44-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ADAAreaOralCavitySystem"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-04-28"
        },
        "recorded" : "2022-04-28T23:11:44-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add ADA Area of Oral Cavity System per HTA; UP-306"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-W3CDID-ns-3-0-4",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-W3CDID-ns-3-0-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-W3CDID-ns-3-0-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-W3CDID-ns-3-0-4</b></p><a name=\"hx1c-W3CDID-ns-3-0-4\"> </a><a name=\"hchx1c-W3CDID-ns-3-0-4\"> </a><p>Provenance for <a href=\"NamingSystem-W3CDID.html\">NamingSystem W3C Decentralized Identifier (DID)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-02-14</td></tr><tr><td>Recorded</td><td>2023-02-14 00:37:49-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/W3CDID"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-02-14"
        },
        "recorded" : "2023-02-14T00:37:49-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add W3C DID per HTA; up-366"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-MONDO-ns-3-0-5",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-MONDO-ns-3-0-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-MONDO-ns-3-0-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-MONDO-ns-3-0-5</b></p><a name=\"hx1c-MONDO-ns-3-0-5\"> </a><a name=\"hchx1c-MONDO-ns-3-0-5\"> </a><p>Provenance for <a href=\"NamingSystem-MONDO.html\">NamingSystem Mondo Disease Ontology</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-02-14</td></tr><tr><td>Recorded</td><td>2023-02-14 10:16:20-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MONDO"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-02-14"
        },
        "recorded" : "2023-02-14T10:16:20-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add MONDO per HTA; up-354"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ICD11MMS-ns-3-0-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ICD11MMS-ns-3-0-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ICD11MMS-ns-3-0-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ICD11MMS-ns-3-0-6</b></p><a name=\"hx1c-ICD11MMS-ns-3-0-6\"> </a><a name=\"hchx1c-ICD11MMS-ns-3-0-6\"> </a><p>Provenance for <a href=\"NamingSystem-ICD11MMS.html\">NamingSystem International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-02-14</td></tr><tr><td>Recorded</td><td>2023-02-14 12:12:56-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICD11MMS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-02-14"
        },
        "recorded" : "2023-02-14T12:12:56-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add ICD-11 MMS per HTA; up-365"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v2-tables-vs-5-1-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v2-tables-vs-5-1-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v2-tables-vs-5-1-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v2-tables-vs-5-1-1</b></p><a name=\"hx1c-v2-tables-vs-5-1-1\"> </a><a name=\"hchx1c-v2-tables-vs-5-1-1\"> </a><p>Provenance for <a href=\"CodeSystem-v2-tables.html\">CodeSystem V2 Table List</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-05-08</td></tr><tr><td>Recorded</td><td>2023-05-08 11:47:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>V2MG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-tables"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-05-08"
        },
        "recorded" : "2023-05-08T11:47:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "ValueSets v2-0078 and v3-ObservationIntrerpretation have the same oid; up-184"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "V2MG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-loinc-ns-5-1-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-loinc-ns-5-1-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-loinc-ns-5-1-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-loinc-ns-5-1-2</b></p><a name=\"hx1c-v3-loinc-ns-5-1-2\"> </a><a name=\"hchx1c-v3-loinc-ns-5-1-2\"> </a><p>Provenance for <a href=\"NamingSystem-v3-loinc.html\">NamingSystem Logical Observation Identifier Names and Codes (LOINC)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-05-08</td></tr><tr><td>Recorded</td><td>2023-05-08 13:58:46-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Gaurav Vaidya</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>ITS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-loinc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-05-08"
        },
        "recorded" : "2023-05-08T13:58:46-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Request to add IRI stems to LOINC; up-364"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Gaurav Vaidya"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "ITS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-appointment-cancellation-reason-cs-5-1-3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-appointment-cancellation-reason-cs-5-1-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-appointment-cancellation-reason-cs-5-1-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-appointment-cancellation-reason-cs-5-1-3</b></p><a name=\"hx1c-appointment-cancellation-reason-cs-5-1-3\"> </a><a name=\"hchx1c-appointment-cancellation-reason-cs-5-1-3\"> </a><p>Provenance for <a href=\"CodeSystem-appointment-cancellation-reason.html\">CodeSystem Appointment cancellation reason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-05-09</td></tr><tr><td>Recorded</td><td>2023-05-09 13:07:16-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/appointment-cancellation-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-05-09"
        },
        "recorded" : "2023-05-09T13:07:16-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Clarify several Appointment Cancellation Reason concept displays; up-400"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-V2Tables-cs-5-1-4",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-V2Tables-cs-5-1-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-V2Tables-cs-5-1-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-V2Tables-cs-5-1-4</b></p><a name=\"hx1c-V2Tables-cs-5-1-4\"> </a><a name=\"hchx1c-V2Tables-cs-5-1-4\"> </a><p>Provenance for <a href=\"CodeSystem-v2-tables.html\">CodeSystem V2 Table List</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-15</td></tr><tr><td>Recorded</td><td>2023-06-15 10:15:46-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>V2MG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-tables"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-15"
        },
        "recorded" : "2023-06-15T10:15:46-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "V2 / V3 ValueSets for InformationSensitivityPolicy have the same OID; up-185"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "V2MG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-iri-ns-5-1-5",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-iri-ns-5-1-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-iri-ns-5-1-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-iri-ns-5-1-5</b></p><a name=\"hx1c-iri-ns-5-1-5\"> </a><a name=\"hchx1c-iri-ns-5-1-5\"> </a><p>Provenance for <a href=\"NamingSystem-iri.html\">NamingSystem Internationalized Resource Identifier (IRI)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-17</td></tr><tr><td>Recorded</td><td>2023-06-17 23:29:02-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Gaurav Vaidya</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>ITS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/iri"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-17"
        },
        "recorded" : "2023-06-17T23:29:02-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add IRIs to the External Known Identifier Systems; up-406"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Gaurav Vaidya"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "ITS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-hl7-work-group-cs-5-1-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-hl7-work-group-cs-5-1-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-hl7-work-group-cs-5-1-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-hl7-work-group-cs-5-1-6</b></p><a name=\"hx1c-hl7-work-group-cs-5-1-6\"> </a><a name=\"hchx1c-hl7-work-group-cs-5-1-6\"> </a><p>Provenance for <a href=\"CodeSystem-hl7-work-group.html\">CodeSystem HL7Workgroup</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-18</td></tr><tr><td>Recorded</td><td>2023-06-18 21:08:59-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/hl7-work-group"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-18"
        },
        "recorded" : "2023-06-18T21:08:59-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "changing display and definition of Vocab code in code system of HL7 WGs; up-404"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-measure-supplemental-data-cs-5-1-7",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-measure-supplemental-data-cs-5-1-7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-measure-supplemental-data-cs-5-1-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-measure-supplemental-data-cs-5-1-7</b></p><a name=\"hx1c-measure-supplemental-data-cs-5-1-7\"> </a><a name=\"hchx1c-measure-supplemental-data-cs-5-1-7\"> </a><p>Provenance for <a href=\"CodeSystem-measure-supplemental-data.html\">CodeSystem Measure Supplemental Data</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-18</td></tr><tr><td>Recorded</td><td>2023-06-18 21:15:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-supplemental-data"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-18"
        },
        "recorded" : "2023-06-18T21:15:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create a measure-supplemental-data Codesystem and Valueset; up-390"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-measure-aggregate-method-cs-5-1-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-measure-aggregate-method-cs-5-1-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-measure-aggregate-method-cs-5-1-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-measure-aggregate-method-cs-5-1-8</b></p><a name=\"hx1c-measure-aggregate-method-cs-5-1-8\"> </a><a name=\"hchx1c-measure-aggregate-method-cs-5-1-8\"> </a><p>Provenance for <a href=\"CodeSystem-measure-aggregate-method.html\">CodeSystem Measure Aggregate Method</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-18</td></tr><tr><td>Recorded</td><td>2023-06-18 23:18:01-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-aggregate-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-18"
        },
        "recorded" : "2023-06-18T23:18:01-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create a measure-aggregate-method Codesystem and Valueset; up-397"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-measure-aggregate-method-vs-5-1-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-measure-aggregate-method-vs-5-1-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-measure-aggregate-method-vs-5-1-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-measure-aggregate-method-vs-5-1-8</b></p><a name=\"hx1c-measure-aggregate-method-vs-5-1-8\"> </a><a name=\"hchx1c-measure-aggregate-method-vs-5-1-8\"> </a><p>Provenance for <a href=\"ValueSet-measure-aggregate-method.html\">ValueSet Measure Aggregate Method</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-18</td></tr><tr><td>Recorded</td><td>2023-06-18 23:18:08-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/measure-aggregate-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-18"
        },
        "recorded" : "2023-06-18T23:18:08-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create a measure-aggregate-method Codesystem and Valueset; up-397"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-measure-supplemental-data-vs-5-1-7",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-measure-supplemental-data-vs-5-1-7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-measure-supplemental-data-vs-5-1-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-measure-supplemental-data-vs-5-1-7</b></p><a name=\"hx1c-measure-supplemental-data-vs-5-1-7\"> </a><a name=\"hchx1c-measure-supplemental-data-vs-5-1-7\"> </a><p>Provenance for <a href=\"ValueSet-measure-supplemental-data.html\">ValueSet Measure Supplemental Data</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-18</td></tr><tr><td>Recorded</td><td>2023-06-18 23:19:01-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/measure-supplemental-data"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-18"
        },
        "recorded" : "2023-06-18T23:19:01-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create a measure-supplemental-data Codesystem and Valueset; up-390"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-certainty-rating-cs-5-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-certainty-rating-cs-5-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-certainty-rating-cs-5-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-certainty-rating-cs-5-1-10</b></p><a name=\"hx1c-certainty-rating-cs-5-1-10\"> </a><a name=\"hchx1c-certainty-rating-cs-5-1-10\"> </a><p>Provenance for <a href=\"CodeSystem-certainty-rating.html\">CodeSystem StatisticCertaintyRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-19</td></tr><tr><td>Recorded</td><td>2023-06-19 00:35:32-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/certainty-rating"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-19"
        },
        "recorded" : "2023-06-19T00:35:32-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add 12 terms to StatisticCertaintyRating CodeSystem on THO; up-396"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-directness-cs-5-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-directness-cs-5-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-directness-cs-5-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-directness-cs-5-1-11</b></p><a name=\"hx1c-directness-cs-5-1-11\"> </a><a name=\"hchx1c-directness-cs-5-1-11\"> </a><p>Provenance for <a href=\"CodeSystem-directness.html\">CodeSystem EvidenceDirectness</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-19</td></tr><tr><td>Recorded</td><td>2023-06-19 07:42:04-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/directness"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-19"
        },
        "recorded" : "2023-06-19T07:42:04-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update EvidenceDirectness CodeSystem display and definition values; up-394"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-synthesis-type-cs-5-1-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-synthesis-type-cs-5-1-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-synthesis-type-cs-5-1-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-synthesis-type-cs-5-1-12</b></p><a name=\"hx1c-synthesis-type-cs-5-1-12\"> </a><a name=\"hchx1c-synthesis-type-cs-5-1-12\"> </a><p>Provenance for <a href=\"CodeSystem-synthesis-type.html\">CodeSystem StatisticSynthesisType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-19</td></tr><tr><td>Recorded</td><td>2023-06-19 08:00:56-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/synthesis-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-19"
        },
        "recorded" : "2023-06-19T08:00:56-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update StatisticSynthesisType CodeSystem to drop pooled term and add NotApplicable term; up-395"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cdshooks-indicator-cs-5-1-22",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cdshooks-indicator-cs-5-1-22",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cdshooks-indicator-cs-5-1-22\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cdshooks-indicator-cs-5-1-22</b></p><a name=\"hx1c-cdshooks-indicator-cs-5-1-22\"> </a><a name=\"hchx1c-cdshooks-indicator-cs-5-1-22\"> </a><p>Provenance for <a href=\"CodeSystem-cdshooks-indicator.html\">CodeSystem CDS Hooks Indicator</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-19</td></tr><tr><td>Recorded</td><td>2023-06-19 09:39:06-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/cdshooks-indicator"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-19"
        },
        "recorded" : "2023-06-19T09:39:06-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create a CodeSystem for CDS Hooks indicator; up-392"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-condition-ver-status-cs-5-1-13",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-condition-ver-status-cs-5-1-13",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-condition-ver-status-cs-5-1-13\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-condition-ver-status-cs-5-1-13</b></p><a name=\"hx1c-condition-ver-status-cs-5-1-13\"> </a><a name=\"hchx1c-condition-ver-status-cs-5-1-13\"> </a><p>Provenance for <a href=\"CodeSystem-condition-ver-status.html\">CodeSystem ConditionVerificationStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-19</td></tr><tr><td>Recorded</td><td>2023-06-19 23:45:02-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Michelle Miller</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PC</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/condition-ver-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-19"
        },
        "recorded" : "2023-06-19T23:45:02-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "ConditionVerificationStatus definitions are tautological; up-387"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Michelle Miller"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PC"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-consentscope-cs-5-1-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-consentscope-cs-5-1-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-consentscope-cs-5-1-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-consentscope-cs-5-1-14</b></p><a name=\"hx1c-consentscope-cs-5-1-14\"> </a><a name=\"hchx1c-consentscope-cs-5-1-14\"> </a><p>Provenance for <a href=\"CodeSystem-consentscope.html\">CodeSystem Consent Scope Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-19</td></tr><tr><td>Recorded</td><td>2023-06-19 23:52:36-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>David Pyke</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CBCP</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentscope"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-19"
        },
        "recorded" : "2023-06-19T23:52:36-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Re add the code ADR to the Consent Scope code system; up-255"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "David Pyke"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CBCP"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-sex-parameter-for-clinical-use-cs-5-1-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-sex-parameter-for-clinical-use-cs-5-1-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-sex-parameter-for-clinical-use-cs-5-1-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-sex-parameter-for-clinical-use-cs-5-1-15</b></p><a name=\"hx1c-sex-parameter-for-clinical-use-cs-5-1-15\"> </a><a name=\"hchx1c-sex-parameter-for-clinical-use-cs-5-1-15\"> </a><p>Provenance for <a href=\"CodeSystem-sex-parameter-for-clinical-use.html\">CodeSystem Sex Parameter For Clinical Use</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-20</td></tr><tr><td>Recorded</td><td>2023-06-20 07:36:54-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/sex-parameter-for-clinical-use"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-20"
        },
        "recorded" : "2023-06-20T07:36:54-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Moving gender harmony terminology from extension IG into THO; up-432"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-sex-parameter-for-clinical-use-vs-5-1-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-sex-parameter-for-clinical-use-vs-5-1-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-sex-parameter-for-clinical-use-vs-5-1-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-sex-parameter-for-clinical-use-vs-5-1-15</b></p><a name=\"hx1c-sex-parameter-for-clinical-use-vs-5-1-15\"> </a><a name=\"hchx1c-sex-parameter-for-clinical-use-vs-5-1-15\"> </a><p>Provenance for <a href=\"ValueSet-sex-parameter-for-clinical-use.html\">ValueSet Sex Parameter for Clinical Use</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-20</td></tr><tr><td>Recorded</td><td>2023-06-20 07:37:05-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/sex-parameter-for-clinical-use"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-20"
        },
        "recorded" : "2023-06-20T07:37:05-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Moving gender harmony terminology from extension IG into THO; up-432"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-gender-identity-vs-5-1-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-gender-identity-vs-5-1-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-gender-identity-vs-5-1-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-gender-identity-vs-5-1-15</b></p><a name=\"hx1c-gender-identity-vs-5-1-15\"> </a><a name=\"hchx1c-gender-identity-vs-5-1-15\"> </a><p>Provenance for <a href=\"ValueSet-gender-identity.html\">ValueSet Gender Identity</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-20</td></tr><tr><td>Recorded</td><td>2023-06-20 07:37:34-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/gender-identity"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-20"
        },
        "recorded" : "2023-06-20T07:37:34-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Moving gender harmony terminology from extension IG into THO; up-432"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-recorded-sex-or-gender-type-vs-5-1-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-recorded-sex-or-gender-type-vs-5-1-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-recorded-sex-or-gender-type-vs-5-1-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-recorded-sex-or-gender-type-vs-5-1-15</b></p><a name=\"hx1c-recorded-sex-or-gender-type-vs-5-1-15\"> </a><a name=\"hchx1c-recorded-sex-or-gender-type-vs-5-1-15\"> </a><p>Provenance for <a href=\"ValueSet-recorded-sex-or-gender-type.html\">ValueSet Recorded Sex Or Gender Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-20</td></tr><tr><td>Recorded</td><td>2023-06-20 07:37:47-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/recorded-sex-or-gender-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-20"
        },
        "recorded" : "2023-06-20T07:37:47-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Moving gender harmony terminology from extension IG into THO; up-432"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-pronouns-vs-5-1-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-pronouns-vs-5-1-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-pronouns-vs-5-1-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-pronouns-vs-5-1-15</b></p><a name=\"hx1c-pronouns-vs-5-1-15\"> </a><a name=\"hchx1c-pronouns-vs-5-1-15\"> </a><p>Provenance for <a href=\"ValueSet-pronouns.html\">ValueSet Personal Pronouns</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-20</td></tr><tr><td>Recorded</td><td>2023-06-20 07:38:03-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/pronouns"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-20"
        },
        "recorded" : "2023-06-20T07:38:03-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Moving gender harmony terminology from extension IG into THO; up-432"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-MVX-ns-5-1-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-MVX-ns-5-1-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-MVX-ns-5-1-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-MVX-ns-5-1-16</b></p><a name=\"hx1c-MVX-ns-5-1-16\"> </a><a name=\"hchx1c-MVX-ns-5-1-16\"> </a><p>Provenance for <a href=\"NamingSystem-MVX.html\">NamingSystem Manufacturers of Vaccines (MVX)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-20</td></tr><tr><td>Recorded</td><td>2023-06-20 10:06:06-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/MVX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-20"
        },
        "recorded" : "2023-06-20T10:06:06-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Unify and Update MVX Entries; up-240"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-mdr-ns-5-1-17",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-mdr-ns-5-1-17",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-mdr-ns-5-1-17\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-mdr-ns-5-1-17</b></p><a name=\"hx1c-mdr-ns-5-1-17\"> </a><a name=\"hchx1c-mdr-ns-5-1-17\"> </a><p>Provenance for <a href=\"NamingSystem-mdr.html\">NamingSystem Medical Dictionary for Regulatory Activities</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-20</td></tr><tr><td>Recorded</td><td>2023-06-20 11:43:25-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/mdr"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-20"
        },
        "recorded" : "2023-06-20T11:43:25-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Updated MedDRA Code System and Naming System per HTA; up-202"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-CVX-ns-5-1-18",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-CVX-ns-5-1-18",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-CVX-ns-5-1-18\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-CVX-ns-5-1-18</b></p><a name=\"hx1c-CVX-ns-5-1-18\"> </a><a name=\"hchx1c-CVX-ns-5-1-18\"> </a><p>Provenance for <a href=\"NamingSystem-CVX.html\">NamingSystem Vaccine Administered Code Set (CVX)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-20</td></tr><tr><td>Recorded</td><td>2023-06-20 13:06:41-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CVX"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-20"
        },
        "recorded" : "2023-06-20T13:06:41-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Remove duplicate CVX entry from THO; up-374"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-CDCLocal-ns-5-1-19",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-CDCLocal-ns-5-1-19",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-CDCLocal-ns-5-1-19\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-CDCLocal-ns-5-1-19</b></p><a name=\"hx1c-CDCLocal-ns-5-1-19\"> </a><a name=\"hchx1c-CDCLocal-ns-5-1-19\"> </a><p>Provenance for <a href=\"NamingSystem-CDCLocal.html\">NamingSystem CDC Local Coding System</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-20</td></tr><tr><td>Recorded</td><td>2023-06-20 20:28:29-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CDCLocal"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-20"
        },
        "recorded" : "2023-06-20T20:28:29-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add CDC Local Coding System per HTA; up-429"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-OpenEligibilityTaxonomy-ns-5-1-20",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-OpenEligibilityTaxonomy-ns-5-1-20",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-OpenEligibilityTaxonomy-ns-5-1-20\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-OpenEligibilityTaxonomy-ns-5-1-20</b></p><a name=\"hx1c-OpenEligibilityTaxonomy-ns-5-1-20\"> </a><a name=\"hchx1c-OpenEligibilityTaxonomy-ns-5-1-20\"> </a><p>Provenance for <a href=\"NamingSystem-OpenEligibilityTaxonomy.html\">NamingSystem Open Eligibility Taxonomy</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-20</td></tr><tr><td>Recorded</td><td>2023-06-20 23:46:53-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/OpenEligibilityTaxonomy"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-20"
        },
        "recorded" : "2023-06-20T23:46:53-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add Open Eligibility Taxonomy per HTA; up-412"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-X12ServiceTypeCodes-ns-5-1-21",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-X12ServiceTypeCodes-ns-5-1-21",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-X12ServiceTypeCodes-ns-5-1-21\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-X12ServiceTypeCodes-ns-5-1-21</b></p><a name=\"hx1c-X12ServiceTypeCodes-ns-5-1-21\"> </a><a name=\"hchx1c-X12ServiceTypeCodes-ns-5-1-21\"> </a><p>Provenance for <a href=\"NamingSystem-X12ServiceTypeCodes.html\">NamingSystem X12 Service Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-21</td></tr><tr><td>Recorded</td><td>2023-06-21 01:23:16-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/X12ServiceTypeCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-21"
        },
        "recorded" : "2023-06-21T01:23:16-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add X12 Service Type Codes per HTA; up-373"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-ActSite-cs-3-1-24",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-ActSite-cs-3-1-24",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-ActSite-cs-3-1-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-ActSite-cs-3-1-24</b></p><a name=\"hx1c-v3-ActSite-cs-3-1-24\"> </a><a name=\"hchx1c-v3-ActSite-cs-3-1-24\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActSite.html\">CodeSystem ActSite</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-06-21</td></tr><tr><td>Recorded</td><td>2023-06-21 11:43:36-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActSite"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-06-21"
        },
        "recorded" : "2023-06-21T11:43:36-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Adding missing v3-ActSite value set; up-428"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-usage-context-type-cs-5-2-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-usage-context-type-cs-5-2-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-usage-context-type-cs-5-2-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-usage-context-type-cs-5-2-1</b></p><a name=\"hx1c-usage-context-type-cs-5-2-1\"> </a><a name=\"hchx1c-usage-context-type-cs-5-2-1\"> </a><p>Provenance for <a href=\"CodeSystem-usage-context-type.html\">CodeSystem UsageContextType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-08-31</td></tr><tr><td>Recorded</td><td>2023-08-31 15:49:03-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Lloyd McKenzie</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/usage-context-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-08-31"
        },
        "recorded" : "2023-08-31T15:49:03.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add 'jurisdiction' to Usage-context-type; up-459"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Lloyd McKenzie"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cpt-usable-vs-5-2-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cpt-usable-vs-5-2-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cpt-usable-vs-5-2-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cpt-usable-vs-5-2-2</b></p><a name=\"hx1c-cpt-usable-vs-5-2-2\"> </a><a name=\"hchx1c-cpt-usable-vs-5-2-2\"> </a><p>Provenance for <a href=\"ValueSet-cpt-usable.html\">ValueSet AMA CPT Usable Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-06</td></tr><tr><td>Recorded</td><td>2023-09-06 09:49:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>FHIR Product Director</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/cpt-usable"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-06"
        },
        "recorded" : "2023-09-06T09:49:31.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Addition of HL7 value sets for CPT; up-457"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "FHIR Product Director"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cpt-all-vs-5-2-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cpt-all-vs-5-2-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cpt-all-vs-5-2-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cpt-all-vs-5-2-2</b></p><a name=\"hx1c-cpt-all-vs-5-2-2\"> </a><a name=\"hchx1c-cpt-all-vs-5-2-2\"> </a><p>Provenance for <a href=\"ValueSet-cpt-all.html\">ValueSet AMA CPT All Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-06</td></tr><tr><td>Recorded</td><td>2023-09-06 09:51:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>FHIR Product Director</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/cpt-all"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-06"
        },
        "recorded" : "2023-09-06T09:51:50.89-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Addition of HL7 value sets for CPT; up-457"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "FHIR Product Director"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cpt-base-vs-5-2-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cpt-base-vs-5-2-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cpt-base-vs-5-2-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cpt-base-vs-5-2-2</b></p><a name=\"hx1c-cpt-base-vs-5-2-2\"> </a><a name=\"hchx1c-cpt-base-vs-5-2-2\"> </a><p>Provenance for <a href=\"ValueSet-cpt-base.html\">ValueSet AMA CPT Base Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-06</td></tr><tr><td>Recorded</td><td>2023-09-06 09:51:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>FHIR Product Director</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/cpt-base"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-06"
        },
        "recorded" : "2023-09-06T09:51:59.34-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Addition of HL7 value sets for CPT; up-457"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "FHIR Product Director"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cpt-modifiers-vs-5-2-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cpt-modifiers-vs-5-2-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cpt-modifiers-vs-5-2-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cpt-modifiers-vs-5-2-2</b></p><a name=\"hx1c-cpt-modifiers-vs-5-2-2\"> </a><a name=\"hchx1c-cpt-modifiers-vs-5-2-2\"> </a><p>Provenance for <a href=\"ValueSet-cpt-modifiers.html\">ValueSet AMA CPT Modifier Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-06</td></tr><tr><td>Recorded</td><td>2023-09-06 09:52:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>FHIR Product Director</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/cpt-modifiers"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-06"
        },
        "recorded" : "2023-09-06T09:52:13.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Addition of HL7 value sets for CPT; up-457"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "FHIR Product Director"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v2-0396-cs-5-2-3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v2-0396-cs-5-2-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v2-0396-cs-5-2-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v2-0396-cs-5-2-3</b></p><a name=\"hx1c-v2-0396-cs-5-2-3\"> </a><a name=\"hchx1c-v2-0396-cs-5-2-3\"> </a><p>Provenance for <a href=\"CodeSystem-v2-0396.html\">CodeSystem codingSystem</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-06</td></tr><tr><td>Recorded</td><td>2023-09-06 13:31:09-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-0396"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-06"
        },
        "recorded" : "2023-09-06T13:31:09.46-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add a Sex Parameter for Clinical Use (SPCU) entry to codingSystem; up-454"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v2-0396-cs-5-2-4",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v2-0396-cs-5-2-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v2-0396-cs-5-2-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v2-0396-cs-5-2-4</b></p><a name=\"hx1c-v2-0396-cs-5-2-4\"> </a><a name=\"hchx1c-v2-0396-cs-5-2-4\"> </a><p>Provenance for <a href=\"CodeSystem-v2-0396.html\">CodeSystem codingSystem</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-06</td></tr><tr><td>Recorded</td><td>2023-09-06 22:22:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-0396"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-06"
        },
        "recorded" : "2023-09-06T22:22:44.15-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add a Data Absent Reason (DAR) entry to codingSystem; up-443"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v2-tables-cs-5-2-5",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v2-tables-cs-5-2-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v2-tables-cs-5-2-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v2-tables-cs-5-2-5</b></p><a name=\"hx1c-v2-tables-cs-5-2-5\"> </a><a name=\"hchx1c-v2-tables-cs-5-2-5\"> </a><p>Provenance for <a href=\"CodeSystem-v2-tables.html\">CodeSystem V2 Table List</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-06</td></tr><tr><td>Recorded</td><td>2023-09-06 22:28:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>vocab</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-tables"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-06"
        },
        "recorded" : "2023-09-06T22:28:11.88-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Missing content for code system for V2 table 560; up-46"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "vocab"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-sex-parameter-for-clinical-use-cs-5-2-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-sex-parameter-for-clinical-use-cs-5-2-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-sex-parameter-for-clinical-use-cs-5-2-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-sex-parameter-for-clinical-use-cs-5-2-6</b></p><a name=\"hx1c-sex-parameter-for-clinical-use-cs-5-2-6\"> </a><a name=\"hchx1c-sex-parameter-for-clinical-use-cs-5-2-6\"> </a><p>Provenance for <a href=\"CodeSystem-sex-parameter-for-clinical-use.html\">CodeSystem Sex Parameter For Clinical Use</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-06</td></tr><tr><td>Recorded</td><td>2023-09-06 23:38:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/sex-parameter-for-clinical-use"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-06"
        },
        "recorded" : "2023-09-06T23:38:13.20-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update the definition of specified in SfCU value set; up-452"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ICD-9CM-diagnosiscodes-ns-5-2-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ICD-9CM-diagnosiscodes-ns-5-2-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ICD-9CM-diagnosiscodes-ns-5-2-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ICD-9CM-diagnosiscodes-ns-5-2-8</b></p><a name=\"hx1c-ICD-9CM-diagnosiscodes-ns-5-2-8\"> </a><a name=\"hchx1c-ICD-9CM-diagnosiscodes-ns-5-2-8\"> </a><p>Provenance for <a href=\"NamingSystem-ICD-9CM-diagnosiscodes.html\">NamingSystem ICD-9-CM (diagnosis codes)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-07</td></tr><tr><td>Recorded</td><td>2023-09-07 00:56:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICD-9CM-diagnosiscodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-07"
        },
        "recorded" : "2023-09-07T00:56:11.79-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix existing ICD-9-CM metadata record, add ICD-9-PCS, and fix Using ICD with HL7 standards page; up-435"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ICD-9CM-procedurecodes-ns-5-2-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ICD-9CM-procedurecodes-ns-5-2-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ICD-9CM-procedurecodes-ns-5-2-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ICD-9CM-procedurecodes-ns-5-2-8</b></p><a name=\"hx1c-ICD-9CM-procedurecodes-ns-5-2-8\"> </a><a name=\"hchx1c-ICD-9CM-procedurecodes-ns-5-2-8\"> </a><p>Provenance for <a href=\"NamingSystem-ICD-9CM-procedurecodes.html\">NamingSystem ICD-9-CM (procedure codes)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-07</td></tr><tr><td>Recorded</td><td>2023-09-07 00:56:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICD-9CM-procedurecodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-07"
        },
        "recorded" : "2023-09-07T00:56:26.57-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix existing ICD-9-CM metadata record, add ICD-9-PCS, and fix Using ICD with HL7 standards page; up-435"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-icd9cm-ns-5-2-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-icd9cm-ns-5-2-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-icd9cm-ns-5-2-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-icd9cm-ns-5-2-8</b></p><a name=\"hx1c-icd9cm-ns-5-2-8\"> </a><a name=\"hchx1c-icd9cm-ns-5-2-8\"> </a><p>Provenance for <a href=\"NamingSystem-icd9cm.html\">NamingSystem ICD-9CM</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-07</td></tr><tr><td>Recorded</td><td>2023-09-07 00:58:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/icd9cm"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-07"
        },
        "recorded" : "2023-09-07T00:58:31.28-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix existing ICD-9-CM metadata record, add ICD-9-PCS, and fix Using ICD with HL7 standards page; up-435"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-CDPS-ns-5-2-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-CDPS-ns-5-2-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-CDPS-ns-5-2-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-CDPS-ns-5-2-9</b></p><a name=\"hx1c-CDPS-ns-5-2-9\"> </a><a name=\"hchx1c-CDPS-ns-5-2-9\"> </a><p>Provenance for <a href=\"NamingSystem-CDPS.html\">NamingSystem Chronic Illness and Disability Payment System (CDPS)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-07</td></tr><tr><td>Recorded</td><td>2023-09-07 10:05:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CDPS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-07"
        },
        "recorded" : "2023-09-07T10:05:40.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add Chronic Illness and Disability Payment System per HTA; up-460"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-payeetype-cs-5-2-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-payeetype-cs-5-2-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-payeetype-cs-5-2-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-payeetype-cs-5-2-10</b></p><a name=\"hx1c-payeetype-cs-5-2-10\"> </a><a name=\"hchx1c-payeetype-cs-5-2-10\"> </a><p>Provenance for <a href=\"CodeSystem-payeetype.html\">CodeSystem Payee Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-07</td></tr><tr><td>Recorded</td><td>2023-09-07 10:18:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Corey Spears</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>FM</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/payeetype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-07"
        },
        "recorded" : "2023-09-07T10:18:29.20-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update FHIR payee type Terminologies details (change from example); up-315"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Corey Spears"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "FM"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-payeetype-vs-5-2-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-payeetype-vs-5-2-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-payeetype-vs-5-2-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-payeetype-vs-5-2-10</b></p><a name=\"hx1c-payeetype-vs-5-2-10\"> </a><a name=\"hchx1c-payeetype-vs-5-2-10\"> </a><p>Provenance for <a href=\"ValueSet-payeetype.html\">ValueSet Payee Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-07</td></tr><tr><td>Recorded</td><td>2023-09-07 10:20:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Corey Spears</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>FM</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/payeetype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-07"
        },
        "recorded" : "2023-09-07T10:20:20.59-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update FHIR payee type Terminologies details (change from example); up-315"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Corey Spears"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "FM"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-claimcareteamrole-cs-5-2-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-claimcareteamrole-cs-5-2-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-claimcareteamrole-cs-5-2-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-claimcareteamrole-cs-5-2-11</b></p><a name=\"hx1c-claimcareteamrole-cs-5-2-11\"> </a><a name=\"hchx1c-claimcareteamrole-cs-5-2-11\"> </a><p>Provenance for <a href=\"CodeSystem-claimcareteamrole.html\">CodeSystem Claim Care Team Role Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-07</td></tr><tr><td>Recorded</td><td>2023-09-07 11:37:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Corey Spears</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>FM</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/claimcareteamrole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-07"
        },
        "recorded" : "2023-09-07T11:37:33.83-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update FHIR Claim CareTeamRole Terminologies with codes and other details; up-312"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Corey Spears"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "FM"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-claim-careteamrole-vs-5-2-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-claim-careteamrole-vs-5-2-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-claim-careteamrole-vs-5-2-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-claim-careteamrole-vs-5-2-11</b></p><a name=\"hx1c-claim-careteamrole-vs-5-2-11\"> </a><a name=\"hchx1c-claim-careteamrole-vs-5-2-11\"> </a><p>Provenance for <a href=\"ValueSet-claim-careteamrole.html\">ValueSet Claim Care Team Role Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-09-07</td></tr><tr><td>Recorded</td><td>2023-09-07 11:37:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Corey Spears</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>FM</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-careteamrole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-09-07"
        },
        "recorded" : "2023-09-07T11:37:54.19-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update FHIR Claim CareTeamRole Terminologies with codes and other details; up-312"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Corey Spears"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "FM"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-measure-population-cs-5-3-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-measure-population-cs-5-3-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-measure-population-cs-5-3-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-measure-population-cs-5-3-1</b></p><a name=\"hx1c-measure-population-cs-5-3-1\"> </a><a name=\"hchx1c-measure-population-cs-5-3-1\"> </a><p>Provenance for <a href=\"CodeSystem-measure-population.html\">CodeSystem Measure Population Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-09</td></tr><tr><td>Recorded</td><td>2023-11-09 12:12:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-population"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-09"
        },
        "recorded" : "2023-11-09T12:12:41.02-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update numerator definition in MeasurePopulationType code system; up-480"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v2-0396-cs-5-3-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v2-0396-cs-5-3-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v2-0396-cs-5-3-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v2-0396-cs-5-3-2</b></p><a name=\"hx1c-v2-0396-cs-5-3-2\"> </a><a name=\"hchx1c-v2-0396-cs-5-3-2\"> </a><p>Provenance for <a href=\"CodeSystem-v2-0396.html\">CodeSystem codingSystem</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-09</td></tr><tr><td>Recorded</td><td>2023-11-09 15:20:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-0396"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-09"
        },
        "recorded" : "2023-11-09T15:20:29.01-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add a MED-RT entry to codingSystem; up-473"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-edible-substance-type-vs-5-3-3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-edible-substance-type-vs-5-3-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-edible-substance-type-vs-5-3-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-edible-substance-type-vs-5-3-3</b></p><a name=\"hx1c-edible-substance-type-vs-5-3-3\"> </a><a name=\"hchx1c-edible-substance-type-vs-5-3-3\"> </a><p>Provenance for <a href=\"ValueSet-edible-substance-type.html\">ValueSet Types of Edible Substances</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-09</td></tr><tr><td>Recorded</td><td>2023-11-09 22:52:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>OO</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/edible-substance-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-09"
        },
        "recorded" : "2023-11-09T22:52:50.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move edible substance type value set from FHIR core to THO; up-479"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "OO"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-consentcategorycodes-cs-5-3-4",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-consentcategorycodes-cs-5-3-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-consentcategorycodes-cs-5-3-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-consentcategorycodes-cs-5-3-4</b></p><a name=\"hx1c-consentcategorycodes-cs-5-3-4\"> </a><a name=\"hchx1c-consentcategorycodes-cs-5-3-4\"> </a><p>Provenance for <a href=\"CodeSystem-consentcategorycodes.html\">CodeSystem Consent Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-10</td></tr><tr><td>Recorded</td><td>2023-11-10 11:36:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>David Pyke</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CBCP</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentcategorycodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-10"
        },
        "recorded" : "2023-11-10T11:36:31.48-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update Descriptions for Consent Category Code; up-413"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "David Pyke"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CBCP"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-POAIndicators-vs-5-3-5",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-POAIndicators-vs-5-3-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-POAIndicators-vs-5-3-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-POAIndicators-vs-5-3-5</b></p><a name=\"hx1c-POAIndicators-vs-5-3-5\"> </a><a name=\"hchx1c-POAIndicators-vs-5-3-5\"> </a><p>Provenance for <a href=\"ValueSet-POAIndicators.html\">ValueSet Present on Admission Indicators</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-13</td></tr><tr><td>Recorded</td><td>2023-11-13 11:20:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/POAIndicators"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-13"
        },
        "recorded" : "2023-11-13T11:20:45.30-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Updating PresentOnAdmission value set by removing '1' exclusion; up-471"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-hcpcs-Level-II-ns-5-3-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-hcpcs-Level-II-ns-5-3-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-hcpcs-Level-II-ns-5-3-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-hcpcs-Level-II-ns-5-3-6</b></p><a name=\"hx1c-hcpcs-Level-II-ns-5-3-6\"> </a><a name=\"hchx1c-hcpcs-Level-II-ns-5-3-6\"> </a><p>Provenance for <a href=\"NamingSystem-hcpcs-Level-II.html\">NamingSystem Healthcare Common Procedure Coding System (HCPCS) level II alphanumeric codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-13</td></tr><tr><td>Recorded</td><td>2023-11-13 14:10:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/hcpcs-Level-II"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-13"
        },
        "recorded" : "2023-11-13T14:10:48.55-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix technical error with HCPCS uri; up-472"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-HealthCareCommonProcedureCodingSystem-vs-5-3-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-HealthCareCommonProcedureCodingSystem-vs-5-3-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-HealthCareCommonProcedureCodingSystem-vs-5-3-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-HealthCareCommonProcedureCodingSystem-vs-5-3-6</b></p><a name=\"hx1c-v3-HealthCareCommonProcedureCodingSystem-vs-5-3-6\"> </a><a name=\"hchx1c-v3-HealthCareCommonProcedureCodingSystem-vs-5-3-6\"> </a><p>Provenance for <a href=\"ValueSet-v3-HealthCareCommonProcedureCodingSystem.html\">ValueSet HealthCareCommonProcedureCodingSystem</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-13</td></tr><tr><td>Recorded</td><td>2023-11-13 14:11:14-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-HealthCareCommonProcedureCodingSystem"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-13"
        },
        "recorded" : "2023-11-13T14:11:14.57-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix technical error with HCPCS uri; up-472"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-TribalEntityUS-cs-5-3-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-TribalEntityUS-cs-5-3-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-TribalEntityUS-cs-5-3-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-TribalEntityUS-cs-5-3-8</b></p><a name=\"hx1c-v3-TribalEntityUS-cs-5-3-8\"> </a><a name=\"hchx1c-v3-TribalEntityUS-cs-5-3-8\"> </a><p>Provenance for <a href=\"CodeSystem-v3-TribalEntityUS.html\">CodeSystem TribalEntityUS</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 01:00:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-TribalEntityUS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T01:00:50.01-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update TribalEntity CS with 8/11/2023 Federal Register Publication; up-475"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ucum-common-vs-5-4-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ucum-common-vs-5-4-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ucum-common-vs-5-4-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ucum-common-vs-5-4-1</b></p><a name=\"hx1c-ucum-common-vs-5-4-1\"> </a><a name=\"hchx1c-ucum-common-vs-5-4-1\"> </a><p>Provenance for <a href=\"ValueSet-ucum-common.html\">ValueSet Common UCUM units</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-12-20</td></tr><tr><td>Recorded</td><td>2023-12-20 13:08:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ucum-common"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-12-20"
        },
        "recorded" : "2023-12-20T13:08:13.69-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "ucum-common and ucum-units should be migrated to HL7 Terminology (THO); up-481"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ucum-units-vs-5-4-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ucum-units-vs-5-4-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ucum-units-vs-5-4-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ucum-units-vs-5-4-1</b></p><a name=\"hx1c-ucum-units-vs-5-4-1\"> </a><a name=\"hchx1c-ucum-units-vs-5-4-1\"> </a><p>Provenance for <a href=\"ValueSet-ucum-units.html\">ValueSet UCUM Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-12-20</td></tr><tr><td>Recorded</td><td>2023-12-20 13:08:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ucum-units"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-12-20"
        },
        "recorded" : "2023-12-20T13:08:19.79-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "ucum-common and ucum-units should be migrated to HL7 Terminology (THO); up-481"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-organization-type-cs-5-4-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-organization-type-cs-5-4-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-organization-type-cs-5-4-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-organization-type-cs-5-4-1</b></p><a name=\"hx1c-organization-type-cs-5-4-1\"> </a><a name=\"hchx1c-organization-type-cs-5-4-1\"> </a><p>Provenance for <a href=\"CodeSystem-organization-type.html\">CodeSystem Organization type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-02-29</td></tr><tr><td>Recorded</td><td>2024-02-29 10:40:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Josh Mandel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/organization-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-02-29"
        },
        "recorded" : "2024-02-29T10:40:52.48-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Include additional concepts in Organization Types; up-516"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Josh Mandel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cs-service-referral-method-5-4-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cs-service-referral-method-5-4-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cs-service-referral-method-5-4-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cs-service-referral-method-5-4-2</b></p><a name=\"hx1c-cs-service-referral-method-5-4-2\"> </a><a name=\"hchx1c-cs-service-referral-method-5-4-2\"> </a><p>Provenance for <a href=\"CodeSystem-service-referral-method.html\">CodeSystem ReferralMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-02-29</td></tr><tr><td>Recorded</td><td>2024-02-29 13:17:42-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Carmen Tao</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/service-referral-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-02-29"
        },
        "recorded" : "2024-02-29T13:17:42.35-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Addition to FHIR spec: ReferralMethod; up-449"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Carmen Tao"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-artifact-version-policy-codes-cs-5-4-5",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-artifact-version-policy-codes-cs-5-4-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-artifact-version-policy-codes-cs-5-4-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-artifact-version-policy-codes-cs-5-4-5</b></p><a name=\"hx1c-artifact-version-policy-codes-cs-5-4-5\"> </a><a name=\"hchx1c-artifact-version-policy-codes-cs-5-4-5\"> </a><p>Provenance for <a href=\"CodeSystem-artifact-version-policy-codes.html\">CodeSystem Artifact Version Policy Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-01</td></tr><tr><td>Recorded</td><td>2024-03-01 10:06:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bryn Rhodes</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/artifact-version-policy-codes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-01"
        },
        "recorded" : "2024-03-01T10:06:33.00-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add version policy code system; up-482"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bryn Rhodes"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-artifact-version-policy-vs-5-4-5",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-artifact-version-policy-vs-5-4-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-artifact-version-policy-vs-5-4-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-artifact-version-policy-vs-5-4-5</b></p><a name=\"hx1c-artifact-version-policy-vs-5-4-5\"> </a><a name=\"hchx1c-artifact-version-policy-vs-5-4-5\"> </a><p>Provenance for <a href=\"ValueSet-artifact-version-policy.html\">ValueSet Artifact Version Policy</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-01</td></tr><tr><td>Recorded</td><td>2024-03-01 10:06:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bryn Rhodes</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/artifact-version-policy"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-01"
        },
        "recorded" : "2024-03-01T10:06:38.06-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add version policy code system; up-482"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bryn Rhodes"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-artifact-identifier-type-cs-5-4-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-artifact-identifier-type-cs-5-4-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-artifact-identifier-type-cs-5-4-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-artifact-identifier-type-cs-5-4-6</b></p><a name=\"hx1c-artifact-identifier-type-cs-5-4-6\"> </a><a name=\"hchx1c-artifact-identifier-type-cs-5-4-6\"> </a><p>Provenance for <a href=\"CodeSystem-artifact-identifier-type.html\">CodeSystem Artifact Identifier Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-01</td></tr><tr><td>Recorded</td><td>2024-03-01 22:51:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/artifact-identifier-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-01"
        },
        "recorded" : "2024-03-01T22:51:38.56-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move code system and value set from Quality Measure IG to THO; up-525"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-artifact-identifier-type-vs-5-4-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-artifact-identifier-type-vs-5-4-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-artifact-identifier-type-vs-5-4-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-artifact-identifier-type-vs-5-4-6</b></p><a name=\"hx1c-artifact-identifier-type-vs-5-4-6\"> </a><a name=\"hchx1c-artifact-identifier-type-vs-5-4-6\"> </a><p>Provenance for <a href=\"ValueSet-artifact-identifier-type.html\">ValueSet Artifact Identifier Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-01</td></tr><tr><td>Recorded</td><td>2024-03-01 22:51:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Abdullah Rafiqi</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/artifact-identifier-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-01"
        },
        "recorded" : "2024-03-01T22:51:43.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move code system and value set from Quality Measure IG to THO; up-525"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Abdullah Rafiqi"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-HealthcareServiceLocation-vs-5-4-4",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-HealthcareServiceLocation-vs-5-4-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-HealthcareServiceLocation-vs-5-4-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-HealthcareServiceLocation-vs-5-4-4</b></p><a name=\"hx1c-v3-HealthcareServiceLocation-vs-5-4-4\"> </a><a name=\"hchx1c-v3-HealthcareServiceLocation-vs-5-4-4\"> </a><p>Provenance for <a href=\"ValueSet-v3-HealthcareServiceLocation.html\">ValueSet HealthcareServiceLocation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-01</td></tr><tr><td>Recorded</td><td>2024-03-01 18:48:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-HealthcareServiceLocation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-01"
        },
        "recorded" : "2024-03-01T18:48:05.36-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Allow CMS Place of Service codes for HealthcareServiceLocation; up-458"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cql-access-modifier-cs-5-4-7",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cql-access-modifier-cs-5-4-7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cql-access-modifier-cs-5-4-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cql-access-modifier-cs-5-4-7</b></p><a name=\"hx1c-cql-access-modifier-cs-5-4-7\"> </a><a name=\"hchx1c-cql-access-modifier-cs-5-4-7\"> </a><p>Provenance for <a href=\"CodeSystem-cql-access-modifier.html\">CodeSystem CQL Access Modifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-01</td></tr><tr><td>Recorded</td><td>2024-03-01 23:11:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bryn Rhodes</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/cql-access-modifier"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-01"
        },
        "recorded" : "2024-03-01T23:11:26.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add CQL Access Level Codes; up-522"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bryn Rhodes"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cql-access-modifier-vs-5-4-7",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cql-access-modifier-vs-5-4-7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cql-access-modifier-vs-5-4-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cql-access-modifier-vs-5-4-7</b></p><a name=\"hx1c-cql-access-modifier-vs-5-4-7\"> </a><a name=\"hchx1c-cql-access-modifier-vs-5-4-7\"> </a><p>Provenance for <a href=\"ValueSet-cql-access-modifier.html\">ValueSet CQL Access Modifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-01</td></tr><tr><td>Recorded</td><td>2024-03-01 23:11:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bryn Rhodes</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/cql-access-modifier"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-01"
        },
        "recorded" : "2024-03-01T23:11:30.50-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add CQL Access Level Codes; up-522"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bryn Rhodes"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ae-clinical-research-causality-relatedness-vs-5-4-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ae-clinical-research-causality-relatedness-vs-5-4-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ae-clinical-research-causality-relatedness-vs-5-4-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ae-clinical-research-causality-relatedness-vs-5-4-8</b></p><a name=\"hx1c-ae-clinical-research-causality-relatedness-vs-5-4-8\"> </a><a name=\"hchx1c-ae-clinical-research-causality-relatedness-vs-5-4-8\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-clinical-research-causality-relatedness.html\">ValueSet Adverse Event Clinical Research Causality Relatedness</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 10:25:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bret Heale</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>BRR</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-clinical-research-causality-relatedness"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T10:25:07.59-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "AdverseEvent Clinical Research value sets; up-485"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bret Heale"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "BRR"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-adverse-event-clinical-research-grades-vs-5-4-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-adverse-event-clinical-research-grades-vs-5-4-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-adverse-event-clinical-research-grades-vs-5-4-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-adverse-event-clinical-research-grades-vs-5-4-8</b></p><a name=\"hx1c-adverse-event-clinical-research-grades-vs-5-4-8\"> </a><a name=\"hchx1c-adverse-event-clinical-research-grades-vs-5-4-8\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-clinical-research-grades.html\">ValueSet Adverse Event Clinical Research Grades</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 10:25:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bret Heale</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>BRR</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-clinical-research-grades"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T10:25:31.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "AdverseEvent Clinical Research value sets; up-485"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bret Heale"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "BRR"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-adverse-event-clinical-research-outcomes-vs-5-4-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-adverse-event-clinical-research-outcomes-vs-5-4-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-adverse-event-clinical-research-outcomes-vs-5-4-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-adverse-event-clinical-research-outcomes-vs-5-4-8</b></p><a name=\"hx1c-adverse-event-clinical-research-outcomes-vs-5-4-8\"> </a><a name=\"hchx1c-adverse-event-clinical-research-outcomes-vs-5-4-8\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-clinical-research-outcomes.html\">ValueSet Adverse Event Clinical Research Outcomes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 10:25:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bret Heale</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>BRR</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-clinical-research-outcomes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T10:25:57.70-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "AdverseEvent Clinical Research value sets; up-485"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bret Heale"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "BRR"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ae-clinical-research-seriousness-criteria-vs-5-4-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ae-clinical-research-seriousness-criteria-vs-5-4-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ae-clinical-research-seriousness-criteria-vs-5-4-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ae-clinical-research-seriousness-criteria-vs-5-4-8</b></p><a name=\"hx1c-ae-clinical-research-seriousness-criteria-vs-5-4-8\"> </a><a name=\"hchx1c-ae-clinical-research-seriousness-criteria-vs-5-4-8\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-clinical-research-seriousness-criteria.html\">ValueSet Adverse Event Clinical Research Seriousness Criteria</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 10:26:16-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bret Heale</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>BRR</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-clinical-research-seriousness-criteria"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T10:26:16.20-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "AdverseEvent Clinical Research value sets; up-485"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bret Heale"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "BRR"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-software-system-type-codes-cs-5-4-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-software-system-type-codes-cs-5-4-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-software-system-type-codes-cs-5-4-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-software-system-type-codes-cs-5-4-9</b></p><a name=\"hx1c-software-system-type-codes-cs-5-4-9\"> </a><a name=\"hchx1c-software-system-type-codes-cs-5-4-9\"> </a><p>Provenance for <a href=\"CodeSystem-software-system-type-codes.html\">CodeSystem Software System Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 19:18:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bryn Rhodes</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/software-system-type-codes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T19:18:53.14-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Define software system type codes; up-483"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bryn Rhodes"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-software-system-type-vs-5-4-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-software-system-type-vs-5-4-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-software-system-type-vs-5-4-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-software-system-type-vs-5-4-9</b></p><a name=\"hx1c-software-system-type-vs-5-4-9\"> </a><a name=\"hchx1c-software-system-type-vs-5-4-9\"> </a><p>Provenance for <a href=\"ValueSet-software-system-type.html\">ValueSet Software System Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 19:19:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bryn Rhodes</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/software-system-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T19:19:11.17-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Define software system type codes; up-483"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bryn Rhodes"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-CCDD-ns-5-4-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-CCDD-ns-5-4-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-CCDD-ns-5-4-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-CCDD-ns-5-4-10</b></p><a name=\"hx1c-CCDD-ns-5-4-10\"> </a><a name=\"hchx1c-CCDD-ns-5-4-10\"> </a><p>Provenance for <a href=\"NamingSystem-CCDD.html\">NamingSystem Canadian Clinical Drug Data Set</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 19:33:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CCDD"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T19:33:28.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update Canadian Clinical Drug Dataset (CCDD) to clarify publisher, maintainer, and owner; up-514"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cmshcc-ns-5-4-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cmshcc-ns-5-4-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cmshcc-ns-5-4-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cmshcc-ns-5-4-11</b></p><a name=\"hx1c-cmshcc-ns-5-4-11\"> </a><a name=\"hchx1c-cmshcc-ns-5-4-11\"> </a><p>Provenance for <a href=\"NamingSystem-cmshcc.html\">NamingSystem CMS Hierarchical Condition Categories</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 19:38:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/cmshcc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T19:38:29.97-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add OID for CMS Hierarchical Condition Categories; up-515"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v2-0396-cs-5-4-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v2-0396-cs-5-4-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v2-0396-cs-5-4-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v2-0396-cs-5-4-11</b></p><a name=\"hx1c-v2-0396-cs-5-4-11\"> </a><a name=\"hchx1c-v2-0396-cs-5-4-11\"> </a><p>Provenance for <a href=\"CodeSystem-v2-0396.html\">CodeSystem codingSystem</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 19:38:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-0396"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T19:38:51.42-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add OID for CMS Hierarchical Condition Categories; up-515"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-SO-ns-5-4-12",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-SO-ns-5-4-12",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-SO-ns-5-4-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-SO-ns-5-4-12</b></p><a name=\"hx1c-SO-ns-5-4-12\"> </a><a name=\"hchx1c-SO-ns-5-4-12\"> </a><p>Provenance for <a href=\"NamingSystem-SO.html\">NamingSystem Sequence Ontology</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 19:42:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/SO"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T19:42:36.91-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add Sequence Ontology per HTA; up-488"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-OMOP-ns-5-4-13",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-OMOP-ns-5-4-13",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-OMOP-ns-5-4-13\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-OMOP-ns-5-4-13</b></p><a name=\"hx1c-OMOP-ns-5-4-13\"> </a><a name=\"hchx1c-OMOP-ns-5-4-13\"> </a><p>Provenance for <a href=\"NamingSystem-OMOP.html\">NamingSystem OHDSI Standardized Vocabularies</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 19:49:06-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/OMOP"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T19:49:06.37-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add OHDSI Standardized Vocabularies per HTA; up-487"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-AddressUse-cs-5-4-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-AddressUse-cs-5-4-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-AddressUse-cs-5-4-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-AddressUse-cs-5-4-14</b></p><a name=\"hx1c-v3-AddressUse-cs-5-4-14\"> </a><a name=\"hchx1c-v3-AddressUse-cs-5-4-14\"> </a><p>Provenance for <a href=\"CodeSystem-v3-AddressUse.html\">CodeSystem AddressUse</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 23:05:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-AddressUse"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T23:05:37.75-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix typo in display of one AddressUse concept; up-527"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-jurisdiction-vs-5-4-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-jurisdiction-vs-5-4-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-jurisdiction-vs-5-4-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-jurisdiction-vs-5-4-15</b></p><a name=\"hx1c-jurisdiction-vs-5-4-15\"> </a><a name=\"hchx1c-jurisdiction-vs-5-4-15\"> </a><p>Provenance for <a href=\"ValueSet-jurisdiction.html\">ValueSet Jurisdiction ValueSet</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 23:12:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Reuben Daniels</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/jurisdiction"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T23:12:36.42-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Migrate the Jurisdiction value set from FHIR core to THO; up-521"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Reuben Daniels"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-appointment-cancellation-reason-cs-5-4-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-appointment-cancellation-reason-cs-5-4-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-appointment-cancellation-reason-cs-5-4-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-appointment-cancellation-reason-cs-5-4-16</b></p><a name=\"hx1c-appointment-cancellation-reason-cs-5-4-16\"> </a><a name=\"hchx1c-appointment-cancellation-reason-cs-5-4-16\"> </a><p>Provenance for <a href=\"CodeSystem-appointment-cancellation-reason.html\">CodeSystem Appointment cancellation reason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 23:24:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/appointment-cancellation-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T23:24:12.32-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "FHIR-39600 Endpoint connection type cleanup, FHIR-35965 PA content erroneously marked as example content, FHIR-20484 add definitions for diagnosis-role; up-529"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-diagnosis-role-cs-5-4-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-diagnosis-role-cs-5-4-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-diagnosis-role-cs-5-4-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-diagnosis-role-cs-5-4-16</b></p><a name=\"hx1c-diagnosis-role-cs-5-4-16\"> </a><a name=\"hchx1c-diagnosis-role-cs-5-4-16\"> </a><p>Provenance for <a href=\"CodeSystem-diagnosis-role.html\">CodeSystem Diagnosis Role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 23:24:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/diagnosis-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T23:24:22.91-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "FHIR-39600 Endpoint connection type cleanup, FHIR-35965 PA content erroneously marked as example content, FHIR-20484 add definitions for diagnosis-role; up-529"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-endpoint-connection-type-cs-5-4-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-endpoint-connection-type-cs-5-4-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-endpoint-connection-type-cs-5-4-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-endpoint-connection-type-cs-5-4-16</b></p><a name=\"hx1c-endpoint-connection-type-cs-5-4-16\"> </a><a name=\"hchx1c-endpoint-connection-type-cs-5-4-16\"> </a><p>Provenance for <a href=\"CodeSystem-endpoint-connection-type.html\">CodeSystem Endpoint Connection Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 23:24:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/endpoint-connection-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T23:24:35.22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "FHIR-39600 Endpoint connection type cleanup, FHIR-35965 PA content erroneously marked as example content, FHIR-20484 add definitions for diagnosis-role; up-529"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-service-category-cs-5-4-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-service-category-cs-5-4-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-service-category-cs-5-4-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-service-category-cs-5-4-16</b></p><a name=\"hx1c-service-category-cs-5-4-16\"> </a><a name=\"hchx1c-service-category-cs-5-4-16\"> </a><p>Provenance for <a href=\"CodeSystem-service-category.html\">CodeSystem Service category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 23:24:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/service-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T23:24:44.68-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "FHIR-39600 Endpoint connection type cleanup, FHIR-35965 PA content erroneously marked as example content, FHIR-20484 add definitions for diagnosis-role; up-529"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-service-type-cs-5-4-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-service-type-cs-5-4-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-service-type-cs-5-4-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-service-type-cs-5-4-16</b></p><a name=\"hx1c-service-type-cs-5-4-16\"> </a><a name=\"hchx1c-service-type-cs-5-4-16\"> </a><p>Provenance for <a href=\"CodeSystem-service-type.html\">CodeSystem Service type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 23:24:56-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/service-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T23:24:56.66-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "FHIR-39600 Endpoint connection type cleanup, FHIR-35965 PA content erroneously marked as example content, FHIR-20484 add definitions for diagnosis-role; up-529"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-hl7-work-group-cs-5-4-17",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-hl7-work-group-cs-5-4-17",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-hl7-work-group-cs-5-4-17\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-hl7-work-group-cs-5-4-17</b></p><a name=\"hx1c-hl7-work-group-cs-5-4-17\"> </a><a name=\"hchx1c-hl7-work-group-cs-5-4-17\"> </a><p>Provenance for <a href=\"CodeSystem-hl7-work-group.html\">CodeSystem HL7Workgroup</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 23:29:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/hl7-work-group"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T23:29:20.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update HL7Workgroup to align with extensions pack code system; up-532"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-nuccProviderCodes-ns-5-4-18",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-nuccProviderCodes-ns-5-4-18",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-nuccProviderCodes-ns-5-4-18\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-nuccProviderCodes-ns-5-4-18</b></p><a name=\"hx1c-v3-nuccProviderCodes-ns-5-4-18\"> </a><a name=\"hchx1c-v3-nuccProviderCodes-ns-5-4-18\"> </a><p>Provenance for <a href=\"NamingSystem-v3-nuccProviderCodes.html\">NamingSystem NUCC Health Care Provider Taxonomy</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 23:36:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-nuccProviderCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T23:36:07.80-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix Erroneous URL for NUCC Provider Taxonomy; up-518"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-icpc2E-ns-5-4-19",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-icpc2E-ns-5-4-19",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-icpc2E-ns-5-4-19\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-icpc2E-ns-5-4-19</b></p><a name=\"hx1c-v3-icpc2E-ns-5-4-19\"> </a><a name=\"hchx1c-v3-icpc2E-ns-5-4-19\"> </a><p>Provenance for <a href=\"NamingSystem-v3-icpc2E.html\">NamingSystem International Classification of Primary Care, second edition (1998)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-02</td></tr><tr><td>Recorded</td><td>2024-03-02 23:40:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-icpc2E"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-02"
        },
        "recorded" : "2024-03-02T23:40:41.41-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Activate ICPC-2 code system metadata record; up-519"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ns-hcp-lan-apm-framework-5-4-20",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ns-hcp-lan-apm-framework-5-4-20",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ns-hcp-lan-apm-framework-5-4-20\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ns-hcp-lan-apm-framework-5-4-20</b></p><a name=\"hx1c-ns-hcp-lan-apm-framework-5-4-20\"> </a><a name=\"hchx1c-ns-hcp-lan-apm-framework-5-4-20\"> </a><p>Provenance for <a href=\"NamingSystem-hcp-lan-apm-framework.html\">NamingSystem The Health Care Payment Learning and Action Network (HCPLAN) Alternative Payment Model (APM) Framework Categories</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2024-03-07</td></tr><tr><td>Recorded</td><td>2024-03-07 22:57:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/hcp-lan-apm-framework"
          }
        ],
        "occurredPeriod" : {
          "end" : "2024-03-07"
        },
        "recorded" : "2024-03-07T22:57:40.94-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add LAN APM Framework per HTA; up-533"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v2-tables-cs-6-1-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v2-tables-cs-6-1-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v2-tables-cs-6-1-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v2-tables-cs-6-1-2</b></p><a name=\"hx1c-v2-tables-cs-6-1-2\"> </a><a name=\"hchx1c-v2-tables-cs-6-1-2\"> </a><p>Provenance for <a href=\"CodeSystem-v2-tables.html\">CodeSystem V2 Table List</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 12:20:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-tables"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T12:20:39.43-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "No defined code systems for V2 tables 0931 and 0932; up-48"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-accepting-patients-cs-6-1-3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-accepting-patients-cs-6-1-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-accepting-patients-cs-6-1-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-accepting-patients-cs-6-1-3</b></p><a name=\"hx1c-accepting-patients-cs-6-1-3\"> </a><a name=\"hchx1c-accepting-patients-cs-6-1-3\"> </a><p>Provenance for <a href=\"CodeSystem-accepting-patients.html\">CodeSystem Accepting Patients</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 13:32:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/accepting-patients"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T13:32:50.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create the Accepting Patient Code System and the Accepting Patient Value Set; up-492"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-accepting-patients-vs-6-1-3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-accepting-patients-vs-6-1-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-accepting-patients-vs-6-1-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-accepting-patients-vs-6-1-3</b></p><a name=\"hx1c-accepting-patients-vs-6-1-3\"> </a><a name=\"hchx1c-accepting-patients-vs-6-1-3\"> </a><p>Provenance for <a href=\"ValueSet-accepting-patients.html\">ValueSet Accepting Patients</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 13:32:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/accepting-patients"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T13:32:54.66-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create the Accepting Patient Code System and the Accepting Patient Value Set; up-492"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-virtual-healthcare-delivery-method-cs-6-1-4",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-virtual-healthcare-delivery-method-cs-6-1-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-virtual-healthcare-delivery-method-cs-6-1-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-virtual-healthcare-delivery-method-cs-6-1-4</b></p><a name=\"hx1c-virtual-healthcare-delivery-method-cs-6-1-4\"> </a><a name=\"hchx1c-virtual-healthcare-delivery-method-cs-6-1-4\"> </a><p>Provenance for <a href=\"CodeSystem-virtual-healthcare-delivery-method.html\">CodeSystem Virtual Healthcare Delivery Method</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 15:43:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/virtual-healthcare-delivery-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T15:43:50.05-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create Virtual Modalities Code System and Virtual Modalities Value Set; up-510"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-virtual-healthcare-delivery-method-vs-6-1-4",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-virtual-healthcare-delivery-method-vs-6-1-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-virtual-healthcare-delivery-method-vs-6-1-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-virtual-healthcare-delivery-method-vs-6-1-4</b></p><a name=\"hx1c-virtual-healthcare-delivery-method-vs-6-1-4\"> </a><a name=\"hchx1c-virtual-healthcare-delivery-method-vs-6-1-4\"> </a><p>Provenance for <a href=\"ValueSet-virtual-healthcare-delivery-method.html\">ValueSet Virtual Healthcare Delivery Method</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 15:43:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/virtual-healthcare-delivery-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T15:43:54.00-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create Virtual Modalities Code System and Virtual Modalities Value Set; up-510"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-care-service-accessibility-cs-6-1-5",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-care-service-accessibility-cs-6-1-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-care-service-accessibility-cs-6-1-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-care-service-accessibility-cs-6-1-5</b></p><a name=\"hx1c-care-service-accessibility-cs-6-1-5\"> </a><a name=\"hchx1c-care-service-accessibility-cs-6-1-5\"> </a><p>Provenance for <a href=\"CodeSystem-care-service-accessibility.html\">CodeSystem Care Service Accessibility</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 17:30:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/care-service-accessibility"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T17:30:48.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create the Accessibility Code System and the Accessibility Value Set; up-493"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-care-service-accessibility-vs-6-1-5",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-care-service-accessibility-vs-6-1-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-care-service-accessibility-vs-6-1-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-care-service-accessibility-vs-6-1-5</b></p><a name=\"hx1c-care-service-accessibility-vs-6-1-5\"> </a><a name=\"hchx1c-care-service-accessibility-vs-6-1-5\"> </a><p>Provenance for <a href=\"ValueSet-care-service-accessibility.html\">ValueSet Care Service Accessibility</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 17:30:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/care-service-accessibility"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T17:30:53.31-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create the Accessibility Code System and the Accessibility Value Set; up-493"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx16-organization-affiliation-role-for-hie-cs-6-1-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx16-organization-affiliation-role-for-hie-cs-6-1-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx16-organization-affiliation-role-for-hie-cs-6-1-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx16-organization-affiliation-role-for-hie-cs-6-1-6</b></p><a name=\"hx16-organization-affiliation-role-for-hie-cs-6-1-6\"> </a><a name=\"hchx16-organization-affiliation-role-for-hie-cs-6-1-6\"> </a><p>Provenance for <a href=\"CodeSystem-organization-affiliation-role-for-hie.html\">CodeSystem Organization Affiliation Role for HIE</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 17:46:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/organization-affiliation-role-for-hie"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T17:46:17.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create Organization Affiliation Role Code System and Organization Affiliation Role Value Set; up-511"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx16-organization-affiliation-role-cs-6-1-7",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx16-organization-affiliation-role-cs-6-1-7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx16-organization-affiliation-role-cs-6-1-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx16-organization-affiliation-role-cs-6-1-7</b></p><a name=\"hx16-organization-affiliation-role-cs-6-1-7\"> </a><a name=\"hchx16-organization-affiliation-role-cs-6-1-7\"> </a><p>Provenance for <a href=\"CodeSystem-organization-affiliation-role.html\">CodeSystem Organization Affiliation Role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 17:46:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/organization-affiliation-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T17:46:21.40-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create Organization Affiliation Role Code System and Organization Affiliation Role Value Set; up-511"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx16-organization-affiliation-role-vs-6-1-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx16-organization-affiliation-role-vs-6-1-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx16-organization-affiliation-role-vs-6-1-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx16-organization-affiliation-role-vs-6-1-6</b></p><a name=\"hx16-organization-affiliation-role-vs-6-1-6\"> </a><a name=\"hchx16-organization-affiliation-role-vs-6-1-6\"> </a><p>Provenance for <a href=\"ValueSet-organization-affiliation-role.html\">ValueSet Organization Affiliation Role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 17:46:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/organization-affiliation-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T17:46:25.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create Organization Affiliation Role Code System and Organization Affiliation Role Value Set; up-511"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx17-organization-type-cs-6-1-7",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx17-organization-type-cs-6-1-7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx17-organization-type-cs-6-1-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx17-organization-type-cs-6-1-7</b></p><a name=\"hx17-organization-type-cs-6-1-7\"> </a><a name=\"hchx17-organization-type-cs-6-1-7\"> </a><p>Provenance for <a href=\"CodeSystem-organization-type.html\">CodeSystem Organization type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 18:00:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/organization-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T18:00:36.22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add values to the THO Organization Type Code System; up-507"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ndh-healthcare-service-category-cs-5-1-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ndh-healthcare-service-category-cs-5-1-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ndh-healthcare-service-category-cs-5-1-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ndh-healthcare-service-category-cs-5-1-8</b></p><a name=\"hx1c-ndh-healthcare-service-category-cs-5-1-8\"> </a><a name=\"hchx1c-ndh-healthcare-service-category-cs-5-1-8\"> </a><p>Provenance for <a href=\"CodeSystem-ndh-healthcare-service-category.html\">CodeSystem NDH Healthcare Service Category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 18:59:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ndh-healthcare-service-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T18:59:07.60-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create Healthcare Service Category Code System and Value Set; up-517"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ndh-healthcare-service-category-vs-5-1-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ndh-healthcare-service-category-vs-5-1-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ndh-healthcare-service-category-vs-5-1-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ndh-healthcare-service-category-vs-5-1-8</b></p><a name=\"hx1c-ndh-healthcare-service-category-vs-5-1-8\"> </a><a name=\"hchx1c-ndh-healthcare-service-category-vs-5-1-8\"> </a><p>Provenance for <a href=\"ValueSet-ndh-healthcare-service-category.html\">ValueSet NDH Healthcare Service Category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 18:59:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ming Dunajick</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/ndh-healthcare-service-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T18:59:15.07-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create Healthcare Service Category Code System and Value Set; up-517"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ming Dunajick"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-adverse-event-causality-method-cs-5-1-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-adverse-event-causality-method-cs-5-1-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-adverse-event-causality-method-cs-5-1-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-adverse-event-causality-method-cs-5-1-9</b></p><a name=\"hx1c-adverse-event-causality-method-cs-5-1-9\"> </a><a name=\"hchx1c-adverse-event-causality-method-cs-5-1-9\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-causality-method.html\">CodeSystem AdverseEventCausalityMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 19:27:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Michelle Miller</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Patient Care</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-causality-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T19:27:55.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update definitions within CodeSystem-adverse-event-causality-method; up-598"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Michelle Miller"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Patient Care"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-adverse-event-category-cs-5-1-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-adverse-event-category-cs-5-1-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-adverse-event-category-cs-5-1-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-adverse-event-category-cs-5-1-10</b></p><a name=\"hx1c-adverse-event-category-cs-5-1-10\"> </a><a name=\"hchx1c-adverse-event-category-cs-5-1-10\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-category.html\">CodeSystem AdverseEventCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 19:37:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Michelle Miller</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T19:37:15.50-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add clinical-research to CodeSystem-adverse-event-category; up-597"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Michelle Miller"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-goal-category-cs-5-1-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-goal-category-cs-5-1-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-goal-category-cs-5-1-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-goal-category-cs-5-1-11</b></p><a name=\"hx1c-goal-category-cs-5-1-11\"> </a><a name=\"hchx1c-goal-category-cs-5-1-11\"> </a><p>Provenance for <a href=\"CodeSystem-goal-category.html\">CodeSystem Goal category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-01-20</td></tr><tr><td>Recorded</td><td>2025-01-20 19:41:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Michelle Miller</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/goal-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-01-20"
        },
        "recorded" : "2025-01-20T19:41:10.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add codes to CodeSystem-goal-category; up-599"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Michelle Miller"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-Languages-vs-6-2-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-Languages-vs-6-2-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-Languages-vs-6-2-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-Languages-vs-6-2-1</b></p><a name=\"hx1c-Languages-vs-6-2-1\"> </a><a name=\"hchx1c-Languages-vs-6-2-1\"> </a><p>Provenance for <a href=\"ValueSet-Languages.html\">ValueSet Languages</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-14</td></tr><tr><td>Recorded</td><td>2025-03-14 21:10:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CGP</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/Languages"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-14"
        },
        "recorded" : "2025-03-14T21:10:07.58-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create a US Realm language value set; up-636"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CGP"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v2-0203-cs-6-2-2",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v2-0203-cs-6-2-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v2-0203-cs-6-2-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v2-0203-cs-6-2-2</b></p><a name=\"hx1c-v2-0203-cs-6-2-2\"> </a><a name=\"hchx1c-v2-0203-cs-6-2-2\"> </a><p>Provenance for <a href=\"CodeSystem-v2-0203.html\">CodeSystem identifierType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-14</td></tr><tr><td>Recorded</td><td>2025-03-14 22:09:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Frank Oemig</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HL7 Germany</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-0203"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-14"
        },
        "recorded" : "2025-03-14T22:09:23.41-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "add identifier type for Kassensitz-IK to identifier type (table 0203); up-561"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Frank Oemig"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HL7 Germany"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v2-0396-cs-6-2-3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v2-0396-cs-6-2-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v2-0396-cs-6-2-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v2-0396-cs-6-2-3</b></p><a name=\"hx1c-v2-0396-cs-6-2-3\"> </a><a name=\"hchx1c-v2-0396-cs-6-2-3\"> </a><p>Provenance for <a href=\"CodeSystem-v2-0396.html\">CodeSystem codingSystem</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 09:01:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Caroline Rosin</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>NIST</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-0396"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T09:01:22.78-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add NCIT code to v2 0396; up-586"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Caroline Rosin"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "NIST"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v2-0203-cs-6-2-4",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v2-0203-cs-6-2-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v2-0203-cs-6-2-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v2-0203-cs-6-2-4</b></p><a name=\"hx1c-v2-0203-cs-6-2-4\"> </a><a name=\"hchx1c-v2-0203-cs-6-2-4\"> </a><p>Provenance for <a href=\"CodeSystem-v2-0203.html\">CodeSystem identifierType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 09:10:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Frank Oemig</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HL7 Germany</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-0203"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T09:10:57.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "add codes to v2-0203 for use in German profiles; up-339"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Frank Oemig"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HL7 Germany"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-DischargeDisposition-vs-6-2-5",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-DischargeDisposition-vs-6-2-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-DischargeDisposition-vs-6-2-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-DischargeDisposition-vs-6-2-5</b></p><a name=\"hx1c-v3-DischargeDisposition-vs-6-2-5\"> </a><a name=\"hchx1c-v3-DischargeDisposition-vs-6-2-5\"> </a><p>Provenance for <a href=\"ValueSet-v3-DischargeDisposition.html\">ValueSet Discharge Disposition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 09:23:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-DischargeDisposition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T09:23:28.90-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Merge and migrate US Core and C-CDA discharge disposition value sets to THO; up-578"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v3-HL7DocumentFormatCodes-cs-5-2-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v3-HL7DocumentFormatCodes-cs-5-2-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v3-HL7DocumentFormatCodes-cs-5-2-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v3-HL7DocumentFormatCodes-cs-5-2-6</b></p><a name=\"hx1c-v3-HL7DocumentFormatCodes-cs-5-2-6\"> </a><a name=\"hchx1c-v3-HL7DocumentFormatCodes-cs-5-2-6\"> </a><p>Provenance for <a href=\"CodeSystem-v3-HL7DocumentFormatCodes.html\">CodeSystem HL7 Document Format Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 10:57:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Russell Ott</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-HL7DocumentFormatCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T10:57:05.65-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Update v3 DocumentFormatCodes to align with C-CDA versions in use; up-626"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Russell Ott"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-usage-context-type-cs-5-2-7",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-usage-context-type-cs-5-2-7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-usage-context-type-cs-5-2-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-usage-context-type-cs-5-2-7</b></p><a name=\"hx1c-usage-context-type-cs-5-2-7\"> </a><a name=\"hchx1c-usage-context-type-cs-5-2-7\"> </a><p>Provenance for <a href=\"CodeSystem-usage-context-type.html\">CodeSystem UsageContextType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 11:02:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bryn Rhodes</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/usage-context-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T11:02:19.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add topic and jurisdiction codes to; up-401"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bryn Rhodes"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ICHContextOfUse-ns-6-2-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ICHContextOfUse-ns-6-2-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ICHContextOfUse-ns-6-2-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ICHContextOfUse-ns-6-2-8</b></p><a name=\"hx1c-ICHContextOfUse-ns-6-2-8\"> </a><a name=\"hchx1c-ICHContextOfUse-ns-6-2-8\"> </a><p>Provenance for <a href=\"NamingSystem-ICHContextOfUse.html\">NamingSystem ICH Context of Use</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 11:12:14-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICHContextOfUse"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T11:12:14.60-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add Temporary uri for ICH Context of Use; up-632"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-CDCVIS-ns-6-2-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-CDCVIS-ns-6-2-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-CDCVIS-ns-6-2-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-CDCVIS-ns-6-2-9</b></p><a name=\"hx1c-CDCVIS-ns-6-2-9\"> </a><a name=\"hchx1c-CDCVIS-ns-6-2-9\"> </a><p>Provenance for <a href=\"NamingSystem-CDCVIS.html\">NamingSystem Vaccine Information Statements (VIS)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 11:12:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CDCVIS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T11:12:57.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add Vaccine Information Statements per TSMG; up-649"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-SEVCO-ns-6-2-10",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-SEVCO-ns-6-2-10",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-SEVCO-ns-6-2-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-SEVCO-ns-6-2-10</b></p><a name=\"hx1c-SEVCO-ns-6-2-10\"> </a><a name=\"hchx1c-SEVCO-ns-6-2-10\"> </a><p>Provenance for <a href=\"NamingSystem-SEVCO.html\">NamingSystem Scientific Evidence Code System (SEVCO)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 11:19:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/SEVCO"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T11:19:35.72-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add Scientific Evidence Code System (SEVCO) per TSMG; up-650"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-v2-tables-cs-5-2-11",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-v2-tables-cs-5-2-11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-v2-tables-cs-5-2-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-v2-tables-cs-5-2-11</b></p><a name=\"hx1c-v2-tables-cs-5-2-11\"> </a><a name=\"hchx1c-v2-tables-cs-5-2-11\"> </a><p>Provenance for <a href=\"CodeSystem-v2-tables.html\">CodeSystem V2 Table List</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 11:26:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v2-tables"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T11:26:33.13-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add URIs for V2 Tables Code Systems and Value Sets; up-648"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-measure-supplemental-data-cs-5-2-13",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-measure-supplemental-data-cs-5-2-13",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-measure-supplemental-data-cs-5-2-13\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-measure-supplemental-data-cs-5-2-13</b></p><a name=\"hx1c-measure-supplemental-data-cs-5-2-13\"> </a><a name=\"hchx1c-measure-supplemental-data-cs-5-2-13\"> </a><p>Provenance for <a href=\"CodeSystem-measure-supplemental-data.html\">CodeSystem Measure Supplemental Data</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 11:32:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bryn Rhodes</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-supplemental-data"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T11:32:18.34-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "MeasureSupplementalData code system and value set should be active; up-651"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bryn Rhodes"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-measure-supplemental-data-vs-5-2-13",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-measure-supplemental-data-vs-5-2-13",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-measure-supplemental-data-vs-5-2-13\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-measure-supplemental-data-vs-5-2-13</b></p><a name=\"hx1c-measure-supplemental-data-vs-5-2-13\"> </a><a name=\"hchx1c-measure-supplemental-data-vs-5-2-13\"> </a><p>Provenance for <a href=\"ValueSet-measure-supplemental-data.html\">ValueSet Measure Supplemental Data</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 11:32:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bryn Rhodes</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/measure-supplemental-data"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T11:32:26.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "MeasureSupplementalData code system and value set should be active; up-651"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bryn Rhodes"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-artifact-relationship-type-cs-6-2-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-artifact-relationship-type-cs-6-2-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-artifact-relationship-type-cs-6-2-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-artifact-relationship-type-cs-6-2-14</b></p><a name=\"hx1c-artifact-relationship-type-cs-6-2-14\"> </a><a name=\"hchx1c-artifact-relationship-type-cs-6-2-14\"> </a><p>Provenance for <a href=\"CodeSystem-artifact-relationship-type.html\">CodeSystem Artifact Relationship Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 11:43:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/artifact-relationship-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T11:43:13.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create a new combined CodeSystem within THO that will support the replacement of Composition.relatesTo when RelatedArtifact datatype is deprecated; up-644"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-artifact-relationship-type-vs-6-2-14",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-artifact-relationship-type-vs-6-2-14",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-artifact-relationship-type-vs-6-2-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-artifact-relationship-type-vs-6-2-14</b></p><a name=\"hx1c-artifact-relationship-type-vs-6-2-14\"> </a><a name=\"hchx1c-artifact-relationship-type-vs-6-2-14\"> </a><p>Provenance for <a href=\"ValueSet-artifact-relationship-type.html\">ValueSet Artifact Relationship Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 11:43:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/artifact-relationship-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T11:43:18.35-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create a new combined CodeSystem within THO that will support the replacement of Composition.relatesTo when RelatedArtifact datatype is deprecated; up-644"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-artifact-contribution-instance-type-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-artifact-contribution-instance-type-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-artifact-contribution-instance-type-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-artifact-contribution-instance-type-cs-6-2-15</b></p><a name=\"hx1c-artifact-contribution-instance-type-cs-6-2-15\"> </a><a name=\"hchx1c-artifact-contribution-instance-type-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-artifact-contribution-instance-type.html\">CodeSystem Artifact Contribution Instance Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:04-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/artifact-contribution-instance-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:04.23-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-artifact-url-classifier-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-artifact-url-classifier-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-artifact-url-classifier-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-artifact-url-classifier-cs-6-2-15</b></p><a name=\"hx1c-artifact-url-classifier-cs-6-2-15\"> </a><a name=\"hchx1c-artifact-url-classifier-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-artifact-url-classifier.html\">CodeSystem Artifact Url Classifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/artifact-url-classifier"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:05.15-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-certainty-type-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-certainty-type-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-certainty-type-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-certainty-type-cs-6-2-15</b></p><a name=\"hx1c-certainty-type-cs-6-2-15\"> </a><a name=\"hchx1c-certainty-type-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-certainty-type.html\">CodeSystem Evidence Certainty Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:06-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/certainty-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:06.14-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-citation-artifact-classifier-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-citation-artifact-classifier-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-citation-artifact-classifier-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-citation-artifact-classifier-cs-6-2-15</b></p><a name=\"hx1c-citation-artifact-classifier-cs-6-2-15\"> </a><a name=\"hchx1c-citation-artifact-classifier-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-citation-artifact-classifier.html\">CodeSystem Citation Artifact Classifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/citation-artifact-classifier"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:07.05-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-citation-classification-type-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-citation-classification-type-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-citation-classification-type-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-citation-classification-type-cs-6-2-15</b></p><a name=\"hx1c-citation-classification-type-cs-6-2-15\"> </a><a name=\"hchx1c-citation-classification-type-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-citation-classification-type.html\">CodeSystem Citation Classification Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/citation-classification-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:07.97-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-citation-summary-style-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-citation-summary-style-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-citation-summary-style-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-citation-summary-style-cs-6-2-15</b></p><a name=\"hx1c-citation-summary-style-cs-6-2-15\"> </a><a name=\"hchx1c-citation-summary-style-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-citation-summary-style.html\">CodeSystem Citation Summary Style</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/citation-summary-style"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:08.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-artifact-abstract-type-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-artifact-abstract-type-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-artifact-abstract-type-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-artifact-abstract-type-cs-6-2-15</b></p><a name=\"hx1c-cited-artifact-abstract-type-cs-6-2-15\"> </a><a name=\"hchx1c-cited-artifact-abstract-type-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-cited-artifact-abstract-type.html\">CodeSystem Cited Artifact Abstract Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:09-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/cited-artifact-abstract-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:09.89-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-artifact-classification-type-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-artifact-classification-type-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-artifact-classification-type-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-artifact-classification-type-cs-6-2-15</b></p><a name=\"hx1c-cited-artifact-classification-type-cs-6-2-15\"> </a><a name=\"hchx1c-cited-artifact-classification-type-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-cited-artifact-classification-type.html\">CodeSystem Cited Artifact Classification Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/cited-artifact-classification-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:10.85-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-artifact-contribution-type-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-artifact-contribution-type-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-artifact-contribution-type-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-artifact-contribution-type-cs-6-2-15</b></p><a name=\"hx1c-cited-artifact-contribution-type-cs-6-2-15\"> </a><a name=\"hchx1c-cited-artifact-contribution-type-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-cited-artifact-contribution-type.html\">CodeSystem Cited Artifact Contribution Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/cited-artifact-contribution-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:11.80-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-artifact-part-type-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-artifact-part-type-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-artifact-part-type-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-artifact-part-type-cs-6-2-15</b></p><a name=\"hx1c-cited-artifact-part-type-cs-6-2-15\"> </a><a name=\"hchx1c-cited-artifact-part-type-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-cited-artifact-part-type.html\">CodeSystem Cited Artifact Part Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/cited-artifact-part-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:12.78-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-artifact-status-type-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-artifact-status-type-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-artifact-status-type-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-artifact-status-type-cs-6-2-15</b></p><a name=\"hx1c-cited-artifact-status-type-cs-6-2-15\"> </a><a name=\"hchx1c-cited-artifact-status-type-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-cited-artifact-status-type.html\">CodeSystem Cited Artifact Status Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/cited-artifact-status-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:13.75-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-medium-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-medium-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-medium-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-medium-cs-6-2-15</b></p><a name=\"hx1c-cited-medium-cs-6-2-15\"> </a><a name=\"hchx1c-cited-medium-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-cited-medium.html\">CodeSystem Cited Medium</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:14-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/cited-medium"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:14.73-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-contributor-role-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-contributor-role-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-contributor-role-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-contributor-role-cs-6-2-15</b></p><a name=\"hx1c-contributor-role-cs-6-2-15\"> </a><a name=\"hchx1c-contributor-role-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-contributor-role.html\">CodeSystem Contributor Role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contributor-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:15.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-contributor-summary-source-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-contributor-summary-source-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-contributor-summary-source-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-contributor-summary-source-cs-6-2-15</b></p><a name=\"hx1c-contributor-summary-source-cs-6-2-15\"> </a><a name=\"hchx1c-contributor-summary-source-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-contributor-summary-source.html\">CodeSystem Contributor Summary Source</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:16-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contributor-summary-source"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:16.75-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-contributor-summary-style-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-contributor-summary-style-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-contributor-summary-style-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-contributor-summary-style-cs-6-2-15</b></p><a name=\"hx1c-contributor-summary-style-cs-6-2-15\"> </a><a name=\"hchx1c-contributor-summary-style-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-contributor-summary-style.html\">CodeSystem Contributor Summary Style</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contributor-summary-style"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:17.77-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-contributor-summary-type-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-contributor-summary-type-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-contributor-summary-type-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-contributor-summary-type-cs-6-2-15</b></p><a name=\"hx1c-contributor-summary-type-cs-6-2-15\"> </a><a name=\"hchx1c-contributor-summary-type-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-contributor-summary-type.html\">CodeSystem Contributor Summary Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contributor-summary-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:18.78-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-published-in-type-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-published-in-type-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-published-in-type-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-published-in-type-cs-6-2-15</b></p><a name=\"hx1c-published-in-type-cs-6-2-15\"> </a><a name=\"hchx1c-published-in-type-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-published-in-type.html\">CodeSystem Published In Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/published-in-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:19.78-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-statistic-model-code-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-statistic-model-code-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-statistic-model-code-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-statistic-model-code-cs-6-2-15</b></p><a name=\"hx1c-statistic-model-code-cs-6-2-15\"> </a><a name=\"hchx1c-statistic-model-code-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-statistic-model-code.html\">CodeSystem Statistic Model Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/statistic-model-code"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:20.84-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-title-type-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-title-type-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-title-type-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-title-type-cs-6-2-15</b></p><a name=\"hx1c-title-type-cs-6-2-15\"> </a><a name=\"hchx1c-title-type-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-title-type.html\">CodeSystem Title Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/title-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:21.85-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-variable-role-subtype-cs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-variable-role-subtype-cs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-variable-role-subtype-cs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-variable-role-subtype-cs-6-2-15</b></p><a name=\"hx1c-variable-role-subtype-cs-6-2-15\"> </a><a name=\"hchx1c-variable-role-subtype-cs-6-2-15\"> </a><p>Provenance for <a href=\"CodeSystem-variable-role-subtype.html\">CodeSystem EvidenceVariableRoleSubtype</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/variable-role-subtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:22.88-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-artifact-contribution-instance-type-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-artifact-contribution-instance-type-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-artifact-contribution-instance-type-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-artifact-contribution-instance-type-vs-6-2-15</b></p><a name=\"hx1c-artifact-contribution-instance-type-vs-6-2-15\"> </a><a name=\"hchx1c-artifact-contribution-instance-type-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-artifact-contribution-instance-type.html\">ValueSet Artifact Contribution Instance Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/artifact-contribution-instance-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:23.94-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-artifact-url-classifier-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-artifact-url-classifier-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-artifact-url-classifier-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-artifact-url-classifier-vs-6-2-15</b></p><a name=\"hx1c-artifact-url-classifier-vs-6-2-15\"> </a><a name=\"hchx1c-artifact-url-classifier-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-artifact-url-classifier.html\">ValueSet Artifact Url Classifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/artifact-url-classifier"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:25.05-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-certainty-type-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-certainty-type-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-certainty-type-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-certainty-type-vs-6-2-15</b></p><a name=\"hx1c-certainty-type-vs-6-2-15\"> </a><a name=\"hchx1c-certainty-type-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-certainty-type.html\">ValueSet Evidence Certainty Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/certainty-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:26.12-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-citation-artifact-classifier-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-citation-artifact-classifier-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-citation-artifact-classifier-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-citation-artifact-classifier-vs-6-2-15</b></p><a name=\"hx1c-citation-artifact-classifier-vs-6-2-15\"> </a><a name=\"hchx1c-citation-artifact-classifier-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-citation-artifact-classifier.html\">ValueSet Citation Artifact Classifier</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:27-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/citation-artifact-classifier"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:27.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-citation-classification-type-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-citation-classification-type-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-citation-classification-type-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-citation-classification-type-vs-6-2-15</b></p><a name=\"hx1c-citation-classification-type-vs-6-2-15\"> </a><a name=\"hchx1c-citation-classification-type-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-citation-classification-type.html\">ValueSet Citation Classification Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/citation-classification-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:28.46-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-citation-summary-style-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-citation-summary-style-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-citation-summary-style-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-citation-summary-style-vs-6-2-15</b></p><a name=\"hx1c-citation-summary-style-vs-6-2-15\"> </a><a name=\"hchx1c-citation-summary-style-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-citation-summary-style.html\">ValueSet Citation Summary Style</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/citation-summary-style"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:29.57-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-artifact-abstract-type-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-artifact-abstract-type-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-artifact-abstract-type-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-artifact-abstract-type-vs-6-2-15</b></p><a name=\"hx1c-cited-artifact-abstract-type-vs-6-2-15\"> </a><a name=\"hchx1c-cited-artifact-abstract-type-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-cited-artifact-abstract-type.html\">ValueSet Cited Artifact Abstract Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/cited-artifact-abstract-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:30.66-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-artifact-classification-type-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-artifact-classification-type-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-artifact-classification-type-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-artifact-classification-type-vs-6-2-15</b></p><a name=\"hx1c-cited-artifact-classification-type-vs-6-2-15\"> </a><a name=\"hchx1c-cited-artifact-classification-type-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-cited-artifact-classification-type.html\">ValueSet Cited Artifact Classification Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/cited-artifact-classification-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:31.79-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-artifact-contribution-type-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-artifact-contribution-type-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-artifact-contribution-type-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-artifact-contribution-type-vs-6-2-15</b></p><a name=\"hx1c-cited-artifact-contribution-type-vs-6-2-15\"> </a><a name=\"hchx1c-cited-artifact-contribution-type-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-cited-artifact-contribution-type.html\">ValueSet Cited Artifact Contribution Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/cited-artifact-contribution-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:32.97-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-artifact-part-type-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-artifact-part-type-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-artifact-part-type-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-artifact-part-type-vs-6-2-15</b></p><a name=\"hx1c-cited-artifact-part-type-vs-6-2-15\"> </a><a name=\"hchx1c-cited-artifact-part-type-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-cited-artifact-part-type.html\">ValueSet Cited Artifact Part Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/cited-artifact-part-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:34.09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-artifact-status-type-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-artifact-status-type-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-artifact-status-type-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-artifact-status-type-vs-6-2-15</b></p><a name=\"hx1c-cited-artifact-status-type-vs-6-2-15\"> </a><a name=\"hchx1c-cited-artifact-status-type-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-cited-artifact-status-type.html\">ValueSet Cited Artifact Status Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/cited-artifact-status-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:35.22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-cited-medium-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-cited-medium-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-cited-medium-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-cited-medium-vs-6-2-15</b></p><a name=\"hx1c-cited-medium-vs-6-2-15\"> </a><a name=\"hchx1c-cited-medium-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-cited-medium.html\">ValueSet Cited Medium</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/cited-medium"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:36.33-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-contributor-role-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-contributor-role-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-contributor-role-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-contributor-role-vs-6-2-15</b></p><a name=\"hx1c-contributor-role-vs-6-2-15\"> </a><a name=\"hchx1c-contributor-role-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-contributor-role.html\">ValueSet Contributor Role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contributor-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:37.59-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-contributor-summary-source-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-contributor-summary-source-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-contributor-summary-source-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-contributor-summary-source-vs-6-2-15</b></p><a name=\"hx1c-contributor-summary-source-vs-6-2-15\"> </a><a name=\"hchx1c-contributor-summary-source-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-contributor-summary-source.html\">ValueSet Contributor Summary Source</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contributor-summary-source"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:38.67-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-contributor-summary-style-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-contributor-summary-style-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-contributor-summary-style-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-contributor-summary-style-vs-6-2-15</b></p><a name=\"hx1c-contributor-summary-style-vs-6-2-15\"> </a><a name=\"hchx1c-contributor-summary-style-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-contributor-summary-style.html\">ValueSet Contributor Summary Style</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contributor-summary-style"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:39.81-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-contributor-summary-type-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-contributor-summary-type-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-contributor-summary-type-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-contributor-summary-type-vs-6-2-15</b></p><a name=\"hx1c-contributor-summary-type-vs-6-2-15\"> </a><a name=\"hchx1c-contributor-summary-type-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-contributor-summary-type.html\">ValueSet Contributor Summary Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contributor-summary-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:40.87-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-published-in-type-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-published-in-type-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-published-in-type-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-published-in-type-vs-6-2-15</b></p><a name=\"hx1c-published-in-type-vs-6-2-15\"> </a><a name=\"hchx1c-published-in-type-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-published-in-type.html\">ValueSet Published In Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:42-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/published-in-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:42.13-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-statistic-model-code-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-statistic-model-code-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-statistic-model-code-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-statistic-model-code-vs-6-2-15</b></p><a name=\"hx1c-statistic-model-code-vs-6-2-15\"> </a><a name=\"hchx1c-statistic-model-code-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-statistic-model-code.html\">ValueSet Statistic Model Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/statistic-model-code"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:43.38-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-title-type-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-title-type-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-title-type-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-title-type-vs-6-2-15</b></p><a name=\"hx1c-title-type-vs-6-2-15\"> </a><a name=\"hchx1c-title-type-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-title-type.html\">ValueSet Title Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/title-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:44.56-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-variable-role-subtype-vs-6-2-15",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-variable-role-subtype-vs-6-2-15",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-variable-role-subtype-vs-6-2-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-variable-role-subtype-vs-6-2-15</b></p><a name=\"hx1c-variable-role-subtype-vs-6-2-15\"> </a><a name=\"hchx1c-variable-role-subtype-vs-6-2-15\"> </a><p>Provenance for <a href=\"ValueSet-variable-role-subtype.html\">ValueSet EvidenceVariableRoleSubtype</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-03-15</td></tr><tr><td>Recorded</td><td>2025-03-15 12:28:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joanne Dehnbostel</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/variable-role-subtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-03-15"
        },
        "recorded" : "2025-03-15T12:28:45.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Move terminologies from FHIR to THO for EBMonFHIR Resources; up-633"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joanne Dehnbostel"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-immunization-recommendation-status-cs-5-2-16",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-immunization-recommendation-status-cs-5-2-16",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-immunization-recommendation-status-cs-5-2-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-immunization-recommendation-status-cs-5-2-16</b></p><a name=\"hx1c-immunization-recommendation-status-cs-5-2-16\"> </a><a name=\"hchx1c-immunization-recommendation-status-cs-5-2-16\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-recommendation-status.html\">CodeSystem Immunization Recommendation Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-04-22</td></tr><tr><td>Recorded</td><td>2025-04-22 09:45:06-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Rosemary Hofstede</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Public Health</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-recommendation-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-04-22"
        },
        "recorded" : "2025-04-22T09:45:06.27-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "The narrative definition of the code complete is not consistent with the usage in immunizationRecommendation.; up-580"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Rosemary Hofstede"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Public Health"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-UniProt-ns-6-2-17",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-UniProt-ns-6-2-17",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-UniProt-ns-6-2-17\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-UniProt-ns-6-2-17</b></p><a name=\"hx1c-UniProt-ns-6-2-17\"> </a><a name=\"hchx1c-UniProt-ns-6-2-17\"> </a><p>Provenance for <a href=\"NamingSystem-UniProt.html\">NamingSystem Universal Protein Resource</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-04-26</td></tr><tr><td>Recorded</td><td>2025-04-26 11:43:02-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/UniProt"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-04-26"
        },
        "recorded" : "2025-04-26T11:43:02.39-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add UniProt Identifier System per TSMG; up-664"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-ICHContextOfUse-ns-6-2-18",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-ICHContextOfUse-ns-6-2-18",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-ICHContextOfUse-ns-6-2-18\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-ICHContextOfUse-ns-6-2-18</b></p><a name=\"hx1c-ICHContextOfUse-ns-6-2-18\"> </a><a name=\"hchx1c-ICHContextOfUse-ns-6-2-18\"> </a><p>Provenance for <a href=\"NamingSystem-ICHContextOfUse.html\">NamingSystem ICH Context of Use</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-04-26</td></tr><tr><td>Recorded</td><td>2025-04-26 11:49:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/ICHContextOfUse"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-04-26"
        },
        "recorded" : "2025-04-26T11:49:45.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add ICH Context of Use per TSMG; up-663"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-yes-no-unknown-not-applicable-vs-6-2-19",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-yes-no-unknown-not-applicable-vs-6-2-19",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-yes-no-unknown-not-applicable-vs-6-2-19\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-yes-no-unknown-not-applicable-vs-6-2-19</b></p><a name=\"hx1c-yes-no-unknown-not-applicable-vs-6-2-19\"> </a><a name=\"hchx1c-yes-no-unknown-not-applicable-vs-6-2-19\"> </a><p>Provenance for <a href=\"ValueSet-yes-no-unknown-not-applicable.html\">ValueSet Yes No Unknown NotApplicable</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-04-26</td></tr><tr><td>Recorded</td><td>2025-04-26 20:13:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/yes-no-unknown-not-applicable"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-04-26"
        },
        "recorded" : "2025-04-26T20:13:54.78-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create a THO Valueset for Y/N/NA/UNK; up-642"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-plan-definition-type-cs-5-2-20",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-plan-definition-type-cs-5-2-20",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-plan-definition-type-cs-5-2-20\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-plan-definition-type-cs-5-2-20</b></p><a name=\"hx1c-plan-definition-type-cs-5-2-20\"> </a><a name=\"hchx1c-plan-definition-type-cs-5-2-20\"> </a><p>Provenance for <a href=\"CodeSystem-plan-definition-type.html\">CodeSystem PlanDefinitionType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-04-26</td></tr><tr><td>Recorded</td><td>2025-04-26 20:18:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bryn Rhodes</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CDS</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/plan-definition-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-04-26"
        },
        "recorded" : "2025-04-26T20:18:15.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add protocol to PlanDefinitionType; up-655"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bryn Rhodes"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CDS"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-CMSPlaceofServiceCodes-cs-5-2-21",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-CMSPlaceofServiceCodes-cs-5-2-21",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-CMSPlaceofServiceCodes-cs-5-2-21\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-CMSPlaceofServiceCodes-cs-5-2-21</b></p><a name=\"hx1c-CMSPlaceofServiceCodes-cs-5-2-21\"> </a><a name=\"hchx1c-CMSPlaceofServiceCodes-cs-5-2-21\"> </a><p>Provenance for <a href=\"CodeSystem-CMSPlaceofServiceCodes.html\">CodeSystem CMS Place of Service Codes (POS)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-04-26</td></tr><tr><td>Recorded</td><td>2025-04-26 20:25:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/CMSPlaceofServiceCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-04-26"
        },
        "recorded" : "2025-04-26T20:25:45.84-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Create a convenience copy of the CMS POS code system; up-590"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-fhir-clinical-doc-information-recipient-vs-6-3-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-fhir-clinical-doc-information-recipient-vs-6-3-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-fhir-clinical-doc-information-recipient-vs-6-3-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-fhir-clinical-doc-information-recipient-vs-6-3-1</b></p><a name=\"hx1c-fhir-clinical-doc-information-recipient-vs-6-3-1\"> </a><a name=\"hchx1c-fhir-clinical-doc-information-recipient-vs-6-3-1\"> </a><p>Provenance for <a href=\"ValueSet-fhir-clinical-doc-information-recipient.html\">ValueSet FHIR Clinical Document Information Recipients Participant Types</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-05-07</td></tr><tr><td>Recorded</td><td>2025-05-07 00:13:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bret Heale</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/fhir-clinical-doc-information-recipient"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-05-07"
        },
        "recorded" : "2025-05-07T00:13:25.16-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Valuesets for FHIR Clinical Documents; up-665"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bret Heale"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1c-fhir-clinical-doc-participant-vs-6-3-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1c-fhir-clinical-doc-participant-vs-6-3-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1c-fhir-clinical-doc-participant-vs-6-3-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1c-fhir-clinical-doc-participant-vs-6-3-1</b></p><a name=\"hx1c-fhir-clinical-doc-participant-vs-6-3-1\"> </a><a name=\"hchx1c-fhir-clinical-doc-participant-vs-6-3-1\"> </a><p>Provenance for <a href=\"ValueSet-fhir-clinical-doc-participant.html\">ValueSet FHIR Clinical Document Participant Types Value set</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2025-05-07</td></tr><tr><td>Recorded</td><td>2025-05-07 00:13:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Bret Heale</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/fhir-clinical-doc-participant"
          }
        ],
        "occurredPeriod" : {
          "end" : "2025-05-07"
        },
        "recorded" : "2025-05-07T00:13:35.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Valuesets for FHIR Clinical Documents; up-665"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Bret Heale"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    }
  ]
}

```
