# HL7 Terminology Home Page - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* **HL7 Terminology Home Page**

## HL7 Terminology Home Page

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ImplementationGuide/hl7.terminology | *Version*:7.0.1 |
| Active as of 2026-01-26 | *Computable Name*:HL7Terminology |

### Introduction

 This is the main entry page for access to the HL7 Terminology. This material comprises the Code Systems and Value Sets which are cited in HL7 Published artifacts (International Standards and Implemenation Guides) in a convenient browsable form. 

 As part of the HL7 approach to provide unified governance, and support consistent access to the terminology and vocabulary that has been published for many years, all of the published Code Systems and Value Sets across all of the main HL7 Product families is intended to be accessible on these pages. This includes Version 2, Version 3, CDA (base only), and FHIR. Note that the full unification of all of the terminology content of HL7 Code Systems will be an ongoing effort. Included here are also the Concept Domains and Tables, as well as Concept Maps and Naming Systems defined and published by HL7. There is an option to download the terminology along with additional components, and background information. Users may browse and download the HL7 terminology on these pages. 

#### Using This Content Layout

 The black bar on the top of the pages is the primary navigation tool. Selecting any of the named items from that bar will navigate to a page with that content on it. Each page is in a similar format for easy access to the content. Each of these pages has a selection of tabs on the page which group the content in ways that are convenient for access. 

1. **All Code Systems**lists all of the code systems published on these pages.
1. **CDA**lists the code systems (all from V3) that are used in the CDA Base Standard.
1. **FHIR**lists the code systems references by FHIR standards that are rooted at terminology.hl7.org
1. **V2**lists the code systems underlying the Version 2 Tables that list codes.
1. **V3**lists the code systems published in the Version 3 Standards (traditionally in the coremif).
1. **Unified**lists the code systems which are used across all of the HL7 Product Families, and whose coded content has been unified across all uses.
1. **External**lists the code systems which are published by organizations outside of HL7 but are referenced by, and identified in, HL7 Published Stanards.
1. **Retired**lists the code systems which were published by HL7 some time in the past, but are no longer published and have been retired from use.

### Licensing

 This THO content is made available under the CC0 designation. For more information see the [THO licensing details](license.md) page. 

### Identificaton of Versions

 The HL7 Terminology releases carry a 3-part release version identifier, in the format of Major.Minor.Build (similar to the commonly used semantic versioning scheme). For the HL7 Terminology releases, the Major number indicates a new major release, and will be updated occasionally when significant new content is added or there are substantial layout and formatting changes, or changes are being released which MAY break some backward compatibility. Upon a new major release, the Major number will be incrementd by one, and the Minor number and Build number will both be reset to zero. 

The Minor number indicates a snapshot of the current build (ci build) that has been taken and released. These releases will have internal conistency, and will consist of one to many approved changes to the HL7 terminology content. These releases will occur relatively frequently, and will be done to support various HL7 needs, and respond to requests of the HL7 community for access to changed content. Occasionally a minor release may coincide with other HL7 Standards releases for synchronization purposes. The Build number will be reset to zero on a new minor release. 

 The Build number for published releases will almost always remain at zero, unless there is some highly exceptional circumstance. This number however is incremented on the HL7 Terminology ci build page (link to 'current' in the Published Releases list), and will be incremented with every new implementation of UTG changes and subsequent rebuild of the continuous integration environment, and thus is important primarily on the continuous build pages, and helps to indicate the number of completed UTG tickets since the last published release. 

### Changes and Enhancements to the HL7 Terminology

 In order to request changes to the content on these pages, and to participate in the process, please see the information for participation and sign-up on the [HL7 Vocabulary Maintenance](https://confluence.hl7.org/display/VMAH/Vocabulary+Maintenance+at+HL7) pages. 



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.terminology",
  "url" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
  "version" : "7.0.1",
  "name" : "HL7Terminology",
  "title" : "HL7 Terminology (THO)",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "HL7 International - Vocabulary Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/Special/committees/vocab"
        }
      ]
    }
  ],
  "description" : "Defines and exposes all HL7 terminologies managed through the unified terminology governance process",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "packageId" : "hl7.terminology",
  "license" : "CC0-1.0",
  "fhirVersion" : ["5.0.0"],
  "dependsOn" : [
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r5",
      "version" : "5.2.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r5#0.9.0"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-mif-assocConceptProp"
        },
        "name" : "MIF Associated concept property",
        "description" : "Concept Properties that are associated with this Code System or Value Set Version"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-mif-relationship-isNavigable"
        },
        "name" : "MIF concept relationship is navigable",
        "description" : "Indicates whether the relationship is intended to be navigated when selecting a code"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-mif-relationship-reflexivity"
        },
        "name" : "MIF concept relationship is reflexivity",
        "description" : "Indicates if the association always holds for a concept with itself (refexive), never holds for a concept with itself (irreflexive)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-mif-relationship-inverseName"
        },
        "name" : "MIF concept relationship inverse name",
        "description" : "Identifies the name of the relationship that references the inverse of the current relationship.  Allows linking a relationship and its derived inverse."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-mif-relationship-relationshipKind"
        },
        "name" : "MIF concept relationship kind",
        "description" : "Identifies a type of relationship between codes that is supported by this code system version"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-mif-relationship-symmetry"
        },
        "name" : "MIF concept relationship symmetry",
        "description" : "Indicates if the relationship always holds in the reverse direction as well (symetric), never holds in the reverse direction as well (antisymetric)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-mif-relationship-transitivity"
        },
        "name" : "MIF concept relationship transitivity",
        "description" : "Indicates whether the relationship always (transitive) or never (antitransitive) propagates such that if the association exists from A to B and from B to C that the relationship can be inferred to exist from A to C"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-namingsystem-title"
        },
        "name" : "NamingSystem title",
        "description" : "The human-readable descriptive name for the code or identifier system"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-namingsystem-version"
        },
        "name" : "NamingSystem version",
        "description" : "The business version associated with the Naming System"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/allHL7-Rendering"
        },
        "name" : "All HL7 Content Rendering Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/cda-Rendering"
        },
        "name" : "CDA Rendering Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/deprCSVS-Rendering"
        },
        "name" : "Deprecated Code Systems Rendering Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/fhir-Normative"
        },
        "name" : "FHIR Normative Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/fhir-Rendering"
        },
        "name" : "FHIR Rendering Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/identifiers-Rendering"
        },
        "name" : "Identifier Systems Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/pendingCS-Rendering"
        },
        "name" : "Pending Code Systems Rendering Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/retired-Rendering"
        },
        "name" : "Retired Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/retired-ext-cs-fragment-Rendering"
        },
        "name" : "Retired Code System Fragment Rendering Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/retired-techids-Rendering"
        },
        "name" : "Retired Code System Identification Records Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/unified-Rendering"
        },
        "name" : "Unified Rendering Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/v2-Publishing"
        },
        "name" : "V2 Publishing Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/v2-rendering"
        },
        "name" : "V2 Rendering Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/v3-Publishing"
        },
        "name" : "V3 Publishing Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "List"
          }
        ],
        "reference" : {
          "reference" : "List/v3-rendering"
        },
        "name" : "V3 Rendering Manifest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ADAToothSurfaceCodes"
        },
        "name" : "ADA Tooth Surface Codes",
        "description" : "Tooth Surface Codes are defined by the HIPAA standard electronic dental claim transaction (837D v5010) and the ADA Dental Claim Form.   Surface codes can be used in a variety of combinations to define a multi-surface procedure (ie. MOD for a singular intervention which covers Mesial, Occlusal, and Distal surfaces).   Tooth Surface Codes can be accessed through the [ADA Guide to Dental Procedures Reported with Area of the Oral Cavity or Tooth Anatomy (or Both).](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/final_areaoftheoralcavityandtoothanatomy.pdf?rev=fbd215c7d8c546aa967443e79f9d8e20&hash=2F759947EFD75EF5ABCCBF0F62CE1FE7)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ADAUniversalToothDesignationSystem"
        },
        "name" : "ADA Universal Tooth Designation System",
        "description" : "The American Dental Association (ADA) accepted the Universal/National Tooth Designation System and the ISO/ANSI/ADA Specification No. 3950 for Designation System for Teeth and Areas of the Oral Cavity as the human tooth and oral cavity enumeration schemas in 1994.\r\n\r\nThe universal tooth designation or numbering system is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America.\r\n\r\nTeeth are numbered 1-32, starting with the third molar (1) on the right side of the upper arch, following around the arch to the third molar (16) on the left side, and descending to the lower third molar (17) on the left side, and following that arch to the terminus of the lower jaw, the lower right third molar (32).\r\n\r\nSupernumerary teeth are identified by the numbers 51 through 82, beginning with the area of the upper right third molar, following around the upper arch and continuing on the lower arch to the area of the lower right third molar (e.g., supernumerary #51 is adjacent to the upper right molar #1; supernumerary #82 is adjacent to the lower right third molar #32).\r\n\r\nThe Universal Numbering System can be found in the ADA Dental Claim Form. For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. \r\n\r\nA Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/CMSPlaceofServiceCodes"
        },
        "name" : "CMS Place of Service Codes (POS)",
        "description" : "Place of Service Codes are two-digit codes placed on health care professional claims to indicate the setting in which a service was provided. The Centers for Medicare & Medicaid Services (CMS) maintain POS codes used throughout the health care industry.\r\n\r\nThis code set is required for use in the implementation guide adopted as the national standard for electronic transmission of professional health care claims under the provisions of the Health Insurance Portability and Accountability Act of 1996 (HIPAA). HIPAA directed the Secretary of HHS to adopt national standards for electronic transactions. These standard transactions require all health plans and providers to use standard code sets to populate data elements in each transaction. The Transaction and Code Set Rule adopted the ASC X12N-837 Health Care Claim: Professional, volumes 1 and 2, as the standard for electronic submission of professional claims. This standard names the POS code set currently maintained by CMS as the code set to be used for describing sites of service in such claims. POS information is often needed to determine the acceptability of direct billing of Medicare, Medicaid and private insurance services provided by a given provider."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ILRSpeakingSkillScale"
        },
        "name" : "Interagency Language Roundtable Speaking Skill Scale",
        "description" : "The following Interagency Language Roundtable (ILR) Skill Level Descriptions (SLDs) describe proficiency as the functional ability to produce spoken language that reflects current usage. The SLDs characterize proficiency ranging from no communicative ability to mastery. They constitute an ordinal scale that includes six ranked base levels from 0 to 5. They illustrate, but do not exhaustively characterize, the proficiency a person may demonstrate at a given level on the scale.\r\n\r\nControl of a base level (Levels 1, 2, 3, 4, and 5) typically implies control of the previous levels' aspects. A higher level of performance in one aspect does not justify a higher general proficiency rating. Level 5 includes the features of all levels. Still, as with all levels, Level 5 is a range and performance will vary.\r\n\r\nThere are plus levels for levels 0 through 4. Plus levels describe proficiency that substantially exceeds one base level and does not fully meet the criteria of the next base level. To merit a plus level, the demonstrated proficiency must match the plus level description and not be merely a strong performance at the base level.\r\n\r\nThe SLDs describe four aspects of language proficiency: functional ability (color coded green), precision of forms and meanings (red), content meaningfulness (black), and contextual appropriateness (blue). Functional ability refers to the communicative acts or tasks that an individual can accomplish. There are no functional abilities specific to the plus levels. Precision of forms and meanings refers to accuracy, range, and complexity. Content meaningfulness refers to the relevance and substantive coverage of topics. Contextual appropriateness refers to register, acceptability, and appropriateness of language for the intended audience.\r\n\r\nThe SLDs are presented in an official prose version as well as a supplementary crosswalk matrix. Each level description begins with a bolded main statement that summarizes the features of that level. Color coded supporting statements follow the main statement and describe the four aspects in detail. The crosswalk matrix shows the structure of the SLDs explicitly across the four skills.\r\n\r\nFor more information, including the source content, please see [https://www.govtilr.org/Skills/Speaking.htm](https://www.govtilr.org/Skills/Speaking.htm)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/presentOnAdmission"
        },
        "name" : "CMS Present on Admission (POA) Indicator",
        "description" : "This code system consists of Present on Admission (POA) indicators which are assigned to the principal and secondary diagnoses (as defined in Section II of the Official Guidelines for Coding and Reporting) and the external cause of injury codes to indicate the presence or absence of the diagnosis at the time of inpatient admission."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ADAAreaOralCavitySystem"
        },
        "name" : "American Dental Association Area of Oral Cavity System",
        "description" : "The Area of Oral Cavity System is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America.\r\n\r\nArea of the oral cavity is designated by a two-digit code.\r\n\r\nThe Area of Oral Cavity System can be found in the ADA Comprehensive ADA Dental Claim Form Completion Instructions (see https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf). For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. \r\n\r\nA Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ADAToothSurfaceCodes"
        },
        "name" : "American Dental Association Tooth Surface Codes",
        "description" : "Tooth Surface Codes are defined by the HIPAA standard electronic dental claim transaction (837D v5010) and the ADA Dental Claim Form.   Surface codes can be used in a variety of combinations to define a multi-surface procedure (ie. MOD for a singular intervention which covers Mesial, Occlusal, and Distal surfaces).   Tooth Surface Codes can be accessed through the [ADA Guide to Dental Procedures Reported with Area of the Oral Cavity or Tooth Anatomy (or Both).](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/final_areaoftheoralcavityandtoothanatomy.pdf?rev=fbd215c7d8c546aa967443e79f9d8e20&hash=2F759947EFD75EF5ABCCBF0F62CE1FE7). \r\n\r\nA Statement of Understanding (SOU) between ADA and HL7 exists [here](http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ADAUniversalToothDesignationSystem"
        },
        "name" : "ADA Universal Tooth Designation System",
        "description" : "The American Dental Association (ADA) accepted the Universal/National Tooth Designation System and the ISO/ANSI/ADA Specification No. 3950 for Designation System for Teeth and Areas of the Oral Cavity as the human tooth and oral cavity enumeration schemas in 1994.\r\n\r\nThe universal tooth designation or numbering system is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America.\r\n\r\nTeeth are numbered 1-32, starting with the third molar (1) on the right side of the upper arch, following around the arch to the third molar (16) on the left side, and descending to the lower third molar (17) on the left side, and following that arch to the terminus of the lower jaw, the lower right third molar (32).\r\n\r\nSupernumerary teeth are identified by the numbers 51 through 82, beginning with the area of the upper right third molar, following around the upper arch and continuing on the lower arch to the area of the lower right third molar (e.g., supernumerary #51 is adjacent to the upper right molar #1; supernumerary #82 is adjacent to the lower right third molar #32).\r\n\r\nThe Universal Numbering System can be found in the ADA Dental Claim Form. For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. \r\n\r\nA Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AHANUBCConditionCodes"
        },
        "name" : "AHA NUBC Condition Codes",
        "description" : "\"The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified.\"\r\n\r\nThis code system consists of the following:\r\n\r\n\\* FL 18-28 Condition Codes\r\n\r\nThese codes are used to convey the applicable Condition Codes and are the property of the American Hospital Association.\r\n\r\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\r\n\r\nStatement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.\r\n\r\n\"The UB-04 Manual has a 12-month subscription period from June 30 through July 1.\"\r\n\r\nNational Uniform Billing Committee Data Element Specifications Change Request Guidelines\r\n\r\n\"The National Uniform Billing Committee (NUBC) holds meetings and conference calls throughout the year and change requests to the UB-04 Manual or UB-04 Data Set may be submitted at any time. To be considered at the next scheduled meeting, requests for changes must be received by the NUBC Secretary at least 45 days in advance. Approved changes are usually effective as of July 1 or about 90 days after approval, as appropriate.\"\r\n\r\nFor more information and to submit a change request, please see [here](https://www.nubc.org/form/change-request-guidelines-form-n)\r\n\r\nFor frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AHANUBCPatientDischargeStatus"
        },
        "name" : "AHA NUBC Patient Discharge Status Codes",
        "description" : "\"The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified.\"\r\n\r\nThis code system consists of the following:\r\n\r\n\\* FL 17 - Patient Discharge Status\r\n\r\nThese codes are used to convey the patient discharge status and are the property of the American Hospital Association.\r\n\r\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\r\n\r\nStatement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.\r\n\r\n\"The UB-04 Manual has a 12-month subscription period from June 30 through July 1.\"\r\n\r\nFor frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AHANUBCPointOfOriginNewborn"
        },
        "name" : "AHA NUBC Point of Origin for Newborn",
        "description" : "\"The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified.\"\r\n\r\nThis code system consists of the following:\r\n\r\n\\* FL 15 - Point of Origin for Admission or Visit for Newborn\r\n\r\nThese codes are used to convey the patient point of origin for an admission or visit and are the property of the American Hospital Association.\r\n\r\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\r\n\r\nStatement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.\r\n\r\n\"The UB-04 Manual has a 12-month subscription period from June 30 through July 1.\"\r\n\r\nFor frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AHANUBCPointOfOriginNonnewborn"
        },
        "name" : "AHA NUBC Point of Origin for Non-newborn",
        "description" : "\"The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified.\"\r\n\r\nThis code system consists of the following:\r\n\r\n\\* FL 15 - Point of Origin for Admission or Visit for Non-newborn\r\n\r\nThese codes are used to convey the patient point of origin for an admission or visit and are the property of the American Hospital Association.\r\n\r\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\r\n\r\nStatement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.\r\n\r\n\"The UB-04 Manual has a 12-month subscription period from June 30 through July 1.\"\r\n\r\nFor frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AHANUBCPriorityTypeOfAdmitOrVisit"
        },
        "name" : "AHA NUBC Priority (Type) of Admission or Visit",
        "description" : "\"The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified.\"\r\n\r\nThis code system consists of the following:\r\n\r\n\\* FL 14 - Priority (Type) of Admission or Visit\r\n\r\nThese codes are used to convey the priority of an admission or visit and are the property of the American Hospital Association.\r\n\r\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\r\n\r\nStatement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.\r\n\r\n\"The UB-04 Manual has a 12-month subscription period from June 30 through July 1.\"\r\n\r\nFor frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AHANUBCRevenueCodes"
        },
        "name" : "AHA NUBC Revenue Codes",
        "description" : "\"The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified.\"\r\n\r\nThis code system consists of the following:\r\n\r\n\\* FL 42 - Revenue Codes\r\n\r\nThese codes are used to convey the revenue code and are the property of the American Hospital Association.\r\n\r\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\r\n\r\nStatement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.\r\n\r\n\"The UB-04 Manual has a 12-month subscription period from June 30 through July 1.\"\r\n\r\nFor frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AHANUBCTypeOfBill"
        },
        "name" : "AHA NUBC Type Of Bill Codes",
        "description" : "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified.\r\n\r\nThis code system consists of the following:\r\n\r\n \\* FL 04 - Type of Bill Facility Codes\r\n\r\n \\* FL 04 - Type of Bill Frequency Codes\r\n\r\nA code indicating the specific Type of Bill (TOB), e.g., hospital inpatient, outpatient, replacements, voids, etc. The first digit is a leading zero*. The fourth digit defines the frequency of the bill for the institutional and electronic professional claim.\r\n\r\nNote that with the advent of UB-04, the matrix methodology of constructing the first component of TOB codes according to digit position was abandoned in favor of specifying valid discrete codes. As a result, the first three digits in TOB have no underlying meaning.\r\n\r\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\r\n\r\nThe UB-04 Manual has a 12-month subscription period from June 30 through July 1."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AHANUBCValueCodesAndAmounts"
        },
        "name" : "AHA NUBC Value Codes and Amounts",
        "description" : "\"The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified.\"\r\n\r\nThis code system consists of the following:\r\n\r\n\\* FL 39-41 Value Codes and Amounts\r\n\r\nThese codes are used to convey the applicable Value Codes and Amounts and are the property of the American Hospital Association.\r\n\r\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\r\n\r\nStatement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.\r\n\r\n\"The UB-04 Manual has a 12-month subscription period from June 30 through July 1.\"\r\n\r\nNational Uniform Billing Committee Data Element Specifications Change Request Guidelines\r\n\r\n\"The National Uniform Billing Committee (NUBC) holds meetings and conference calls throughout the year and change requests to the UB-04 Manual or UB-04 Data Set may be submitted at any time. To be considered at the next scheduled meeting, requests for changes must be received by the NUBC Secretary at least 45 days in advance. Approved changes are usually effective as of July 1 or about 90 days after approval, as appropriate.\"\r\n\r\nFor more information and to submit a change request, please see [here](https://www.nubc.org/form/change-request-guidelines-form-n)\r\n\r\nFor frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/apdrg"
        },
        "name" : "All Patient Diagnosis Related Groups (AP DRGs)",
        "description" : "In 1987, the state of New York passed legislation instituting a DRG-based prospective payment system for all non-Medicare patients. The legislation included a requirement that the New York State Department of Health (NYDH) evaluate the applicability of the DRGs to a non-Medicare population. In particular, the legislation required that the DRGs be evaluated with respect to neonates and patients with Human Immunodeficiency Virus (HIV) infections. NYDH entered into an agreement with 3M HIS to assist with the evaluation of the need for DRG modifications as well as to make the necessary changes in the DRG definitions and software. The DRG definitions developed by NYDH and 3M HIS are referred to as the All Patient DRGs (AP DRGs)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/APRDRG"
        },
        "name" : "All Patient Refined Diagnosis Related Groups (APR DRGs)",
        "description" : "3M APR DRGs have become the standard across the U.S. for classifying hospital inpatients in non-Medicare populations. As of January 2019, 27 state Medicaid programs use 3M APR DRGs to pay hospitals, as do approximately a dozen commercial payers and Medicaid managed care organizations. Over 2,400 hospitals have licensed 3M APR DRGs to verify payment and analyze their internal operations.\r\n\r\nThe 3M APR DRG methodology classifies hospital inpatients according to their reason for admission, severity of illness and risk of mortality.\r\n\r\nEach year 3M calculates and releases a set of statistics for each 3M APR DRG based on our analysis of large national data sets. These statistics include a relative weight for each 3M APR DRG. The relative weight reflects the average hospital resource use for a patient in that 3M APR DRG relative to the average hospital resource use of all inpatients. Please note that payers and other users of the 3M APR DRG methodology are responsible for ensuring that they use relative weights that are appropriate for their particular populations. The 3M APR DRG statistics also include data for each 3M APR DRG on relative frequency, average length of stay, average charges and incidence of mortality.\r\n\r\n3M APR DRGs can be rolled up into broader categories. The 326 base DRGs roll up into 25 major diagnostic categories (MDCs) plus a pre-MDC category. An example is MDC 04, Diseases and Disorders of the Respiratory System. As well, each 3M APR DRG is assigned to a service line that is consistent with the outpatient service lines that are defined by the 3M™  Enhanced Ambulatory Patient Groups (EAPGs)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AlabamaDLN"
        },
        "name" : "Alabama Driver's License",
        "description" : "Alabama Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AlaskaDLN"
        },
        "name" : "Alaska Driver's License",
        "description" : "Alaska Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ArizonaDLN"
        },
        "name" : "Arizona Driver's License",
        "description" : "Arizona Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ArkansasDLN"
        },
        "name" : "Arkansas Driver's License",
        "description" : "Arkansas Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CAPeCC"
        },
        "name" : "College of American Pathologists (CAP) eCC (electronic Cancer Checklists)",
        "description" : "\"The College of American Pathologists (CAP) eCC (electronic Cancer Checklists) enables pathologists to use the [CAP Cancer Protocols](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocols) directly within their laboratory information system (LIS) workflow and to ensure that each report is completed with the necessary required elements. Most anatomic pathology (AP)-LIS vendors offer a CAP eCC synoptic module for reporting on surgical cancer resections and selected biopsies.\"\r\n\r\n\"The CAP eCC is based on the [CAP Cancer Protocols](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocols) and is produced under the guidance of the [CAP Pathology Electronic Reporting (PERT) Committee](https://www.cap.org/member-resources/councils-committees/pathology-electronic-reporting-pert-committee) along with close interaction and advisement of the [Cancer Committee](https://www.cap.org/member-resources/councils-committees/cancer-committee).\r\n\r\nThe eCC is developed in collaboration with and partially underwritten by the Centers for Disease Control and Prevention (CDC). Additional collaborators include the American Joint Committee on Cancer (AJCC), Cancer Care Ontario (CCO), and the North American Association of Central Cancer Registries (NAACCR).\r\n\r\nThe CAP currently is working with the [California Cancer Registry (CCR)](http://www.ccrcal.org/) to offer the benefits of the eCC to California laboratories. CCR and the CAP are seeking out laboratories interested in participating in an ongoing project using the eCC to directly transfer cancer data to the central registry.\"\r\n\r\n\"The CAP releases eCC templates on a rolling basis, coordinating as much as possible with the posting of new and revised [Cancer Protocols and Cancer Biomarker Reporting Templates](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocol-templates). A few weeks prior to each Major or Agile release, email notifications are sent out to all licensed CAP eCC users.\" For more information, see page [here](https://www.cap.org/laboratory-improvement/proficiency-testing/cap-ecc)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CCDD"
        },
        "name" : "Canadian Clinical Drug Data Set",
        "description" : "The Canadian Clinical Drug Data Set provides codes for identification and a consistent approach to naming of medications and some medical devices in Canada. It has been designed and developed to reflect current clinical practice and safety advice and is freely available for use in digital health solutions and design applications. CCDD is available in English and Canadian French.\r\n\r\nTo request content changes, send an email to [clinicaldrug@infoway-inforoute.ca](mailto:clinicaldrug@infoway-inforoute.ca).\r\n\r\nCanada Health Infoway has developed a FHIR representation of CCDD, which can be viewed at: [https://ontoserver.csiro.au/shrimp/launch.html?iss=https://terminologystandardsservice.ca/fhir](https://ontoserver.csiro.au/shrimp/launch.html?iss=https://terminologystandardsservice.ca/fhir)\r\n\r\nThe CCDD FHIR representation contains supplemental property codes, as defined in the Health Canada Drug Product Database (DPD), managed by Health Canada, as follows:\r\n\r\n- Anatomical Therapeutical Chemical (ATC): The purpose of the ATC classification system is to be used as a tool for drug utilization research to improve the quality of drug use.\r\n\r\n- Biosimilar: Identifies biosimilar products.\r\n\r\n- Pediatric: Identifies pediatric products.\r\n\r\n- Schedule: Each drug is assigned one or more schedules according to the Food and Drug Regulations and the Controlled Drugs and Substances Act.\r\n\r\nFurther information on the supplemental properties may be obtained by reviewing the information at [https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database.html](https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database.html) or by emailing [pharma_drug_enquiries-renseignements_medicaments_pharma@hc-sc.gc.ca](mailto:pharma_drug_enquiries-renseignements_medicaments_pharma@hc-sc.gc.ca)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CCN"
        },
        "name" : "CMS Certification Numbers",
        "description" : "Per CMS Transmittal 29 dated OCTOBER 12, 2007:\r\n\r\n\"The National Provider Identifier (NPI) will replace the Medicare/Medicaid Provider Number on Medicare claims. The NPI will assume the Medicare/Medicaid Provider Number's role as a primary identifier. However, the Medicare/Medicaid Provider Number will continue to be issued to providers and used to verify Medicare/Medicaid certification on all survey and certification, and resident/patient assessment transactions. In order to avoid confusion with the NPI, the Medicare/Medicaid Provider Number (also known as the OSCAR Provider Number, Medicare Identification Number or Provider Number) has been renamed the CMS Certification Number (CCN). The CCN continues to serve a critical role in verifying that a provider has been Medicare certified and for what type of services.\"\r\n\r\nSee https://www.cms.gov/regulations-and-guidance/guidance/transmittals/downloads/r29soma.pdf"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CDCLocal"
        },
        "name" : "CDC Local Coding System",
        "description" : "\"CDC Public Health Information Network local coding system used for creating the concepts that are not available in the Standard Development Organization (SDO) Vocabulary like SNOMED CT, LOINC, ICD-9, etc.\"\r\n\r\nVersioning numbered according to PHIN VADS convention.\r\n\r\nFor more information, see [https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CDCREC"
        },
        "name" : "CDC Race and Ethnicity",
        "description" : "The U.S. Centers for Disease Control and Prevention (CDC) has prepared a code set for use in coding race and ethnicity data. This code set is based on current federal standards for classifying data on race and ethnicity, specifically the minimum race and ethnicity categories defined by the U.S. Office of Management and Budget (OMB) and a more detailed set of race and ethnicity categories maintained by the U.S. Bureau of the Census (BC). The main purpose of the code set is to facilitate use of federal standards for classifying data on race and ethnicity when these data are exchanged, stored, retrieved, or analyzed in electronic form. At the same time, the code set can be applied to paper-based record systems to the extent that these systems are used to collect, maintain, and report data on race and ethnicity in accordance with current federal standards.\r\n\r\nThe content is available at https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238#."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CDCVIS"
        },
        "name" : "Vaccine Information Statements (VIS)",
        "description" : "\"A VIS or Vaccine Information Statement is a document, produced by CDC, that informs vaccine recipients – or their parents or legal representatives - about the benefits and risks of a vaccine they are receiving.\"\r\n\r\nA lookup table of current VIS concept names and codes can be found here: [https://www.cdc.gov/iis/code-sets/vis-barcode-lookup-table.html](https://www.cdc.gov/iis/code-sets/vis-barcode-lookup-table.html)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CDPS"
        },
        "name" : "Chronic Illness and Disability Payment System (CDPS)",
        "description" : "\"The Chronic Illness and Disability Payment System (CDPS) is a diagnostic-based risk adjustment model that is widely used to adjust capitated payments for health plans that enroll Medicaid beneficiaries.\r\n\r\nCDPS uses International Classification of Disease (ICD) codes to assign CDPS Categories that indicate illness burden related to major body systems (e.g. cardiovascular) or types of chronic disease (e.g. diabetes). Within each major category is a hierarchy reflecting both the clinical severity of the condition and its expected effect on future costs. Each of the hierarchical CDPS Categories is assigned a CDPS weight. CDPS weights are additive across major categories.\"\r\n\r\n\"The CDPS model was developed in 2000 using data from seven Fee-for-Service (FFS) Medicaid programs.  The model received major updates in 2009 (using national FFS Medicaid data from 2002-2005) and in 2014 (using additional national FFS Medicaid data from 2011). CDPS has also received regular annual updates to include the most recent ICD and NDC codes.\"\r\n\r\nFor more information, please visit [https://hwsph.ucsd.edu/research/programs-groups/cdps.html](https://hwsph.ucsd.edu/research/programs-groups/cdps.html)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CDT"
        },
        "name" : "Code on Dental Procedures and Nomenclature",
        "description" : "The purpose of the CDT Code is to achieve uniformity, consistency and specificity in accurately documenting dental treatment. One use of the CDT Code is to provide for the efficient processing of dental claims, and another is to populate an Electronic Health Record."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CLIA"
        },
        "name" : "Clinical Laboratory Improvement Amendments",
        "description" : "\"The Centers for Medicare & Medicaid Services (CMS) regulates all laboratory testing (except research) performed on humans in the U.S. through the Clinical Laboratory Improvement Amendments (CLIA). In total, CLIA covers approximately 330,000 laboratory entities. The Division of Clinical Laboratory Improvement & Quality, within the Quality, Safety & Oversight Group, under the Center for Clinical Standards and Quality (CCSQ) has the responsibility for implementing the CLIA Program.\r\n\r\nThe objective of the CLIA program is to ensure quality laboratory testing. Although all clinical laboratories must be properly certified to receive Medicare or Medicaid payments, CLIA has no direct Medicare or Medicaid program responsibilities.\"\r\n\r\nCMS CLIA certified laboratories will be assigned a10-digit alphanumeric CLIA identification number, with the \"D\" in the third position identifying the provider/supplier as a laboratory certified under CLIA.\"\r\n\r\nCLIA is maintained by CMS. It is in the public domain and free to use without restriction.\r\n\r\nSee http://cms.gov/regulations-and-guidance/legislation/clia."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CMSPlaceofServiceCodes"
        },
        "name" : "CMS Place of Service Codes (POS)",
        "description" : "Place of Service Codes are two-digit codes placed on health care professional claims to indicate the setting in which a service was provided. The Centers for Medicare & Medicaid Services (CMS) maintain POS codes used throughout the health care industry.\r\n\r\nThis code set is required for use in the implementation guide adopted as the national standard for electronic transmission of professional health care claims under the provisions of the Health Insurance Portability and Accountability Act of 1996 (HIPAA). HIPAA directed the Secretary of HHS to adopt national standards for electronic transactions. These standard transactions require all health plans and providers to use standard code sets to populate data elements in each transaction. The Transaction and Code Set Rule adopted the ASC X12N-837 Health Care Claim: Professional, volumes 1 and 2, as the standard for electronic submission of professional claims. This standard names the POS code set currently maintained by CMS as the code set to be used for describing sites of service in such claims. POS information is often needed to determine the acceptability of direct billing of Medicare, Medicaid and private insurance services provided by a given provider."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/cmshcc"
        },
        "name" : "CMS Hierarchical Condition Categories",
        "description" : "The CMS-HCC model uses more than 9,000 ICD-10-CM codes, which are mapped to condition categories that predict costs well. The condition categories are based on diagnoses clinically related to one another and with similar predicted cost implications. Hierarchies are imposed on the condition categories to capture the most costly diagnoses. Hierarchy logic is imposed on certain condition categories to account for different hierarchical costs, thus, the term Hierarchical Condition Category, or HCC.\r\n\r\nFor more information, see https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-Adjustors.\r\n\r\nThe CMS HCCs are in the public domain and are free to use without restriction."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CMSRxHCC"
        },
        "name" : "CMS Prescription Drug Hierarchical Condition Categories",
        "description" : "Starting in 2006, with the implementation of the Part D program, CMS introduced a second major HCC-based risk adjustment model. Created with the passage of the Medicare Modernization Act (MMA) of 2003, the Medicare Part D Prescription Drug benefit became the second major Medicare capitated payment system. CMS developed the Part D RxHCC risk adjustment model to apply to monthly capitated payments to both Medicare Advantage (MA-PDs) and standalone prescription drug plans (PDPs). The Part D RxHCC risk adjustment model implemented in 2006 was developed using a structure similar to the CMS-HCC model, in that it included demographic and diagnosis information clustered into hierarchical condition categories. CMS obtains diagnoses for all Medicare beneficiaries from either fee-for-service claims or Medicare Advantage reporting. In 2011, CMS implemented an updated Part D RxHCC risk adjustment model, incorporating program data derived from prescription drug event (PDE) data. The data used to calibrate this updated model was more recent cost and utilization data, resulting in a model that reflects more recent drug cost and utilization patterns.\r\n\r\nFor more information, see: https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-Adjustors\r\n\r\nThe CMS RxHCCs are in the public domain and are free to use without restriction."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CPT"
        },
        "name" : "Current Procedural Terminology (CPT®)",
        "description" : "The Current Procedural Terminology (CPT) code set, created and maintained by the American Medical Association, is the language of medicine today and the code to its future. This system of terminology is the most widely accepted medical nomenclature used to report medical procedures and services under public and private health insurance programs. CPT coding is also used for administrative management purposes such as claims processing and developing guidelines for medical care review. Each year, via a rigorous, evidence-based and transparent process, the independent CPT Editorial Panel revises, creates or deletes hundreds of codes in order to reflect current medical practice.\r\n\r\nDesignated by the U.S. Department of Health and Human Services under the Health Insurance Portability and Accountability Act (HIPAA) as a national coding set for physician and other health care professional services and procedures, CPT’s evidence-based codes accurately encompass the full range of health care services.\r\n\r\nAll CPT codes are five-digits and can be either numeric or alphanumeric, depending on the category. CPT code descriptors are clinically focused and utilize common standards so that a diverse set of users can have common understanding across the clinical health care paradigm.\r\n\r\nThere are various types of CPT codes:\r\n\r\nCategory I: These codes have descriptors that correspond to a procedure or service. Codes range from 00100–99499 and are generally ordered into sub-categories based on procedure/service type and anatomy.\r\n\r\nCategory II: These alphanumeric tracking codes are supplemental codes used for performance measurement. Using them is optional and not required for correct coding.\r\n\r\nCategory III: These are temporary alphanumeric codes for new and developing technology, procedures and services. They were created for data collection, assessment and in some instances, payment of new services and procedures that currently don’t meet the criteria for a Category I code.\r\n\r\nProprietary Laboratory Analyses (PLA) codes: These codes describe proprietary clinical laboratory analyses and can be either provided by a single (“solesource”) laboratory or licensed or marketed to multiple providing laboratories that are cleared or approved by the Food and Drug Administration (FDA)). This category includes but is not limited to Advanced Diagnostic Laboratory Tests (ADLTs) and Clinical Diagnostic Laboratory Tests (CDLTs), as defined under the Protecting Access to Medicare Act of 2014 (PAMA)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CTAS"
        },
        "name" : "Canadian Triage and Acuity Scale",
        "description" : "The Canadian Triage and Acuity Scale (CTAS) provides a standardized, five-level method for prioritizing patients who present to emergency departments, ensuring that those in greatest need receive the fastest care. The system evolved from military triage principles, adapted for hospitals in the 1960s, and formally standardized in 1999 through collaboration among CAEP, NENA, and AMUQ. It replaced the earlier three-level model to improve national consistency, reliability, and patient outcomes.\r\n\r\nTriage is defined as a rapid, structured assessment process guided by critical thinking, where an experienced nurse evaluates a patient’s condition, determines severity, assigns a CTAS category, and directs them to appropriate care. This process improves safety, efficiency, and communication while helping manage limited emergency resources. The five CTAS levels range from Level 1 (Resuscitation) for life-threatening emergencies to Level 5 (Non-Urgent) for minor complaints.\r\n\r\nEffective triage depends on both system design and nurse expertise. Triage nurses must balance speed and accuracy, applying cognitive, behavioral, and interpersonal skills—critical thinking, autonomy, composure under pressure, compassion, and clear communication. Their role includes assessment, initiation of basic interventions, collaboration with physicians, documentation, and ongoing patient reassessment. They serve as patient advocates and frontline decision-makers in dynamic, often crowded environments.\r\n\r\nThe triage process begins with a “critical look”—a 3-to-5-second across-the-room assessment of airway, breathing, circulation, and neurological status—followed by infection control screening, subjective (patient-reported) and objective (observed) assessments, and the selection of a CEDIS Presenting Complaint. Modifiers such as vital-sign deviations or risk factors help refine acuity assignment. Clear documentation of findings and CTAS level is essential, and reassessment intervals are defined: continuous for Level 1 patients, every 15 minutes for Level 2, and progressively less frequent for lower levels.\r\n\r\nTriage reliability can be affected by ED overcrowding or access block, leading to “triage drift,” where acuity scores may be subconsciously adjusted to fit available space. Strategies such as lean “streaming” processes, internal waiting rooms, and rapid assessment zones help mitigate these pressures.\r\n\r\nUltimately, CTAS is more than a categorization tool—it is a cornerstone of emergency care quality and accountability. By integrating standardized assessment with professional judgment, it ensures that patients receive timely, appropriate care while supporting system efficiency, data benchmarking, and continuous improvement across Canadian emergency departments.\r\n\r\nFor more information, see [https://share.google/PedyLtc66nmDyt3a7](https://share.google/PedyLtc66nmDyt3a7)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CVX"
        },
        "name" : "Vaccine Administered Code Set (CVX)",
        "description" : "The CDC's National Center of Immunization and Respiratory Diseases (NCIRD - see [https://www.cdc.gov/ncird/](https://www.cdc.gov/ncird/)) developed and maintains the CVX (vaccine administered) code set. It includes both active and inactive vaccines available in the US. CVX codes for inactive vaccines allow transmission of historical immunization records. When a MVX (manufacturer) code is paired with a CVX (vaccine administered) code, the specific trade named vaccine may be indicated. These codes should be used for immunization messages using either HL7 Version 2.3.1 or HL7 Version 2.5.1. CVX is the underlying Master Code System for V2 table 0292 (Vaccines Administered). The machine readable name for CVX in PHIN VADS is PH_VaccinesAdministeredCVX_CDC_NIP. The version of the CVX code set for certification can be found on the archive page:[https://www2a.cdc.gov/vaccines/iis/iisstandards/mu3versioned_codes.asp](https://www2a.cdc.gov/vaccines/iis/iisstandards/mu3versioned_codes.asp) \r\n\r\nThe Status column indicates if the vaccine is currently available in the United States.\r\n\r\n*  Active: A currently available administrable vaccine \r\n\r\n*  Inactive: An administrable vaccine formulation that is no longer available for patient administration, but can be found in historical patient records OR A historical record of a vaccine administered where the exact formulation is unknown \r\n\r\n*  Pending: A vaccine that is expected to become active in the future \r\n\r\n*  Non-US: A vaccine that available outside the US only \r\n\r\n*  Never Active: A vaccine that was never available and is not in the pipeline of new vaccines \r\n\r\nThe Last Updated column indicates the last time this particular vaccine code was updated in this table.\r\n\r\nQuestions regarding this table should be directed to the IIS Technical Assistance Team via iisinfo@cdc.gov (or use mailing address via [https://www2a.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=cvx#addr](https://www2a.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=cvx#addr)) \r\n\r\nHL7 Implementers should note that 'Status' IS NOT CONCEPT STATUS as all codes are ACTIVE in this code system.\r\n\r\nThe current code system is available via [https://www2a.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=cvx](https://www2a.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=cvx)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CaliforniaDLN"
        },
        "name" : "California Driver's License",
        "description" : "California Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CanadaProvinceCodes"
        },
        "name" : "Canada Post Province Codes",
        "description" : "For more information, see [https://www.canadapost-postescanada.ca/cpc/en/support/articles/addressing-guidelines/symbols-and-abbreviations.page](https://www.canadapost-postescanada.ca/cpc/en/support/articles/addressing-guidelines/symbols-and-abbreviations.page)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ClinicalTrialsGov"
        },
        "name" : "ClinicalTrials.gov",
        "description" : "The U.S. National Institutes of Health, Department of Health and Human Services, through its National Library of Medicine, has developed [ClinicalTrials.gov](http://clinicaltrials.gov) to provide patients, family members, and members of the public current information about clinical research studies. [ClinicalTrials.gov](http://clinicaltrials.gov) contains summary information about clinical studies being conducted throughout the United States and in many countries throughout the world. These data are provided to the National Library of Medicine by organizations and institutions that sponsor and implement the studies.\r\n\r\n[ClinicalTrials.gov](http://clinicaltrials.gov) is updated daily. You should check [ClinicalTrials.gov](http://clinicaltrials.gov) frequently for updated information.\r\n\r\nMore information about ClinicalTrials.gov can be found [here](https://clinicaltrials.gov/about-site/about-ctg)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ColoradoDLN"
        },
        "name" : "Colorado Driver's License",
        "description" : "Colorado Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ConnecticutDLN"
        },
        "name" : "Connecticut Driver's License",
        "description" : "Connecticut Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DCDLN"
        },
        "name" : "DC Driver's License",
        "description" : "DC Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DUNSNumber"
        },
        "name" : "Data Universal Numbering System (DUNS) Number",
        "description" : "\"The Dun & Bradstreet D-U-N-S® Number (short for Data Universal Numbering System) is a nine-digit unique identifier for businesses. Hundreds of millions of D-U-N-S Numbers exist for companies across the globe.\r\n\r\nA D-U-N-S Number is assigned through our patented identity resolution process, (part of our DUNSRight™ data governance, which includes thousands of separate automated checks.) The D-U-N-S Number identifies a company as being unique from any other in the [Dun & Bradstreet Data Cloud](https://www.dnb.com/about-us/data-cloud.html).  It is used as the starting point for any company's [Live Business Identity](https://www.dnb.com/about-us/data-cloud/live-business-identity.html), which helps ensure you have the most accurate and up-to-date view of organizations.\"\r\n\r\nFor more information, see [https://www.dnb.com/duns.html](https://www.dnb.com/duns.html)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DelawareDLN"
        },
        "name" : "Delaware Driver's License",
        "description" : "Delaware Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/bluetooth-address-identifier"
        },
        "name" : "Bluetooth Address as a device identifier",
        "description" : "The Bluetooth Device Address (sometimes referred to as a Bluetooth MAC address) is a unique 48-bit identifier assigned to each Bluetooth device by the manufacturer. Bluetooth Addresses are usually displayed as 6 bytes written in hexadecimal and separated by colons (example - 00:11:22:33:FF:EE). They are an essential part of Bluetooth-based protocols. The upper half of a Bluetooth Address (most-significant 24 bits) is the so-called Organizationally Unique Identifier (OUI). It can be used to determine the manufacturer of a device (Bluetooth MAC Address Lookup form). OUI prefixes are assigned by the Institute of Electrical and Electronics Engineers (IEEE). An EUI (Extended Unique Identifier) is generally made from an OUI and thus a Bluetooth Address is also an EUI-48. A device that has a Bluetooth address can also have it own Ethernet MAC address."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ethernet-address-identifier"
        },
        "name" : "Ethernet MAC Address as a device identifier",
        "description" : "The Ethernet MAC (media access control) address is a unique identifier assigned to a network interface controller (NIC) for use as a network address in communications within a network segment. This use is common in most IEEE 802 networking technologies.  The address typically includes a manufacturer's organizationally unique identifier (OUI). MAC addresses are formed according to the principles of two numbering spaces based on Extended Unique Identifiers (EUI) managed by the Institute of Electrical and Electronics Engineers (IEEE): EUI-48. A device that has an Ethernet MAC address can also have it own Bluetooth MAC address."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/imei-identifier"
        },
        "name" : "IMEI as a device identifier",
        "description" : "The International Mobile Equipment Identity (IMEI) is a number, usually unique, to identify 3GPP and iDEN mobile phones, as well as some satellite phones. The IMEI consists of 15 decimal digits: 14 digits plus a check digit while the IMEISV consists of 16 decimal digits: 14 digits plus two software version digits. These numbers includes information on the origin, model, and serial number of the device. The structure of the IMEI/SV is specified in 3GPP TS 23.003. The model and origin comprise the initial 8-digit portion of the IMEI/SV, known as the Type Allocation Code (TAC). The remainder of the IMEI is manufacturer-defined, with a Luhn check digit at the end."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/usb-address-identifier"
        },
        "name" : "USB VID and PID as a device identifier",
        "description" : "A USB device that is plugged in identifies itself by its VID/PID combination. A VID is a 16-bit vendor number (Vendor ID). A PID is a 16-bit product number (Product ID). A host uses the VID/PID combination to find the drivers (if any) that are to be used for the USB device. For this to work, the VID/PID combination must be unique, in the sense that each USB device with the same VID/PID will use the same driver. So, whenever you need a specific driver for your USB product, you will need a unique VID/PID for that product. In that sense, the VID/PID combination does not really serve as a truly unique identifier of a single device instance. It is, however, useful to know for medical devices that communicate using USB."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/zigbee-address-identifier"
        },
        "name" : "ZigBee Address as a device identifier",
        "description" : "The ZigBee Address is a unique 64-bit identifier assigned to each ZigBee device by the manufacturer. ZigBee Addresses are usually displayed as 8 bytes written in hexadecimal and separated by colons (example - DF:3B:00:11:22:33:FF:EE). They are an essential part of ZigBee-based protocols. The most-significant 24 bits of the ZigBee address is the so-called Organizationally Unique Identifier (OUI). It can be used to determine the manufacturer of a device. OUI prefixes are assigned by the Institute of Electrical and Electronics Engineers (IEEE). An EUI (Extended Unique Identifier) is generally made from an OUI and thus a ZigBee Address is also an EUI-64. When a ZigBee device joins a network it is assigned an additional 16-bit address sometimes referred to as its network address. This address is different from the 64-bit ZigBee address and is dynamic."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/FEI"
        },
        "name" : "FDA Establishment Identifier",
        "description" : "\"A FDA Establishment Identifier or Firm Establishment Identifier (FEI) is an FDA system generated number used to identify a firm. FDA systems interact, occasionally creating multiple records (FEIs) for one firm. Upon evaluation, these numbers are merged into one surviving FEI which is used to identify the firm. The remaining FEIs become children of the surviving FEI and are not used to identify the firm.\"\r\n\r\nFor more information, see [https://www.accessdata.fda.gov/scripts/feiportal/index.cfm?action=common.faq](https://www.accessdata.fda.gov/scripts/feiportal/index.cfm?action=common.faq)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/FIPS52"
        },
        "name" : "Federal Information Processing Standards Publication: Codes for the Identification of the States, the District of Columbia and the Outlying Areas of the United States, and Associated Areas (FIPS 5-2)",
        "description" : "\"This standard provides a set of two-digit numeric codes and a set of two-letter alphabetic codes for representing the 50 states, the District of Columbia and the outlying areas of the United States, and associated areas. The standard covers all land areas under the sovereignty of the United States, the freely associated states of Federated States of Micronesia and Marshall Islands, and the trust territory of Palau. This revision supersedes FIPS PUB 5-1 in its entirety.\"\r\n\r\nFor more information, see [https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub5-2.pdf](https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub5-2.pdf)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/FIPS64"
        },
        "name" : "Federal Information Processing Standards Publication: Counties and Equivalent Entities of the United States, Its Possessions, and Associated Areas (FIPS 6-4)",
        "description" : "\"The FIPS county code is a five-digit Federal Information Processing Standard (FIPS) code (FIPS 6-4) which uniquely identifies counties and county equivalents in the United States, certain U.S. possessions, and certain freely associated states. This is the 3-digit part of the 5-digit county FIPS code specifically standing for the county.\"\r\n\r\nFor more information, see [https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub6-4.pdf](https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub6-4.pdf)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/FOI"
        },
        "name" : "FEvIR Object Identifier",
        "description" : "The FEvIR Object Identifier (FOI) is a globally unique persistent digital object identifier for Resources accessible through the FEvIR Platform. The FEvIR Platform is a platform to support creation, viewing, notification, and interaction for computable expression of scientific knowledge. The FEvIR Platform is used to facilitate many projects, including the HL7 EBMonFHIR project and the Evidence Based Medicine on FHIR Implementation Guide."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/FloridaDLN"
        },
        "name" : "Florida Driver's License",
        "description" : "Florida Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/GLN"
        },
        "name" : "Global Location Number (GLN)",
        "description" : "Global Location Number (GLN) can be used by companies to identify their locations, giving them complete flexibility to identify any type or level of location required.\r\n\r\nFor more information as to how GLNs are used in healthcare, see a GS1 provided guide located here https://www.gs1.org/docs/healthcare/GLN_Healthcare_Imp_Guide.pdf \r\n\r\nFor additional information regarding the GLN standard refer to the GS1 General Specifications (https://www.gs1.org/standards/barcodes-epcrfid-id-keys/gs1-general-specifications) and for assignment refer to the GS1 GLN Allocation Rules (https://www.gs1.org/1/glnrules/en/).\r\n\r\nGS1 local offices handle all enquiries related to GS1 standards. Please see the list of GS1 offices (https://www.gs1.org/contact/overview) for more information.\r\n\r\nIn relation to the \"Healthcare GLN Implementation Guideline\":\r\n\r\n\"GS1®, under its IP Policy, seeks to avoid uncertainty regarding intellectual property claims by requiring the participants in the Work Group that developed this Healthcare GLN Implementation Guideline to agree to grant to GS1 members a royalty-free licence or a RAND licence to Necessary Claims, as that term is defined in the GS1 IP Policy. Furthermore, attention is drawn to the possibility that an implementation of one or more features of this Specification may be the subject of a patent or other intellectual property right that does not involve a Necessary Claim. Any such patent or other intellectual property right is not subject to the licensing obligations of GS1. Moreover, the agreement to grant licences provided under the GS1 IP Policy does not include IP rights and any claims of third parties who were not participants in the Work Group.\r\n\r\nAccordingly, GS1 recommends that any organisation developing an implementation designed to be in conformance with this Specification should determine whether there are any patents that may encompass a specific implementation that the organisation is developing in compliance with the Specification and whether a licence under a patent or other intellectual property right is needed. Such a determination of a need for licencing should be made in view of the details of the specific system designed by the organisation in consultation with their own patent counsel.\"\r\n\r\n\"GS1 disclaims all liability for any damages arising from use or misuse of this document, whether special, indirect, consequential, or compensatory damages, and including liability for infringement of any intellectual property rights, relating to use of information in or reliance upon this document.\"\r\n\r\nGS1 and the GS1 logo are registered trademarks of GS1 AISBL."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/GTR"
        },
        "name" : "Genetic Testing Registry",
        "description" : "The Genetic Testing Registry (GTR) provides a central location for voluntary submission of genetic test information by providers. The scope includes the test's purpose, methodology, validity, evidence of the test's usefulness, and laboratory contacts and credentials. The overarching goal of the GTR is to advance the public health and research into the genetic basis of health and disease.\r\n\r\nEach Test is a specific, orderable test from a particular laboratory, and is assigned a unique GTR accession number. The format is GTR00000001.1, with a leading prefix \"GTR\" followed by 8 digits, a period, then 1 or more digits representing the version. When a laboratory updates a registered test, a new version number is assigned.\r\n\r\nTo find all laboratories in GTR and all registered tests, see here https://www.ncbi.nlm.nih.gov/gtr/all/tests/?term=all%5Bsb%5D"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/GeorgiaDLN"
        },
        "name" : "Georgia Driver's License",
        "description" : "Georgia Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/HGNCGeneGroup"
        },
        "name" : "HUGO Gene Nomenclature Committee Gene Group",
        "description" : "\"The HGNC is responsible for approving unique symbols and names for human loci, including protein coding genes, ncRNA genes and pseudogenes, to allow unambiguous scientific communication.\"\r\n\r\nHGNC Gene Group is an index on gene families/groups. The numeric GeneGroup IDs should be used as codes. GeneGroup IDs do not begin with \"HGNC:\" (like the GeneIDs for genes in HGNC Genes), so care must be made to ensure alignment of concepts when viewing an HGNC ID from an older system that may be referring to the GeneID and not a gene group. For example, 588 refers to the HLA gene family, but HGNC:588 identifies the ATG12 gene. To provide clarity for systems that do not distinguish codes from genes and gene families, use \"http://www.genenames.org\" for genes and \"http://www.genenames.org/genegroup\" for gene families as code system URIs.\r\n\r\n\"For each known human gene we approve a gene name and symbol (short-form abbreviation). All approved symbols are stored in the HGNC database,[www.genenames.org](https://www.genenames.org/tools/search), a curated online repository of HGNC-approved gene nomenclature, gene groups and associated resources including links to genomic, proteomic and phenotypic information. Each symbol is unique and we ensure that each gene is only given one approved gene symbol. It is necessary to provide a unique symbol for each gene so that we and others can talk about them, and this also facilitates electronic data retrieval from publications and databases.\"\r\n\r\nFor more information on the use of HGNC Genes, see [https://terminology.hl7.org/CodeSystem-v3-hgnc.html](https://terminology.hl7.org/CodeSystem-v3-hgnc.html).\r\n\r\nHGNC is a free database for the public.\r\n\r\nPlease see https://www.genenames.org/ for more info."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/HIPPS"
        },
        "name" : "Health Insurance Prospective Payment System (HIPPS)",
        "description" : "\"Health Insurance Prospective Payment System (HIPPS) rate codes represent specific sets of patient characteristics (or case-mix groups) health insurers use to make payment determinations under several prospective payment systems. Case-mix groups are developed based on research into utilization patterns among various provider types. For the payment systems that use HIPPS codes, clinical assessment data is the basic input. A standard patient assessment instrument is interpreted by case-mix grouping software algorithms, which assign the case mix group. For payment purposes, at least one HIPPS code is defined to represent each case-mix group. These HIPPS codes are reported on claims to insurers.\r\n\r\nInstitutional providers use HIPPS codes on claims in association with special revenue codes. One revenue code is defined for each prospective payment system that requires HIPPS codes. HIPPS codes are placed in data element SV202 on the electronic 837 institutional claims transaction, using an HP qualifier, or in Form Locator (FL) 44 (\"HCPCS/rate\") on a paper UB-04 claims form. The associated revenue code is placed in data element SV201 or in FL 42. In certain circumstances, multiple HIPPS codes may appear on separate lines of a single claim.\"\r\n\r\n\"HIPPS codes are alpha-numeric codes of five digits. Each code contains intelligence, with certain positions of the code indicating the case mix group itself, and other positions providing additional information. The additional information varies among HIPPS codes pertaining to different payment systems, but often provides information about the clinical assessment used to arrive at the code. Which positions of the code carry the case mix group information may also vary by payment systems.\"\r\n\r\n\"Under the Health Insurance Portability and Accountability Act (HIPAA) rules for transactions and code sets, HIPPS codes are defined as a non-medical code set. Therefore, these codes are effective by transaction date.\r\n\r\nEffective From Dates: HIPPS codes are valid under HIPAA on transactions on or after this date. Since all HIPPS codes to date have been initially created for Original Medicare payment systems, this is also date of service the codes begin to be payable by Medicare. While it is valid under HIPAA rules that a claim for dates of service before this date could be submitted on a transaction after this date, CMS is not aware of a business need for a provider to do so. The code would not be payable by any insurer and no Grouper software would be available to produce a code for those dates.\r\n\r\nEffective Through Dates: HIPPS codes are no longer valid under HIPAA on transactions on or after this date. This date may vary from the date a code ceases to be payable by Medicare, since other payers may continue to use older HIPPS codes after Medicare transitions to a new payment system. Since CMS, as the HIPPS code set maintainer, may not have complete information about other payers’ uses of these codes, codes may remain effective under HIPAA long after they cease to be payable on Medicare claims. To reflect this, a separate column on the HIPPS Code Master List indicates the Medicare Payment Though Date.\""
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/HPO"
        },
        "name" : "Human Phenotype Ontology",
        "description" : "\"The Human Phenotype Ontology (HPO) provides a standardized vocabulary of phenotypic abnormalities encountered in human disease. Each term in the HPO describes a phenotypic abnormality, such as Atrial septal defect. The HPO is currently being developed using the medical literature, Orphanet, DECIPHER, and OMIM. HPO currently contains over 13,000 terms and over 156,000 annotations to hereditary diseases. The HPO project and others have developed software for phenotype-driven differential diagnostics, genomic diagnostics, and translational research. The HPO is a flagship product of the Monarch Initiative, an NIH-supported international consortium dedicated to semantic integration of biomedical and model organism data with the ultimate goal of improving biomedical research. The HPO, as a part of the Monarch Initiative, is a central component of one of the 13 driver projects in the Global Alliance for Genomics and Health (GA4GH) strategic roadmap.\"\r\n\r\nPlease see https://hpo.jax.org/app/download/ontology.\r\n\r\nReleases, produced approximately every 2 months, can be found [here](https://github.com/obophenotype/human-phenotype-ontology/releases)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/HawaiiDLN"
        },
        "name" : "Hawaii Driver's License",
        "description" : "Hawaii Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icaosex"
        },
        "name" : "International Civil Aviation Organization Sex",
        "description" : "ICAO is funded and directed by 193 national governments to support their diplomacy and cooperation in air transport as signatory states to the [Chicago Convention (1944)](https://www.icao.int/about-icao/History/Pages/default.aspx)\r\n\r\nIts core function is to maintain an administrative and expert bureaucracy (the [ICAO Secretariat](https://www.icao.int/secretariat/Pages/default.aspx) supporting these diplomatic interactions, and to research new air transport policy and standardization innovations as directed and endorsed by governments through the [ICAO Assembly](https://www.icao.int/about-icao/assembly/Pages/default.aspx), or by the [ICAO Council](https://www.icao.int/about-icao/Council/Pages/council.aspx) which the assembly elects.\r\n\r\nICAO has developed a technical specification (sample version form 2021 [here](https://www.icao.int/publications/Documents/9303_p7_cons_en.pdf) ) to \"allow compatibility and global interchange using both visual (eye readable) and machine readable means. The specifications lay down standards for visas which can, where issued by a State and accepted by a receiving State, be used for travel purposes. The MRV[Machine Readable Visa] shall, as a minimum, contain the data specified herein in a form that is legible both visually and by optical character recognition methods..\" \r\n\r\nFurther, defining that \"Sex of MRV-A[Format A - Machine Readable Visa] holder, when included, is to be specified by use of the single initial commonly used in the language of the State of issue. If translation into English, French or Spanish is necessary, followed by an oblique and the capital letter F for female, M for male, or X for unspecified.\"\r\n\r\nSex of MRV-B[Format B - Machine Readable Visa] holder, when included, is to be specified by use of the single initial commonly used in the language of the State of issue. If translation into English, French or Spanish is necessary, followed by an oblique and the capital letter F for female, M for male, or X for unspecified."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ICD11MMS"
        },
        "name" : "International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS)",
        "description" : "The International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS) is one of the ICD11 linearizations. Information about the ICD Foundation Component and the ICD11 Linearizations can be found in the complete reference guide here: [https://icd.who.int/icd11refguide/en/index.html](https://icd.who.int/icd11refguide/en/index.html)\r\n\r\n\"**The ICD11 Linearizations (Tabular lists)**\r\n\r\nA linearization is a subset of the foundation component, that is:\r\n\r\n1. fit for a particular purpose: reporting mortality, morbidity, primary care or other uses;\r\n\r\n 2. composed of entities that are Mutually Exclusive of each other; \r\n\r\n3. each entity is given a single parent.\r\n\r\nLinearization is similar to the classical print versions of ICD Tabular List (e.g. volume I of ICD-10 or other previous editions). The main linearization of ICD-11 is Mortality and Morbidity Statistics (MMS). Various linearizations could be built at different granularity, use case or other purposes such as for Primary Care, Clinical Care or Research. The linkage from the foundation component to a particular linearization will ensure consistent use of the ICD.\"\r\n\r\nICD-11 for Mortality and Morbidity (ICD-11 MMS) can be downloaded in either print or electronic (spreadsheet) format from the  browser in the Info tab located [here](https://icd.who.int/browse11/l-m/en)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ICF"
        },
        "name" : "International Classification of Functioning, Disability and Health",
        "description" : "\"The International Classification of Functioning, Disability and Health, known more commonly as ICF, is a classification of health and health-related domains. As the functioning and disability of an individual occurs in a context, ICF also includes a list of environmental factors.\r\n\r\nICF is the WHO framework for measuring health and disability at both individual and population levels.\r\n\r\nICF was officially endorsed by all 191 WHO Member States in the Fifty-fourth World Health Assembly on 22 May 2001(resolution [WHA 54.21](http://apps.who.int/gb/archive/pdf_files/WHA54/ea54r21.pdf) ) as the international standard to describe and measure health and disability.\r\n\r\nICF is based on the same foundation as ICD and ICHI and share the same set of extension codes that enable documentation at a higher level of detail.\"\r\n\r\nOfficial updates to the ICF are available as annual lists of changes.\r\n\r\nThese updates are approved annually at the October meeting of the WHO Family of International Classifications (WHO-FIC) Network.\r\n\r\nTo license ICF, the same rules apply for ICF as for ICD. See [http://icd.who.int/](http://icd.who.int/).\r\n\r\nFor more information, see [https://www.who.int/standards/classifications/international-classification-of-functioning-disability-and-health](https://www.who.int/standards/classifications/international-classification-of-functioning-disability-and-health)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ICFDut"
        },
        "name" : "International Classification of Functioning, Disability and Health, Dutch Translation",
        "description" : "\"The International Classification of Functioning, Disability and Health, known more commonly as ICF, is a classification of health and health-related domains. As the functioning and disability of an individual occurs in a context, ICF also includes a list of environmental factors.\r\n\r\nICF is the WHO framework for measuring health and disability at both individual and population levels.\r\n\r\nICF was officially endorsed by all 191 WHO Member States in the Fifty-fourth World Health Assembly on 22 May 2001(resolution [WHA 54.21](http://apps.who.int/gb/archive/pdf_files/WHA54/ea54r21.pdf) ) as the international standard to describe and measure health and disability.\r\n\r\nICF is based on the same foundation as ICD and ICHI and share the same set of extension codes that enable documentation at a higher level of detail.\"\r\n\r\n\"The Dutch translation of the ICF is published in book form by BSL. The ICF can also be consulted online in the [Classification Browser](https://class.whofic.nl/browser.aspx?scheme=ICF-nl.cla).\r\n\r\nThe ICF team of the WHO-FIC Collaborating Center combines expertise in the field of the ICF for the Dutch language area and currently consists of delegations from the Netherlands Paramedical Institute, the University Medical Center Groningen, Maastricht University, the Big Move Institute, Stichting Scientific Research Road Safety, University of Ghent, Vilans, and Rehabilitation Center de Hoogstraat.\"\r\n\r\nOfficial updates to the ICF are available as annual lists of changes.\r\n\r\nThese updates are approved annually at the October meeting of the WHO Family of International Classifications (WHO-FIC) Network.\r\n\r\nTo license ICF, the same rules apply for ICF as for ICD. See [http://icd.who.int/](http://icd.who.int/).\r\n\r\nFor more information, see [https://www.whofic.nl/familie-van-internationale-classificaties/referentie-classificaties/icf](https://www.whofic.nl/familie-van-internationale-classificaties/referentie-classificaties/icf)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ICHContextOfUse"
        },
        "name" : "ICH Context of Use",
        "description" : "Codes are found within the vocabulary package at the link above which is available from this page: [https://ich.org/page/ich-electronic-common-technical-document-ectd-v40](https://ich.org/page/ich-electronic-common-technical-document-ectd-v40). Specifically, the codes are in the “ICH Context of Use” tab of the \"ICH M8 OID Listing_eCTDv4_v5.xlsx\" workbook. The codes are part of the ICH implementation of HL7 V3 Standard: Regulated Studies; Regulated Product Submissions (RPS), Release 2 Normative (described here: [https://www.hl7.org/implement/standards/product_brief.cfm?product_id=38](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=38))\r\n\r\nWhen using this uri in FHIR, the version identifier is mandatory and the code system uri cannot be used without it.\r\n\r\nThis system uses an integer based versioning system in conjunction with an OID update. For example, if the version of the system is v5, the OID is 2.16.840.1.113883.3.989.2.2.1.1.5. This system has an OID stem of 2.16.840.1.113883.3.989.2.2.1.1."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ICPC3"
        },
        "name" : "International Classification of Primary Care - Third Revision",
        "description" : "The International Classification of Primary Care (ICPC) is the most widely used international classification for systematically capturing and organising clinical information in primary care. It is a unifying language for Primary Care, supporting the coherent coding of reason(s) for encounter, symptoms and complaints, diagnoses, health problems, functioning, environmental factors, personal factors related to health and processes of care, all in only one classification."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/IECColourManagement"
        },
        "name" : "IEC 61966-2-1: Colour measurement and management - Part 2-1: Colour management - Default RGB colour space - sRGB",
        "description" : "IEC 61966-2-1:1999 is the official specification of sRGB. It provides viewing environment, encoding, and colorimetric details.\r\n\r\nFor more information, please see https://webstore.iec.ch/publication/6168"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ILRSpeakingSkillScale"
        },
        "name" : "ILRSpeakingSkillScale",
        "description" : "The following Interagency Language Roundtable (ILR) Skill Level Descriptions (SLDs) describe proficiency as the functional ability to produce spoken language that reflects current usage. The SLDs characterize proficiency ranging from no communicative ability to mastery. They constitute an ordinal scale that includes six ranked base levels from 0 to 5. They illustrate, but do not exhaustively characterize, the proficiency a person may demonstrate at a given level on the scale.\r\n\r\nControl of a base level (Levels 1, 2, 3, 4, and 5) typically implies control of the previous levels' aspects. A higher level of performance in one aspect does not justify a higher general proficiency rating. Level 5 includes the features of all levels. Still, as with all levels, Level 5 is a range and performance will vary.\r\n\r\nThere are plus levels for levels 0 through 4. Plus levels describe proficiency that substantially exceeds one base level and does not fully meet the criteria of the next base level. To merit a plus level, the demonstrated proficiency must match the plus level description and not be merely a strong performance at the base level.\r\n\r\nThe SLDs describe four aspects of language proficiency: functional ability (color coded green), precision of forms and meanings (red), content meaningfulness (black), and contextual appropriateness (blue). Functional ability refers to the communicative acts or tasks that an individual can accomplish. There are no functional abilities specific to the plus levels. Precision of forms and meanings refers to accuracy, range, and complexity. Content meaningfulness refers to the relevance and substantive coverage of topics. Contextual appropriateness refers to register, acceptability, and appropriateness of language for the intended audience.\r\n\r\nThe SLDs are presented in an official prose version as well as a supplementary crosswalk matrix. Each level description begins with a bolded main statement that summarizes the features of that level. Color coded supporting statements follow the main statement and describe the four aspects in detail. The crosswalk matrix shows the structure of the SLDs explicitly across the four skills.\r\n\r\nFor more information, including the source content, please see [https://www.govtilr.org/Skills/Speaking.htm](https://www.govtilr.org/Skills/Speaking.htm)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/IMO"
        },
        "name" : "Intelligent Medical Objects",
        "description" : "IMO is a clinical interface terminology, which helps to map diagnostic, procedure and other terminologies to medical concepts and codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ISBT128ProductDescriptionCodes"
        },
        "name" : "ISBT 128 Standard Terminology for Medical Products of Human Origin Product Description Codes",
        "description" : "The ISBT 128 Standard provides for the identification, terminology, coding, labeling, and data exchange for medical products of human origin. ISBT 128 Product Description Codes (PDCs) are associated with product descriptions in the ISBT 128 PDC Database based on standardized terminology. The ISBT 128 PDC Database is an international database protected by copyright that contains PDCs that may not apply to all countries. Note that the existence of a PDC does not imply that a product is acceptable to produce and distribute in your region. It is the responsibility of the user to observe national regulations, guidelines, and standards. For more information, see [https://www.isbt128.org/uri/productdescriptioncode](https://www.isbt128.org/uri/productdescriptioncode)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ISBT128PropertyTypes"
        },
        "name" : "ISBT 128 Standard Terminology for Medical Products of Human Origin Property Types",
        "description" : "ISBT 128 Reference Table 042 provides data references for ISBT 128 Standard data structures used for the transfer of data pertaining to medical products of human origin within electronic messages. For more information, see [https://www.isbt128.org/uri](https://www.isbt128.org/uri)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ISCN"
        },
        "name" : "International System for Human Cytogenomic Nomenclature (ISCN)",
        "description" : "The International System for Human Cytogenetic Nomenclature (ISCN) was created by the International Standing committee on Human Cytogenetic Nomenclature to represent the outcome of cytogenetic tests. ISCN specifies the nomenclature to describe karyotypes, chromosome abnormalities, in situ hybridization, etc. ISCN provides a list of symbols and abbreviated terms in adjunction with a set of rules, which can be used in the description of chromosomes and chromosome abnormalities, such as p for short arm of chromosome, q for long arm of chromosome, cen for centromere, del for deletion, ish for in situ hybridization, and plus sign (+) for gain, etc.\r\n\r\nA LOINC code is created to represent \"chromosome analysis results in ISCN expression\". In HL7 v2 messages, this LOINC code is used in OBX-3 with a coded result (CWE data type) that will be sent in OBX-5. The value of the coded result is an ISCN expression, and ISCN will be the code system for the coded result."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ISO3166Part1"
        },
        "name" : "ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code",
        "description" : "ISO 3166-1 establishes codes that represent the current names of countries, dependencies, and other areas of particular geopolitical interest, on the basis of country names obtained from the United Nations."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ISO3166Part2"
        },
        "name" : "ISO 3166-2 Codes for the representation of names of countries and their subdivisions — Part 2: Country subdivision code",
        "description" : "ISO 3166-2 establishes a code that represents the names of the principal administrative divisions, or similar areas, of the countries and entities included in ISO 3166-1."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ISO3166Part3"
        },
        "name" : "ISO 3166-3 Codes for the representation of names of countries and their subdivisions — Part 3: Code for formerly used names of countries",
        "description" : "ISO 3166-3 establishes a code that represents non-current country names, i.e. the country names deleted from ISO 3166 since its first publication in 1974."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/IdahoDLN"
        },
        "name" : "Idaho Driver's License",
        "description" : "Idaho Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/IllinoisDLN"
        },
        "name" : "Illinois Driver's License",
        "description" : "Illinois Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/IndianaDLN"
        },
        "name" : "Indiana Driver's License",
        "description" : "Indiana Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/IowaDLN"
        },
        "name" : "Iowa Driver's License",
        "description" : "Iowa Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/KansasDLN"
        },
        "name" : "Kansas Driver's License",
        "description" : "Kansas Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/KentuckyDLN"
        },
        "name" : "Kentucky Driver's License",
        "description" : "Kentucky Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/hcp-lan-apm-framework"
        },
        "name" : "The Health Care Payment Learning and Action Network (HCPLAN) Alternative Payment Model (APM) Framework Categories",
        "description" : "\"The Health Care Payment Learning and Action Network (HCPLAN or LAN) [https://hcp-lan.org/](https://hcp-lan.org/) is a public-private partnership established in 2015 by the US Department of Health and Human Services (HHS) to accelerate the transition to value-based payment models in the US healthcare system.\"\r\n\r\n   \"The  Framework represents payments from public and private payers to provider organizations (including payments between the payment and delivery arms of highly integrated health systems). It is designed to accommodate payments in multiple categories that are made by a single payer, as well as single provider organizations that receive payments in different categories—potentially from the same payer.\"\r\n\r\n   \"Since the original APM Framework White Paper was released in January 2016, it has become the foundation for implementing APMs and evaluating progress toward health care payment reform. Payers, providers, and purchasers have all used the APM Framework to better understand the payment reform landscape and to set goals for participation in APMs, and health care stakeholders have used the APM Framework to identify common goals for transforming the nation’s health care system. Overall, the APM Framework’s classification system has been adopted by the health care ecosystem.\"\r\n\r\n   \"The LAN APM Framework represents a continuum of payment approaches across four Categories.\"\r\n\r\n  Initial version of the APM Framework White Paper was published in 2016. The updated version of the White Paper was published in 2017.\r\n\r\n  For more information, please see [https://hcp-lan.org/workproducts/apm-refresh-whitepaper-final.pdf](https://hcp-lan.org/workproducts/apm-refresh-whitepaper-final.pdf)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/LouisianaDLN"
        },
        "name" : "Louisiana Driver's License",
        "description" : "Louisiana Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MEDRT"
        },
        "name" : "Medication Reference Terminology (MED-RT)",
        "description" : "Medication Reference Terminology (MED-RT) is the evolutionary successor to the Veterans Health Administration National Drug File – Reference Terminology (VHA NDF-RT). Both are formal ontology representations of medication terminology, pharmacologic classifications, and asserted authoritative relationships between them.\r\n\r\nThe MED-RT code system includes relationships between MED-RT concepts and concepts in external code systems, as well as relationships between concepts only in the external code systems. The external code systems that MED-RT references include RxNorm, MeSH, and SNOMED CT US Edition.\r\n\r\nMED-RT can be downloaded from https://evs.nci.nih.gov/ftp1/MED-RT/ \r\n\r\nFor more information, please see https://ncit.nci.nih.gov/ncitbrowser/pages/vocabulary.jsf?dictionary=MED-RT"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MONDO"
        },
        "name" : "Mondo Disease Ontology",
        "description" : "The Mondo Disease Ontology is a semi-automatically constructed ontology that merges in multiple disease resources to yield a coherent merged ontology that contains cross-species disease terminology.\r\n\r\nNumerous sources for disease definitions and data models currently exist, which include HPO, OMIM, SNOMED CT, ICD, PhenoDB, MedDRA, MedGen, ORDO, DO, GARD, etc; however, these sources partially overlap and sometimes conflict, making it difficult to know definitively how they relate to each other. This has resulted in a proliferation of mappings between disease entries in different resources; however mappings are problematic: collectively, they are expensive to create and maintain. Most importantly, the mappings lack completeness, accuracy, and precision; as a result, mapping calls are often inconsistent between resources. The UMLS provides intermediate concepts through which other resources can be mapped, but these mappings suffer from the same challenges: they are not guaranteed to be one-to-one, especially in areas with evolving disease concepts such as rare disease.\r\n\r\nIn order to address the lack of a unified disease terminology that provides precise equivalences between disease concepts, we created Mondo, which provides a logic-based structure for unifying multiple disease resources.\r\n\r\nMondo’s development is coordinated with the Human Phenotype Ontology (HPO), which describes the individual phenotypic features that constitute a disease. Like the HPO, Mondo provides a hierarchical structure which can be used for classification or “rolling up” diseases to higher level groupings. It provides mappings to other disease resources, but in contrast to other mappings between ontologies, we precisely annotate each mapping using strict semantics, so that we know when two disease names or identifiers are equivalent or one-to-one, in contrast to simply being closely related.\r\n\r\nFor more information, see [https://mondo.monarchinitiative.org/](https://mondo.monarchinitiative.org/)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MSDRG"
        },
        "name" : "Medicare Severity Diagnosis Related Groups (MS-DRGs)",
        "description" : "Section 1886(d) of the Act specifies that the Secretary shall establish a classification system (referred to as DRGs) for inpatient discharges and adjust payments under the IPPS based on appropriate weighting factors assigned to each DRG.  Therefore, under the IPPS, we[CMS] pay for inpatient hospital services on a rate per discharge basis that varies according to the DRG to which a beneficiary's stay is assigned. The formula used to calculate payment for a specific case multiplies an individual hospital's payment rate per case by the weight of the DRG to which the case is assigned.  Each DRG weight represents the average resources required to care for cases in that particular DRG, relative to the average resources used to treat cases in all DRGs. Congress recognized that it would be necessary to recalculate the DRG relative weights periodically to account for changes in resource consumption.  Accordingly, section 1886(d)(4)(C) of the Act requires that the Secretary adjust the DRG classifications and relative weights at least annually.  These adjustments are made to reflect changes in treatment patterns, technology, and any other factors that may change the relative use of hospital resources.\r\n\r\nCurrently, cases are classified into Medicare Severity Diagnosis Related Groups (MS-DRGs) for payment under the IPPS based on the following information reported by the hospital: the principal diagnosis, up to 25 additional diagnoses, and up to 25 procedures performed during the stay.  In a small number of MS-DRGs, classification is also based on the age, sex, and discharge status of the patient.  Effective October 1, 2015, the diagnosis and procedure information is reported by the hospital using codes from the International Classification of Diseases, Tenth Revision, Clinical Modification (ICD-10-CM) and the International Classification of Diseases, Tenth Revision, Procedure Coding System (ICD-10-PCS).\r\n\r\nContent can be obtained on the CMS hosted page located at https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/AcuteInpatientPPS/MS-DRG-Classifications-and-Software \r\n\r\nThe DRGs are released annually with errata published infrequently. The fiscal year and release version should be noted (e.g., 2021.38.R1).\r\n\r\nRequests for annual MS-DRG classification changes and any MS-DRG related inquiries should be sent to the MSDRGClassificationChange@cms.hhs.gov mailbox.\r\n\r\nFor additional information on the MS-DRG system, including yearly reviews and changes to the MS-DRGs, please view prior Inpatient Prospective Payment System (IPPS) proposed and final rules located in the left navigational area of https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/AcuteInpatientPPS/MS-DRG-Classifications-and-Software"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MaineDLN"
        },
        "name" : "Maine Driver's License",
        "description" : "Maine Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MarylandDLN"
        },
        "name" : "Maryland Driver's License",
        "description" : "Maryland Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MassachusettsDLN"
        },
        "name" : "Massachusetts Driver's License",
        "description" : "Massachusetts Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MeSH"
        },
        "name" : "Medical Subject Headings",
        "description" : "The Medical Subject Headings (MeSH) thesaurus is a controlled and hierarchically-organized vocabulary produced by the National Library of Medicine. It is used for indexing, cataloging, and searching of biomedical and health-related information. MeSH includes the subject headings appearing in MEDLINE/PubMed, the NLM Catalog, and other NLM databases.\r\n\r\nMeSH can be downloaded from https://www.nlm.nih.gov/databases/download/mesh.html\r\n\r\nMeSH can be browsed here: https://meshb.nlm.nih.gov/search"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MichiganDLN"
        },
        "name" : "Michigan Driver's License",
        "description" : "Michigan Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MinnesotaDLN"
        },
        "name" : "Minnesota Driver's License",
        "description" : "Minnesota Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MississippiDLN"
        },
        "name" : "Mississippi Driver's License",
        "description" : "Mississippi Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MissouriDLN"
        },
        "name" : "Missouri Driver's License",
        "description" : "Missouri Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MontanaDLN"
        },
        "name" : "Montana Driver's License",
        "description" : "Montana Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NAICCompanyCodes"
        },
        "name" : "National Association of Insurance Commissioners (NAIC) Company Codes",
        "description" : "NAIC company codes, also referred to as NAIC numbers, are five-digit identification codes assigned by the National Association of Insurance Commissioners (NAIC) to every insurance company to identify them. NAIC maintains a list of all lines of insurance the company sells and a list of all jurisdictions in which the company is licensed.\r\n\r\nFor more information, see [https://content.naic.org/cis_consumer_information.htm](https://content.naic.org/cis_consumer_information.htm)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NCPDPBrandGenericIndicator"
        },
        "name" : "NCPDP Brand Generic Indicator",
        "description" : "Denotes brand or generic drug dispensed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NCPDPCompoundCode"
        },
        "name" : "NCPDP Compound Code",
        "description" : "Code indicating whether or not the prescription is a compound."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NCPDPDispensedAsWrittenOrProductSelectionCode"
        },
        "name" : "NCPDP Dispense As Written (DAW)/Product Selection Code",
        "description" : "Code indicating whether or not the prescriber's instructions regarding generic substitution were followed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NCPDPPharmacyType"
        },
        "name" : "NCPDP Pharmacy Type",
        "description" : "Type of pharmacy."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NCPDPPrescriptionOriginCode"
        },
        "name" : "NCPDP Prescription Origin Code",
        "description" : "Code indicating the origin of the prescription. Indicates whether the prescription was transmitted as an electronic prescription, by phone, by fax, or as a written paper copy."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NCPDPProviderIdentificationNumber"
        },
        "name" : "NCPDP Provider Identification Number",
        "description" : "A NCPDP assigned number that provides pharmacies with a unique, 7-digit national identifying number that assists pharmacies in their interactions with federal agencies and third party providers. The NCPDP Provider Identification Number was formerly known as the NABP (National Board of Pharmacy) number. NCPDP also enumerates licensed dispensing sites in the United States as part of its Alternate Site Enumeration Program Numbering System (ASEP). The purpose of this system is to enable a site to identify itself to all third party processors by one standard number, in order to adjudicate claims and receive reimbursement from prescription card programs."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NCPDPRejectCode"
        },
        "name" : "NCPDP Reject Code",
        "description" : "Code indicating the error encountered. Contains exception definitions for use when transaction processing cannot be completed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NCSBNID"
        },
        "name" : "National Council of State Boards of Nursing (NCSBN) ID",
        "description" : "Every licensed nurse is assigned an NCSBN ID. This unique number connects all licenses held by a nurse—regardless of license type and across jurisdictions. It supports efficient license management and verification while protecting personal identifiable information (PII), enabling data sharing between systems without compromising privacy. With one number, a nurse can easily access all licensure information in one place.\r\n\r\nNursys is the only national database for verification of nurse licensure, discipline and practice privileges for RNs, LPN/VNs and APRNs licensed in participating jurisdictions, including all states in the Nurse Licensure Compact (NLC).\r\n\r\nFor more information, see [https://www.ncsbn.org/nursing-regulation/licensure/license-verification/ncsbn-id.page](https://www.ncsbn.org/nursing-regulation/licensure/license-verification/ncsbn-id.page)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NDFRT"
        },
        "name" : "National Drug File Reference Terminology (NDF-RT)",
        "description" : "NDF-RT is a concept-oriented terminology, a collection of concepts, each of which represents a single, unique meaning. Every concept has one fully-specified name and an arbitrary number of other names, all of which are intended to mean the same thing and are therefore synonymous terms. Synonymous terms from external vocabulary sources may have associated unique identifiers. Publication of NDF-RT has ended. The Medication Reference Terminology (MED-RT) is the evolutionary successor to the NDF-RT."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NPU"
        },
        "name" : "Nomenclature for Properties and Units (NPU)",
        "description" : "The NPU terminology is a coding system and terminology for identification and communication of examinations for ordering and reporting results between clinical laboratories and laboratory information systems, hospital patient records, general practitioners (GP) and local and national data repositories."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NebraskaDLN"
        },
        "name" : "Nebraska Driver's License",
        "description" : "Nebraska Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NevadaDLN"
        },
        "name" : "Nevada Driver's License",
        "description" : "Nevada Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NewHampshireDLN"
        },
        "name" : "New Hampshire Driver's License",
        "description" : "New Hampshire Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NewJerseyDLN"
        },
        "name" : "New Jersey Driver's License",
        "description" : "New Jersey Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NewMexicoDLN"
        },
        "name" : "NewMexico Driver's License",
        "description" : "New Mexico Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NewYorkDLN"
        },
        "name" : "New York Driver's License",
        "description" : "New York Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NorthCarolinaDLN"
        },
        "name" : "North Carolina Driver's License",
        "description" : "North Carolina Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NorthDakotaDLN"
        },
        "name" : "North Dakota Driver's License",
        "description" : "North Dakota Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/OMOP"
        },
        "name" : "OHDSI Standardized Vocabularies",
        "description" : "Standardized Vocabularies are an integral part of the OMOP CDM. The Standardized Vocabularies contain all of the code sets, terminologies, vocabularies, nomenclatures, lexicons, thesauri, ontologies, taxonomies, classifications, abstractions, and other such data that are needed for:\r\n\r\n* Generation of the transformed (i.e., standardized) data from the raw source dataset into the OMOP CDM,\r\n\r\n* Searching, querying and extraction of the transformed data, and browsing and navigating the hierarchies of classes and abstractions inherent in the transformed data, and\r\n\r\n* Interpreting the meanings of the data.\r\n\r\nThis asset is available for free to anyone and can be [downloaded](https://athena.ohdsi.org/vocabulary/list) from the Atena download page in a delimited file format.\r\n\r\nTo manage the change of content, but to allow users to use and refer to a defined set of vocabularies, the whole resource is issued in releases. Major changes to the OMOP Vocabulary is released twice yearly in February and August. Instead of a major / minor version scheme, the releases of the Standardized Vocabularies component of the OMOP Vocabulary are tagged with the release date. Version label is based on the version of the CDM its aligned-to, plus a suffix appended incremented based on release date, for example: “v5.0 31-MAY-23.” At this time prior versions of the OMOP Vocabulary are not publicly available. Each release is accompanied by a [standard release note](https://github.com/OHDSI/Vocabulary-v5.0/releases), containing information about:\r\n\r\n* Domain changes\r\n\r\n* Newly added concepts grouped by vocabulary_id and domain\r\n\r\n* Standard concept changes\r\n\r\n* Newly added concepts and their standard concept status\r\n\r\n* Changes of concept mapping status grouped by target domain\r\n\r\nAdditional details about the OMOP Vocabulary release notes can be found [here](https://github.com/OHDSI/Vocabulary-v5.0/wiki/Releases)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/OhioDLN"
        },
        "name" : "Ohio Driver's License",
        "description" : "Ohio Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/OklahomaDLN"
        },
        "name" : "Oklahoma Driver's License",
        "description" : "Oklahoma Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/OpenEligibilityTaxonomy"
        },
        "name" : "Open Eligibility Taxonomy",
        "description" : "\"The Open Eligibility Project is a collaborative for a series of standards for the human services sector. The Open Eligibility taxonomy is a simple way to categorize human services and human situations. With these common categories, we, as service providers, navigators, and people in need, can find human services quickly and easily.\"\r\n\r\n\"The Open Eligibility taxonomy consists of two important concepts: Human Services and Human Situations.\r\n\r\nHuman Services are services offered by government or charitable organizations, and include things such as housing, food pantries or counseling services.\r\n\r\nHuman Situations are ways of describing attributes of a person that could help them find programs they are looking for, including examples like: veterans, physical disability or seniors.\"\r\n\r\nFor more information, see [https://support.findhelp.com/hc/en-us/articles/4404055283227-The-Open-Eligibility-Project](https://support.findhelp.com/hc/en-us/articles/4404055283227-The-Open-Eligibility-Project)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/OregonDLN"
        },
        "name" : "Oregon Driver's License",
        "description" : "Oregon Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/PMIXMethodofPayment"
        },
        "name" : "PMIX Method of Payment",
        "description" : "This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee.\r\n\r\nChair: [Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)\r\n\r\nVice Chair: [Chelsea Townsend](mailto:townseca@dhec.sc.gov)\r\n\r\nMethod of Payment: The PMIX equivalent to the DSP16 field of the ASAP format which identifies the primary method of payment for the prescription, for use in PDMP (Prescription Drug Monitoring Program) data exchanges."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/PMIXOpioidTreatmentCode"
        },
        "name" : "PMIX Opioid Treatment Code",
        "description" : "This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee.\r\n\r\nChair: [Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)\r\n\r\nVice Chair: [Chelsea Townsend](mailto:townseca@dhec.sc.gov)\r\n\r\nOpioid Treatment Code: The PMIX equivalent to the DSP24 field of the ASAP format which identifies whether or not the prescription is for the purpose of treating Opioid Use Disorder, and if so, the type of treatment. For use in PDMP (Prescription Drug Monitoring Program) data exchanges."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/PMIXPatientAlertCatCode"
        },
        "name" : "PMIX Patient Alert Category Code",
        "description" : "This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee.\r\n\r\nChair: [Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)\r\n\r\nVice Chair: [Chelsea Townsend](mailto:townseca@dhec.sc.gov)\r\n\r\nPatient Alert Category Code: In the event that the PDMP (Prescription Drug Monitoring Program) utilizes an “alert” functionality – a functionality that alerts an end user to some known or detected activity or condition regarding the requested patient – the alert category code indicates what type of alert was detected and is being sent by the PDMP."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/PMIXSpeciesTypeCode"
        },
        "name" : "PMIX Species Type Code",
        "description" : "This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee.\r\n\r\nChair: [Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)\r\n\r\nVice Chair: [Chelsea Townsend](mailto:townseca@dhec.sc.gov)\r\n\r\nSpecies Type Code: The PMIX equivalent to the PAT20 field of the ASAP format which identifies whether the patient is a human patient or a veterinary patient, for use in PDMP (Prescription Drug Monitoring Program) data exchanges."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/PMIXStatusCode"
        },
        "name" : "PMIX Status Code",
        "description" : "This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee.\r\n\r\nChair: [Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)\r\n\r\nVice Chair: [Chelsea Townsend](mailto:townseca@dhec.sc.gov)\r\n\r\nStatus Code: A code that indicates the status of the request to the PDMP (Prescription Drug Monitoring Program)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/PMIXTransmissionFormRxOriginCodeType"
        },
        "name" : "PMIX Transmission Form Of Rx Origin Code Type",
        "description" : "This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee.\r\n\r\nChair: [Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)\r\n\r\nVice Chair: [Chelsea Townsend](mailto:townseca@dhec.sc.gov)\r\n\r\nTransmission Form Of Rx Origin Code Type: The PMIX equivalent to the DSP12 field of the ASAP format which identifies by which method the pharmacy received the prescription, for use in PDMP (Prescription Drug Monitoring Program) data exchanges."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/PennsylvaniaDLN"
        },
        "name" : "Pennsylvania Driver's License",
        "description" : "Pennsylvania Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/PharmVar"
        },
        "name" : "Pharmacogene Variation",
        "description" : "\"The major focus of the Pharmacogene Consortium (PharmVar) is to serve as a repository for allelic variation, providing an official and unified allele designation system for the Pharmacogenetics (PGx) community and facilitating the translation of genotype into phenotype and clinical implementation of PGx. While the majority of pharmacogenes in PharmVar utilize the star nomenclature to describe variation, the provision of single nucleotide variants (SNVs), rather than haplotype, is preferred for some genes. Thus, PharmVar has two different page formats, A) using star nomenclature and B) using rs ID# as allele (referred to as ‘rs-format’).\r\n\r\nPharmVar designates human pharmacogene variation and houses allelic variants in the PharmVar database.\r\n\r\n* All submissions to PharmVar must use the submission form available on [www.PharmVar.org](https://www.pharmvar.org/) and be submitted to [submissions@PharmVar.org](mailto:submissions@PharmVar.org). Only complete submission requests will be accepted and processed.\r\n\r\n* PharmVar Gene Expert Panels will review each submission and make a recommendation to the PharmVar Steering Committee.\r\n\r\n* In this ‘Allele Designation Criteria and Evidence level’ document, we collectively refer to deviations from the RefSeq as “sequence variations” or \"SNVs\", including single nucleotide polymorphisms (SNPs) and small nucleotide insertions and deletions (indels) up to 50 bp. Copy number variants (i.e. entire or partial gene deletions and duplications), hybrid genes (e.g. CYP2D6/2D7 hybrids) and duplications containing non-identical gene copies (e.g. CYP2D6\\*36+\\*10) are referred to as CNVs or structural variants.\r\n\r\n* PharmVar applies the following criteria for allele designation. In rare cases, exceptions may be made to accommodate established star allele definitions to minimize impact on research, clinical labs and/or PGx implementation.\"\r\n\r\nPharmVar is released monthly (or more frequently) and uses a numbered database version format for each release.\r\n\r\nNote on updates to variants: The variants defined in association with a given PharmVar ID are immutable. When it is necessary to update the variant definitions for an associated concept, the existing allele and PharmVar ID are marked as \"retired\" and a new PharmVar ID is issued with the updated variant definitions.\r\n\r\nIn the context of the representation of PharmVar in HL7 standards:\r\n\r\n* The concept identifier is the PharmVar ID\r\n\r\n* The concept display name is the Allele Name\r\n\r\n* There are several concept properties associated with PharmVar concepts (Legacy Label, Variants, etc.)\r\n\r\n* The code system is represented with an is-a hierarchy"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/RARC"
        },
        "name" : "X12 Remittance Advice Remark Codes",
        "description" : "X12, chartered by the American National Standards Institute for more than 40 years, develops and maintains EDI standards and XML schemas which drive business processes globally. X12's diverse membership includes technologists and business process experts in health care, insurance, transportation, finance, government, supply chain and other industries.\r\n\r\nRemittance Advice Remark Codes (RARCs) are used to provide additional explanation for an adjustment already described by a Claim Adjustment Reason Code (CARC) or to convey information about remittance processing. Each RARC identifies a specific message as shown in the Remittance Advice Remark Code List. There are two types of RARCs, supplemental and informational. The majority of the RARCs are supplemental; these are generally referred to as RARCs without further distinction. Supplemental RARCs provide additional explanation for an adjustment already described by a CARC. The second type of RARC is informational; these RARCs are all prefaced with Alert: and are often referred to as Alerts. Alerts are used to convey information about remittance processing and are never related to a specific adjustment or CARC."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/RadLex"
        },
        "name" : "RadLex radiology lexicon",
        "description" : "RadLex is a comprehensive set of radiology terms for use in radiology reporting, decision support, data mining, data registries, education and research.\r\n\r\nRadLex Playbook is a project of the Radiological Society of North America (RSNA), and constitutes a portion of the RadLex ontology. Playbook aims to provide a standard system for naming radiology procedures, based on the elements which define an imaging exam such as modality and body part. By providing standard names and codes for radiologic studies, Playbook is intended to facilitate a variety of operational and quality improvement efforts, including workflow optimization, chargemaster management, radiation dose tracking, enterprise integration and image exchange.\r\n\r\nAs of RadLex Playbook version 2.5, a four-year project to harmonize RadLex Playbook with the radiology portion of the LOINC standard has been concluded, leading to the LOINC-RSNA Radiology Playbook which is jointly managed by the Regenstrief Institute (publisher of LOINC) and RSNA. This harmonized Playbook defines a new information model for describing imaging procedures, and identifies correspondences between RadLex Playbook codes and LOINC codes. (See https://loinc.org/download/loinc-users-guide and http://pubs.rsna.org/doi/pdf/10.1148/rg.2017160188 for details.) Note that RadLex Playbook codes start with \"RPID\" followed by a numerical value. LOINC codes consist of a numerical code, followed by a hyphen and a single additional digit (called the check digit). Note that in the future, new codes will be created in the LOINC format only, not the RPID format. New adopters are encouraged to use LOINC-format codes.\r\n\r\nLOINC-format codes may be accessed at http://search.loinc.org. New code requests may be submitted to the joint Regenstrief-RSNA governance committee at https://loinc.org/submissions/. \r\n\r\nFrom the RSNA website:\r\n\r\n\"We (RSNA) recognize the benefits that come from radiologists using common language to communicate diagnostic results. For this reason, RSNA produced RadLex®, a comprehensive set of radiology terms for use in radiology reporting, decision support, data mining, data registries, education and research.\r\n\r\nRadLex provides the foundation for vital data resources used in radiology:\r\n\r\n *  The LOINC/RSNA Radiology Playbook (http://playbook.radlex.org/playbook/SearchRadlexAction) \r\n *  RadElement Common Data Elements (http://www.radelement.org/) \r\n *  RadReport Radiology Reporting Templates (http://radreport.org/) \r\n\r\nThe development of RadLex has been supported by the National Institute of Biomedical Imaging and Bioengineering (NIBIB) and the cancer Biomedical Informatics Grid (caBIG) project.;\""
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/RhodeIslandDLN"
        },
        "name" : "Rhode Island Driver's License",
        "description" : "Rhode Island Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/SEVCO"
        },
        "name" : "Scientific Evidence Code System (SEVCO)",
        "description" : "The Scientific Evidence Code System (SEVCO) includes terms for describing scientific research, including study design, risk of bias, and statistical concepts. For additional derivation details for any term, see [https://fevir.net/resources/CodeSystem/27270](https://fevir.net/resources/CodeSystem/27270)\r\n\r\nFor more information, see [https://fevir.net/sevco](https://fevir.net/sevco)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/SO"
        },
        "name" : "Sequence Ontology",
        "description" : "\"The Sequence Ontology is a set of terms and relationships used to describe the features and attributes of biological sequence. SO includes different kinds of features which can be located on the sequence. Biological features are those which are defined by their disposition to be involved in a biological process.\"\r\n\r\n\"The Sequence Ontologies are provided as a resource to the biological community. They have the following obvious uses:\r\n\r\n* To provide for a structured controlled vocabulary for the description of primary annotations of nucleic acid sequence, e.g. the annotations shared by a DAS server ([BioDAS](http://www.biodas.org/documents/das2/das2_protocol.html), [Biosapiens DAS](http://www.biosapiens.info/page.php?page=das_portal)), or annotations encoded by [GFF3](http://www.sequenceontology.org/gff3.shtml).\"\r\n\r\n* To provide for a structured representation of these annotations within databases. Were genes within model organism databases to be annotated with these terms then it would be possible to query all these databases for, for example, all genes whose transcripts are edited, or trans-spliced, or are bound by a particular protein. One such genomic database is [Chado](http://www.gmod.org/wiki/Chado).\r\n\r\n* To provide a structured controlled vocabulary for the description of mutations at both the sequence and more gross level in the context of genomic databases.\"\r\n\r\n\"The Sequence Ontology is part of [OBO](http://www.obofoundry.org/). It has close links to other ontology projects such as the [RNAO consortium](http://roc.bgsu.edu/), and the [Biosapiens polypeptide features](http://www.ebi.ac.uk/ontology-lookup/browse.do?ontName=BS).\"\r\n\r\nThe content can be browsed [here](http://www.sequenceontology.org/browser/obob.cgi)\r\n\r\nThe content can be downloaded [here](https://github.com/The-Sequence-Ontology/SO-Ontologies)\r\n\r\nFor information on contributing, please see [here](https://github.com/The-Sequence-Ontology/SO-Ontologies#contributing)\r\n\r\nTo request a term or register feedback, see [here](https://github.com/The-Sequence-Ontology/SO-Ontologies/issues)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/SOPT"
        },
        "name" : "Source of Payment Typology",
        "description" : "The Source of Payment Typology (SOPT) is maintained by the Centers for Disease Control and Prevention (CDC), National Center for Health Statistics (NCHS).\r\n\r\nThe code system is used to allow consistent reporting of payer data to public health agencies for health care services and research, and to exchange health insurance payer and program information.\r\n\r\nSee [https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.3.221.5](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.3.221.5)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/SouthCarolinaDLN"
        },
        "name" : "South Carolina Driver's License",
        "description" : "South Carolina Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/SouthDakotaDLN"
        },
        "name" : "South Dakota Driver's License",
        "description" : "South Dakota Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/TNM"
        },
        "name" : "TNM Staging System",
        "description" : "The TNM Staging System was developed and is maintained by the AJCC and the Union for International Cancer Control (UICC). It is the most commonly used staging system by medical professionals around the world. The TNM classification system was developed as a tool for doctors to stage different types of cancer based on certain, standardized criteria. The TNM Staging System is based on the extent of the tumor (T), the extent of spread to the lymph nodes (N), and the presence of metastasis (M).\r\n\r\nHTA Note: Most content of TNM (V6) is in the SNOMED international release but not content from the most recent (V9).  In Europe many countries use TNM codes, taken from the book and referenced using an OID."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/TangramMedicalTerminology"
        },
        "name" : "OMAHA Tangram Medical Terminology",
        "description" : "OMAHA Tangram Medical Terminology is an ontology-based medical terminological resource developed by Chinese language. It helps to standardize the expression of Chinese medical terms, and improve the semantic interoperability between different systems. The terminology can be used in electronic health records, decision support systems and digital health researches, providing the functions of mapping, data capture, data mining, data registries, statistical analysis and reasoning etc.\r\n\r\nTangram Medical Terminology is released quarterly using the file name format as Tangram_Medical_Terminology _YYYYMMDD (Example: Tangram _Medical_Terminology _20200120). For more information, please visit http://wiki.omaha.org.cn/pages/viewpage.action?pageId=31425763 \r\n\r\nFor more information, see https://term.omaha.org.cn/."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/TennesseeDLN"
        },
        "name" : "Tennessee Driver's License",
        "description" : "Tennessee Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/TexasDLN"
        },
        "name" : "Texas Driver's License",
        "description" : "Texas Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/UNII"
        },
        "name" : "Unique Ingredient Identifier (UNII)",
        "description" : "A UNII is a non-proprietary, free, unique, unambiguous, nonsemantic, alphanumeric identifier based on a substance's molecular structure and/or descriptive information. UNII identifiers are generated based on scientific identity characteristics using ISO 11238 data elements. UNII availability does not imply any regulatory review or approval. Synonyms and mappings are based on the best public information available at the time of publication."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/USDEANumber"
        },
        "name" : "United States Drug Enforcement Agency (DEA) Number",
        "description" : "A DEA number is a number assigned to a health care provider (such as a medical practitioner, dentist, or veterinarian) by the U.S. Drug Enforcement Administration allowing them to write prescriptions for controlled substances. Legally, the DEA number is solely to be used for tracking controlled substance prescribers and prescriptions. It is often used by the industry, however, as a general \"prescriber number\".\r\n\r\nA single person may have multiple DEA numbers.  In particular, a prescriber who practices in multiple states or jurisdictions must have a DEA-issued number specific to each state or jurisdiction.\r\n\r\nA DEA number can be structurally validated:\r\n\r\n1. Add together the first, third, and fifth digits.\r\n\r\n2. Add together the second, fourth, and sixth digits. Multiply the sum by 2.\r\n\r\n3. Add together the totals from Step 1 and Step 2.\r\n\r\n4. Verify that the last digit of the result of Step 3 matches the check digit of the DEA number.\r\n\r\nThis validates that the number is a valid DEA number, but does not confirm that the DEA number is active or assigned to the person presenting it."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/USEIN"
        },
        "name" : "United States Employer Identification Number",
        "description" : "An Employer Identification Number (EIN) is also known as a Federal Tax Identification Number, and is used to identify a business entity."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/USPSStateCodes"
        },
        "name" : "USPS State Codes",
        "description" : "State Codes as defined by US Postal Service\r\n\r\nFor more information, see [https://pe.usps.com/text/pub28/28apb.htm](https://pe.usps.com/text/pub28/28apb.htm)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/UniProt"
        },
        "name" : "Universal Protein Resource",
        "description" : "The Universal Protein Resource (UniProt) is a comprehensive resource for protein sequence and annotation data. The UniProt databases are the [UniProt Knowledgebase (UniProtKB)](https://www.uniprot.org/help/uniprotkb), the [UniProt Reference Clusters (UniRef)](https://www.uniprot.org/help/uniref[), and the [UniProt Archive (UniParc)](https://www.uniprot.org/help/uniparc).\r\n\r\nUniProt Technical Information: [https://www.uniprot.org/help/technical](https://www.uniprot.org/help/technical).\r\n\r\nExamples of records from FDA GSRS (Global Substance Registration System) using UniProt [Accession number](https://www.uniprot.org/help/accession_numbers) identifiers:\r\n\r\n 1. Minor histocompatibility antigen HA-1\r\n\r\n     - GSRS [record](https://gsrs.ncats.nih.gov/ginas/app/ui/substances/826ee7a3-7441-4dd1-9adb-e0ef04caba18)  (note UNIPROT accession number is listed under \"Codes - Identifiers\")\r\n\r\n     - UNIPROT Accession Number identifier: [O78181](https://www.uniprot.org/uniprotkb/O78181/entry)\r\n\r\n 2. PULMONARY SURFACTANT-ASSOCIATED PROTEIN C (BOS TAURUS)\r\n\r\n     - GSRS [record](https://gsrs.ncats.nih.gov/ginas/app/ui/substances/6ef2d88a-75db-4ab5-9f46-e81f63e99e74) (note UNIPROT accession number is listed under \"Codes - Identifiers\")\r\n\r\n     - UNIPROT Accession Number identifier: [P15783](https://www.uniprot.org/uniprotkb/P15781/entry)     \r\n\r\nUniProt releases are published every 8 weeks (4 weeks until the last 2019 release, 2019_11), with possible exceptions in January and summer due to reduced staff during holidays.\r\n\r\nThe current release number format is YYYY_XX where YYYY is the calendar year and XX a 2-digit number that is incremented for each release of a given year, e.g. 2010_01, 2010_02, etc.\r\n\r\nFor more information, see [https://www.uniprot.org/help/synchronization](https://www.uniprot.org/help/synchronization)\r\n\r\nOther useful links:\r\n\r\n   1. [API access](https://www.uniprot.org/help/api)\r\n\r\n   2. [Proteins (UniProtKB)](https://www.uniprot.org/uniprotkb?query=*)\r\n\r\n   3. [Species (Proteomes)](https://www.uniprot.org/proteomes?query=*)\r\n\r\n   4. [Protein clusters (UniRef)](https://www.uniprot.org/uniref?query=*)\r\n\r\n   5. [Sequence archive (UniParc)](https://www.uniprot.org/uniparc?query=*)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/UtahDLN"
        },
        "name" : "Utah Driver's License",
        "description" : "Utah Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/VermontDLN"
        },
        "name" : "Vermont Driver's License",
        "description" : "Vermont Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/VirginiaDLN"
        },
        "name" : "Virginia Driver's License",
        "description" : "Virginia Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/W3CDID"
        },
        "name" : "W3C Decentralized Identifier (DID)",
        "description" : "\"[Decentralized identifiers](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) (DIDs) are a new type of identifier that enables verifiable, decentralized digital identity. A DID refers to any subject (e.g., a person, organization, thing, data model, abstract entity, etc.) as determined by the controller of the [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers). In contrast to typical, federated identifiers, [DIDs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) have been designed so that they may be decoupled from centralized registries, identity providers, and certificate authorities. Specifically, while other parties might be used to help enable the discovery of information related to a [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers), the design enables the controller of a [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) to prove control over it without requiring permission from any other party. [DIDs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) are [URIs](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-uri) that associate a [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects) with a [DID document](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-documents) allowing trustable interactions associated with that subject.\r\n\r\nEach [DID document](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-documents) can express cryptographic material, [verification methods](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-verification-method), or [services](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-service), which provide a set of mechanisms enabling a [DID controller](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-controllers) to prove control of the [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers). [Services](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-service) enable trusted interactions associated with the [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects). A [DID](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-decentralized-identifiers) might provide the means to return the [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects) itself, if the [DID subject](https://www.w3.org/TR/2022/REC-did-core-20220719/#dfn-did-subjects) is an information resource such as a data model.\"\r\n\r\nFor more information, see [https://www.w3.org/TR/did-core/](https://www.w3.org/TR/did-core/)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/WashingtonDLN"
        },
        "name" : "Washington Driver's License",
        "description" : "Washington Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/WestVirginiaDLN"
        },
        "name" : "West Virginia Driver's License",
        "description" : "West Virginia Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/WisconsinDLN"
        },
        "name" : "Wisconsin Driver's License",
        "description" : "Wisconsin Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/WyomingDLN"
        },
        "name" : "Wyoming Driver's License",
        "description" : "Wyoming Motor Vehicle Bureau"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/X12AmbulanceTransportReasonCodes"
        },
        "name" : "X12 Ambulance Transport Reason Codes",
        "description" : "\"X12, chartered by the American National Standards Institute for more than 40 years, develops and maintains EDI standards and XML schemas which drive business processes globally. X12's diverse membership includes technologists and business process experts in health care, insurance, transportation, finance, government, supply chain and other industries.\"\n\nThe X12 Ambulance Transport Reason Codes indicate the reason for ambulance transport. These codes are listed within an X12 implementation guide (TR3) and maintained by X12.\n\nA list of codes and associated descriptions established, maintained, and published as part of an X12 Standard."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/X12ClaimAdjustmentReasonCodes"
        },
        "name" : "X12 Claim Adjustment Reason Codes",
        "description" : "\"X12, chartered by the American National Standards Institute for more than 40 years, develops and maintains EDI standards and XML schemas which drive business processes globally. X12's diverse membership includes technologists and business process experts in health care, insurance, transportation, finance, government, supply chain and other industries.\"\r\n\r\nThe X12 Claim Adjustment Reason Codes describe why a claim or service line was paid differently than it was billed. These codes are listed within an X12 implementation guide (TR3) and maintained by X12.\r\n\r\nExternal code lists maintained by X12 and external code lists maintained by others and distributed by WPC on behalf of the maintainer can be found here: [here](https://x12.org/codes)\r\n\r\nClick on the name of any external code list to access more information about the code list, view the codes, or submit a maintenance request. These external code lists were previously published on either [www.wpc-edi.com/reference](http://www.wpc-edi.com/reference) or [www.x12.org/codes](https://x12.org/codes)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/X12ServiceTypeCodes"
        },
        "name" : "X12 Service Type Codes",
        "description" : "\"X12, chartered by the American National Standards Institute for more than 40 years, develops and maintains EDI standards and XML schemas which drive business processes globally. X12's diverse membership includes technologists and business process experts in health care, insurance, transportation, finance, government, supply chain and other industries.\"\r\n\r\nThe X12 Service Type Codes identify business groupings for health care services or benefits. These codes are listed within an X12 implementation guide (TR3) and maintained by X12.\r\n\r\nExternal code lists maintained by X12 and external code lists maintained by others and distributed by WPC on behalf of the maintainer can be found here: [https://x12.org/codes](https://x12.org/codes)\r\n\r\nClick on the name of any external code list to access more information about the code list, view the codes, or submit a maintenance request. These external code lists were previously published on either [http://www.wpc-edi.com/reference](http://www.wpc-edi.com/reference) or [http://www.x12.org/codes](http://www.x12.org/codes).\r\n\r\nIf you have questions about these lists, submit them on the [X12 Feedback form](https://x12.org/resources/feedback).\r\n\r\n\"All X12 products are subject to this IP policy, including published and draft works.\r\n\r\nX12 is the only organization authorized to grant permission for use of X12 products. Users of all X12 products should make sure that they understand the permissible uses, as well as the limitations on such usage, as outlined below.\"\r\n\r\nAdditional IP information can be found here: [https://x12.org/products/ip-use](https://x12.org/products/ip-use)\r\n\r\n\"Send an email to [ip@x12.org](mailto:ip@x12.org) to request permission to reproduce X12 IP. Include your name, organization, title, address, city, state, zip, email, a detailed description of the Submitted Artifact, including the underlying or cited X12 Product, and a detailed description of the intended audience and planned distribution method for the Artifact.\"\r\n\r\nAdditional information on X12 licensing program can be found here: [https://x12.org/products/licensing-program](https://x12.org/products/licensing-program)\r\n\r\nTo purchase code list subscriptions call (425) 562-2245 or email [admin@wpc-edi.com](mailto:admin@wpc-edi.com)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ca-hc-dpd-schedule"
        },
        "name" : "Health Canada Drug Product Database - Schedule",
        "description" : "The Code System describes the characteristics of drugs for use in Canada.\\r\\n\\r\\nDrugs in Canada are assigned one or more of the following schedules, according to the Food and Drug Regulations, and the Controlled Drugs and Substances Act.\\r\\n\\r\\n- Prescription (prescription drugs included in the Prescription Drug List)\\r\\n\\r\\n- Prescription Recommended (drugs that are recommended to be listed on the Prescription Drug List)\\r\\n\\r\\n- Schedule G (control drugs)\\r\\n\\r\\n- Schedule G (Controlled Drugs and Substances Act [CDSA] III)\\r\\n\\r\\n- Schedule G (CDSA IV)\\r\\n\\r\\n- Schedule C (drugs listed in Schedule C of the Food and Drugs Act, for example, radiopharmaceutical drugs)\\r\\n\\r\\n- Schedule D (drugs listed in Schedule D of the Food and Drugs Act, ie. biological products)\\r\\n\\r\\n- Narcotic (Narcotic Control Act)\\r\\n\\r\\n- Narcotic (CDSA I)\\r\\n\\r\\n- Narcotic (CDSA II)\\r\\n\\r\\n- Targeted (CDSA IV)\\r\\n\\r\\n- CDSA Recommended- Undergoing Regulatory Amendment to add this new substance to Controlled Drugs Substances Act\\r\\n\\r\\n- OTC (over the counter drugs that do not appear on a schedule or are not recommended to appear on any schedule)\\r\\n\\r\\n- Ethical: a drug that, in accordance with Federal Legislation, does not require a prescription, but that is generally prescribed by a medical practitioner. Ethical products are unscheduled non-prescription professional use products (e.g. MRI contrast agents, hemodialysis solutions) and a few emergency use products (e.g. nitroglycerine)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ClinVarV"
        },
        "name" : "ClinVar Variant ID",
        "description" : "ClinVar is a freely accessible, public archive of reports of the relationships among human variations and phenotypes, with supporting evidence. ClinVar thus facilitates access to and communication about the relationships asserted between human variation and observed health status, and the history of that interpretation. ClinVar processes submissions reporting variants found in patient samples, assertions made regarding their clinical significance, information about the submitter, and other supporting data. The alleles described in submissions are mapped to reference sequences, and reported according to the HGVS standard. ClinVar then presents the data for interactive users as well as those wishing to use ClinVar in daily workflows and other local applications. ClinVar works in collaboration with interested organizations to meet the needs of the medical genetics community as efficiently and effectively as possible. Read more about using ClinVar.\r\n\r\nClinVar supports submissions of differing levels of complexity. The submission may be as simple as a representation of an allele and its interpretation (sometimes termed a variant-level submission), or as detailed as providing multiple types of structured observational (case-level) or experimental evidence about the effect of the variation on phenotype. A major goal is to support computational (re)evaluation, both of genotypes and assertions, and to enable the ongoing evolution and development of knowledge regarding variations and associated phenotypes. ClinVar is an active partner of the ClinGen project, providing data for evaluation and archiving the results of interpretation by recognized expert panels and providers of practice guidelines (see https://www.ncbi.nlm.nih.gov/clinvar/docs/review_guidelines/). ClinVar archives and versions submissions which means that when submitters update their records, the previous version is retained for review. Read more about submitting data to ClinVar at https://www.ncbi.nlm.nih.gov/clinvar/docs/submit. \r\n\r\nThe level of confidence in the accuracy of variation calls and assertions of clinical significance depends in large part on the supporting evidence, so this information, when available, is collected and visible to users. Because the availability of supporting evidence may vary, particularly in regard to retrospective data aggregated from published literature, the archive accepts submissions from multiple groups, and aggregates related information, to reflect transparently both consensus and conflicting assertions of clinical significance. A review status is also assigned to any assertion, to support communication about the trustworthiness of any assertion. Domain experts are encouraged to apply for recognition as an expert panel (more info at https://www.ncbi.nlm.nih.gov/clinvar/docs/review_guidelines/). \r\n\r\nAccessions, with the format SCV000000000.0, are assigned to each submitted record. If there are multiple submitted records about the same variation/condition pair, they are aggregated within ClinVar's data flow and reported as a reference accession with the format RCV000000000.0. Because of this model, one variant will be included in multiple RCV accessions whenever different conditions are reported for that variant. Submitted records for the same variation are also aggregated and reported as an accession with the format VCV000000000.0. This aggregation lets a user review all submitted data for a variant, regardless of the condition for which it was interpreted.\r\n\r\nClinVar archives submitted information, and adds identifiers and other data that may be available about a variant or condition from other public resources. However ClinVar neither curates content nor modifies interpretations independent of an explicit submission. If you have data that differs from what is currently represented in ClinVar, we encourage you to submit your data and the evidence supporting your interpretation. There is a submission wizard to guide you through that process. See https://www.ncbi.nlm.nih.gov/variation/clinvar_single_wizard/. \r\n\r\nIf you are submitting variants that were interpreted as part of work funded by the NIH, please consult your program officer about expectations for submissions to ClinVar."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/cmsMBI"
        },
        "name" : "Medicare Beneficiary Identifier (United States)",
        "description" : "Medicare Beneficiary Identifier (MBI) number is a unique identifier of a beneficiary used for Medicare entitlement and billing purposes. Medicare Beneficiary Identifiers are represented without any spaces or dashes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/dui"
        },
        "name" : "DICOM Unique Id",
        "description" : "An OID issued under DICOM OID rules. DICOM OIDs are represented as plain OIDs, with a prefix of \"urn:oid:\". See https://www.dicomstandard.org/"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/gtin"
        },
        "name" : "GTIN Global Trade Item Number",
        "description" : "The GS1 GTIN is a globally unique identifier of trade items. A trade item is any item (product or service) upon which there is a need to retrieve pre-defined information and that may be priced, or ordered, or invoiced at any point in any supply chain. Note: GTINs may be used in both Codes (http://build.fhir.org/datatypes.html#Coding) and Identifiers (http://build.fhir.org/datatypes.html#Identifier)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ca-hc-din"
        },
        "name" : "Health Canada Drug Id Number",
        "description" : "A Drug Identification Number (DIN) is a computer-generated eight digit number assigned by Health Canada to a drug product prior to being marketed in Canada. It uniquely identifies all drug products sold in a dosage form in Canada and is located on the label of prescription and over-the-counter drug products that have been evaluated and authorized for sale in Canada.  A DIN uniquely identifies the following product characteristics:\r\n\r\n *  manufacturer\r\n *  product name\r\n *  active ingredient(s)\r\n *  strength(s) of active ingredient(s)\r\n *  pharmaceutical form, and\r\n *  route of administration.\r\n\r\nNote: The number has a leading zero.\r\n\r\nFurther information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/applications-submissions/guidance-documents/regulatory-requirements-drug-identification-numbers/document.html"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/hcpcs-Level-II"
        },
        "name" : "Healthcare Common Procedure Coding System (HCPCS) level II alphanumeric codes",
        "description" : "The Level II HCPCS codes, which are established by CMS's Alpha-Numeric Editorial Panel, primarily represent items and supplies and non-physician services not covered by the American Medical Association's Current Procedural Terminology-4 (CPT-4) codes; Medicare, Medicaid, and private health insurers use HCPCS procedure and modifier codes for claims processing.  Level II alphanumeric procedure and modifier codes comprise the A to V range."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iri"
        },
        "name" : "Internationalized Resource Identifier (IRI)",
        "description" : "As defined by RFC 3987 (http://www.ietf.org/rfc/rfc3987.txt). Internationalized Resource Identifiers (IRIs) are the internationalized version of URIs (which are also defined as a NamingSystem as https://terminology.hl7.org/4.0.0/NamingSystem-uri.html) that allow Unicode characters to be used in the identifier with some restrictions, which was defined by the Internet Engineering Task Force (IETF) in 2005. An IRI such as 'https://hi.wikipedia.org/wiki/हृदय' can be percent-encoded into the URI 'https://hi.wikipedia.org/wiki/%E0%A4%B9%E0%A5%83%E0%A4%A6%E0%A4%AF' to be used as a URL, but the IRI is easier to read, particularly for readers of non-Latin languages, and is natively supported by many tools, including many browsers, HTTP libraries, and in the Resource Description Framework (RDF). IRI values SHALL NOT be used in Identifier.system or Coding.system. They SHALL only be used in Identifier.value (where Identifier.system = urn:ietf:rfc:3987)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/medicareHIC"
        },
        "name" : "United States Medicare Number",
        "description" : "Medicare Health Insurance Claim # (HIC) is a unique identifier of a beneficiary used for Medicare entitlement and billing purposes. Medicare Numbers (HIC or HICN) are represented without any spaces or dashes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/npi"
        },
        "name" : "United States National Provider Identifier",
        "description" : "National Provider Identifier"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/IANATimeZoneDatabase"
        },
        "name" : "IANA Time Zone Database",
        "description" : "The Time Zone Database (often called tz or zoneinfo) contains code and data that represent the history of local time for many representative locations around the globe. It is updated periodically to reflect changes made by political bodies to time zone boundaries, UTC offsets, and daylight-saving rules."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ABW"
        },
        "name" : "Passport Numbers Namespace for ARUBA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ARUBA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-AFG"
        },
        "name" : "Passport Numbers Namespace for AFGHANISTAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of AFGHANISTAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-AGO"
        },
        "name" : "Passport Numbers Namespace for ANGOLA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ANGOLA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-AIA"
        },
        "name" : "Passport Numbers Namespace for ANGUILLA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ANGUILLA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ALA"
        },
        "name" : "Passport Numbers Namespace for ALAND ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ALAND ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ALB"
        },
        "name" : "Passport Numbers Namespace for ALBANIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ALBANIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-AND"
        },
        "name" : "Passport Numbers Namespace for ANDORRA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ANDORRA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ANT"
        },
        "name" : "Passport Numbers Namespace for NETHERLANDS ANTILLES",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NETHERLANDS ANTILLES.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ARE"
        },
        "name" : "Passport Numbers Namespace for UNITED ARAB EMIRATES",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of UNITED ARAB EMIRATES.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ARG"
        },
        "name" : "Passport Numbers Namespace for ARGENTINA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ARGENTINA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ARM"
        },
        "name" : "Passport Numbers Namespace for ARMENIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ARMENIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ASM"
        },
        "name" : "Passport Numbers Namespace for AMERICAN SAMOA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of AMERICAN SAMOA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ATA"
        },
        "name" : "Passport Numbers Namespace for ANTARCTICA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ANTARCTICA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ATF"
        },
        "name" : "Passport Numbers Namespace for FRENCH SOUTHERN TERRITORIES",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of FRENCH SOUTHERN TERRITORIES.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ATG"
        },
        "name" : "Passport Numbers Namespace for ANTIGUA AND BARBUDA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ANTIGUA AND BARBUDA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-AUS"
        },
        "name" : "Passport Numbers Namespace for AUSTRALIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of AUSTRALIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-AUT"
        },
        "name" : "Passport Numbers Namespace for AUSTRIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of AUSTRIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-AZE"
        },
        "name" : "Passport Numbers Namespace for AZERBAIJAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of AZERBAIJAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BDI"
        },
        "name" : "Passport Numbers Namespace for BURUNDI",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BURUNDI.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BEL"
        },
        "name" : "Passport Numbers Namespace for BELGIUM",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BELGIUM.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BEN"
        },
        "name" : "Passport Numbers Namespace for BENIN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BENIN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BFA"
        },
        "name" : "Passport Numbers Namespace for BURKINA FASO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BURKINA FASO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BGD"
        },
        "name" : "Passport Numbers Namespace for BANGLADESH",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BANGLADESH.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BGR"
        },
        "name" : "Passport Numbers Namespace for BULGARIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BULGARIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BHR"
        },
        "name" : "Passport Numbers Namespace for BAHRAIN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BAHRAIN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BHS"
        },
        "name" : "Passport Numbers Namespace for BAHAMAS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BAHAMAS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BIH"
        },
        "name" : "Passport Numbers Namespace for BOSNIA AND HERZEGOVINA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BOSNIA AND HERZEGOVINA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BLM"
        },
        "name" : "Passport Numbers Namespace for SAINT BARTHELEMY",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SAINT BARTHELEMY.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BLR"
        },
        "name" : "Passport Numbers Namespace for BELARUS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BELARUS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BLZ"
        },
        "name" : "Passport Numbers Namespace for BELIZE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BELIZE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BMU"
        },
        "name" : "Passport Numbers Namespace for BERMUDA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BERMUDA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BOL"
        },
        "name" : "Passport Numbers Namespace for BOLIVIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BOLIVIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BRA"
        },
        "name" : "Passport Numbers Namespace for BRAZIL",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BRAZIL.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BRB"
        },
        "name" : "Passport Numbers Namespace for BARBADOS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BARBADOS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BRN"
        },
        "name" : "Passport Numbers Namespace for BRUNEI DARUSSALAM",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BRUNEI DARUSSALAM.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BTN"
        },
        "name" : "Passport Numbers Namespace for BHUTAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BHUTAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BVT"
        },
        "name" : "Passport Numbers Namespace for BOUVET ISLAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BOUVET ISLAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-BWA"
        },
        "name" : "Passport Numbers Namespace for BOTSWANA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BOTSWANA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CAF"
        },
        "name" : "Passport Numbers Namespace for CENTRAL AFRICAN REPUBLIC",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CENTRAL AFRICAN REPUBLIC.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CAN"
        },
        "name" : "Passport Numbers Namespace for CANADA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CANADA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CCK"
        },
        "name" : "Passport Numbers Namespace for COCOS (KEELING) ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of COCOS (KEELING) ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CHE"
        },
        "name" : "Passport Numbers Namespace for SWITZERLAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SWITZERLAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CHL"
        },
        "name" : "Passport Numbers Namespace for CHILE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CHILE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CHN"
        },
        "name" : "Passport Numbers Namespace for CHINA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CHINA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CIV"
        },
        "name" : "Passport Numbers Namespace for COTE D'IVOIRE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of COTE D'IVOIRE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CMR"
        },
        "name" : "Passport Numbers Namespace for CAMEROON",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CAMEROON.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-COD"
        },
        "name" : "Passport Numbers Namespace for CONGO, THE DEMOCRATIC REPUBLIC OF THE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CONGO, THE DEMOCRATIC REPUBLIC OF THE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-COG"
        },
        "name" : "Passport Numbers Namespace for CONGO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CONGO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-COK"
        },
        "name" : "Passport Numbers Namespace for COOK ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of COOK ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-COL"
        },
        "name" : "Passport Numbers Namespace for COLOMBIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of COLOMBIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-COM"
        },
        "name" : "Passport Numbers Namespace for COMOROS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of COMOROS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CPV"
        },
        "name" : "Passport Numbers Namespace for CAPE VERDE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CAPE VERDE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CRI"
        },
        "name" : "Passport Numbers Namespace for COSTA RICA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of COSTA RICA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CUB"
        },
        "name" : "Passport Numbers Namespace for CUBA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CUBA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CXR"
        },
        "name" : "Passport Numbers Namespace for CHRISTMAS ISLAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CHRISTMAS ISLAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CYM"
        },
        "name" : "Passport Numbers Namespace for CAYMAN ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CAYMAN ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CYP"
        },
        "name" : "Passport Numbers Namespace for CYPRUS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CYPRUS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-CZE"
        },
        "name" : "Passport Numbers Namespace for CZECH REPUBLIC",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CZECH REPUBLIC.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-DEU"
        },
        "name" : "Passport Numbers Namespace for GERMANY",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GERMANY.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-DJI"
        },
        "name" : "Passport Numbers Namespace for DJIBOUTI",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of DJIBOUTI.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-DMA"
        },
        "name" : "Passport Numbers Namespace for DOMINICA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of DOMINICA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-DNK"
        },
        "name" : "Passport Numbers Namespace for DENMARK",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of DENMARK.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-DOM"
        },
        "name" : "Passport Numbers Namespace for DOMINICAN REPUBLIC",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of DOMINICAN REPUBLIC.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-DZA"
        },
        "name" : "Passport Numbers Namespace for ALGERIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ALGERIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ECU"
        },
        "name" : "Passport Numbers Namespace for ECUADOR",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ECUADOR.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-EGY"
        },
        "name" : "Passport Numbers Namespace for EGYPT",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of EGYPT.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ERI"
        },
        "name" : "Passport Numbers Namespace for ERITREA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ERITREA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ESH"
        },
        "name" : "Passport Numbers Namespace for WESTERN SAHARA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of WESTERN SAHARA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ESP"
        },
        "name" : "Passport Numbers Namespace for SPAIN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SPAIN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-EST"
        },
        "name" : "Passport Numbers Namespace for ESTONIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ESTONIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ETH"
        },
        "name" : "Passport Numbers Namespace for ETHIOPIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ETHIOPIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-FIN"
        },
        "name" : "Passport Numbers Namespace for FINLAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of FINLAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-FJI"
        },
        "name" : "Passport Numbers Namespace for FIJI",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of FIJI.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-FLK"
        },
        "name" : "Passport Numbers Namespace for FALKLAND ISLANDS (MALVINAS)",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of FALKLAND ISLANDS (MALVINAS).  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-FRA"
        },
        "name" : "Passport Numbers Namespace for FRANCE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of FRANCE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-FRO"
        },
        "name" : "Passport Numbers Namespace for FAROE ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of FAROE ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-FSM"
        },
        "name" : "Passport Numbers Namespace for MICRONESIA, FEDERATED STATES OF",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MICRONESIA, FEDERATED STATES OF.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GAB"
        },
        "name" : "Passport Numbers Namespace for GABON",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GABON.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GBR"
        },
        "name" : "Passport Numbers Namespace for UNITED KINGDOM",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of UNITED KINGDOM.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GEO"
        },
        "name" : "Passport Numbers Namespace for GEORGIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GEORGIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GGY"
        },
        "name" : "Passport Numbers Namespace for GUERNSEY",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GUERNSEY.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GHA"
        },
        "name" : "Passport Numbers Namespace for GHANA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GHANA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GIB"
        },
        "name" : "Passport Numbers Namespace for GIBRALTAR",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GIBRALTAR.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GIN"
        },
        "name" : "Passport Numbers Namespace for GUINEA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GUINEA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GLP"
        },
        "name" : "Passport Numbers Namespace for GUADELOUPE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GUADELOUPE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GMB"
        },
        "name" : "Passport Numbers Namespace for GAMBIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GAMBIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GNB"
        },
        "name" : "Passport Numbers Namespace for GUINEA-BISSAU",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GUINEA-BISSAU.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GNQ"
        },
        "name" : "Passport Numbers Namespace for EQUATORIAL GUINEA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of EQUATORIAL GUINEA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GRC"
        },
        "name" : "Passport Numbers Namespace for GREECE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GREECE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GRD"
        },
        "name" : "Passport Numbers Namespace for GRENADA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GRENADA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GRL"
        },
        "name" : "Passport Numbers Namespace for GREENLAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GREENLAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GTM"
        },
        "name" : "Passport Numbers Namespace for GUATEMALA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GUATEMALA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GUF"
        },
        "name" : "Passport Numbers Namespace for FRENCH GUIANA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of FRENCH GUIANA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GUM"
        },
        "name" : "Passport Numbers Namespace for GUAM",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GUAM.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-GUY"
        },
        "name" : "Passport Numbers Namespace for GUYANA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of GUYANA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-HKG"
        },
        "name" : "Passport Numbers Namespace for HONG KONG",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of HONG KONG.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-HMD"
        },
        "name" : "Passport Numbers Namespace for HEARD ISLAND AND MCDONALD ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of HEARD ISLAND AND MCDONALD ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-HND"
        },
        "name" : "Passport Numbers Namespace for HONDURAS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of HONDURAS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-HRV"
        },
        "name" : "Passport Numbers Namespace for CROATIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CROATIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-HTI"
        },
        "name" : "Passport Numbers Namespace for HAITI",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of HAITI.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-HUN"
        },
        "name" : "Passport Numbers Namespace for HUNGARY",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of HUNGARY.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-IDN"
        },
        "name" : "Passport Numbers Namespace for INDONESIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of INDONESIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-IMM"
        },
        "name" : "Passport Numbers Namespace for ISLE OF MAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ISLE OF MAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-IND"
        },
        "name" : "Passport Numbers Namespace for INDIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of INDIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-IOT"
        },
        "name" : "Passport Numbers Namespace for BRITISH INDIAN OCEAN TERRITORY",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of BRITISH INDIAN OCEAN TERRITORY.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-IRL"
        },
        "name" : "Passport Numbers Namespace for IRELAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of IRELAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-IRN"
        },
        "name" : "Passport Numbers Namespace for IRAN (ISLAMIC REPUBLIC OF)",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of IRAN (ISLAMIC REPUBLIC OF).  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-IRQ"
        },
        "name" : "Passport Numbers Namespace for IRAQ",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of IRAQ.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ISL"
        },
        "name" : "Passport Numbers Namespace for ICELAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ICELAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ISR"
        },
        "name" : "Passport Numbers Namespace for ISRAEL",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ISRAEL.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ITA"
        },
        "name" : "Passport Numbers Namespace for ITALY",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ITALY.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-JAM"
        },
        "name" : "Passport Numbers Namespace for JAMAICA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of JAMAICA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-JEY"
        },
        "name" : "Passport Numbers Namespace for JERSEY",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of JERSEY.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-JOR"
        },
        "name" : "Passport Numbers Namespace for JORDAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of JORDAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-JPN"
        },
        "name" : "Passport Numbers Namespace for JAPAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of JAPAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-KAZ"
        },
        "name" : "Passport Numbers Namespace for KAZAKHSTAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of KAZAKHSTAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-KEN"
        },
        "name" : "Passport Numbers Namespace for KENYA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of KENYA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-KGZ"
        },
        "name" : "Passport Numbers Namespace for KYRGYZSTAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of KYRGYZSTAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-KHM"
        },
        "name" : "Passport Numbers Namespace for CAMBODIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CAMBODIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-KIR"
        },
        "name" : "Passport Numbers Namespace for KIRIBATI",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of KIRIBATI.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-KNA"
        },
        "name" : "Passport Numbers Namespace for SAINT KITTS AND NEVIS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SAINT KITTS AND NEVIS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-KOR"
        },
        "name" : "Passport Numbers Namespace for KOREA, REPUBLIC OF",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of KOREA, REPUBLIC OF.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-KWT"
        },
        "name" : "Passport Numbers Namespace for KUWAIT",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of KUWAIT.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-LAO"
        },
        "name" : "Passport Numbers Namespace for LAO PEOPLE'S DEMOCRATIC REPUBLIC",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of LAO PEOPLE'S DEMOCRATIC REPUBLIC.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-LBN"
        },
        "name" : "Passport Numbers Namespace for LEBANON",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of LEBANON.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-LBR"
        },
        "name" : "Passport Numbers Namespace for LIBERIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of LIBERIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-LBY"
        },
        "name" : "Passport Numbers Namespace for LIBYAN ARAB JAMAHIRIYA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of LIBYAN ARAB JAMAHIRIYA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-LCA"
        },
        "name" : "Passport Numbers Namespace for SAINT LUCIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SAINT LUCIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-LIE"
        },
        "name" : "Passport Numbers Namespace for LIECHTENSTEIN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of LIECHTENSTEIN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-LKA"
        },
        "name" : "Passport Numbers Namespace for SRI LANKA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SRI LANKA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-LSO"
        },
        "name" : "Passport Numbers Namespace for LESOTHO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of LESOTHO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-LTU"
        },
        "name" : "Passport Numbers Namespace for LITHUANIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of LITHUANIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-LUX"
        },
        "name" : "Passport Numbers Namespace for LUXEMBOURG",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of LUXEMBOURG.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-LVA"
        },
        "name" : "Passport Numbers Namespace for LATVIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of LATVIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MAC"
        },
        "name" : "Passport Numbers Namespace for MACAO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MACAO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MAF"
        },
        "name" : "Passport Numbers Namespace for SAINT MARTIN (FRENCH PART)",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SAINT MARTIN (FRENCH PART).  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MAR"
        },
        "name" : "Passport Numbers Namespace for MOROCCO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MOROCCO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MCO"
        },
        "name" : "Passport Numbers Namespace for MONACO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MONACO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MDA"
        },
        "name" : "Passport Numbers Namespace for MOLDOVA, REPUBLIC OF",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MOLDOVA, REPUBLIC OF.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MDG"
        },
        "name" : "Passport Numbers Namespace for MADAGASCAR",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MADAGASCAR.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MDV"
        },
        "name" : "Passport Numbers Namespace for MALDIVES",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MALDIVES.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MEX"
        },
        "name" : "Passport Numbers Namespace for MEXICO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MEXICO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MHL"
        },
        "name" : "Passport Numbers Namespace for MARSHALL ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MARSHALL ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MKD"
        },
        "name" : "Passport Numbers Namespace for MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MLI"
        },
        "name" : "Passport Numbers Namespace for MALI",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MALI.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MLT"
        },
        "name" : "Passport Numbers Namespace for MALTA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MALTA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MMR"
        },
        "name" : "Passport Numbers Namespace for MYANMAR",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MYANMAR.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MNE"
        },
        "name" : "Passport Numbers Namespace for MONTENEGRO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MONTENEGRO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MNG"
        },
        "name" : "Passport Numbers Namespace for MONGOLIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MONGOLIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MNP"
        },
        "name" : "Passport Numbers Namespace for NORTHERN MARIANA ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NORTHERN MARIANA ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MOZ"
        },
        "name" : "Passport Numbers Namespace for MOZAMBIQUE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MOZAMBIQUE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MRT"
        },
        "name" : "Passport Numbers Namespace for MAURITANIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MAURITANIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MSR"
        },
        "name" : "Passport Numbers Namespace for MONTSERRAT",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MONTSERRAT.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MTQ"
        },
        "name" : "Passport Numbers Namespace for MARTINIQUE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MARTINIQUE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MUS"
        },
        "name" : "Passport Numbers Namespace for MAURITIUS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MAURITIUS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MWI"
        },
        "name" : "Passport Numbers Namespace for MALAWI",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MALAWI.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MYS"
        },
        "name" : "Passport Numbers Namespace for MALAYSIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MALAYSIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-MYT"
        },
        "name" : "Passport Numbers Namespace for MAYOTTE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of MAYOTTE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NAM"
        },
        "name" : "Passport Numbers Namespace for NAMIBIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NAMIBIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NCL"
        },
        "name" : "Passport Numbers Namespace for NEW CALEDONIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NEW CALEDONIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NER"
        },
        "name" : "Passport Numbers Namespace for NIGER",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NIGER.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NFK"
        },
        "name" : "Passport Numbers Namespace for NORFOLK ISLAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NORFOLK ISLAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NGA"
        },
        "name" : "Passport Numbers Namespace for NIGERIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NIGERIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NIC"
        },
        "name" : "Passport Numbers Namespace for NICARAGUA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NICARAGUA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NIU"
        },
        "name" : "Passport Numbers Namespace for NIUE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NIUE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NLD"
        },
        "name" : "Passport Numbers Namespace for NETHERLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NETHERLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NOR"
        },
        "name" : "Passport Numbers Namespace for NORWAY",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NORWAY.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NPL"
        },
        "name" : "Passport Numbers Namespace for NEPAL",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NEPAL.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NRU"
        },
        "name" : "Passport Numbers Namespace for NAURU",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NAURU.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-NZL"
        },
        "name" : "Passport Numbers Namespace for NEW ZEALAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of NEW ZEALAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-OMN"
        },
        "name" : "Passport Numbers Namespace for OMAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of OMAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PAK"
        },
        "name" : "Passport Numbers Namespace for PAKISTAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of PAKISTAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PAN"
        },
        "name" : "Passport Numbers Namespace for PANAMA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of PANAMA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PCN"
        },
        "name" : "Passport Numbers Namespace for PITCAIRN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of PITCAIRN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PER"
        },
        "name" : "Passport Numbers Namespace for PERU",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of PERU.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PHL"
        },
        "name" : "Passport Numbers Namespace for PHILIPPINES",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of PHILIPPINES.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PLW"
        },
        "name" : "Passport Numbers Namespace for PALAU",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of PALAU.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PNG"
        },
        "name" : "Passport Numbers Namespace for PAPUA NEW GUINEA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of PAPUA NEW GUINEA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-POL"
        },
        "name" : "Passport Numbers Namespace for POLAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of POLAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PRI"
        },
        "name" : "Passport Numbers Namespace for PUERTO RICO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of PUERTO RICO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PRK"
        },
        "name" : "Passport Numbers Namespace for KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PRT"
        },
        "name" : "Passport Numbers Namespace for PORTUGAL",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of PORTUGAL.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PRY"
        },
        "name" : "Passport Numbers Namespace for PARAGUAY",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of PARAGUAY.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PSE"
        },
        "name" : "Passport Numbers Namespace for PALESTINIAN TERRITORY, OCCUPIED",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of PALESTINIAN TERRITORY, OCCUPIED.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-PYF"
        },
        "name" : "Passport Numbers Namespace for FRENCH POLYNESIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of FRENCH POLYNESIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-QAT"
        },
        "name" : "Passport Numbers Namespace for QATAR",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of QATAR.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-REU"
        },
        "name" : "Passport Numbers Namespace for REUNION",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of REUNION.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ROU"
        },
        "name" : "Passport Numbers Namespace for ROMANIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ROMANIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-RUS"
        },
        "name" : "Passport Numbers Namespace for RUSSIAN FEDERATION",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of RUSSIAN FEDERATION.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-RWA"
        },
        "name" : "Passport Numbers Namespace for RWANDA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of RWANDA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SAU"
        },
        "name" : "Passport Numbers Namespace for SAUDI ARABIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SAUDI ARABIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SDN"
        },
        "name" : "Passport Numbers Namespace for SUDAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SUDAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SEN"
        },
        "name" : "Passport Numbers Namespace for SENEGAL",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SENEGAL.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SGP"
        },
        "name" : "Passport Numbers Namespace for SINGAPORE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SINGAPORE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SGS"
        },
        "name" : "Passport Numbers Namespace for SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SHN"
        },
        "name" : "Passport Numbers Namespace for SAINT HELENA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SAINT HELENA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SJM"
        },
        "name" : "Passport Numbers Namespace for SVALBARD AND JAN MAYEN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SVALBARD AND JAN MAYEN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SLB"
        },
        "name" : "Passport Numbers Namespace for SOLOMON ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SOLOMON ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SLE"
        },
        "name" : "Passport Numbers Namespace for SIERRA LEONE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SIERRA LEONE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SLV"
        },
        "name" : "Passport Numbers Namespace for EL SALVADOR",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of EL SALVADOR.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SMR"
        },
        "name" : "Passport Numbers Namespace for SAN MARINO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SAN MARINO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SOM"
        },
        "name" : "Passport Numbers Namespace for SOMALIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SOMALIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SPM"
        },
        "name" : "Passport Numbers Namespace for SAINT PIERRE AND MIQUELON",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SAINT PIERRE AND MIQUELON.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SRB"
        },
        "name" : "Passport Numbers Namespace for SERBIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SERBIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-STP"
        },
        "name" : "Passport Numbers Namespace for SAO TOME AND PRINCIPE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SAO TOME AND PRINCIPE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SUR"
        },
        "name" : "Passport Numbers Namespace for SURINAME",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SURINAME.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SVK"
        },
        "name" : "Passport Numbers Namespace for SLOVAKIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SLOVAKIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SVN"
        },
        "name" : "Passport Numbers Namespace for SLOVENIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SLOVENIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SWE"
        },
        "name" : "Passport Numbers Namespace for SWEDEN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SWEDEN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SWZ"
        },
        "name" : "Passport Numbers Namespace for SWAZILAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SWAZILAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SYC"
        },
        "name" : "Passport Numbers Namespace for SEYCHELLES",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SEYCHELLES.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-SYR"
        },
        "name" : "Passport Numbers Namespace for SYRIAN ARAB REPUBLIC",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SYRIAN ARAB REPUBLIC.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TCA"
        },
        "name" : "Passport Numbers Namespace for TURKS AND CAICOS ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TURKS AND CAICOS ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TCD"
        },
        "name" : "Passport Numbers Namespace for CHAD",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of CHAD.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TGO"
        },
        "name" : "Passport Numbers Namespace for TOGO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TOGO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-THA"
        },
        "name" : "Passport Numbers Namespace for THAILAND",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of THAILAND.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TJK"
        },
        "name" : "Passport Numbers Namespace for TAJIKISTAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TAJIKISTAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TKL"
        },
        "name" : "Passport Numbers Namespace for TOKELAU",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TOKELAU.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TKM"
        },
        "name" : "Passport Numbers Namespace for TURKMENISTAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TURKMENISTAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TLS"
        },
        "name" : "Passport Numbers Namespace for TIMOR-LESTE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TIMOR-LESTE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TON"
        },
        "name" : "Passport Numbers Namespace for TONGA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TONGA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TTO"
        },
        "name" : "Passport Numbers Namespace for TRINIDAD AND TOBAGO",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TRINIDAD AND TOBAGO.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TUN"
        },
        "name" : "Passport Numbers Namespace for TUNISIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TUNISIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TUR"
        },
        "name" : "Passport Numbers Namespace for TURKEY",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TURKEY.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TUV"
        },
        "name" : "Passport Numbers Namespace for TUVALU",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TUVALU.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TWN"
        },
        "name" : "Passport Numbers Namespace for TAIWAN, PROVINCE OF CHINA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TAIWAN, PROVINCE OF CHINA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-TZA"
        },
        "name" : "Passport Numbers Namespace for TANZANIA, UNITED REPUBLIC OF",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of TANZANIA, UNITED REPUBLIC OF.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-UGA"
        },
        "name" : "Passport Numbers Namespace for UGANDA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of UGANDA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-UKR"
        },
        "name" : "Passport Numbers Namespace for UKRAINE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of UKRAINE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-UMI"
        },
        "name" : "Passport Numbers Namespace for UNITED STATES MINOR OUTLYING ISLANDS",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of UNITED STATES MINOR OUTLYING ISLANDS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-URY"
        },
        "name" : "Passport Numbers Namespace for URUGUAY",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of URUGUAY.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-USA"
        },
        "name" : "Passport Numbers Namespace for UNITED STATES",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of UNITED STATES.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-UZB"
        },
        "name" : "Passport Numbers Namespace for UZBEKISTAN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of UZBEKISTAN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-VAT"
        },
        "name" : "Passport Numbers Namespace for HOLY SEE (VATICAN CITY STATE)",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of HOLY SEE (VATICAN CITY STATE).  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-VCT"
        },
        "name" : "Passport Numbers Namespace for SAINT VINCENT AND THE GRENADINES",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SAINT VINCENT AND THE GRENADINES.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-VEN"
        },
        "name" : "Passport Numbers Namespace for VENEZUELA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of VENEZUELA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-VGB"
        },
        "name" : "Passport Numbers Namespace for VIRGIN ISLANDS (BRITISH)",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of VIRGIN ISLANDS (BRITISH).  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-VIR"
        },
        "name" : "Passport Numbers Namespace for VIRGIN ISLANDS (U.S.)",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of VIRGIN ISLANDS (U.S.).  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-VNM"
        },
        "name" : "Passport Numbers Namespace for VIET NAM",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of VIET NAM.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-VUT"
        },
        "name" : "Passport Numbers Namespace for VANUATU",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of VANUATU.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-WLF"
        },
        "name" : "Passport Numbers Namespace for WALLIS AND FUTUNA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of WALLIS AND FUTUNA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-WSM"
        },
        "name" : "Passport Numbers Namespace for SAMOA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SAMOA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-YEM"
        },
        "name" : "Passport Numbers Namespace for YEMEN",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of YEMEN.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-YUG"
        },
        "name" : "Passport Numbers Namespace for YUGOSLAVIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of YUGOSLAVIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ZAF"
        },
        "name" : "Passport Numbers Namespace for SOUTH AFRICA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of SOUTH AFRICA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ZMB"
        },
        "name" : "Passport Numbers Namespace for ZAMBIA",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ZAMBIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/passportNumNS-ZWE"
        },
        "name" : "Passport Numbers Namespace for ZIMBABWE",
        "description" : "Identifier of the namespace for Passport Numbers issued by the country of ZIMBABWE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/presentOnAdmission"
        },
        "name" : "CMS Present on Admission (POA) Indicator",
        "description" : "This code system consists of Present on Admission (POA) indicators which are assigned to the principal and secondary diagnoses (as defined in Section II of the Official Guidelines for Coding and Reporting) and the external cause of injury codes to indicate the presence or absence of the diagnosis at the time of inpatient admission."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ssn"
        },
        "name" : "United States Social Security Number",
        "description" : "United States Social Security Number (SSN).  Assigned by the U.S. Social Security Administration.  Note: IRS assigned ITINs are often used as drop-ins for social security numbers.  The SSN is represented in resources with dashes removed. See http://www.ssa.gov/."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/uri"
        },
        "name" : "Uniform Resource Identifier (URI)",
        "description" : "As defined by RFC 3986 (http://www.ietf.org/rfc/rfc3986.txt)(with many schemes defined in many RFCs). For OIDs and UUIDs, use the URN form (urn:oid:(note: lowercase) and urn:uuid:). See http://www.ietf.org/rfc/rfc3001.txt and http://www.ietf.org/rfc/rfc4122.txt \r\n\r\nThis oid is used as an identifier II.root to indicate the the extension is an absolute URI (technically, an IRI). Typically, this is used for OIDs and GUIDs. Note that when this OID is used with OIDs and GUIDs, the II.extension should start with urn:oid or urn:uuid: \r\n\r\nNote that this OID is created to aid with interconversion between CDA and FHIR - FHIR uses urn:ietf:rfc:3986 as equivalent to this OID. URIs as identifiers appear more commonly in FHIR.\r\n\r\nThis OID may also be used in CD.codeSystem."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/HCPCS-all-codes"
        },
        "name" : "HCFA Procedure Codes (HCPCS)",
        "description" : "The Level II HCPCS codes, which are established by CMS's Alpha-Numeric Editorial Panel, primarily represent items and supplies and non-physician services not covered by the American Medical Association's Current Procedural Terminology-4 (CPT-4) codes; Medicare, Medicaid, and private health insurers use HCPCS procedure and modifier codes for claims processing.  Level II alphanumeric procedure and modifier codes comprise the A to V range."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-hgnc"
        },
        "name" : "HUGO Gene Nomenclature Committee Genes",
        "description" : "\"The HGNC is responsible for approving unique symbols and names for human loci, including protein coding genes, ncRNA genes and pseudogenes, to allow unambiguous scientific communication.\"\r\n\r\nThe HGNC gene table carries gene IDs, gene symbols and full gene names. Guidance from HGNC confirms that gene symbols are not unique across species and have been known to change in some instances. Thus the commonly used gene symbols should be encoded in FHIR as \"displays\" with the corresponding IDs (beginning with \"HGNC:\") as the \"codes\".\r\n\r\n\"For each known human gene we approve a gene name and symbol (short-form abbreviation). All approved symbols are stored in the HGNC database,[www.genenames.org](https://www.genenames.org/tools/search), a curated online repository of HGNC-approved gene nomenclature, gene groups and associated resources including links to genomic, proteomic and phenotypic information. Each symbol is unique and we ensure that each gene is only given one approved gene symbol. It is necessary to provide a unique symbol for each gene so that we and others can talk about them, and this also facilitates electronic data retrieval from publications and databases.\"\r\n\r\nHGNC also provides an index on gene families/groups. GeneGroup IDs do not begin with \"HGNC:\", so care must be made to ensure alignment of concepts when viewing an HGNC ID from an older system that may be referring to the GeneID and not a gene group. For example, 588 refers to the HLA gene family, but HGNC:588 identifies the ATG12 gene. To provide clarity for systems that do not distinguish codes from genes and gene families, use \"http://www.genenames.org\" for genes and \"http://www.genenames.org/genegroup\" for gene families as code system URIs.\r\n\r\nFor more information on HGNC Gene Groups, see [https://terminology.hl7.org/CodeSystem-HGNCGeneGroup.html](https://terminology.hl7.org/CodeSystem-HGNCGeneGroup.html).\r\n\r\nHistorically, HGNC gene symbols were used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model Implementation Guide, HGNC gene symbols were used as the observation values for gene identifiers. For example, OBX 1 CWE 48018-6^Gene identifier^ BRCA1^HGNC. Please note that gene symbols may be present in legacy systems, but GeneID should be used to exchange HGNC gene information in current implementations.\r\n\r\nHGNC is a free database for the public.\r\n\r\nVersioning Information: The version of the HGNC database is reported using the last updated date. The last updated date is posted on the main HGNC Search screen in the format like \"2024-07-25\".\r\n\r\nCurrent, monthly and quarterly HGNC dataset files are published.\r\n\r\nPlease see https://www.genenames.org/ for more info."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v2-0350"
        },
        "name" : "nubc-OccurrenceCode",
        "description" : "National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 31 - 34, Occurrence Codes and Amounts - code and associated date defining asignificant event relating to the bill that may affect payer processing the claim. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.  Used in HL7 Version 2.x messaging in the OCD segment. Updated by NUBC annually; see the coding instructions for more detail.  Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v2-0351"
        },
        "name" : "nubc-OccurrenceSpan",
        "description" : "HL7-defined code system of concepts  specifying a National Uniform Billing Committee (NUBC) code that identifies an event that relates to the payment of a claim.  The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.  Used in HL7 Version 2.x messaging in the Occurrence Span Code and Date (OSP) value. Updated by NUBC annually; see the coding instructions for more detail.  Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v2-0456"
        },
        "name" : "nubc-ServiceLineRevenue",
        "description" : "Code system of concepts specifying a revenue code as specified in the National Uniform Billing Committee (NUBC) UB-04 manual, UB form locator 42, the service line revenue code.  These are claim codes indicating the identifying number for the product or service provided. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.  Used in HL7 Version 2.x messaging in the Revenue Code (GP1) value. Updated by NUBC annually; see the coding instructions for more detail.  Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v2-0895"
        },
        "name" : "nubc-PresentOnAdmission",
        "description" : "National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 67, Present on Admission (POA) Indicator. Code identifying a diagnosis that  was present at the time the order for inpatient admission occurs. POA indicator is assigned to all diagnoses as defined in Appendix I of the \"ICD-9-CM Official Guidelines for Coding and Reporting\" or \"ICD-10-CM Official Guidelines for Coding and Reporting (appropriate to the ICD revision used).\r\n \r\nThe UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.  Used in HL7 Version 2.x messaging in the DG1 segment. Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-ada-snodent"
        },
        "name" : "Systematized Nomenclature of Dentistry (SNODENT)",
        "description" : "Systematized Nomenclature of Dentistry (SNODENT) is owned, maintained and distributed by the American Dental Association (ADA). SNODENT is a vocabulary designed for use in the electronic environment - for electronic health and dental records. The intended purpose is to:\r\n\r\n *  Provide standardized terms for describing dental disease\r\n *  Capture clinical detail and patient characteristics\r\n *  Permit analysis of patient care services and outcomes\r\n *  To be interoperable with Electronic Health Records (EHR) and Electronic Dental Records (EDR)\r\n\r\nSNODENT licensing information can be found at: http://www.ada.org/8466.aspx\r\n\r\nURL for Official Source: http://www.ada.org/snodent.aspx"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-mediaType"
        },
        "name" : "Media Type",
        "description" : "Internet Assigned Numbers Authority (IANA) Mime Media Types. Identifies the type of the encapsulated data and identifies a method to interpret or render the data. The IANA defined domain of media types is established by the Internet standard RFC 2045 \\[http://www.ietf.org/rfc/rfc2045.txt\\] and 2046 \\[http://www.ietf.org/rfc/rfc2046.txt\\]. RFC 2046 defines the media type to consist of two parts:\r\n\r\n1.  top level media type, and\r\n2.  media subtype\r\n\r\nHowever, this HL7 datatypes specification treats the entire media type as one atomic code symbol in the form defined by IANA, i.e., top level type followed by a slash \"/\" followed by media subtype. Currently defined media types are registered in a database \\[http://www.iana.org/assignments/media-types/index.html\\] maintained by IANA. Currently several hundred different MIME media types are defined, with the list growing rapidly. In general, all those types defined by the IANA MAY be used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ACR"
        },
        "name" : "American College of Radiology Finding Codes",
        "description" : "American College of Radiology finding codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AS4"
        },
        "name" : "ASTM E1238/E1467 Universal",
        "description" : "ASTM E1238/ E1467 Universal"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/AS4E"
        },
        "name" : "AS4 Neurophysiology Codes",
        "description" : "AS4 Neurophysiology Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/C5"
        },
        "name" : "CPT-5",
        "description" : "CPT-5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CAS"
        },
        "name" : "Chemical Abstract Codes",
        "description" : "Chemical abstract codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CCC"
        },
        "name" : "Clinical Care Classification System",
        "description" : "Clinical Care Classification System (formerly Home Health Care Classification system) codes. The Clinical Care Classification (CCC) consists of two taxonomies: CCC of Nursing Diagnoses and CCC of Nursing Interventions both of which are classified by 21 Care Components. Each of these are classified by Care Components which provide a standardized framework for documenting patient care in hospitals, home health agencies, ambulatory care clinics, and other health care settings."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CD2"
        },
        "name" : "CDT-2 Codes",
        "description" : "American Dental Association's Current Dental Terminology 2 (CDT-2) codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CDARUS"
        },
        "name" : "CDA_RUS",
        "description" : "Coding system intended for use in the Russian clinical documents"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CDCA"
        },
        "name" : "CDC Analyte Codes",
        "description" : "CDC Analyte Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CDCM"
        },
        "name" : "CDC Methods/Instruments Codes",
        "description" : "CDC Methods/Instruments Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CDS"
        },
        "name" : "CDC Surveillance",
        "description" : "CDC Surveillance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CE"
        },
        "name" : "CEN ECG diagnostic codes",
        "description" : "CEN ECG diagnostic codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CLP"
        },
        "name" : "CLIP",
        "description" : "CLIP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CST"
        },
        "name" : "COSTART",
        "description" : "COSTART"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DCL"
        },
        "name" : "DICOM Class Label",
        "description" : "DICOM Class Label"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-DCM"
        },
        "name" : "DICOM Controlled Terminology",
        "description" : "Coded concepts defined in PS 3.16 Digital Imaging and Communications in Medicine (DICOM): Part 16: Content Mapping Resource, Annex D: DICOM Controlled Terminology Definition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS"
        },
        "name" : "DEEDS vocabularies",
        "description" : "root for the DEEDS code sets"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS210"
        },
        "name" : "DEEDS2.10",
        "description" : "Code for ED Practitioner Role"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS402"
        },
        "name" : "DEEDS402",
        "description" : "Mode of transport to ED"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS405"
        },
        "name" : "DEEDS405",
        "description" : "ED Source of Referral"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS407"
        },
        "name" : "DEEDS407",
        "description" : "Code for Initial Healthcare Encounter for Chief Complaint"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS408"
        },
        "name" : "DEEDS408",
        "description" : "Code for Acuity Assessment"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS412"
        },
        "name" : "DEEDS412",
        "description" : "ED Responsiveness Assessment"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS414"
        },
        "name" : "DEEDS414",
        "description" : "Glasgow eye opening assessment"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS415"
        },
        "name" : "DEEDS415",
        "description" : "Glasgow verbal component assessment"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS416"
        },
        "name" : "DEEDS416",
        "description" : "Glasgow motor component assessment"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS418"
        },
        "name" : "DEEDS418",
        "description" : "Systolic blood pressure special situation"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS422"
        },
        "name" : "DEEDS422",
        "description" : "Heart rate method"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS424"
        },
        "name" : "DEEDS424",
        "description" : "Respiratory rate special circumstances codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS427"
        },
        "name" : "DEEDS427",
        "description" : "Patient temperature route"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS506"
        },
        "name" : "DEEDS506",
        "description" : "Injury Activity"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS508"
        },
        "name" : "DEEDS508",
        "description" : "Safety Equipment Use"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/DEEDS519"
        },
        "name" : "DEEDS519",
        "description" : "Clinical Finding Data Source"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/E5"
        },
        "name" : "Euclides quantity codes",
        "description" : "Euclides quantity codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/E6"
        },
        "name" : "Euclides Lab method codes",
        "description" : "Euclides Lab method codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/E7"
        },
        "name" : "Euclides Lab equipment codes",
        "description" : "Euclides Lab equipment codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ENZC"
        },
        "name" : "Enzyme Codes",
        "description" : "Enzyme Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/EPSG-GeodeticParameterDataset"
        },
        "name" : "EPSG Geodetic Parameter Dataset",
        "description" : "**Description:** The EPSG (European Petroleum Survey Group) dataset represents all Datums, coordinate references (projected and 2D geographic) and coordinate systems (including Cartesian coordinate systems) used in surveying worldwide. Each record includes a 4-8 digit unique identifier. The current version is available from http://www.epsg.org/. The database contains over 4000 records covering spatial data applications worldwide.\r\n\r\n**Deprecation Comment:** This has been superceded by the two code systems EPSG-CRS and EPSG-CA"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/FDBHICCode"
        },
        "name" : "FDB HIC Code",
        "description" : "The FDB Hierarchical Ingredient Code is a six character identifier that represents an active ingredient and its specific therapeutic classification."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/FDDC"
        },
        "name" : "First DataBank Drug Codes",
        "description" : "First DataBank Drug Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/FDDX"
        },
        "name" : "First DataBank Diagnostic Codes",
        "description" : "First DataBank Diagnostic Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/GCDF"
        },
        "name" : "GCDF",
        "description" : "GCDF\r\n\r\nDosage Form Code (2-character)\r\n\r\na two-character alphanumeric column that represents a dosage form. The dosage form of a generic drug formulation describes the physical presentation of a drug, such as tablet, capsule, or liquid. It may also incorporate the delivery and release mechanism of the drug. A GCDF is associated to each GCN\\_SEQNO to identify that component of the generic drug formulation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/GCRT"
        },
        "name" : "GCRT",
        "description" : "GCRT\r\n\r\nRoute of Administration Code (1-character)\r\n\r\na one-character alphanumeric column that provides the normal site or method by which a drug is administered, such as oral, injection, or topical. A GCRT is associated to each GCN\\_SEQNO to identify that component of the generic drug formulation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/GMDN"
        },
        "name" : "Global Medical Device Nomenclature",
        "description" : "http://www.gmdnagency.com/"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-HealthcareProviderTaxonomyHIPAA"
        },
        "name" : "Healthcare Provider Taxonomy HIPAA",
        "description" : "This HL7 Version 3 code system stub was created many years ago for the convenience of the HL7 community using the RIM; it has been determined that there is licensure issue with the republishing of the content for this code system by HL7, as well as erroneous and incomplete content.  Content should be accessed using the links at nucc.org"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/IC2"
        },
        "name" : "ICHPPC-2",
        "description" : "ICHPPC-2"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ICD-10DualCoding"
        },
        "name" : "ICD-10 Dual Coding",
        "description" : "ICD-10 allows dual coding. Refer to Section 3.1.3 of the ICD-10 Instruction Manual (2nd Edition, http://www.who.int/entity/classifications/icd/ICD-10\\_2nd\\_ed\\_volume2.pdf).\r\n\r\nThis OID identifies the code system that describes how to encode Dual Coding in a CD compatible expression (for Datatypes R2 CD only).\r\n\r\nAn ICD-10 dual code expression SHALL consist of two ICD-10 codes separated by space. This code system SHALL NOT be used for single ICD-10 codes; the normal ICD-10 code system oid which is 2.16.840.1.113883.6.3 should be used in this case.\r\n\r\nDual code expressions SHALL only be used per the rules described in the ICD-10 instruction manual.\r\n\r\n**An example CD:**\r\n\r\n```\r\n<example code=\"J21.8 B95.6\" codeSystem=\"2.16.840.1.113883.6.260\">\r\n  <originalText value=\"Staph aureus bronchiolitis\"/>\r\n</example>\r\n```\r\nWhere:\r\n* J21.8 is: Acute bronchiolitis due to other specified organisms\r\n* B95.6 is: Staphylococcus aureus as the cause of diseases classified to other chapters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ICD-9CM-diagnosiscodes"
        },
        "name" : "ICD-9-CM (diagnosis codes)",
        "description" : "The International Classification of Diseases, 9th Revision, Clinical Modification (ICD-9-CM), Volumes I, II (diagnoses) and III (procedures) describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases and procedures. The ICD-9-CM codes can be used as the value of the Act.cd attribute."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ICD-9CM-procedurecodes"
        },
        "name" : "ICD-9-CM (procedure codes)",
        "description" : "The International Classification of Diseases, 9th Revision, Clinical Modification (ICD-9-CM), Volumes I, II (diagnoses) and III (procedures) describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases and procedures. The ICD-9-CM codes can be used as the value of the Act.cd attribute."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ICD-9DualCoding"
        },
        "name" : "ICD-9 Dual Coding",
        "description" : "ICD-9 Dual Coding Expression Syntax\", description: ICD-9 allows dual coding. Refer to Section ?? of the ICD-9 Instruction Manual (ref?).\r\n\r\nThis OID identifies the code system that describes how to encode Dual Coding in a CD compatible expression (for Datatypes R2 CD only).\r\n\r\nAn ICD-9 dual code expression SHALL consist of two ICD-9 codes separated by space. This code system SHALL NOT be used for single ICD-9 codes; the normal ICD-9 code system oid which is 2.16.840.1.113883.6.3 should be used in this case. DisplayName SHALL not be used.\r\n\r\nDual code expressions SHALL only be used per the rules described in the ICD-9 instruction manual.\r\n\r\n**An example CD:**\r\n\r\n```\r\n<example code=\"989.5 E905.9\" codeSystem=\"2.16.840.1.113883.6.260\">\r\n  <originalText value=\"ANAPHYLAXIS DUE TO BITE OR STING\"/>\r\n</example>\r\n```\r\nWhere:\r\n* 989.5 is: \"Toxic effect of venom\"\r\n* E905.9 is: \"Bite or sting\""
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ICD10dut"
        },
        "name" : "ICD10, Dutch Translation",
        "description" : "Hirs, W., H.W. Becker, C. van Boven, S.K. Oskam, I.M. Okkes, H. Lamberts. ICD-10, Dutch Translation, 200403. Amsterdam: Department of General Practice, Academic Medical Center/University of Amsterdam, Dutch College of General Practitioners (NHG), March 20"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ICSD"
        },
        "name" : "International Classification of Sleep Disorders",
        "description" : "International Classification of Sleep Disorders"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/IETF1766"
        },
        "name" : "IETF RFC 1766",
        "description" : "Codes representing languages for which a person has some level of proficiency for written or spoken communication.\r\n\r\n*Examples:* Spanish, Italian, German, English, American Sign, etc."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/IUPC"
        },
        "name" : "IUPAC/IFCC Component Codes",
        "description" : "IUPAC/IFCC Component Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/IUPP"
        },
        "name" : "IUPAC/IFCC Property Codes",
        "description" : "IUPAC/IFCC Property Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/JC8"
        },
        "name" : "Japanese Chemistry",
        "description" : "Japanese Chemistry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MDDX"
        },
        "name" : "Medispan Diagnostic Codes",
        "description" : "Medispan Diagnostic Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MDRAE"
        },
        "name" : "MedDRA Am Engl",
        "description" : "Medical Dictionary for Regulatory Activities Terminology (MedDRA), American English Equivalents, Version 7.0. Bethesda, MD: National Library of Medicine, March 1, 2004 This is the English language version as encapsulated in the UMLS.."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MDRDUT"
        },
        "name" : "MedDRA Dutch",
        "description" : "Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, Dutch Edition. International conference on Harmonization of Technical Requirements for Registration of Pharmaceuticals for Human Use (ICH). Reston, VA: MedDRA MSSO, March 1, 2004 This is the Dutch language version as encapsulated in the UMLS.."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MDREA"
        },
        "name" : "MedDRA Am Engl expanded",
        "description" : "Medical Dictionary for Regulatory Activities Terminology (MedDRA), American English Equivalents with expanded abbreviations, Version 7.0. Bethesda, MD: National Library of Medicine, March 1, 2004."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MDREX"
        },
        "name" : "MedDRA expanded",
        "description" : "Medical Dictionary for Regulatory Activities Terminology (MedDRA), with expanded abbreviations, Version 7.0. Bethesda, MD: National Library of Medicine, March 1, 2004."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MDRFRE"
        },
        "name" : "MedDRA French",
        "description" : "Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, French Edition. International conference on Harmonization of Technical Requirements for Registration of Pharmaceuticals for Human Use (ICH). Reston, VA: MedDRA MSSO, March 1, 2004 This is the French language version as encapsulated in the UMLS.."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MDRGER"
        },
        "name" : "MedDRA German",
        "description" : "Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, German Edition. International conference on Harmonization of Technical Requirements for Registration of Pharmaceuticals for Human Use (ICH). Reston, VA: MedDRA MSSO, March 1, 2004 This is the German language version as encapsulated in the UMLS.."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MDRPOR"
        },
        "name" : "MedDRA Portuguese",
        "description" : "Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, Portuguese Edition. International conference on Harmonization of Technical Requirements for Registration of Pharmaceuticals for Human Use (ICH). Reston, VA: MedDRA MSSO, March 1, 2004. This is the Portuguese language version as encapsulated in the UMLS.."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MDRSPA"
        },
        "name" : "MedDRA Spanish",
        "description" : "Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, Spanish Edition. International conference on Harmonization of Technical Requirements for Registration of Pharmaceuticals for Human Use (ICH). Reston, VA: MedDRA MSSO, March 1, 2004. This is the Spanish language version as encapsulated in the UMLS.."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MEDC"
        },
        "name" : "Medical Economics Drug Codes",
        "description" : "Medical Economics Drug Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MEDX"
        },
        "name" : "Medical Economics Diagnostic Codes",
        "description" : "Medical Economics Diagnostic Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MGPI"
        },
        "name" : "Medispan GPI",
        "description" : "Medispan GPI"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MTHMDRSPA"
        },
        "name" : "MTH MedDRA Spanish",
        "description" : "Metathesaurus Forms of Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, Spanish Edition. Bethesda, MD: National Library of Medicine, March 2004."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/MVX"
        },
        "name" : "Manufacturers of Vaccines (MVX)",
        "description" : "\"The CDC's National Center for Immunization and Respiratory Diseases ([NCIRD](https://www.cdc.gov/ncird/)) developed and maintains HL7 Table 0227, Manufacturers of Vaccines (MVX). It includes both active and inactive manufacturers of vaccines in the US. Inactive MVX codes allow transmission of historical immunization records. When MVX code is paired with a CVX (vaccine administered) code, the specific trade named vaccine may be indicated. MVX is the underlying Master Code System for V2 table 0227 (Manufacturers Of Vaccines (code=MVX)). The machine readable name for MVX in PHIN VADS is PH_VaccinesAdministeredCVX_CDC_NIP.\r\n\r\nStatus indicates if the manufacturer is currently making vaccine for distribution in the United States.\r\n\r\nLast Updated indicates the last time this particular manufacturer code was updated in this table.\r\n\r\nQuestions regarding MVX should be directed to the [IIS Technical Assistance Team](mailto:iisinfo@cdc.gov)(or use [mailing address](https://www2.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=mvx#addr)).\"\r\n\r\nFor more information, please see [here](https://www2.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=mvx)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNBSIRiskFactors"
        },
        "name" : "NHSN BSI Risk Factors",
        "description" : "NHSN Blood Stream Infection Risk Factors"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNHipReplacement"
        },
        "name" : "NHSN Hip Replacement",
        "description" : "NHSN Hip Replacement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNInfectionType"
        },
        "name" : "NHSN Infection Type",
        "description" : "NHSN Infection Type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNKneeReplacement"
        },
        "name" : "NHSN KneeR eplacement",
        "description" : "NHSN Knee Replacement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNLCBIPathways"
        },
        "name" : "NHSN LCBI Pathways",
        "description" : "NHSN Laboratory Confirmed Bloodstream Infection Pathways"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNOccasionOfDetection"
        },
        "name" : "NHSN Occasion Of Detection",
        "description" : "NHSN Occasion Of Detection"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNProcedureCategory"
        },
        "name" : "NHSN Procedure Category",
        "description" : "NHSN Procedure Category"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNSSIAnatomicSite"
        },
        "name" : "NHSN SSI Anatomic Site",
        "description" : "NHSN Surgical Site Infection Anatomic Site"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNSSILocationType"
        },
        "name" : "NHSN SSI Location Type",
        "description" : "NHSN SSI LocationType"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNSpinalFusionApproach"
        },
        "name" : "NHSN Spinal Fusion Approach",
        "description" : "NHSN Spinal Fusion Approach"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNSpinalFusionLevel"
        },
        "name" : "NHSN Spinal Fusion Level",
        "description" : "NHSN Spinal Fusion Level"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNSummaryData"
        },
        "name" : "NHSN Summary Data",
        "description" : "NHSN Summary Data"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/NHSNVocabulary"
        },
        "name" : "NHSN HAI Vocabulary",
        "description" : "NHSN HAI Vocabulary used for Single Value bindingsto Observation Identifier"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/PHIndustryCDCCensus2010"
        },
        "name" : "Industry CDC Census 2010",
        "description" : "2010 Industry coding system used by CDC (NIOSH and NCHS) for coding industry text. Industry describes an economic/business sector comprised of businesses/ enterprises concerned with the output of a specified category of products or services."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/PHOccupationCDCCensus2010"
        },
        "name" : "Occupation CDC Census 2010",
        "description" : "2010 Occupation coding system used by CDC (NIOSH and NCHS) for coding occupation text. Occupation describes a set of activities or tasks that individuals are paid to perform or, if unpaid, define a person's contribution to a household/family business/community."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/PHOccupationalDataForHealthODH"
        },
        "name" : "Occupational Data for Health (ODH)",
        "description" : "The concepts representing the values supporting Occupational Data for Health, including Job Supervisory Level or Pay Grade (ODH) code system consists of data elements that describe a person's work information, structured to facilitate individual, population, and public health use; not intended to support billing.)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/POS"
        },
        "name" : "POS Codes",
        "description" : "POS Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/SCDHEC-GISSpatialAccuracyTiers"
        },
        "name" : "SCDHEC GIS Spatial Accuracy Tiers",
        "description" : "**Description:** The South Carolina Department of Health and Environmental Control GIS Spatial Data Accuracy Tiers have been derived from the National Standard for Spatial Data Accuracy as a means to categorize the accuracy of spatial data assignment utilizing a variety of tools for capturing coordinates including digitizers, geocoding software and global positioning system devices."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/SDM"
        },
        "name" : "SNOMED-DICOM Microglossary",
        "description" : "SNOMED-DICOM Microglossary"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/SNM3"
        },
        "name" : "SNOMED International",
        "description" : "SNOMED International"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/SNT"
        },
        "name" : "SNOMED topology codes (anatomic sites)",
        "description" : "SNOMED topology codes (anatomic sites)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/UC"
        },
        "name" : "UCDS",
        "description" : "UCDS"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/UMD"
        },
        "name" : "MDNS",
        "description" : "MDNS"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/UML"
        },
        "name" : "Unified Medical Language",
        "description" : "Unified Medical Language"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/UPC"
        },
        "name" : "Universal Product Code",
        "description" : "Universal Product Code"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/USCOC"
        },
        "name" : "US Census Occupation Code",
        "description" : "Coding system of United States Census Occupation Codes, published by the US Governmetn Bureau of the Census. Doucmentation and Crosswalk mapping between the COC and the SOC and NAICS code systems available at http://www.census.gov/hhes/www/ioindex/view.html"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/USZIPCODES"
        },
        "name" : "United States Postal Service",
        "description" : "Coding system of defined postal zip codes for the United States of America."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/VHA"
        },
        "name" : "US Department of Veterans Affairs",
        "description" : "VHA Enterprise Reference Terminology is based on CHI standard terminologies (e.g., SNOMED-CT, LOINC, HL7, NDF-RT, etc.) when available and on VHA own code sets when necessary (e.g., allergens). All concepts used within the VHA clinical environment receive a VHA Unique IDentifier or VUID. VHA Enterprise Reference Terminology complies with the semantics of the HL7 message structure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/W1-W2"
        },
        "name" : "WHO rec# drug codes",
        "description" : "WHO rec\\# drug codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/W4"
        },
        "name" : "WHO rec# code with ASTM extension",
        "description" : "WHO rec\\# code with ASTM extension"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-WC"
        },
        "name" : "WHO ATC",
        "description" : "WHO ATC"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/X12.3"
        },
        "name" : "X12.3 Data Elementary Dictionary",
        "description" : "X12.3 Data Elementary Dictionary\r\n\r\nThis is the root OID for vocabulary defined internally by X12N. OIDS for each vocabulary will be assigned underneath this oid by appending the X12N data element id to the root OID. Data Element 1336 is Insurance Type Code, so the OID for the X12N Insurance Type Code vocabulary will be 2.16.840.1.113883.6.255.1336"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/abcCodes"
        },
        "name" : "ABC Codes",
        "description" : "Five character alphabetic codes fit into current claims processing software or onto standard paper claim forms. ABC Codes give business parity to licensed CAM and nurse providers who file claims to insurance companies. ."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-ada-snodent"
        },
        "name" : "American Dental Association Systematized Nomenclature of Dentistry (SNODENT)",
        "description" : "Systematized Nomenclature of Dentistry (SNODENT) is owned, maintained and distributed by the American Dental Association (ADA). SNODENT is a vocabulary designed for use in the electronic environment - for electronic health and dental records. The intended purpose is to:\r\n\r\n *  Provide standardized terms for describing dental disease\r\n *  Capture clinical detail and patient characteristics\r\n *  Permit analysis of patient care services and outcomes\r\n *  To be interoperable with Electronic Health Records (EHR) and Electronic Dental Records (EDR)\r\n\r\nSNODENT licensing information can be found at: [http://www.ada.org/8466.aspx](http://www.ada.org/8466.aspx)\r\n\r\nURL for Official Source: [http://www.ada.org/snodent.aspx](http://www.ada.org/snodent.aspx)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ahfs"
        },
        "name" : "AHFS Pharmacologic-Therapeutic Classification",
        "description" : "**Description:** The AHFS Pharmacologic-Therapeutic Classification has been in use in hospitals in the United States since its inception in 1959. An integral part of the American Hospital Formulary Service, the AHFS classification allows the grouping of drugs with similar pharmacologic, therapeutic, and/or chemical characteristics. Today, the AHFS classification is used by many people outside of hospitals."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/art"
        },
        "name" : "WHO Adverse Reaction Terms",
        "description" : "WHO Adverse Reaction Terms"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-brazilianProcedureCodesSUS"
        },
        "name" : "Brazilian Procedure Codes SUS",
        "description" : "Brazilian Procedure Codes used in the National Health System"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/camncvs"
        },
        "name" : "CAMNCVS",
        "description" : "CAM & Nursing Coding Vocabulary Set"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-cci"
        },
        "name" : "Canadian Classification of Health Interventions",
        "description" : "CCI  (Canadian Classification of Health Interventions) was developed by CIHI to accompany ICD-10-CA. It was designed to be service-provider and service-setting neutral and can be used comprehensively throughout Canada’s health systems. CCI classifies a broad range of interventions including therapeutic and diagnostic interventions and other health care interventions, such as assistance with activities of daily living, environmental assessments and counselling."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/CDCNHSN"
        },
        "name" : "NHSN Surveillance System Codes",
        "description" : "A set of healthcare surveillance vocabulary concepts and associated identifiers intended solely for data submissions to the National Healthcare Safety Network (NHSN). Other uses are not recommended.\r\n\r\nThe CDCNHSN code system is highly specialized to meet the needs of NHSN surveillance reporting, is undergoing changes, and is not recommended for creating value sets to be used outside of NHSN."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/cpnum"
        },
        "name" : "Gold Standard's Clinical Pharmacology Monograph Number",
        "description" : "Gold Standard's Clinical Pharmacology Monograph Number"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/csaid"
        },
        "name" : "CAN/CSA-Z795-96",
        "description" : "** Inactvie since 2015.    Nature of injury (NOI) codes, which are part of the Work Injury or Disease Information coding system (CAN/CSA-Z795-96 - R2003).\r\n\r\nThe CSA code set includes 3 parts: Nature of injury (NOI), body part (BP), side of body (SB).\r\n\r\nFor example:\r\n\r\n *  NOI - Cut or laceration Injury = 03400\r\n *  BP - Upper Arm body part = 31100\r\n *  SOB - Left Side of Body = L\r\n\r\nThe Body Part codes are qualified by the Side of Body codes code system, to be more precise in specifying the location of the injury being coded.\r\n\r\nCode set is maintained by the Canadian Standards Association (CSA).\r\n\r\nset is maintained by the Canadian Standards Association (CSA).\r\n\r\nThe Canadian Standards Association 5060 Spectrum Way Mississauga, Ontario Canada L4W 5N6\r\n\r\nPhone: (416) 747-4000 1-800-463-6727 Fax: (416) 747-2473"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-dbSNP"
        },
        "name" : "Genetic Sequence polymorphism database",
        "description" : "In collaboration with the National Human Genome Research Institute, The National Center for Biotechnology Information has established the dbSNP database to serve as a central repository for both single base nucleotide substitutions and short deletion and insertion polymorphisms.\r\n\r\nThe entries in the dbSNP database can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, dbSNP entries can be used to as the observation values for DNA sequence variation identifiers. For example, OBX|1|CWE|48004-6^DNA Sequence Variation Identifier^LN||rs55538123^^dbSNP\r\n\r\nVersioning is identified by the build id. A new build is released approximately every six months or every year. The latest build id is 130, and the dbSNP web query for built 130 was available on Apr 30, 2009.\r\n\r\ndbSNP is a database that can be used freely by the public.\r\n\r\nMore information may be fouond at: http://www.ncbi.nlm.nih.gov/projects/SNP/"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/deeds-old"
        },
        "name" : "DEEDS(old)",
        "description" : "retired root for DEEDs from earlier work. Superceded."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/dicomMDLTY"
        },
        "name" : "DICOM modality codes",
        "description" : "DICOM modality codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/dicomqry"
        },
        "name" : "DICOM Query Label",
        "description" : "DICOM Query Label"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/dmdICD10"
        },
        "name" : "ICD-10 German",
        "description" : "Internationale Klassifikation der Krankheiten 10 \\[German translation of ICD10\\]. Germany: Deutsches Institut fuer Medizinische Dokumentation und Information, 1998."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/epsg-ca"
        },
        "name" : "European Petroleum Survey Group Geodetic Parameter Dataset Coordinate Axis",
        "description" : "**Description:**The set of values found in the Coord Axis Code column of the Coordinate Axis table as maintained in the EPSG geodetic parameter dataset. These define the axis for coordinate systems for geographic coordinates."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/epsg-crs"
        },
        "name" : "European Petroleum Survey Group Geodetic Parameter Dataset Coordinate Reference System",
        "description" : "**Description:** The set of values found in the Coord Axis Code column of the Coordinate Axis table as maintained in the EPSG geodetic parameter dataset. These define the axis for coordinate systems for geographic coordinates."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/euclides"
        },
        "name" : "EUCLIDES",
        "description" : "EUCLIDES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/externalCodeSystems"
        },
        "name" : "HL7 Registered External Coding Systems",
        "description" : "External coding systems registered in HL7 with an HL7 OID"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-fda-FCE"
        },
        "name" : "Food and Drug Administration Food Canning Establishments",
        "description" : "Entered erroneously - do not use. The correct OID for this identifier system is 2.16.840.1.113883.4.345."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-fda-FFRN"
        },
        "name" : "Food and Drug Administration Food Facility Registration Numbers",
        "description" : "Entered in error originally - do not use. Correct OID for this item is 2.16.840.1.113883.4.344."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/fdk"
        },
        "name" : "FDA K10",
        "description" : "FDA K10"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/fipspub92"
        },
        "name" : "FIPS_SOC",
        "description" : "FIPSPUB92 - GUIDELINE FOR STANDARD OCCUPATIONAL CLASSIFICATION (SOC) CODES, version 1983 February 24. This entry is now obsolete, as FIPS92 was withdrawn from use in February 2005 by the US Government. It has been replaced by 2.16.840.1.113883.6.243; please use that OID instead."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-hc-aic"
        },
        "name" : "Active Ingredient Code",
        "description" : "Foreign key for the Active Ingredient Table that relates active ingredients to specific products.  \r\n\r\nFurther information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/read-file-drug-product-database-data-extract.htmll"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-hc-aigc"
        },
        "name" : "Active Ingredient Group Code",
        "description" : "Part of the active ingredient code number starting at position 3 and ending at position 7.  \r\n\r\nFurther information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/terminology.html"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-hc-aign"
        },
        "name" : "Active Ingredient Group Number",
        "description" : "The AIG number is a 10 digit number that identifies products that have the same active ingredient(s) and ingredient strength(s). The AIG is comprised of three portions: \r\n\r\n *  the first portion (2 digits) identifies the number of active ingredients\r\n *  the second portion(5 digits) identifies the unique groups of active ingredients(s);\r\n *  the last portion (3 digits) identifies the active ingredient group strength. The strength group has a tolerance of -2% to +10%.\r\n \r\n\r\nFurther information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/terminology.html"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-hc-npn"
        },
        "name" : "Health Canada Natural Product Number",
        "description" : "Natural Product Number (NPN) is an eight (8) digit numerical code assigned to each natural health product approved to be marketed under the Natural Health Products Regulations. A Homeopathic Medicine Number (DIN-HM) is an eight (8) digit numerical code assigned to each homeopathic medicine approved to be marketed under the Natural Health Products Regulations. \r\n\r\nFurther information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/natural-non-prescription/applications-submissions/product-licensing/licensed-natural-health-products-database.html"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-hgvs"
        },
        "name" : "Human Genome Variation Society nomenclature",
        "description" : "HGVS nomenclatures are the guidelines for mutation nomenclature made by the Human Genome Variation Society.\r\n\r\nHGVS nomenclature can be used with the HL7 coded data type (code data type that accepts expression data, or a coded expression data type). This coded data type should be able to distinguish expressions in HGVS nomenclature from coded concepts. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, HGVS nomenclature can be used to as the observation values for DNA sequence variations. For example, OBX|1|CWE|48004-6^DNA Sequence Variation^LN||c.1129C>T^^HGVS|\r\n\r\nVersioning information: The HGVS nomenclature for the description of sequence variants was last modified Feb 20, 2008. The HGVS nomenclature for the description of protein sequence variants was last modified May 12, 2007. The HGVS nomenclature for the description of DNA sequence variants was last modified June 15, 2007 The HGVS nomenclature for the description of RNA sequence variants was last modified May 12, 2007\r\n\r\nHGVS nomenclatures can be used freely by the public."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/hhcc"
        },
        "name" : "Home Health Care",
        "description" : "HHCC - Home Health Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/hi"
        },
        "name" : "Health Outcomes",
        "description" : "Health Outcomes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/hibccHIN"
        },
        "name" : "HIBCC",
        "description" : "HIBCC"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/hsloc"
        },
        "name" : "NHSN Healthcare Facility Patient Care Location",
        "description" : "A classification of patient care locations within healthcare facilities for public health purposes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ib"
        },
        "name" : "ISBT",
        "description" : "ISBT 128 is a coding system for blood components, hematopoietic progenitor cells and other tissues. It is comprised of an overall Application Specification, and labeling and coding documents for the separate sections: blood components, hematopoietic progenitor cells (draft), source plasma (draft) and tissues (draft). The documentation is supported by databases: Country/Collection Facility, Product Code (blood components), Product Code (hematopoietic progenitor sells), Product Code (source plasma), Product Code (tissues) and Special Testing. ISBT 128 is designed as a series of data structures that are designed to be technology-independent and can be used for bar coding, radio frequency tag encoding and electronic data interchange. The HL7 Blood Bank SIG is currently designing example messages that incorporate ISBT 128 coding. No changes of any kind will be needed to use ISBT 128 in HL7 messages."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icd-o-3"
        },
        "name" : "International Classification of Diseases for Oncology, version 3.",
        "description" : "International Classification of Diseases for Oncology, version 3. For more information see http://www.who.int/classifications/icd/adaptations/oncology/en/."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icd-o"
        },
        "name" : "International Classification of Diseases for Oncology",
        "description" : "International Classification of Diseases for Oncology)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icd10-CA"
        },
        "name" : "Canadian DiagnosisCodes ICD-10-CA",
        "description" : "ICD-10-CA (International Statistical Classification of Diseases and Related Health Problems, 10th Revision, Canada) was developed by the World Health Organization (WHO) and enhanced by CIHI to meet Canadian morbidity data needs. ICD-10-CA classifies diseases, injuries and causes of death, as well as external causes of injury and poisoning. It also includes conditions and situations that are not diseases but represent risk factors to health, such as occupational and environmental factors, lifestyle and psychosocial circumstances."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icd10"
        },
        "name" : "ICD-10",
        "description" : "International Classification of Diseases revision 10 (ICD 10)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icd10CM"
        },
        "name" : "International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM)",
        "description" : "The International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM), describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases. The ICD-10-CM codes can be used as the value of the Act.cd attribute."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icd10PCS"
        },
        "name" : "ICD-10 Procedure Codes",
        "description" : "ICD Procedure Coding System (ICD 10 PCS)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icd10ae"
        },
        "name" : "ICD-10 American English",
        "description" : "International Statistical Classification of Diseases and Related Health Problems (ICD-10): Americanized Version. 10th rev. Geneva (Switzerland): World Health Organization, 1998."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icd9"
        },
        "name" : "ICD9",
        "description" : "ICD9"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icd9cm"
        },
        "name" : "ICD-9CM",
        "description" : "International Classification of Diseases revision 9, with Clinical Modifications (ICD 9 CM)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icnp"
        },
        "name" : "International Classification for Nursing Practice",
        "description" : "ICNP(r) is a combinatorial terminology, using a multi-axial structure. ICNP(r) provides standardized terms and codes for terms in two classifications that can be used to compose or create pre-coordinated concepts to represent observations and procedures, specifically, patient problems/nursing diagnoses, nursing interventions including those focused on assessment and actual or expected (goal) outcomes. The ICNP(r) Classification for Nursing Phenomena is used to compose concepts or statements to represent observations (nursing diagnoses, patient problems, patient status, patient outcomes). The ICNP(r) Nursing Actions Classification is used to compose concepts or statements to represent procedures (nursing interventions)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-BAQ"
        },
        "name" : "International Classification of Primary Care 1993 Basque",
        "description" : "The International Classification of Primary Care (ICPC). Basque Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-DAN"
        },
        "name" : "International Classification of Primary Care 1993 Danish",
        "description" : "The International Classification of Primary Care (ICPC). Danish Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-DUT"
        },
        "name" : "International Classification of Primary Care 1993 Dutch",
        "description" : "The International Classification of Primary Care (ICPC). Dutch Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-ENG"
        },
        "name" : "International Classification of Primary Care 1993 (English)",
        "description" : "The International Classification of Primary Care (ICPC). Swedish Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-FIN"
        },
        "name" : "International Classification of Primary Care 1993 Finnish",
        "description" : "The International Classification of Primary Care (ICPC). Finnish Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-FRE"
        },
        "name" : "International Classification of Primary Care 1993 French",
        "description" : "The International Classification of Primary Care (ICPC). French Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-GER"
        },
        "name" : "International Classification of Primary Care 1993 German",
        "description" : "The International Classification of Primary Care (ICPC). German Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-HEB"
        },
        "name" : "International Classification of Primary Care 1993 Hebrew",
        "description" : "The International Classification of Primary Care (ICPC). Hebrew Translation, Denmark: World Organisation of Family Doctors, 1993"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-HUN"
        },
        "name" : "International Classification of Primary Care 1993 Hungarian",
        "description" : "The International Classification of Primary Care (ICPC). Hungarian Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-ITA"
        },
        "name" : "International Classification of Primary Care 1993 Italian",
        "description" : "The International Classification of Primary Care (ICPC). Italian Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-NOR"
        },
        "name" : "International Classification of Primary Care 1993 Norwegian",
        "description" : "The International Classification of Primary Care (ICPC). Norwegian Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-POR"
        },
        "name" : "International Classification of Primary Care 1993 Portuguese",
        "description" : "The International Classification of Primary Care (ICPC). Portuguese Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-SPA"
        },
        "name" : "International Classification of Primary Care 1993 Spanish",
        "description" : "The International Classification of Primary Care (ICPC). Spanish Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc-SWE"
        },
        "name" : "International Classification of Primary Care 1993 Swedish",
        "description" : "The International Classification of Primary Care (ICPC). Swedish Translation. Denmark: World Organisation of Family Doctors, 1993."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc"
        },
        "name" : "International Classification of Primary Care, 1993 edition",
        "description" : "The International Classification of Primary Care (ICPC). Denmark: World Organisation of Family Doctors, 1993. Various language translations are identified beneath this OID."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc2-icd10-DUT"
        },
        "name" : "ICPC2-ICD10ENG Thesaurus, Dutch Translation",
        "description" : "International Classification of Primary Care / prepared by the Classification Committee of the World Organization of National Colleges, Academies and Academic Associations of General Practitioners/Family Physicians (WONCA), known more briefly as the World"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc2-icd10-ENG"
        },
        "name" : "ICPC2-ICD10 Thesaurus (English)",
        "description" : "Becker, H.W., C. van Boven, S.K. Oskam, I.M. Okkes, W. Hirs, H. Lamberts. ICPC2 - ICD10 Thesaurus, Version March, 2004. Amsterdam: Project \"Adaptation ICPC, integration and implementation of ICPC2 and ICD10(-CM).\" Department of General Practice, Academic"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc2-icd10-THSRS"
        },
        "name" : "ICPC2-ICD10 Thesaurus",
        "description" : "A diagnostic Terminology for semi-automatic Double Coding in Electronic Patient Records\r\n\r\nThe thesaurus is a part of the CD Rom: \"ICPC in the Amsterdam Transition Project. Extended Version. IM Okkes, SK Oskam, H. Lamberts. Amsterdam: Academic Medical Center/University of Amsterdam. Department of Family Medicine\", see also the web site http://www.transitieproject.nl for this application of the thesaurus.\r\n\r\nThis bilingual (English/Dutch) ICPC2-ICD10 thesaurus is derived from an extended version of the CD-Rom ICPC in the Amsterdam Transition Project, that was published as a companion to ICPC-2-R by Oxford University Press (2005). As was the case with the former thesaurus (published in Dutch in 2003), the content of this new thesaurus may be copied for academic purposes, and be used for teaching and research under the usual referencing conditions. Any other and/or commercial use requires prior permission from the authors, represented by Dr. Inge Okkes (see below).\r\n\r\nIt is strongly recommended that you first go through the ICPC Tutorial, the Manual and the Glossary, and consider printing them.\r\n\r\nBecker, H.W., C. van Boven, S.K. Oskam, I.M. Okkes, W. Hirs, H. Lamberts. ICPC2 - ICD10 Thesaurus, Version March, 2004. Amsterdam: Project \"Adaptation ICPC, integration and implementation of ICPC2 and ICD10(-CM).\" Department of General Practice, Academic"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc2E-DUT"
        },
        "name" : "ICPC2E, Dutch Translation",
        "description" : "Hirs, W., H.W. Becker, C. van Boven, S.K. Oskam, I.M. Okkes, H. Lamberts. International Classification of Primary Care 2E: 2nd ed. electronic. Dutch Translation. Amsterdam: Department of General Practice, Academic Medical Center/University of Amsterdam, D"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc2E-ENG"
        },
        "name" : "International Classification of Primary Care, second edition, English",
        "description" : "International Classification of Primary Care / prepared by the Classification Committee of the World Organization of National Colleges, Academies and Academic Associations of General Practitioners/Family Physicians (WONCA), known more briefly as the World"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc2E-P-AE"
        },
        "name" : "ICPC2E 1998 Plus Am Engl",
        "description" : "International Classification of Primary Care, Version 2-Plus, Australian Modification. Americanized English Equivalents, January, 2000. Produced by NLM. Bethesda (MD): National Library of Medicine, UMLS project"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc2E-P-AUS"
        },
        "name" : "ICPC2P 1998 Plus Austral Mod",
        "description" : "International Classification of Primary Care, Version 2-Plus, Australian Modification. January, 2000"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/icpc2E-P"
        },
        "name" : "ICPC2E 1998 Plus",
        "description" : "International Classification of Primary Care, Version 2-Plus. Produced by NLM. Bethesda (MD): National Library of Medicine, UMLS project. This node has the various modifications and translations produced under it."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-icpc2E"
        },
        "name" : "International Classification of Primary Care, second edition (1998)",
        "description" : "International Classification of Primary Care / prepared by the Classification Committee of the World Organization of National Colleges, Academies and Academic Associations of General Practitioners/Family Physicians (WONCA), known more briefly as the World"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ics"
        },
        "name" : "ICCS",
        "description" : "ICCS"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/ietf3066"
        },
        "name" : "Tags for the Identification of Languages",
        "description" : "from OID registry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso21000-6-2004E-RDD"
        },
        "name" : "ISO/IEC 21000-6:2004(E) Rights Data Dictionary",
        "description" : "ISO/IEC 21000-6:2004 describes a Rights Data Dictionary which comprises a set of clear, consistent, structured, integrated and uniquely identified terms to support the MPEG-21 Rights Expression Language (REL), ISO/IEC 21000-5. Annex A specifies the methodology for and structure of the RDD Dictionary, and specifies how further Terms may be defined under the governance of a Registration Authority, requirements for which are described in Annex C.\r\n\r\nTaken together, these specifications and the RDD Dictionary and Database make up the RDD System. Use of the RDD System will facilitate the accurate exchange and processing of information between interested parties involved in the administration of rights in, and use of, Digital Items, and in particular it is intended to support ISO/IEC 21000-5 (REL). Clause 6 describes how ISO/IEC 21000-6:2004 relates to ISO/IEC 21000-5.\r\n\r\nAs well as providing definitions of terms for use in ISO/IEC 21000-5, the RDD System is designed to support the mapping of terms from different namespaces. Such mapping will enable the transformation of metadata from the terminology of one namespace (or Authority) into that of another namespace. Mapping, to ensure minimum ambiguity or loss of semantic integrity, will be the responsibility of the Registration Authority. Provision of automated trm look-up is also a requirement.\r\n\r\nThe RDD Dictionary is a prescriptive dctionary, in the sense that it defines a single meaning for a trm represented by a particular RddAuthorized TermName, but it is also inclusive in that it can recognize the prescription of other Headwords and definitions by other Authorities and incorporates them through mappings. The RDD Dictionary also supports the circumstance that the same name may have different meanings under different Authorities. ISO/IEC 21000-6:2004describes audit provisions so that additions, amendments and deletions to Terms and their attributes can be tracked.\r\n\r\nISO/IEC 21000-6:2004 recognizes legal definitions as and only as Terms from other Authorities that can be mapped into the RDD Dictionary. Therefore Terms that are directly authorized by the RDD Registration Authority neither define nor prescribe intellectual property rights or other legal entities."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-iso3166-1"
        },
        "name" : "ISO 3166 Part 1 Country Codes",
        "description" : "Identifies the coding system published in the ISO 3166-1 Standard for Country codes. This standard is released periodically, and a new OID will be assigned by ISO for new editions."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso3166-1edition2"
        },
        "name" : "ISO 3166 Part 1 Country Codes, 2nd Edition",
        "description" : "This OID identifies the coding system published in the ISO 3166-1 Standard for Country codes. It contains 3 sets of synonyms for the country codes: 2-character alphabetic, 3-character alphabetic, and numeric. Note that this is the 2nd edition of the standard."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso3166-1edition2alpha2"
        },
        "name" : "ISO 3166 Part 1 Country Codes, 2nd Edition, Alpha-2",
        "description" : "Identifies the coding system published in the ISO 3166-1 Standard for Country codes, 2nd edition, 2-character alphabetic codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso3166-1edition2alpha3"
        },
        "name" : "ISO 3166 Part 1 Country Codes, 2nd Edition, Alpha-3",
        "description" : "Identifies the coding system published in the ISO 3166-1 Standard for Country codes, 2nd edition, 3-character alphabetic codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso3166-1edition2numeric"
        },
        "name" : "ISO 3166 Part 1 Country Codes, 2nd Edition, Numeric",
        "description" : "Identifies the coding system published in the ISO 3166-1 Standard for Country codes, 2nd edition, numeric codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso3166-2"
        },
        "name" : "ISO 3166 Part 2 Country Subdivision Codes",
        "description" : "Identifies the coding system published in the ISO 3166-2 Standard for Country Subdivision codes. This standard is released periodically, and a new OID will be assigned by ISO for new editions."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso4217"
        },
        "name" : "ISO 4217 Currency Codes",
        "description" : "ISO 4217 currency codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso639-1"
        },
        "name" : "ISO 639-1: Codes for the representation of names of languages -- Part 1: Alpha-2 code",
        "description" : "**Description:** Codes for the Representation of Names of Languages Part 1: Alpha-2 Code. Used as part of the IETF 3066 specification for languages throughout the HL7 specification.\r\n\r\nThis part of ISO 639 provides a code consisting of language code elements comprising two-letter language identifiers for the representation of names of languages. The language identifiers according to this part of ISO 639 were devised originally for use in terminology, lexicography and linguistics, but may be adopted for any application requiring the expression of language in two- letter coded form, especially in computerized systems. The alpha-2 code was devised for practical use for most of the major languages of the world that are not only most frequently represented in the total body of the world's literature, but which also comprise a considerable volume of specialized languages and terminologies. Additional language identifiers are created when it becomes apparent that a significant body of documentation written in specialized languages and terminologies exists. Languages designed exclusively for machine use, such as computer-programming languages, are not included in this code.\r\n\r\nThe code set is available from http://www.iso.org/iso/iso\\_catalogue/catalogue\\_ics/catalogue\\_detail\\_ics.htm? csnumber=22109&ICS1=1&ICS2=140&ICS3=20"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso639-1ret"
        },
        "name" : "ISO 639-1 Alpha-2 Language Codes",
        "description" : "Codes for the Representation of Names of Languages Part 1: Alpha-2 Code. Used as part of the IETF 3066 specification for languages throughout the HL7 specification.\r\n\r\n*DeprecationComment:* This code system is being deprecated, as the OID identifying it has been replaced with the correct ISO OID of 1.0.639.1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso639-2"
        },
        "name" : "ISO 639-2: Codes for the representation of names of languages -- Part 2: Alpha-3 code",
        "description" : "**Description:** Codes for the representation of names of languages, 3 character alphabetic codes. This has been superceded by ISO 639-3 for many purposes. ISO 639-2 was released in 1998.\r\n\r\nThe code set is available from http://www.iso.org/iso/iso\\_catalogue/catalogue\\_tc/catalogue\\_detail.htm?csnumber=4767"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso639-2ret"
        },
        "name" : "ISO 639-2 Alpha-3 Language Codes",
        "description" : "Codes for the Representation of Names of Languages Part 2: Alpha-3 Code. Used as part of the IETF 3066 specification for languages throughout the HL7 specification.\r\n\r\n*DeprecationComment:* This code system is being deprecated, as the OID identifying it has been replaced with the correct ISO OID of 1.0.639.2"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/iso639-3"
        },
        "name" : "ISO 639-3 Language Codes Alpha 3",
        "description" : "**Description:** ISO 639-3 is a code that aims to define three-letter identifiers for all known human languages. At the core of ISO 639-3 are the individual languages already accounted for in ISO 639-2. The large number of living languages in the initial inventory of ISO 639-3 beyond those already included in ISO 639-2 was derived primarily from Ethnologue (15th edition). Additional extinct, ancient, historic, and constructed languages have been obtained from Linguist List.\r\n\r\nSIL International has been designated as the ISO 639-3/RA for the purpose of processing requests for alpha-3 language codes comprising the International Standard, Codes for the representation of names of languages - Part 3: Alpha-3 code for comprehensive coverage of languages. The ISO 639-3/RA receives and reviews applications for requesting new language codes and for the change of existing ones according to criteria indicated in the standard. It maintains an accurate list of information associated with registered language codes which can be viewed on or downloaded from this website, and processes updates of registered language codes. Notification of pending and adopted updates are also distributed on a regular basis to subscribers and other parties."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-loinc"
        },
        "name" : "Logical Observation Identifier Names and Codes (LOINC)",
        "description" : "LOINC provides a set of universal names and ID codes for identifying laboratory and clinical test results.1,2 LOINC facilitates the exchange and pooling of results, such as blood hemoglobin, serum potassium, or vital signs, for clinical care, outcomes management, and research. LOINC's universal identifiers (names and codes) can be used in the context of order and observation exchanges between information systems that use syntax standards such as HL73, CEN TC251, ISO TC215, ASTM4, and DICOM. Specifically, the identifier can be used as the coded value for an observation in any other standard that uses the observation/observation value paradigm, whether messages, documents, application programming interface (API), etc. For example, LOINC codes are used widely in the OBX segment Observation Identifier field (OBX-3) of an ORU HL7 (HL7 version 2.x or ASTM 1238-9410) message that may be sent between a Clinical Laboratory Information Management Systems (LIMS) and Electronic Health Record Systems (EHR).5, 6 In this way, LOINC codes provide universal identifiers that allow the exchange of clinical data between heterogeneous computing environments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-lrg"
        },
        "name" : "Locus Reference Genomic Sequences (LRG)",
        "description" : "In collaboration with NCBI, the European Bioinformatics Institute (EBI) is developing the Locus Reference Genomic Sequences (LRG) database, which is a database of reference sequences.\r\n\r\nLRG is a system for providing a genomic DNA sequence representation of a single gene that is idealized, has a permanent ID (with no versioning), and core content that never changes. LRG is not a nomenclature system. More than one LRG could be created for a region of interest, should that need arise. Additional annotations will be present that may change with time (each item carrying its own date stamp), so that the latest ancillary knowledge about a gene is directly available. In other words, an LRG sequence and its core annotation are not meant to represent current biology knowledge, but to provide a standard for reporting variation in a stable coordinate system. The combination of the LRG plus the updatable-annotation layer will be used to support the biological interpretation of variants.\r\n\r\nLRG identifiers can be used with the HL7 coded data type (code data type that accepts expression data, or a coded expression data type). This coded data type will be gene symbols can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, LRG identifiers can be used to as the observation values for Genomic Reference Sequence Identifier (LOINC code: 48013-7).\r\n\r\nLRG is a database that can be used freely by the public."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-mdc"
        },
        "name" : "ISO 11073-10101 Health informatics - Point-of-care",
        "description" : "The nomenclature relates primarily to vital signs monitoring, but also includes semantics of other medical devices that are commonly used in acute care settings. There are multiple coding partitions each of which has a systematic name consisting of a set of base concepts and differentiating criteria."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/mddid"
        },
        "name" : "MDDID",
        "description" : "Medispan Drug Descriptor ID\r\n\r\nEntry autogenerated to support Sources from the UMLS. Full metadata set still incomplete."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/mdr"
        },
        "name" : "Medical Dictionary for Regulatory Activities",
        "description" : "MedDRA is a multilingual standardised international medical terminology which can be used for regulatory communication and evaluation of data pertaining to medicinal products for human use.  MedDRA is designed for use in the registration, documentation and safety monitoring of medicinal products through all phases of the development cycle (i.e., from clinical trials to post-marketing surveillance).#13;\n\r\nMedDRA is structured as a five level hierarchy. System Organ Classes (SOCs) are the broadest terms (e.g., Cardiac disorders, Investigations). The lowest level of the terminology is the Lowest Level Term (LLT) level."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/medcin"
        },
        "name" : "MEDCIN",
        "description" : "MEDCIN contains more than 175,000 clinical data elements arranged in a hierarchy, with each item having weighted links to relevant diagnoses. The clinical data elements are organized into six basic termtypes designed to accommodate information relevant to a clinical encounter. The basic termtypes in MEDCIN's terminological hierarchy are as follows:\r\n\r\nSymptoms History Physical Examination Tests Diagnoses Therapy\r\n\r\nWithin this basic structure, MEDCIN terms are further organized in a ten level terminological hierarchy, supplemented by an optional, multi-hierarchical diagnostic index. For example, the symptom of \"difficulty breathing\" is placed in the terminological hierarchy as a subsidiary (or \"child\") finding of \"pulmonary symptoms,\" although the presence (or absence) of difficulty breathing can related to conditions as diverse as myocardial infarction, bronchitis, pharyngeal foreign bodies, asthma, pulmonary embolism, etc. MEDCIN's diagnostic index provides more than 800 such links for difficulty breathing."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-mediaType"
        },
        "name" : "IANA Media Types",
        "description" : "Internet Assigned Numbers Authority (IANA) Mime Media Types. Identifies the type of the encapsulated data and identifies a method to interpret or render the data. The IANA defined domain of media types is established by the Internet standard RFC 2045 \\[http://www.ietf.org/rfc/rfc2045.txt\\] and 2046 \\[http://www.ietf.org/rfc/rfc2046.txt\\]. RFC 2046 defines the media type to consist of two parts:\r\n\r\n1.  top level media type, and\r\n2.  media subtype\r\n\r\nHowever, this HL7 datatypes specification treats the entire media type as one atomic code symbol in the form defined by IANA, i.e., top level type followed by a slash \"/\" followed by media subtype. Currently defined media types are registered in a database \\[http://www.iana.org/assignments/media-types/index.html\\] maintained by IANA. Currently several hundred different MIME media types are defined, with the list growing rapidly. In general, all those types defined by the IANA MAY be used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/metabolicSyndrome"
        },
        "name" : "METABOLIC SYNDROME",
        "description" : "A collection of metabolic risk factors in one individual. The root causes of metabolic syndrome are overweight / obesity, physical inactivity, and genetic factors. Various risk factors have been included in metabolic syndrome. Factors generally accepted as being characteristic of this syndrome include abdominal obesity, atherogenic dyslipidemia, raised blood pressure, insulin resistence with or without glucose intolerance, prothrombotic state, and proinflammatory state."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-mime"
        },
        "name" : "MIME",
        "description" : "IETF MIME media types"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/mth-icpc2-icd10-7B"
        },
        "name" : "ICPC2-ICD10 Thesaurus, 7-bit",
        "description" : "International Classification of Primary Care / prepared by the Classification Committee of the World Organization of National Colleges, Academies and Academic Associations of General Practitioners/Family Physicians (WONCA), known more briefly as the World"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/mth-icpc2-icd10-AE"
        },
        "name" : "ICPC2-ICD10 Thesaurus, Am Engl",
        "description" : "International Classification of Primary Care / prepared by the Classification Committee of the World Organization of National Colleges, Academies and Academic Associations of General Practitioners/Family Physicians (WONCA), known more briefly as the World"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/mthicpc2E-AE"
        },
        "name" : "ICPC2E Am Engl (Metathesaurus)",
        "description" : "Henk Lamberts and Inge Hofmans-Okkes. International Classification of Primary Care 2nd Edition, Electronic, 2E, American English Equivalents. Amsterdam: International Classification of Primary Care / prepared by the Classification Committee of the World Health Organization. Entry derived from the UMLS Metathesaurus."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/multum"
        },
        "name" : "Multum Lexicon",
        "description" : "Broadly, the fields and values in the Multum Lexicon and the VantageRx Database are intended to be available for use in any HL7 message that includes a reference to non-veterinary drug products or active ingredients that are either approved for sale by the FDA or readily available in the United States. The following inter-related definitions recently circulated by us to the HL7 Vocabulary Technical Committee explain the scope of what we mean by \"drug product\" and \"active ingredient\". (A definition for \"drug ingredient\" is also provided here because the definition of \"active ingredient\" is reliant on this term.)\r\n\r\nDrug Product A drug product is a manufactured or extemporaneously-compounded physiologically-active material intended by the preparer to achieve therapeutic, diagnostic, or preventative effects via biochemical mechanisms when applied to an epithelial surface or placed in an internal body space of a targeted organism.\r\n\r\nDrug Ingredient A drug ingredient is a chemical compound or biologic agent that occurs in a drug product.\r\n\r\nActive Ingredient An active ingredient is a drug ingredient that mediates one or more of the intended therapeutic, diagnostic, or preventative effects of a drug product and is present in sufficient quantities to achieve such effects according to the allopathic tradition of healthcare practice."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/naaccrCodes"
        },
        "name" : "NAACCR",
        "description" : "NAACCR Cancer Registry"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/naics"
        },
        "name" : "North American Industry Classification System",
        "description" : "North American Industry Classification System(NAICS) for the United States, a new economic classification system that replaces the 1987 Standard Industrial Classification (SIC) for statistical purposes. NAICS is a system for classifying establishments by type of economic activity. Its purposes are: (1) to facilitate the collection, tabulation, presentation, and analysis of data relating to establishments, and (2) to promote uniformity and comparability in the presentation of statistical data describing the economy. NAICS will be used by Federal statistical agencies that collect or publish data by industry."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/nanda-i"
        },
        "name" : "NANDA International",
        "description" : "The terminology consists of standardized terms and codes for patient problems or life processes expressed as nursing diagnoses. These data elements would be classified by HL7 as \"observations\". The taxonomy is multi-axial. It consists of 12 domains and 36 classes. All domains and classes are defined. There are 7 axes with definitions for each. Each nursing diagnosis consists of: a concept label or term expressed as a noun or a noun phrase; a definition of the term; a set of defining characteristics (signs and symptoms) of the diagnostic term; an approved list of modifiers of the term; a set of risk factors with definitions; and a set of related factors (or etiologies) for the term. The system preserves semantics by having robust review procedures and policies to ensure against semantic drift in the meanings of the encoded terms over time. NANDA as an organization is committed to updating the terminology on a regular biannual basis. NANDA has been in existence since 1973 and is thus the oldest developer of standardized language in nursing. Most other nursing language systems use many of the older NANDA terms in their vocabularies. The express purpose of the organization is to develop a comprehensive standardized nursing language that captures the conclusions that nurses make based on observations - in effect, the nursing diagnoses. The work is a continuing effort and diagnoses are revised, retired or added bi-annually. The codes are simple integers and are not linked to each other. If a diagnostic term is retired, the code is also retired. If a new diagnosis is added a new code is given to that term. If a diagnostic term is revised, the code is kept intact but the date of the revision is published alongside the term. Domains and classes are not coded."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-nciThesaurus"
        },
        "name" : "NCI Thesaurus",
        "description" : "NCI Thesaurus NCI Thesaurus is a biomedical thesaurus created specifically to meet the needs of the cancer research community, especially those engaged in translational research NCI Thesaurus is produced by the NCI Enterprise Vocabulary Services project. The NCI Thesaurus is provided under an open content license."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/nciVersionOfNDF-RT"
        },
        "name" : "NCI Version of NDF-RT",
        "description" : "The National Drug File RT (NDF-RT) is published by the US Veterans' Administration (VA). NDF-RT covers clinical drugs used at the VA. The NCI version of NDF-RT is used by NCI to provide automated terminology access to the Food and Drug Administration (FDA) Structured Product Label (SPL) initiative. NCI makes its version of NDF-RT available publicly thru the Web, download via FTP and via open APIs for Java, SOAP and HTTP."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-ndc"
        },
        "name" : "National drug codes",
        "description" : "National drug codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/nddf"
        },
        "name" : "National Drug Data File",
        "description" : "National Drug Data File Plus Source Vocabulary 2004. San Bruno, CA: First DataBank, March 11, 2004.\r\n\r\nThis entry was generated to support the Sources in the UMLS. Additional metadata is still missing."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/nic"
        },
        "name" : "Nursing Intervention Classification",
        "description" : "The Nursing Interventions Classification (NIC) is a standardized classification developed by a research team at the University of Iowa. The purpose of NIC is to define interventions that nurses do on behalf of patients in all care domains. An intervention is defined as 'any treatment, based upon clinical judgment and knowledge, a nurse performs to enhance patient/client outcomes.' NIC is updated a five-year cycle."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/nmds"
        },
        "name" : "Nursing Minimum Data Set",
        "description" : "The NMDS is the minimum set of items of information with uniform definitions and categories concerning the specific dimension of the context of patient care delivery. It represents the minimum data used to support the management and administration of patient/nursing care delivery across all types of settings."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/nmmds"
        },
        "name" : "Nursing Management Minimum Data Set",
        "description" : "The NMMDS is the minimum set of items of information with uniform definitions and categories concerning the specific dimension of the context of patient care delivery. It represents the minimum data used to support the management and administration of patient/nursing care delivery across all types of settings. The NMMDS is composed of seventeen (17) data elements organized into three categories: environment, nurse resources, and financial resources. See Tables 1-3 for the elements and related definitions organized by each categories. The NMMDS most appropriately focuses at the first level of accountability for patient/client/family/community nursing care: this may be the delivery unit, service, or center of excellence level. The NMMDS supports numerous constructed variables as well as aggregation of data at the unit, institution, network, and system, etc levels. This minimum data set provides the structure for the collection of uniform information that influences quality of patient care, directly and indirectly."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/noc"
        },
        "name" : "NOC",
        "description" : "NOC - Nursing Outcome Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/nubc-UB92"
        },
        "name" : "National Uniform Billing Council, UB 92",
        "description" : "National Uniform Billing Council, UB 92"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-nuccProviderCodes"
        },
        "name" : "NUCC Health Care Provider Taxonomy",
        "description" : "The Provider Taxonomy Code List is published (released) twice a year on July 1st and January 1st. The July publication is effective for use on October 1st and the January publication is effective for use on April 1st. The time between the publication release and the effective date is considered an implementation period to allow providers, payers and vendors an opportunity to incorporate any changes into their systems. This listing includes Active codes approved for use effective April 1st, 2003, version 3.0; and codes that are New and approved for use effective October 1st, 2003, version 3.1.\r\n\r\nIt was identified that there is an IP licensure issue with the republishing of the content for this code system by HL7, so the content was removed as of the July 2016 Harmonization cycle release. This external code system content may be accessed from the web page located at http://www.nucc.org/index.php/code-sets-mainmenu-41/provider-taxonomy-mainmenu-40. Multiple formats and means of accessing the content are available from this page."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/oms"
        },
        "name" : "Omaha System",
        "description" : "The Omaha System provides standardized terms, definitions, and codes for observations and procedures, specifically for client problems, multidisciplinary interventions including those focusing on assessment and care, and problem-specific client outcomes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/opinions"
        },
        "name" : "Online Product Identification Number Index of Nova Scotia",
        "description" : "**Description:** Codes to identify products and services that do not have DIN's and which need to be billed. http://www.atlanticpharmaceutical.ca/default.asp?mn=5.23"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/pclocd"
        },
        "name" : "pan-Canadian LOINC Observation Code Database",
        "description" : "The pan Canadian LOINC Observation Code Database (pCLOCD) is the Canadian version of the LOINC(tm) database. It was created using the LOINC(tm) records and attributes that were constrained for Canadian use and supplemented to specifically meet Canadian requirements. It contains the core LOINC(tm) attributes as required by Regenstrief copyright rules. The LOINC(tm) Component has been customized to meet Canadian requirements and is displayed as the pan Canadian Component Name. This component name is the basis for the pan Canadian Display Name. Core attributes are include both English and Canadian French.\r\n\r\nThis code system contains supplemental \"X\" codes defined in the pCLOCD that do not yet exist in the LOINC code system."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/pnds"
        },
        "name" : "Perioperative Nursing Data Set",
        "description" : "The PNDS provides standardized terms and codes for patient problems/nursing diagnoses, nursing interventions including actual or expected (goal) outcomes. The PNDS provides standardized terms and codes for nursing diagnoses (a subset of NANDA), nursing interventions and outcomes. The outcomes and interventions are in a relational database. The PNDS intervention and outcome statements are attached in an Access Database. The NANDA diagnoses in the PNDS have already been registered by HL7."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/rcFB"
        },
        "name" : "The Read Codes Four Byte Set:",
        "description" : "The Read Codes Four Byte Set consists of 4 alphanumeric characters. This version contains approximately 40,000 codes arranged in a hierarchical structure.\r\n\r\nTop level hierarchy sections: Disorders Findings Surgical procedures Investigations Occupations Drugs"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/rcV2"
        },
        "name" : "The Read Codes Version 2",
        "description" : "The Read Codes Version 2 contains over 70,000 coded concepts arranged in a hierarchical structure.\r\n\r\nTop level hierarchy sections: Disorders Findings Surgical procedures Investigations Occupations Drugs"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/read-Codes"
        },
        "name" : "Read Classification",
        "description" : "Clinical Terms Version 3 contains over 200,000 coded concepts arranged in a sub-type hierarchical structure.\r\n\r\nTop level hierarchy sections: Disorders Findings Morphology Surgical procedures Regimes & therapies Investigations Stages & scales Occupations Organisms Units Drugs Appliances & equipment"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-refSeq"
        },
        "name" : "Gene Reference Sequence Collection",
        "description" : "The Reference Sequence (RefSeq) is one of the NCBI projects, the RefSeq collection aims to provide a comprehensive, integrated, non-redundant, well-annotated set of sequences, including genomic DNA, transcripts, and proteins. ReqSeq is accessible via BLAST, Entrez, and the NCBI FTP site. Information is also available in Entrez Genomes and Entrez Gene, and for some genomes additional information is available in the Map Viewer.\r\n\r\nRefSeq entries can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, RefSeq entries can be used to as the observation values for genomic reference sequence identifiers (LOINC \\#: 48013-7).\r\n\r\nMore information may be found at: http://www.ncbi.nlm.nih.gov/RefSeq\r\n\r\nVersioning informaiton: The latest release of RefSeq was released on May 13, 2009 with the release number of 35.\r\n\r\nRefSeq generates new releases roughly every two months. The dates of the three previous releases were: Release 34, March 12, 2009 Release 33, January 20, 2009 Release 32, November 17, 2008\r\n\r\nRefSeq is a free database for the public."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-rxNorm"
        },
        "name" : "RxNorm",
        "description" : "RxNorm provides normalized names for clinical drugs and links its names to many of the drug vocabularies commonly used in pharmacy management and drug interaction software, including those of First Databank, Micromedex, and Gold Standard Drug Database. By providing links between these vocabularies, RxNorm can mediate messages between systems not using the same software and vocabulary. RxNorm now includes the United States Pharmacopeia (USP) Compendial Nomenclature from the United States Pharmacopeial Convention. USP is a cumulative data set of all Active Pharmaceutical Ingredients (API)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-scpqual"
        },
        "name" : "pan-Canadian Provider Qualification Types",
        "description" : "SCPQUAL is used to encode the degree or educational rank of a healthcare provider credential as defined by the various Royal Canadian Professional Medical Collages. It is also supports the encoding “Expertise type” in the pan-Canadian version 3 messages"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-scptype"
        },
        "name" : "pan-Canadian Provider Types",
        "description" : "SCPTYPE is used to encode and categorize an entity that delivers health care in an expected and professional manner to an entity in need of health care services. Examples: Registered Nurse, Chiropractor, Physician, Custodial Care Clinic. Allows for the implementation of role-based access to clinical functions and data. Provisioning of clinical services is based on the role that a provider may play in the health system."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-sctemp"
        },
        "name" : "pan-Canadian Temporary Codes",
        "description" : "These pan-Canadian codes are maintained in circumstances where the desired code is not yet available in another code system (HL7 code systems, LOINC, SNOMED, etc.) In general, the codes will be deprecated once an equivalent code is available in the preferred code system. The SCTEMP is a transitional or temporary CodeSystem supported and maintained by Canada Health Infoway.  It houses the code(s) required and accepted by Canadian implementers if the implementation cannot wait for the code to be harmonized  with the international terminology authority. The SCTEMP CodeSystem also served as a  source for tracking  submissions that need to be made to the various terminology authorities. The SCTEMP CodeSystem applies to HL7, non-SNOMED CT and non-LOINC /pCLOCD used within pan-Canadian specifications. The SCTEMP is not used for the Unified Code for Units of Measure (UCUM)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/sic"
        },
        "name" : "US Census Bureau",
        "description" : "The Standard Industrial Classification Codes that appear in a company's disseminated EDGAR filings indicate the company's type of business. These codes are also used in the Division of Corporation Finance as a basis for assigning review responsibility for the company's filings. For example, a company whose business was Metal Mining (SIC 1000) would have its filings reviewed by staffers in A/D Office 4. Note that this code system is published both by the US Bureau of Labor Statistics (BLS) at http://www.sec.gov/info/edgar/siccodes.htm, and by the US Occupational & Safety Health Administration (OSHA) at http://www.osha.gov/pls/imis/sic\\_manual.html."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/snm"
        },
        "name" : "Systemized Nomenclature of Medicine (SNOMED)",
        "description" : "Systemized Nomenclature in Medicine (SNOMED)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-snomed-CT"
        },
        "name" : "SNOMED CT International Edition",
        "description" : "SNOMED CT is a core clinical healthcare terminology that contains concepts with unique meanings and formal logic based definitions organized into hierarchies."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/soc"
        },
        "name" : "Standard Occupation Code",
        "description" : "The Standard Occupational Classification (SOC) system is used by Federal statistical agencies to classify workers into occupational categories for the purpose of collecting, calculating, or disseminating data. All workers are classified into one of over 820 occupations according to their occupational definition. To facilitate classification, occupations are combined to form 23 major groups, 96 minor groups, and 449 broad occupations. Each broad occupation includes detailed occupation(s) requiring similar job duties, skills, education, or experience. This code system replaced the older FIPSPUB92, which was withdrawn in February 2005."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/standardBillingUnit"
        },
        "name" : "Standard Billing Unit",
        "description" : "NCPDP standard product billing codes of NCPDP field Unit of Measure (600-28). This billing code is assigned per product, placed in the Structured Product Label, and used in the pharmacy billing processing for consistent billing unit."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/v3-ucum"
        },
        "name" : "Unified Code for Units of Measure (UCUM)",
        "description" : "The Unified Code for Units of Measure (UCUM) is a code system intended to include all units of measures being contemporarily used in international science, engineering, and business. The purpose is to facilitate unambiguous electronic communication of quantities together with their units. The focus is on electronic communication, as opposed to communication between humans. A typical application of The Unified Code for Units of Measure are electronic data interchange (EDI) protocols, but there is nothing that prevents it from being used in other types of machine communication."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/umls"
        },
        "name" : "Unified Medical Language System",
        "description" : "UMLS codes as CUIs making up the values in a coding system. More information may be found at http://www.nlm.nih.gov/research/umls/"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/url"
        },
        "name" : "URL",
        "description" : "Universal Resource Locator (URL) schemes Currently there is no single authority for URL schemes. The authority for URL scheme assignments clearly lies within IANA or W3C and it is likely that a formal URL/URI assigning authority will be formed soon."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/usEPAsrs"
        },
        "name" : "US EPA Substance Registry System",
        "description" : "The United States Environmental Protection Agency's (US EPA) Substance Registry System (SRS) provides information on substances and how they are represented in US environmental statutes, in US EPA information systems, and in information systems owned by other organizations. The SRS provides standardized identification for each substance to improve data quality in US EPA systems and elsewhere."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/whoARTfl"
        },
        "name" : "WHO Adverse Reaction Terms foreign language translations",
        "description" : "WHO Adverse Drug Reaction Terminology (WHOART). Uppsala (Sweden): WHO Collaborating Centre for International Drug Monitoring, 1997. This branch node OID contains identifiers for the different foreign language versions of this terminology. For more information, see http://www.umc-products.com/graphics/3149.pdf"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/whoFRE"
        },
        "name" : "WHO Adverse Reaction Terms French",
        "description" : "WHO Adverse Drug Reaction Terminology (WHOART). French Translation. Uppsala (Sweden): WHO Collaborating Centre for International Drug Monitoring, 1997. For more information, see http://www.umc-products.com/graphics/3149.pdf"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/whoGER"
        },
        "name" : "WHO Adverse Reaction Terms German",
        "description" : "WHO Adverse Drug Reaction Terminology (WHOART). German Translation. Uppsala (Sweden): WHO Collaborating Centre for International Drug Monitoring, 1997. For more information, see http://www.umc-products.com/graphics/3149.pdf"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/whoPOR"
        },
        "name" : "WHO Adverse Reaction Terms Portuguese",
        "description" : "WHO Adverse Drug Reaction Terminology (WHOART). Portuguese Translation. Uppsala (Sweden): WHO Collaborating Centre for International Drug Monitoring, 1997. For more information, see http://www.umc-products.com/graphics/3149.pdf"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/whoSPA"
        },
        "name" : "WHO Adverse Reaction Terms Spanish",
        "description" : "WHO Adverse Drug Reaction Terminology (WHOART). Spanish Translation. Uppsala (Sweden): WHO Collaborating Centre for International Drug Monitoring, 1997. For more information, see http://www.umc-products.com/graphics/3149.pdf"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/FDI-surface"
        },
        "name" : "Surface Codes",
        "description" : "This value set includes a smattering of FDI tooth surface codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/accepting-patients"
        },
        "name" : "Accepting Patients",
        "description" : "This code system defines a set of codes that can be used to indicate a practice is accepting new patients."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/action-type"
        },
        "name" : "ActionType",
        "description" : "The type of action to be performed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/activity-definition-category"
        },
        "name" : "ActivityDefinitionCategory",
        "description" : "High-level categorization of the type of activity."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/adjudication-error"
        },
        "name" : "Adjudication Error Codes",
        "description" : "This value set includes a smattering of adjudication codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/adjudication-reason"
        },
        "name" : "Adjudication Reason Codes",
        "description" : "This value set includes smattering of Adjudication Reason codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/adjudication"
        },
        "name" : "Adjudication Value Codes",
        "description" : "This value set includes a smattering of Adjudication Value codes which includes codes to indicate the amounts eligible under the plan, the amount of benefit, copays etc."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/admit-source"
        },
        "name" : "Admit source",
        "description" : "This value set defines a set of codes that can be used to indicate from where the patient came in."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/adverse-event-category"
        },
        "name" : "AdverseEventCategory",
        "description" : "Overall categorization of the event, e.g. product-related or situational."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/adverse-event-causality-assess"
        },
        "name" : "AdverseEventCausalityAssessment",
        "description" : "Codes for the assessment of whether the entity caused the event."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/adverse-event-causality-method"
        },
        "name" : "AdverseEventCausalityMethod",
        "description" : "This code system contains methods for assessing causality."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/adverse-event-seriousness"
        },
        "name" : "AdverseEventSeriousness",
        "description" : "Overall seriousness of this event for the patient."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/adverse-event-severity"
        },
        "name" : "AdverseEventSeverity",
        "description" : "The severity of the adverse event itself, in direct relation to the subject."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allerg-intol-substance-exp-risk"
        },
        "name" : "AllergyIntoleranceSubstanceExposureRisk",
        "description" : "The risk of an adverse reaction (allergy or intolerance) for this patient upon exposure to the substance (including pharmaceutical products)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allergyintolerance-clinical"
        },
        "name" : "AllergyIntolerance Clinical Status Codes",
        "description" : "Preferred value set for AllergyIntolerance Clinical Status."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/allergyintolerance-verification"
        },
        "name" : "AllergyIntolerance Verification Status",
        "description" : "The verification status to support or decline the clinical status of the allergy or intolerance."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/applicability"
        },
        "name" : "Benefit cost applicability",
        "description" : "Whether the cost applies to in-network or out-of-network providers."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/appointment-cancellation-reason"
        },
        "name" : "Appointment cancellation reason",
        "description" : "This example value set defines a set of reasons for the cancellation of an appointment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/artifact-contribution-instance-type"
        },
        "name" : "Artifact Contribution Instance Type",
        "description" : "Artifact Contribution Instance Type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/artifact-identifier-type"
        },
        "name" : "Artifact Identifier Type Codes",
        "description" : "Identifier types for an artifact (e.g. version-independent, version-specific, short-name, endorser, publisher)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/artifact-relationship-type"
        },
        "name" : "Artifact Relationship Type",
        "description" : "This artifact incorporates the target artifact. This artifact is constructed with the target artifact as a component. The target artifact is a part of this artifact. (A dataset is composed of data.)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/artifact-url-classifier"
        },
        "name" : "Artifact Url Classifier",
        "description" : "Code the reason for different URLs, eg abstract and full-text."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/artifact-version-policy-codes"
        },
        "name" : "Artifact Version Policy Codes",
        "description" : "The versioning policy of an artifact (metadata, strict, loose, package)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/attribute-estimate-type"
        },
        "name" : "StatisticAttribute Estimate Type",
        "description" : "Method of reporting variability of estimates, such as confidence intervals, interquartile range or standard deviation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/audit-entity-type"
        },
        "name" : "Audit event entity type",
        "description" : "Code for the entity type involved in the audit event."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/audit-event-outcome"
        },
        "name" : "AuditEventOutcome",
        "description" : "Indicates whether the event succeeded or failed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/audit-event-type"
        },
        "name" : "Audit Event ID",
        "description" : "Event Types for Audit Events - defined by DICOM with some FHIR specific additions."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/basic-resource-type"
        },
        "name" : "Basic Resource Types",
        "description" : "This value set defines codes for resources not yet supported by (or which will never be supported by) FHIR.  Many of the codes listed here will eventually be turned into official resources.  However, there is no guarantee that any particular resource will be created nor that the scope will be exactly as defined by the codes presented here.  Codes in this set will be deprecated if/when formal resources are defined that encompass these concepts."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/benefit-network"
        },
        "name" : "Network Type Codes",
        "description" : "This code system represents the contractual relationship between a provider and payer for administrative purposes for a specific patient, service, or product."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/benefit-term"
        },
        "name" : "Benefit Term Codes",
        "description" : "This value set includes a smattering of Benefit Term codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/benefit-type"
        },
        "name" : "Benefit Type Codes",
        "description" : "This value set includes a smattering of Benefit type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/benefit-unit"
        },
        "name" : "Unit Type Codes",
        "description" : "This value set includes a smattering of Unit type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/can-push-updates"
        },
        "name" : "Can-push-updates",
        "description" : "Ability of the primary source to push updates/alerts"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/care-service-accessibility"
        },
        "name" : "Care Service Accessibility",
        "description" : "This code system defines a set of codes that can be used to describe care service accessibility options offered by a practitioner or at a location."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/catalogType"
        },
        "name" : "CatalogType",
        "description" : "The type of catalog."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cdshooks-card-type"
        },
        "name" : "CDS Hooks Card Types",
        "description" : "Codes defining types of cards that can potentially be returned by a decision support service.  The initial set of codes is biased towards those related to insurance coverage, but all types of response types are acceptable in the code system."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cdshooks-indicator"
        },
        "name" : "CDS Hooks Indicator",
        "description" : "This codesystem captures the indicator codes defined by the CDS Hooks specification.    The indicator is included as an element of the cards in a CDS Hooks response and    conveys the urgency and/or importance of the information in each card. See [Card    Attributes](https://cds-hooks.hl7.org/1.0/#card-attributes) in the CDS Hooks specification    for more information. Note - the CodeSystem is transitioning from the Vocabulary Work Group to Clinical Decision Support (CDS) Work Group."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/certainty-rating"
        },
        "name" : "StatisticCertaintyRating",
        "description" : "The relative quality of the statistic."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/certainty-subcomponent-rating"
        },
        "name" : "StatisticCertaintySubcomponentRating",
        "description" : "The quality rating of the subcomponent of a quality of evidence rating."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/certainty-subcomponent-type"
        },
        "name" : "StatisticCertaintySubcomponentType",
        "description" : "The subcomponent classification of quality of evidence rating systems."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/certainty-type"
        },
        "name" : "Evidence Certainty Type",
        "description" : "The aspect of quality, confidence, or certainty."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/characteristic-method"
        },
        "name" : "CharacteristicMethod",
        "description" : "The method used to determine the characteristic(s) of the variable."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/chargeitem-billingcodes"
        },
        "name" : "ChargeItemCode",
        "description" : "Example set of codes that can be used for billing purposes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/choice-list-orientation"
        },
        "name" : "ChoiceListOrientation",
        "description" : "Direction in which lists of possible answers should be displayed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/chromosome-human"
        },
        "name" : "chromosome-human",
        "description" : "Chromosome number for human."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/citation-classification-type"
        },
        "name" : "Citation Classification Type",
        "description" : "Citation classification type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/citation-summary-style"
        },
        "name" : "Citation Summary Style",
        "description" : "The format for display of the citation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cited-artifact-abstract-type"
        },
        "name" : "Cited Artifact Abstract Type",
        "description" : "Used to express the reason and specific aspect for the variant abstract, such as language and specific language"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cited-artifact-classification-type"
        },
        "name" : "Cited Artifact Classification Type",
        "description" : "Cited Artifact Classification Type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cited-artifact-contribution-type"
        },
        "name" : "Cited Artifact Contribution Type",
        "description" : "Citation contribution."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cited-artifact-part-type"
        },
        "name" : "Cited Artifact Part Type",
        "description" : "To describe the reason for the variant citation, such as version number or subpart specification."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cited-artifact-status-type"
        },
        "name" : "Cited Artifact Status Type",
        "description" : "Cited Artifact Status Type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cited-medium"
        },
        "name" : "Cited Medium",
        "description" : "NLM codes Internet or Print."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/claim-exception"
        },
        "name" : "Exception Codes",
        "description" : "This value set includes sample Exception codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/claim-type"
        },
        "name" : "Claim Type Codes",
        "description" : "This value set includes Claim Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/claimcareteamrole"
        },
        "name" : "Claim Care Team Role Codes",
        "description" : "Claim roles of the care team members providing products and services."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/claiminformationcategory"
        },
        "name" : "Claim Information Category Codes",
        "description" : "This value set includes sample Information Category codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/codesystem-altcode-kind"
        },
        "name" : "AlternativeCodeKind",
        "description" : "Indicates the type of use for which the code is defined."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/common-tags"
        },
        "name" : "Common Tags",
        "description" : "Common Tag Codes defined by FHIR project"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/communication-category"
        },
        "name" : "CommunicationCategory",
        "description" : "Codes for general categories of communications such as alerts, instructions, etc."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/communication-not-done-reason"
        },
        "name" : "CommunicationNotDoneReason",
        "description" : "Codes for the reason why a communication did not happen."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/communication-topic"
        },
        "name" : "CommunicationTopic",
        "description" : "Codes describing the purpose or content of the communication."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/composite-measure-scoring"
        },
        "name" : "CompositeMeasureScoring",
        "description" : "The composite scoring method of the measure."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/composition-altcode-kind"
        },
        "name" : "AlternativeCodeKind",
        "description" : "Indicates the type of use for which the code is defined."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/condition-category"
        },
        "name" : "Condition Category Codes",
        "description" : "Preferred value set for Condition Categories."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/condition-clinical"
        },
        "name" : "Condition Clinical Status Codes",
        "description" : "Preferred value set for Condition Clinical Status."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/condition-state"
        },
        "name" : "ConditionState",
        "description" : "Enumeration indicating whether the condition is currently active, inactive, or has been resolved."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/condition-ver-status"
        },
        "name" : "ConditionVerificationStatus",
        "description" : "The verification status to support or decline the clinical status of the condition or diagnosis."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/conformance-expectation"
        },
        "name" : "ConformanceExpectation",
        "description" : "Indicates the degree of adherence to a specified behavior or capability expected for a system to be deemed conformant with a specification."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/consentaction"
        },
        "name" : "Consent Action Codes",
        "description" : "This value set includes sample Consent Action codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/consentcategorycodes"
        },
        "name" : "Consent Category Codes",
        "description" : "This value set includes sample Consent Directive Type codes, including several consent directive related LOINC codes; HL7 VALUE SET: ActConsentType(2.16.840.1.113883.1.11.19897); examples of US realm consent directive legal descriptions and references to online and/or downloadable forms such as the SSA-827 Authorization to Disclose Information to the Social Security Administration; and other anticipated consent directives related to participation in a clinical trial, medical procedures, reproductive procedures; health care directive (Living Will); advance directive, do not resuscitate (DNR); Physician Orders for Life-Sustaining Treatment (POLST)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/consentpolicycodes"
        },
        "name" : "Consent PolicyRule Codes",
        "description" : "This value set includes sample Regulatory consent policy types from the US and other regions."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/consentscope"
        },
        "name" : "Consent Scope Codes",
        "description" : "This value set includes the four Consent scope codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/consentverification"
        },
        "name" : "Consent Verification Codes",
        "description" : "This value set includes base Consent Verification codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contactentity-type"
        },
        "name" : "Contact entity type",
        "description" : "This example value set defines a set of codes that can be used to indicate the purpose for which you would contact a contact party."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/container-cap"
        },
        "name" : "ContainerCap",
        "description" : "Color of the container cap."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contract-content-derivative"
        },
        "name" : "Contract Content Derivation Codes",
        "description" : "This is an example set of Content Derivative type codes, which represent the minimal content derived from the basal information source at a specific stage in its lifecycle, which is sufficient to manage that source information, for example, in a repository, registry, processes and workflows, for making access control decisions, and providing query responses."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contract-data-meaning"
        },
        "name" : "ContractDataMeaning",
        "description" : "How a resource reference is interpreted when evaluating contract offers."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contract-type"
        },
        "name" : "Contract Type Codes",
        "description" : "This value set includes sample Contract Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contractaction"
        },
        "name" : "Contract Action Codes",
        "description" : "This value set includes sample Contract Action codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contractactorrole"
        },
        "name" : "Contract Actor Role Codes",
        "description" : "This value set includes sample Contract Actor Role codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contractsignertypecodes"
        },
        "name" : "Contract Signer Type Codes",
        "description" : "This value set includes sample Contract Signer Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contractsubtypecodes"
        },
        "name" : "Contract Subtype Codes",
        "description" : "This value set includes sample Contract Subtype codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contracttermsubtypecodes"
        },
        "name" : "Contract Term Subtype Codes",
        "description" : "This value set includes sample Contract Term SubType codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contracttermtypecodes"
        },
        "name" : "Contract Term Type Codes",
        "description" : "This value set includes sample Contract Term Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contributor-role"
        },
        "name" : "Contributor Role",
        "description" : "Used to code the format of the display string."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contributor-summary-source"
        },
        "name" : "Contributor Summary Source",
        "description" : "Used to code the producer or rule for creating the display string."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contributor-summary-style"
        },
        "name" : "Contributor Summary Style",
        "description" : "Used to code the format of the display string."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/contributor-summary-type"
        },
        "name" : "Contributor Summary Type",
        "description" : "Used to code author list statement, contributorship statement, and such."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/copy-number-event"
        },
        "name" : "CopyNumberEvent",
        "description" : "Copy Number Event."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/coverage-class"
        },
        "name" : "Coverage Class Codes",
        "description" : "This value set includes Coverage Class codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/coverage-copay-type"
        },
        "name" : "Coverage Copay Type Codes",
        "description" : "This value set includes sample Coverage Copayment Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/coverage-selfpay"
        },
        "name" : "Coverage SelfPay Codes",
        "description" : "This value set includes Coverage SelfPay codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/coverageeligibilityresponse-ex-auth-support"
        },
        "name" : "CoverageEligibilityResponse Auth Support Codes",
        "description" : "This value set includes CoverageEligibilityResponse Auth Support codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cql-access-modifier"
        },
        "name" : "CQL Access Modifier",
        "description" : "Access modifiers defined by the Clinical Quality Language (CQL) specification in the [Access Modifiers](https://cql.hl7.org/03-developersguide.html#access-modifiers) topic."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/crd-coverage-detail"
        },
        "name" : "CRD Coverage Detail Codes",
        "description" : "Codes that describe additional details related to a coverage information assertion.  These live in THO rather than the CRD specification to support adding additional concepts without putting out a new CRD release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/data-absent-reason"
        },
        "name" : "DataAbsentReason",
        "description" : "Used to specify why the normally expected content of the data element is missing."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/definition-status"
        },
        "name" : "DefinitionStatus",
        "description" : "Codes identifying the lifecycle stage of a definition."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/definition-topic"
        },
        "name" : "DefinitionTopic",
        "description" : "High-level categorization of the definition, used for searching, sorting, and filtering."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/definition-use"
        },
        "name" : "Structure Definition Use Codes / Keywords",
        "description" : "Structure Definition Use Codes / Keywords"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/device-status-reason"
        },
        "name" : "FHIRDeviceStatusReason",
        "description" : "The availability status reason of the device."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/devicealert-activationState"
        },
        "name" : "Device Alert Activation State",
        "description" : "Describes the activation state of a DeviceAlert."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/devicealert-priority"
        },
        "name" : "Device Alert Priority",
        "description" : "Describes the priority of a DeviceAlert."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/deviceassociation-relationship"
        },
        "name" : "DeviceAssociation Relationship Codes",
        "description" : "DeviceAssociation Relationship Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/deviceassociation-status-reason"
        },
        "name" : "DeviceAssociation Status Reason Codes",
        "description" : "DeviceAssociation Status Reason Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/diagnosis-role"
        },
        "name" : "Diagnosis Role",
        "description" : "This value set defines a set of codes that can be used to express the role of a diagnosis on the Encounter or EpisodeOfCare record."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/diagnosistype"
        },
        "name" : "Diagnosis Type Codes",
        "description" : "This value set includes Diagnosis Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/dicom-audit-lifecycle"
        },
        "name" : "DICOM Audit Message Record Lifecycle Events",
        "description" : "Attached is vocabulary for the record lifecycle events, as per DICOM Audit Message,"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/diet"
        },
        "name" : "Diet",
        "description" : "This value set defines a set of codes that can be used to indicate dietary preferences or restrictions a patient may have."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/directness"
        },
        "name" : "EvidenceDirectness",
        "description" : "The quality of how direct the match is."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/discharge-disposition"
        },
        "name" : "Discharge disposition",
        "description" : "This value set defines a set of codes that can be used to where the patient left the hospital."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/dose-rate-type"
        },
        "name" : "DoseAndRateType",
        "description" : "The kind of dose or rate specified."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/encounter-special-arrangements"
        },
        "name" : "Special arrangements",
        "description" : "This value set defines a set of codes that can be used to indicate the kinds of special arrangements in place for a patients visit."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/encounter-subject-status"
        },
        "name" : "Encounter subject status",
        "description" : "This example value set defines a set of codes that can be used to indicate the status of the subject within the encounter"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/encounter-type"
        },
        "name" : "Encounter type",
        "description" : "This example value set defines a set of codes that can be used to indicate the type of encounter: a specific code indicating type of service provided."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/endpoint-connection-type"
        },
        "name" : "Endpoint Connection Type",
        "description" : "This is an example value set defined by the FHIR project, that could be used to represent possible connection type profile values."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/endpoint-payload-type"
        },
        "name" : "Endpoint Payload Type",
        "description" : "This is an example value set defined by the FHIR project, that could be used to represent possible payload document types."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/entformula-additive"
        },
        "name" : "Enteral Formula Additive Type Code",
        "description" : "EnteralFormulaAdditiveType: Codes for the type of modular component such as protein, carbohydrate or fiber to be provided in addition to or mixed with the base formula. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/episodeofcare-type"
        },
        "name" : "Episode of care type",
        "description" : "This example value set defines a set of codes that can be used to express the usage type of an EpisodeOfCare record."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/evidence-quality"
        },
        "name" : "QualityOfEvidenceRating",
        "description" : "A rating system that describes the quality of evidence such as the GRADE, DynaMed, or Oxford CEBM systems."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-USCLS"
        },
        "name" : "USCLS Codes",
        "description" : "This value set includes a smattering of USCLS codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-benefitcategory"
        },
        "name" : "Benefit Category Codes",
        "description" : "This value set includes examples of Benefit Category codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-claimsubtype"
        },
        "name" : "Example Claim SubType Codes",
        "description" : "This value set includes sample Claim SubType codes which are used to distinguish the claim types for example within type institutional there may be subtypes for emergency services, bed stay and transportation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-coverage-financial-exception"
        },
        "name" : "Example Coverage Financial Exception Codes",
        "description" : "This value set includes Example Coverage Financial Exception Codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-diagnosis-on-admission"
        },
        "name" : "Example Diagnosis on Admission Codes",
        "description" : "This value set includes example Diagnosis on Admission codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-diagnosisrelatedgroup"
        },
        "name" : "Example Diagnosis Related Group Codes",
        "description" : "This value set includes example Diagnosis Related Group codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-diagnosistype"
        },
        "name" : "Example Diagnosis Type Codes",
        "description" : "This value set includes example Diagnosis Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-payee-resource-type"
        },
        "name" : "ClaimPayeeResourceType",
        "description" : "The type of Claim payee Resource."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-paymenttype"
        },
        "name" : "Example Payment Type Codes",
        "description" : "This value set includes example Payment Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-procedure-type"
        },
        "name" : "Example Procedure Type Codes",
        "description" : "This value set includes example Procedure Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-programcode"
        },
        "name" : "Example Program Reason Codes",
        "description" : "This value set includes sample Program Reason Span codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-providerqualification"
        },
        "name" : "Example Provider Qualification Codes",
        "description" : "This value set includes sample Provider Qualification codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-relatedclaimrelationship"
        },
        "name" : "Example Related Claim Relationship Codes",
        "description" : "This value set includes sample Related Claim Relationship codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-revenue-center"
        },
        "name" : "Example Revenue Center Codes",
        "description" : "This value set includes sample Revenue Center codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-serviceplace"
        },
        "name" : "Example Service Place Codes",
        "description" : "This value set includes a smattering of Service Place codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-tooth"
        },
        "name" : "Oral Site Codes",
        "description" : "This value set includes a smattering of FDI oral site codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ex-visionprescriptionproduct"
        },
        "name" : "Example Vision Prescription Product Codes",
        "description" : "This value set includes a smattering of Prescription Product codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/expansion-parameter-source"
        },
        "name" : "ExpansionParameterSource",
        "description" : "Declares what the source of a parameter is."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/expansion-processing-rule"
        },
        "name" : "ExpansionProcessingRule",
        "description" : "Defines how concepts are processed into the expansion when it's for UI presentation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/extra-security-role-type"
        },
        "name" : "Security Role Type",
        "description" : "This CodeSystem contains Additional FHIR-defined Security Role types not defined elsewhere"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/failure-action"
        },
        "name" : "Failure-action",
        "description" : "The result if validation fails"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/financialtaskcode"
        },
        "name" : "Financial Task Codes",
        "description" : "This value set includes Financial Task codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/financialtaskinputtype"
        },
        "name" : "Financial Task Input Type Codes",
        "description" : "This value set includes Financial Task Input Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/flag-category"
        },
        "name" : "Flag Category",
        "description" : "Example list of general categories for flagged issues. (Not complete or necessarily appropriate.)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/forms-codes"
        },
        "name" : "Form Codes",
        "description" : "This value set includes a sample set of Forms codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/fundsreserve"
        },
        "name" : "Funds Reservation Codes",
        "description" : "This value set includes sample funds reservation type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/goal-acceptance-status"
        },
        "name" : "GoalAcceptanceStatus",
        "description" : "Codes indicating whether the goal has been accepted by a stakeholder."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/goal-achievement"
        },
        "name" : "Goal achievement status",
        "description" : "Describes the progression, or lack thereof, towards the goal against the target."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/goal-category"
        },
        "name" : "Goal category",
        "description" : "Codes for grouping goals to use for filtering or presentation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/goal-priority"
        },
        "name" : "Goal priority",
        "description" : "Indicates the level of importance associated with reaching or sustaining a goal."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/goal-relationship-type"
        },
        "name" : "GoalRelationshipType",
        "description" : "Types of relationships between two goals."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/group-code"
        },
        "name" : "Group Code",
        "description" : "A code that describes the use of the group. The use of the group usually dictates what kind of entities can be members of the group."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/guide-parameter-code"
        },
        "name" : "GuideParameterCode",
        "description" : "Code of parameter that is input to the guide."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/handling-condition"
        },
        "name" : "HandlingConditionSet",
        "description" : "Set of handling instructions prior testing of the specimen."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/history-absent-reason"
        },
        "name" : "FamilyHistoryAbsentReason",
        "description" : "Codes describing the reason why a family member's history is not available."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/immunization-evaluation-dose-status-reason"
        },
        "name" : "Immunization Evaluation Dose Status Reason codes",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why an administered dose has been assigned a particular status. Often, this reason describes why a dose is considered invalid. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/immunization-evaluation-dose-status"
        },
        "name" : "Immunization Evaluation Dose Status codes",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the validity of a dose relative to a particular recommended schedule. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/immunization-funding-source"
        },
        "name" : "Immunization Funding Source",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the source of the vaccine administered. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/immunization-origin"
        },
        "name" : "Immunization Origin Codes",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the source of the data when the report of the immunization event is not based on information from the person, entity or organization who administered the vaccine. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/immunization-program-eligibility"
        },
        "name" : "Immunization Program Eligibility",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the patient's eligibility for a vaccination program. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/immunization-recommendation-status"
        },
        "name" : "Immunization Recommendation Status Codes",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the status of the patient towards perceived immunity against a vaccine preventable disease. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/immunization-subpotent-reason"
        },
        "name" : "Immunization Subpotent Reason",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why a dose is considered to be subpotent. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/implantStatus"
        },
        "name" : "Implant Status",
        "description" : "A set codes that define the functional status of an implanted device."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/insurance-coverage-type"
        },
        "name" : "Insurance Coverage Type",
        "description" : "This code system defines a set of codes for Insurance CoverageType."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/insurance-plan-type"
        },
        "name" : "Insurance plan type",
        "description" : "This example value set defines a set of codes that can be used to indicate a type of insurance plan."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/insurance-product-type"
        },
        "name" : "Insurance Product Type",
        "description" : "This code system defines a set of codes for Insurance Product Type."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/insuranceplan-plan-type"
        },
        "name" : "Insuranceplan Plan Type",
        "description" : "This code system defines a set of codes for Insuranceplan Plan Type."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/iso-21089-lifecycle"
        },
        "name" : "ISO 21089 2017 Health Record Lifecycle Events",
        "description" : "Attached is vocabulary for the 27 record lifecycle events, as per ISO TS 21089-2017, Health Informatics - Trusted End-to-End Information Flows, Section 3, Terms and Definitions (2017, at ISO Central Secretariat, passed ballot and ready for publication).  This will also be included in the FHIR EHR Record Lifecycle Event Implementation Guide, balloted and (to be) published with FHIR STU-3."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/library-type"
        },
        "name" : "LibraryType",
        "description" : "The type of knowledge asset this library contains."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/list-empty-reason"
        },
        "name" : "List Empty Reasons",
        "description" : "General reasons for a list to be empty. Reasons are either related to a summary list (i.e. problem or medication list) or to a workflow related list (i.e. consultation list)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/list-example-use-codes"
        },
        "name" : "Example Use Codes for List",
        "description" : "Example use codes for the List resource - typical kinds of use."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/list-order"
        },
        "name" : "List Order Codes",
        "description" : "Base values for the order of item lists in resources."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/location-physical-type"
        },
        "name" : "Location type",
        "description" : "This example value set defines a set of codes that can be used to indicate the physical form of the Location.\r\rThis includes several 'non physical' codes which are still considered a location."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/match-grade"
        },
        "name" : "MatchGrade",
        "description" : "A Master Patient Index (MPI) assessment of whether a candidate patient record is a match or not."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/measure-aggregate-method"
        },
        "name" : "Measure Aggregate Method",
        "description" : "Aggregation method for a measure (e.g. sum, average, median, minimum, maximum,    count)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/measure-data-usage"
        },
        "name" : "MeasureDataUsage",
        "description" : "The intended usage for supplemental data elements in the measure."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/measure-improvement-notation"
        },
        "name" : "MeasureImprovementNotation",
        "description" : "Observation values that indicate what change in a measurement value or score is indicative of an improvement in the measured item or scored issue."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/measure-population"
        },
        "name" : "Measure Population Type",
        "description" : "The type of population."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/measure-scoring"
        },
        "name" : "Measure Scoring",
        "description" : "The scoring type of the measure."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/measure-supplemental-data"
        },
        "name" : "Measure Supplemental Data",
        "description" : "Identifier supplemental data in a population for measuring purposes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/measure-type"
        },
        "name" : "MeasureType",
        "description" : "The type of measure (includes codes from 2.16.840.1.113883.1.11.20368)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/med-admin-perform-function"
        },
        "name" : "MedicationAdministration Performer Function Codes",
        "description" : "MedicationAdministration Performer Function Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/media-category"
        },
        "name" : "Digital Media Category",
        "description" : "Codes for high level media types - whether the media is an image, video, or audio."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medical-management-type"
        },
        "name" : "Medical Management Type",
        "description" : "Types of medical management requirements or processes used by health insurers (payers) that may impact whether a service or item is covered or reimbursement rates."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medication-admin-location"
        },
        "name" : "MedicationAdministration Location Codes",
        "description" : "MedicationAdministration Location Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medication-usage-admin-location"
        },
        "name" : "MedicationUsage Administration Location Codes",
        "description" : "MedicationUsage Administration Location Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medicationdispense-performer-function"
        },
        "name" : "MedicationDispense Performer Function Codes",
        "description" : "MedicationDispense Performer Function Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medicationknowledge-characteristic"
        },
        "name" : "MedicationKnowledge Characteristic Codes",
        "description" : "MedicationKnowledge Characteristic Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medicationknowledge-package-type"
        },
        "name" : "MedicationKnowledge Package Type Codes",
        "description" : "MedicationKnowledge Package Type Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medicationknowledge-status"
        },
        "name" : "MedicationKnowledge Status Codes",
        "description" : "MedicationKnowledge Status Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medicationrequest-admin-location"
        },
        "name" : "Medication request  administration  location  codes",
        "description" : "MedicationRequest Administration Location Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medicationrequest-category"
        },
        "name" : "MedicationRequest Category Codes",
        "description" : "MedicationRequest Category Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medicationrequest-course-of-therapy"
        },
        "name" : "MedicationRequest Course of Therapy Codes",
        "description" : "MedicationRequest Course of Therapy Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/medicationrequest-status-reason"
        },
        "name" : "MedicationRequest Status Reason Codes",
        "description" : "MedicationRequest Status Reason Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/message-reasons-encounter"
        },
        "name" : "Example Message Reason Codes",
        "description" : "Example Message Reasons. These are the set of codes that might be used an updating an encounter using admin-update."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/missingtoothreason"
        },
        "name" : "Missing Tooth Reason Codes",
        "description" : "This value set includes sample Missing Tooth Reason codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/modifiers"
        },
        "name" : "Modifier type Codes",
        "description" : "This value set includes sample Modifier type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/name-assembly-order"
        },
        "name" : "HumanNameAssemblyOrder",
        "description" : "A code that represents the preferred display order of the components of a human name."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ndh-healthcare-service-category"
        },
        "name" : "NDH Healthcare Service Category",
        "description" : "This code system defines a set of codes for NDH Healthcare Service Category used in the National Directory of Healthcare Providers and Services (NDH)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/need"
        },
        "name" : "Need",
        "description" : "The frequency with which the target must be validated"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nutrition-intake-category"
        },
        "name" : "Nutrition intake category codes",
        "description" : "NutritionIntake Category Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/nutritionintake-status-reason"
        },
        "name" : "Nutrition Intake Status Reason Codes",
        "description" : "Nutrition Intake Status Reason Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/object-role"
        },
        "name" : "AuditEventEntityRole",
        "description" : "Code representing the role the entity played in the audit event."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/observation-category"
        },
        "name" : "Observation Category Codes",
        "description" : "Observation Category codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/observation-statistics"
        },
        "name" : "StatisticsCode",
        "description" : "The statistical operation parameter -\"statistic\" codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/operation-outcome"
        },
        "name" : "Operation Outcome Codes",
        "description" : "Operation Outcome codes used by FHIR test servers (see Implementation file translations.xml)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/organization-affiliation-role-for-hie"
        },
        "name" : "Organization Affiliation Role for HIE",
        "description" : "This code system defines a set of codes that can be used to indicate an organization affiliation role for HIE."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/organization-affiliation-role"
        },
        "name" : "Organization Affiliation Role",
        "description" : "This code system defines a set of codes that can be used to indicate an organization affiliation role."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/organization-alias-type"
        },
        "name" : "Organization Alias Type",
        "description" : "This code system defines a set of codes for indicating oranization alias type."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/organization-type"
        },
        "name" : "Organization type",
        "description" : "This example value set defines a set of codes that can be used to indicate a type of organization."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/parameter-group"
        },
        "name" : "DeviceDefinitionParameterGroup",
        "description" : "Codes identifying groupings of parameters; e.g. Cardiovascular."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/participant-type"
        },
        "name" : "Participant type",
        "description" : "This value set defines a set of codes that can be used to indicate how an individual participates in an encounter."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/payeetype"
        },
        "name" : "Payee Type Codes",
        "description" : "Codes indicating the type of party to be reimbursed for cost of products and services."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/payment-adjustment-reason"
        },
        "name" : "Payment Adjustment Reason Codes",
        "description" : "This value set includes smattering of Payment Adjustment Reason codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/payment-type"
        },
        "name" : "Payment Type Codes",
        "description" : "This value set includes sample Payment Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/paymentstatus"
        },
        "name" : "Payment Status Codes",
        "description" : "This value set includes a sample set of Payment Status codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/plan-definition-type"
        },
        "name" : "PlanDefinitionType",
        "description" : "The type of PlanDefinition."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/practitioner-role"
        },
        "name" : "Practitioner role",
        "description" : "This example value set defines a set of codes that can be used to indicate the role of a Practitioner."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/primary-source-type"
        },
        "name" : "Primary-source-type",
        "description" : "Type of the validation primary source"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/procedure-type"
        },
        "name" : "Procedure Type Codes",
        "description" : "This value set includes Procedure Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/processpriority"
        },
        "name" : "Process Priority Codes",
        "description" : "This value set includes the financial processing priority codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/professional-credential-status"
        },
        "name" : "Professional Credential Status",
        "description" : "This code system establishes a series of codes designed to represent the status of professional credentials."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/program"
        },
        "name" : "Program",
        "description" : "This value set defines an example set of codes that could be can be used to classify groupings of service-types/specialties."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/provenance-participant-type"
        },
        "name" : "Provenance participant type",
        "description" : "These codes define the type of participation by an agent in a provenance activity. An agent is something that bears the responsibility identified by the type of participation in the activity taking place, for the existence of an entity, or for another agent's activity. An Agent may be An agent, device, system, organization, group, care-team, or other identifiable thing."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/published-in-type"
        },
        "name" : "Published In Type",
        "description" : "The type of publication such as book, database, or journal."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/push-type-available"
        },
        "name" : "Push-type-available",
        "description" : "Type of alerts/updates the primary source can send"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/question-max-occurs"
        },
        "name" : "MaxOccurs",
        "description" : "Flags an element as having unlimited repetitions."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/questionnaire-usage-mode"
        },
        "name" : "QuestionnaireItemUsageMode",
        "description" : "Identifies the modes of usage of a questionnaire that should enable a particular questionnaire item."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/reaction-event-certainty"
        },
        "name" : "AllergyIntoleranceCertainty",
        "description" : "Statement about the degree of clinical certainty that a specific substance was the cause of the manifestation in a reaction event."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/reason-medication-given"
        },
        "name" : "Reason Medication Given Codes",
        "description" : "This value set is provided as an example. The value set to instantiate this attribute should be drawn from a robust terminology code system that consists of or contains concepts to support the medication process."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/recommendation-strength"
        },
        "name" : "StrengthOfRecommendationRating",
        "description" : "A rating system that describes the strength of the recommendation, such as the GRADE, DynaMed, or HGPS systems."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/referencerange-meaning"
        },
        "name" : "Observation Reference Range Meaning Codes",
        "description" : "This value set defines a set of codes that can be used to indicate the meaning/use of a reference range for a particular target population."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/rejection-criteria"
        },
        "name" : "RejectionCriterion",
        "description" : "Criterion for rejection of the specimen by laboratory."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/research-study-objective-type"
        },
        "name" : "ResearchStudyObjectiveType",
        "description" : "Codes for the kind of study objective."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/research-study-party-role"
        },
        "name" : "Research Study Party Role",
        "description" : "This is a ResearchStudy's party role."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/research-study-phase"
        },
        "name" : "ResearchStudyPhase",
        "description" : "Codes for the stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/research-study-prim-purp-type"
        },
        "name" : "ResearchStudyPrimaryPurposeType",
        "description" : "Codes for the main intent of the study."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/research-study-reason-stopped"
        },
        "name" : "ResearchStudyReasonStopped",
        "description" : "Codes for why the study ended prematurely."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/research-study-status"
        },
        "name" : "Research Study Status",
        "description" : "Codes that convey the current status of the research study."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/research-subject-milestone"
        },
        "name" : "ResearchSubjectMilestone",
        "description" : "Indicates the progression of a study subject through the study milestones.    **Deprecation Information:** This Code System is being replaced in favor of using NCI Thesaurus codes. NCI codes through [Research Subject Milestones](http://terminology.hl7.org/ValueSet/research-subject-milestones) should be used instead"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/research-subject-state-type"
        },
        "name" : "ResearchSubjectStateType",
        "description" : "Identifies the kind of state being refered to."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/research-subject-state"
        },
        "name" : "ResearchSubjectState",
        "description" : "Indicates the progression of a study subject through a study."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/resource-security-category"
        },
        "name" : "ResourceSecurityCategory",
        "description" : "Provides general guidance around the kind of access Control to Read, Search, Create, Update, or Delete a resource."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/resource-type-link"
        },
        "name" : "PayeeResourceType",
        "description" : "The type of payee Resource."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/risk-probability"
        },
        "name" : "Risk Probability",
        "description" : "Codes representing the likelihood of a particular outcome in a risk assessment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/security-source-type"
        },
        "name" : "Audit Event Source Type",
        "description" : "The type of process where the audit event originated from."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/service-category"
        },
        "name" : "Service category",
        "description" : "This value set defines an example set of codes that can be used to classify groupings of service-types/specialties."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/service-delivery-method"
        },
        "name" : "Service Delivery Method",
        "description" : "This code system defines a set of codes that can be used to indicate service delivery method"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/service-provision-conditions"
        },
        "name" : "ServiceProvisionConditions",
        "description" : "The code(s) that detail the conditions under which the healthcare service is available/offered."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/service-referral-method"
        },
        "name" : "ReferralMethod",
        "description" : "The methods of referral can be used when referring to a specific HealthCareService resource."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/service-type"
        },
        "name" : "Service type",
        "description" : "This value set defines an example set of codes of service-types."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/sex-parameter-for-clinical-use"
        },
        "name" : "Sex Parameter For Clinical Use",
        "description" : "A summary parameter that provides guidance on how a receiver should apply settings or reference ranges that are derived from observable information such as an organ inventory, recent hormone lab tests, genetic testing, menstrual status, obstetric history, etc.."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/smart-capabilities"
        },
        "name" : "SmartCapabilities",
        "description" : "Codes that define what the server is capable of."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/software-system-type-codes"
        },
        "name" : "Software System Type Codes",
        "description" : "Types of software systems that support knowledge artifact authoring and evaluation (authoring, testing, tooling, evaluation)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/special-values"
        },
        "name" : "SpecialValues",
        "description" : "A set of generally useful codes defined so they can be included in value sets."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/standards-status"
        },
        "name" : "StandardsStatus",
        "description" : "HL7 Ballot/Standards status of artifact."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/state-change-reason"
        },
        "name" : "StateChangeReason",
        "description" : "Indicates why the state of the subject changed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/statistic-model-code"
        },
        "name" : "Statistic Model Code",
        "description" : "The role that the assertion variable plays."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/statistic-type"
        },
        "name" : "StatisticStatisticType",
        "description" : "The type of a specific statistic."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/study-type"
        },
        "name" : "StatisticStudyType",
        "description" : "The type of study a statistic was derived from."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/subscriber-relationship"
        },
        "name" : "SubscriberPolicyholder Relationship Codes",
        "description" : "This value set includes codes for the relationship between the Subscriber and the Beneficiary (insured/covered party/patient)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/subscription-channel-type"
        },
        "name" : "SubscriptionChannel Type Codes",
        "description" : "The type of method used to execute a subscription"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/subscription-error"
        },
        "name" : "Subscription Error Codes",
        "description" : "Codes to represent subscription error details"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/subscription-status-at-event"
        },
        "name" : "SubscriptionStatusAtEvent",
        "description" : "A status code for the state of the Subscription."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/subscription-tag"
        },
        "name" : "SubscriptionTag",
        "description" : "Tags to put on a resource after subscriptions have been sent."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/substance-category"
        },
        "name" : "Substance Category Codes",
        "description" : "Substance category codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/supply-item-type"
        },
        "name" : "Supply Item Type",
        "description" : "This value sets refers to a specific supply item."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/supply-kind"
        },
        "name" : "Supply Type",
        "description" : "This value sets refers to a Category of supply."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/supplyrequest-reason"
        },
        "name" : "SupplyRequestReason",
        "description" : "The reason why the supply item was requested."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/synthesis-type"
        },
        "name" : "StatisticSynthesisType",
        "description" : "Types of combining results from a body of evidence (eg. summary data meta-analysis)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/testscript-operation-codes"
        },
        "name" : "Test script operation code",
        "description" : "This value set defines a set of codes that are used to indicate the supported operations of a testing engine or tool."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/testscript-profile-destination-types"
        },
        "name" : "Test script profile destination type",
        "description" : "This value set defines a set of codes that are used to indicate the profile type of a test system when acting as the destination within a TestScript."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/testscript-profile-origin-types"
        },
        "name" : "Test script profile origin type",
        "description" : "This value set defines a set of codes that are used to indicate the profile type of a test system when acting as the origin within a TestScript."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/time-period-ranges"
        },
        "name" : "Time Period Ranges",
        "description" : "Defines codes for the representation of time period (e.g. age) ranges that are unambiguous, human readable, and machine-readable as a compositional grammar (i.e. the code system defines rules for constructing codes, rather than explicitly enumerating all possible codes). This CodeSystem profiles [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) for expressing time period ranges through two simple durations (as defined in the [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) specification).\n\nCodes in the code system are defined according to the grammar:\n\nA time period (e.g. age) range is defined as two durations: `[duration1]--[duration2]`, where `duration1` specifies the lower inclusive bound of the age range (everyone who is this age and above) and `duration2` specifies the upper exclusive bound of the age range.\n\nFor example, the age range \"1-9 years\" means everyone who is at least one year old and less than 10 years old represented as `P1Y--P10Y`. The age range \"10-14 years\" means everyone who is at least 10 years old and less than 15 years old and is represented as `P10Y--P15Y`.\n\nDurations define the amount of time between two time points. These durations are represented in the form `P[n]Y[n]M[n]DT[n]H[n]M[n]S` or `P[n]W`. The `[n]` is replaced by the value for each of the time elements that follow the `[n]` and the letters have the meaning:\n\n* `P` is the duration designator (for period) placed at the start of the duration representation.\n\t* `Y` is the year designator that follows the value for the number of years.\n\t* `M` is the month designator that follows the value for the number of months.\n\t* `W` is the week designator that follows the value for the number of weeks.\n\t* `D` is the day designator that follows the value for the number of days.\n* `T` is the time designator that precedes the time components of the representation.\n\t* `H` is the hour designator that follows the value for the number of hours.\n\t* `M` is the minute designator that follows the value for the number of minutes.\n\t* `S` is the second designator that follows the value for the number of seconds. (Note that seconds can be a decimal in this format to allow for milliseconds)\n\nFor example, `P3Y6M4DT12H30M5S` represents a duration of _three years, six months, four days, twelve hours, thirty minutes, and five seconds_.\n\nDate and time elements including their designator may be omitted if their value is zero, and lower-order elements may also be omitted for reduced precision. For example, `P23DT23H` and `P4Y` are both acceptable duration representations. However, at least one element must be present, thus `P` is not a valid representation for a duration of _0 seconds_. `PT0S` or `P0D`, however, are both valid and represent the same duration.\n\nNote that the designator `M` is used for both months and minutes, but this is not ambiguous because the minutes designator must be preceded by the time designator `T`. For example `P1M` is _one month_, while `PT1M` is _one minute_.\n\nContent for this code system is adapted from the definition in the IHE-ADX profile: https://www.ihe.net/uploadedFiles/Documents/QRPH/IHE_QRPH_Suppl_ADX.pdf (Appendix 8K Representation of Age Groups in ADX). In addition, the code system definition is adapted from similar content published as part of the SANER implementation guide. See [Age Range Coding System](https://hl7.org/fhir/uv/saner/CodeSystem-IHE-ADX-agerange.html)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/title-type"
        },
        "name" : "Title Type",
        "description" : "Used to express the reason and specific aspect for the variant title, such as language and specific language."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/usage-context-type"
        },
        "name" : "UsageContextType",
        "description" : "A code that specifies a type of context being specified by a usage context."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/validation-process"
        },
        "name" : "Validation-process",
        "description" : "The primary process by which the target is validated"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/validation-status"
        },
        "name" : "Validation-status",
        "description" : "Status of the validation of the target against the primary source"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/validation-type"
        },
        "name" : "Validation-type",
        "description" : "What the target is validated against"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/variable-role-subtype"
        },
        "name" : "EvidenceVariableRoleSubtype",
        "description" : "The subclassification of the role that the assertion variable plays."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/variable-role"
        },
        "name" : "EvidenceVariableRole",
        "description" : "**Deprecation Information:** This CodeSystem/ValueSet was used in FHIR R5 for a CodeableConcept binding that was changed to a code binding in FHIR R6. The replacement CodeSystem/ValueSet is http://hl7.org/fhir/variable-role and http://hl7.org/fhir/ValueSet/variable-role."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/variant-state"
        },
        "name" : "sequenceStatus",
        "description" : "Codes providing the status of the variant test result."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/verificationresult-communication-method"
        },
        "name" : "VerificationResult Communication Method",
        "description" : "Attested information may be validated by process that are manual or automated. For automated processes it may accomplished by the system of record reaching out through another system's API or information may be sent to the system of record. This value set defines a set of codes to describing the process, the how, a resource or data element is validated."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/virtual-healthcare-delivery-method"
        },
        "name" : "Virtual Healthcare Delivery Method",
        "description" : "This code system defines a set of codes for virtual healthcare service delivery method."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/appropriateness-score"
        },
        "name" : "Appropriateness Score",
        "description" : "The scoring for appropriateness of an action based upon RAND."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/citation-artifact-classifier"
        },
        "name" : "Citation Artifact Classifier",
        "description" : "Citation artifact classifier"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/POAIndicators"
        },
        "name" : "Present on Admission Indicators",
        "description" : "Concepts that describe whether a condition is present when a patient is admitted to a healthcare facility."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/accepting-patients"
        },
        "name" : "Accepting Patients",
        "description" : "This value set defines a set of codes that can be used to indicate a practice is accepting new patients."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/action-participant-role"
        },
        "name" : "Action Participant Role",
        "description" : "Either a practitioner role or a relationship type.  Note from UTG import - may have been a temporary entry that subsequently disappeared from the FHIR source; unable to locate.   Version set to 0.1.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/action-type"
        },
        "name" : "ActionType",
        "description" : "The type of action to be performed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/activity-definition-category"
        },
        "name" : "ActivityDefinitionCategory",
        "description" : "High-level categorization of the type of activity."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adjudication-error"
        },
        "name" : "AdjudicationError",
        "description" : "This value set includes a smattering of adjudication codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adjudication-reason"
        },
        "name" : "Adjudication Reason Codes",
        "description" : "This value set includes smattering of Adjudication Reason codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adjudication"
        },
        "name" : "Adjudication Value Codes",
        "description" : "This value set includes a smattering of Adjudication Value codes which includes codes to indicate the amounts eligible under the plan, the amount of benefit, copays etc."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adverse-event-category"
        },
        "name" : "AdverseEventCategory",
        "description" : "Overall categorization of the event, e.g. product-related or situational."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adverse-event-causality-assess"
        },
        "name" : "AdverseEventCausalityAssessment",
        "description" : "Codes for the assessment of whether the entity caused the event."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adverse-event-causality-method"
        },
        "name" : "AdverseEventCausalityMethod",
        "description" : "TODO."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adverse-event-clinical-research-causality-relatedness"
        },
        "name" : "Adverse Event Clinical Research Causality Relatedness",
        "description" : "Value set for stating if a suspected entity is Not Related, Unlikely Related, Possibly Related, or Related to the cause of the adverse event. Using NCI codes. The values originate with ICH. For information on ICH see https://admin.ich.org/sites/default/files/inline-files/OID_Information_Paper_1.pdf from the INTERNATIONAL CONFERENCE ON HARMONISATION OF TECHNICAL REQUIREMENTS FOR REGISTRATION OF PHARMACEUTICALS FOR HUMAN USE (ICH) document ICH E2B(R3), the Electronic Transmission of Individual Case Safety Reports (ICSRs) Implementation Guide Data Elements and Message Specification, and ICH M8, the Electronic Common Technical Document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adverse-event-clinical-research-grades"
        },
        "name" : "Adverse Event Clinical Research Grades",
        "description" : "Value set of grades used in Adverse Event Clinical Research, especially in Oncology clinical trials"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adverse-event-clinical-research-outcomes"
        },
        "name" : "Adverse Event Clinical Research Outcomes",
        "description" : "This value set includes codes that describe the type of outcome from the adverse event as typically used in reporting for Clinical Research, post-market surveillance (e.g. Medwatch forms). NCI codes used here This list originates from the ICH E2B R3 (https://database.ich.org/sites/default/files/E2D_Guideline.pdf), specifically CDISC CL.C66768.OUT. For information on ICH see https://admin.ich.org/sites/default/files/inline-files/OID_Information_Paper_1.pdf from the INTERNATIONAL CONFERENCE ON HARMONISATION OF TECHNICAL REQUIREMENTS FOR REGISTRATION OF PHARMACEUTICALS FOR HUMAN USE (ICH) document ICH E2B(R3), the Electronic Transmission of Individual Case Safety Reports (ICSRs) Implementation Guide Data Elements and Message Specification, and ICH M8, the Electronic Common Technical Document."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adverse-event-clinical-research-seriousness-criteria"
        },
        "name" : "Adverse Event Clinical Research Seriousness Criteria",
        "description" : "Action criteria usually associated with serious events that pose a threat to a patient's life or functioning. Adverse Events criteria to expand on the seriousness of the adverse event. Typically used in reporting for Clinical Research, post-market surveillance (e.g. Form FDA 3500A MedWatch). The adverse event seriousness criteria value set is based on the ICH E2D Post-Approval Safety Data Management: Definitions and Standards for Expedited Reporting guidance (https://database.ich.org/sites/default/files/E2D_Guideline.pdf). For information on ICH see https://admin.ich.org/sites/default/files/inline-files/OID_Information_Paper_1.pdf from the INTERNATIONAL CONFERENCE ON HARMONISATION OF TECHNICAL REQUIREMENTS FOR REGISTRATION OF PHARMACEUTICALS FOR HUMAN USE (ICH) document ICH E2B(R3), the Electronic Transmission of Individual Case Safety Reports (ICSRs) Implementation Guide Data Elements and Message Specification, and ICH M8, the Electronic Common Technical Document"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adverse-event-seriousness"
        },
        "name" : "AdverseEventSeriousness",
        "description" : "Overall seriousness of this event for the patient."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/adverse-event-severity"
        },
        "name" : "AdverseEventSeverity",
        "description" : "The severity of the adverse event itself, in direct relation to the subject."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/allerg-intol-substance-exp-risk"
        },
        "name" : "AllergyIntoleranceSubstanceExposureRisk",
        "description" : "The risk of an adverse reaction (allergy or intolerance) for this patient upon exposure to the substance (including pharmaceutical products)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/allergyintolerance-clinical"
        },
        "name" : "AllergyIntolerance Clinical Status Codes",
        "description" : "Preferred value set for AllergyIntolerance Clinical Status."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/allergyintolerance-verification"
        },
        "name" : "AllergyIntolerance Verification Status",
        "description" : "The verification status to support or decline the clinical status of the allergy or intolerance."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/appointment-cancellation-reason"
        },
        "name" : "Appointment cancellation reason",
        "description" : "This example value set defines a set of reasons for the cancellation of an appointment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/appropriateness-score"
        },
        "name" : "Appropriateness Score",
        "description" : "The scoring for appropriateness of an action based upon RAND."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/artifact-contribution-instance-type"
        },
        "name" : "Artifact Contribution Instance Type",
        "description" : "Artifact Contribution Instance Type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/artifact-identifier-type"
        },
        "name" : "Artifact Identifier Type",
        "description" : "Identifier types for an artifact (e.g. version-independent, version-specific, short-name, endorser, publisher)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/artifact-relationship-type"
        },
        "name" : "Artifact Relationship Type",
        "description" : "Type of relationship to the related artifact."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/artifact-url-classifier"
        },
        "name" : "Artifact Url Classifier",
        "description" : "Code the reason for different URLs, eg abstract and full-text."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/artifact-version-policy"
        },
        "name" : "Artifact Version Policy",
        "description" : "The versioning policy of an artifact or set of artifacts (metadata or strict)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/attribute-estimate-type"
        },
        "name" : "StatisticAttributeEstimateType",
        "description" : "Method of reporting variability of estimates, such as confidence intervals, interquartile range or standard deviation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/audit-event-outcome"
        },
        "name" : "Audit Event Outcome",
        "description" : "The type of process where the audit event originated from."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/audit-source-type"
        },
        "name" : "Audit Event Source Type",
        "description" : "The type of process where the audit event originated from."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/basic-resource-type"
        },
        "name" : "Basic Resource Types",
        "description" : "This value set defines codes for resources not yet supported by (or which will never be supported by) FHIR.  Many of the codes listed here will eventually be turned into official resources.  However, there is no guarantee that any particular resource will be created nor that the scope will be exactly as defined by the codes presented here.  Codes in this set will be deprecated if/when formal resources are defined that encompass these concepts."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/benefit-network"
        },
        "name" : "Network Type Codes",
        "description" : "This value set includes the codes indicating the contractual relationship between a provider and payer for administrative purposes for a specific patient, service, or product."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/benefit-term"
        },
        "name" : "Benefit Term Codes",
        "description" : "This value set includes a smattering of Benefit Term codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/benefit-type"
        },
        "name" : "Benefit Type Codes",
        "description" : "This value set includes a smattering of Benefit type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/benefit-unit"
        },
        "name" : "Unit Type Codes",
        "description" : "This value set includes a smattering of Unit type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/care-service-accessibility"
        },
        "name" : "Care Service Accessibility",
        "description" : "This value set defines a set of codes that can be used to describe care service accessibility options offered by a practitioner or at a location."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/catalogType"
        },
        "name" : "CatalogType",
        "description" : "The type of catalog."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/certainty-rating"
        },
        "name" : "StatisticCertaintyRating",
        "description" : "The relative quality of the statistic."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/certainty-subcomponent-rating"
        },
        "name" : "StatisticCertaintySubcomponentRating",
        "description" : "The quality rating of the subcomponent of a quality of evidence rating."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/certainty-subcomponent-type"
        },
        "name" : "StatisticCertaintySubcomponentType",
        "description" : "The subcomponent classification of quality of evidence rating systems."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/certainty-type"
        },
        "name" : "Evidence Certainty Type",
        "description" : "The aspect of quality, confidence, or certainty."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/characteristic-method"
        },
        "name" : "CharacteristicMethod",
        "description" : "The method used to determine the characteristic(s) of the variable."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/chargeitem-billingcodes"
        },
        "name" : "ChargeItemCode",
        "description" : "Example set of codes that can be used for billing purposes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/choice-list-orientation"
        },
        "name" : "ChoiceListOrientation",
        "description" : "Direction in which lists of possible answers should be displayed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/chromosome-human"
        },
        "name" : "chromosome-human",
        "description" : "Chromosome number for human."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/citation-artifact-classifier"
        },
        "name" : "Citation Artifact Classifier",
        "description" : "Citation artifact classifier"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/citation-classification-type"
        },
        "name" : "Citation Classification Type",
        "description" : "Citation classification type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/citation-summary-style"
        },
        "name" : "Citation Summary Style",
        "description" : "The format for display of the citation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cited-artifact-abstract-type"
        },
        "name" : "Cited Artifact Abstract Type",
        "description" : "Used to express the reason and specific aspect for the variant abstract, such as language and specific language."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cited-artifact-classification-type"
        },
        "name" : "Cited Artifact Classification Type",
        "description" : "Cited Artifact Classification Type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cited-artifact-contribution-type"
        },
        "name" : "Cited Artifact Contribution Type",
        "description" : "Citation contribution."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cited-artifact-part-type"
        },
        "name" : "Cited Artifact Part Type",
        "description" : "To describe the reason for the variant citation, such as version number or subpart specification."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cited-artifact-status-type"
        },
        "name" : "Cited Artifact Status Type",
        "description" : "Cited Artifact Status Type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cited-medium"
        },
        "name" : "Cited Medium",
        "description" : "NLM codes Internet or Print."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/claim-careteamrole"
        },
        "name" : "Claim Care Team Role Codes",
        "description" : "Claim roles of the care team members providing products and services."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/claim-exception"
        },
        "name" : "Exception Codes",
        "description" : "This value set includes sample Exception codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/claim-informationcategory"
        },
        "name" : "Claim Information Category Codes",
        "description" : "This value set includes sample Information Category codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/claim-modifiers"
        },
        "name" : "Modifier type Codes",
        "description" : "This value set includes sample Modifier type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/claim-subtype"
        },
        "name" : "Example Claim SubType Codes",
        "description" : "This value set includes sample Claim SubType codes which are used to distinguish the claim types for example within type institutional there may be subtypes for emergency services, bed stay and transportation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/claim-type"
        },
        "name" : "Claim Type Codes",
        "description" : "This value set includes Claim Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/clinical-discharge-disposition"
        },
        "name" : "Clinical Discharge Disposition",
        "description" : "This value set defines a set of codes that can be used to where the patient left the hospital. Note that this value set explicitly removes 'oth' (Other) to allow the binding strength to be extensible and therefore allow the exchange of additional concepts without requiring mapping to 'oth.'"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/codesystem-altcode-kind"
        },
        "name" : "AlternativeCodeKind",
        "description" : "Indicates the type of use for which the code is defined."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/common-tags"
        },
        "name" : "Common Tags",
        "description" : "Common Tag Codes defined by FHIR project"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/communication-category"
        },
        "name" : "CommunicationCategory",
        "description" : "Codes for general categories of communications such as alerts, instructions, etc."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/communication-not-done-reason"
        },
        "name" : "CommunicationNotDoneReason",
        "description" : "Codes for the reason why a communication did not happen."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/communication-topic"
        },
        "name" : "CommunicationTopic",
        "description" : "Codes describing the purpose or content of the communication."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/composite-measure-scoring"
        },
        "name" : "CompositeMeasureScoring",
        "description" : "The composite scoring method of the measure."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/composition-altcode-kind"
        },
        "name" : "AlternativeCodeKind",
        "description" : "Indicates the type of use for which the code is defined."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/condition-category"
        },
        "name" : "Condition Category Codes",
        "description" : "Preferred value set for Condition Categories."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/condition-clinical"
        },
        "name" : "Condition Clinical Status Codes",
        "description" : "Preferred value set for Condition Clinical Status."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/condition-state"
        },
        "name" : "ConditionState",
        "description" : "Enumeration indicating whether the condition is currently active, inactive, or has been resolved."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/condition-ver-status"
        },
        "name" : "ConditionVerificationStatus",
        "description" : "The verification status to support or decline the clinical status of the condition or diagnosis."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/conformance-expectation"
        },
        "name" : "ConformanceExpectation",
        "description" : "Indicates the degree of adherence to a specified behavior or capability expected for a system to be deemed conformant with a specification."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/consent-action"
        },
        "name" : "Consent Action Codes",
        "description" : "This value set includes sample Consent Action codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/consent-policy"
        },
        "name" : "Consent PolicyRule Codes",
        "description" : "This value set includes sample Regulatory consent policy types from the US and other regions."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/consent-scope"
        },
        "name" : "Consent Scope Codes",
        "description" : "This value set includes the four Consent scope codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/consent-verification"
        },
        "name" : "Consent Verification Codes",
        "description" : "This value set includes base Consent Verification codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contactentity-type"
        },
        "name" : "Contact entity type",
        "description" : "This example value set defines a set of codes that can be used to indicate the purpose for which you would contact a contact party."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/container-cap"
        },
        "name" : "ContainerCap",
        "description" : "Color of the container cap."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contract-action"
        },
        "name" : "Contract Action Codes",
        "description" : "This value set includes sample Contract Action codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contract-actorrole"
        },
        "name" : "Contract Actor Role Codes",
        "description" : "This value set includes sample Contract Actor Role codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contract-content-derivative"
        },
        "name" : "Contract Content Derivation Codes",
        "description" : "This is an example set of Content Derivative type codes, which represent the minimal content derived from the basal information source at a specific stage in its lifecycle, which is sufficient to manage that source information, for example, in a repository, registry, processes and workflows, for making access control decisions, and providing query responses."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contract-data-meaning"
        },
        "name" : "ContractDataMeaning",
        "description" : "How a resource reference is interpreted when evaluating contract offers."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contract-signer-type"
        },
        "name" : "Contract Signer Type Codes",
        "description" : "This value set includes sample Contract Signer Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contract-subtype"
        },
        "name" : "Contract Subtype Codes",
        "description" : "This value set includes sample Contract Subtype codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contract-term-subtype"
        },
        "name" : "Contract Term Subtype Codes",
        "description" : "This value set includes sample Contract Term SubType codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contract-term-type"
        },
        "name" : "Contract Term Type Codes",
        "description" : "This value set includes sample Contract Term Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contract-type"
        },
        "name" : "Contract Type Codes",
        "description" : "This value set includes sample Contract Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contributor-role"
        },
        "name" : "Contributor Role",
        "description" : "Used to code the format of the display string."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contributor-summary-source"
        },
        "name" : "Contributor Summary Source",
        "description" : "Used to code the producer or rule for creating the display string."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contributor-summary-style"
        },
        "name" : "Contributor Summary Style",
        "description" : "Used to code the format of the display string."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contributor-summary-type"
        },
        "name" : "Contributor Summary Type",
        "description" : "Used to code author list statement, contributorship statement, and such."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/copy-number-event"
        },
        "name" : "CopyNumberEvent",
        "description" : "Copy Number Event."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coverage-class"
        },
        "name" : "Coverage Class Codes",
        "description" : "This value set includes Coverage Class codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coverage-copay-type"
        },
        "name" : "Coverage Copay Type Codes",
        "description" : "This value set includes sample Coverage Copayment Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coverage-financial-exception"
        },
        "name" : "Example Coverage Financial Exception Codes",
        "description" : "This value set includes Example Coverage Financial Exception Codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coverage-selfpay"
        },
        "name" : "Coverage SelfPay Codes",
        "description" : "This value set includes Coverage SelfPay codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coverageeligibilityresponse-ex-auth-support"
        },
        "name" : "CoverageEligibilityResponse Auth Support Codes",
        "description" : "This value set includes CoverageEligibilityResponse Auth Support codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cpt-all"
        },
        "name" : "AMA CPT All Codes",
        "description" : "All codes in CPT (including metadata, modifiers, etc)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cpt-base"
        },
        "name" : "AMA CPT Base Codes",
        "description" : "All codes in CPT that represent procedure codes (no modifiers allowed - e.g. for Claim.item.productOrService)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cpt-modifiers"
        },
        "name" : "AMA CPT Modifier Codes",
        "description" : "CPT modifiers (e.g. for Claim.item.modifier)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cpt-usable"
        },
        "name" : "AMA CPT Usable Codes",
        "description" : "All CPT codes (no modifiers) that represent procedure codes (e.g. for Procedure.code)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cql-access-modifier"
        },
        "name" : "CQL Access Modifier",
        "description" : "Access modifiers defined by the Clinical Quality Language (CQL) specification in the [Access Modifiers](https://cql.hl7.org/03-developersguide.html#access-modifiers) topic."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/definition-status"
        },
        "name" : "DefinitionStatus",
        "description" : "Codes identifying the lifecycle stage of a definition."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/definition-topic"
        },
        "name" : "DefinitionTopic",
        "description" : "High-level categorization of the definition, used for searching, sorting, and filtering."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/definition-use"
        },
        "name" : "Structure Definition Use Codes / Keywords",
        "description" : "Structure Definition Use Codes / Keywords"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/device-kind"
        },
        "name" : "FHIR Device Types",
        "description" : "Codes used to identify medical devices. Includes concepts from SNOMED CT (http://www.snomed.org/)    where concept is-a 49062001 (Device)  and is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/device-status-reason"
        },
        "name" : "FHIRDeviceStatusReason",
        "description" : "The availability status reason of the device."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/devicealert-activationState"
        },
        "name" : "DeviceAlert Activation State Codes",
        "description" : "DeviceAlert Activation State Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/devicealert-condition"
        },
        "name" : "DeviceAlert Condition Codes",
        "description" : "DeviceAlert Condition Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/devicealert-priority"
        },
        "name" : "DeviceAlert Priority Codes",
        "description" : "DeviceAlert Priority Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/diagnosis-role"
        },
        "name" : "DiagnosisRole",
        "description" : "This value set defines a set of codes that can be used to express the role of a diagnosis on the Encounter or EpisodeOfCare record."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/diagnosistype"
        },
        "name" : "Diagnosis Type Codes",
        "description" : "This value set includes Diagnosis Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/directness"
        },
        "name" : "EvidenceDirectness",
        "description" : "The quality of how direct the match is."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/dose-rate-type"
        },
        "name" : "DoseAndRateType",
        "description" : "The kind of dose or rate specified."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounter-admit-source"
        },
        "name" : "Admit source",
        "description" : "This value set defines a set of codes that can be used to indicate from where the patient came in."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounter-class"
        },
        "name" : "Encounter class",
        "description" : "This value set defines a set of codes that can be used to indicate the class of encounter: a specific code indicating class of service provided."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounter-diet"
        },
        "name" : "Diet",
        "description" : "This value set defines a set of codes that can be used to indicate dietary preferences or restrictions a patient may have."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounter-discharge-disposition"
        },
        "name" : "Discharge disposition",
        "description" : "This value set defines a set of codes that can be used to where the patient left the hospital."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounter-special-arrangements"
        },
        "name" : "Special arrangements",
        "description" : "This value set defines a set of codes that can be used to indicate the kinds of special arrangements in place for a patients visit."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounter-subject-status"
        },
        "name" : "Encounter subject status",
        "description" : "This example value set defines a set of codes that can be used to indicate the status of the subject within the encounter"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounter-type"
        },
        "name" : "Encounter type",
        "description" : "This example value set defines a set of codes that can be used to indicate the type of encounter: a specific code indicating type of service provided."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/endpoint-connection-type"
        },
        "name" : "Endpoint Connection Type",
        "description" : "This is an example value set defined by the FHIR project, that could be used to represent possible connection type profile values."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/entformula-additive"
        },
        "name" : "Enteral Formula Additive Type Code",
        "description" : "EnteralFormulaAdditiveType: Codes for the type of modular component such as protein, carbohydrate or fiber to be provided in addition to or mixed with the base formula. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/episodeofcare-type"
        },
        "name" : "Episode of care type",
        "description" : "This example value set defines a set of codes that can be used to express the usage type of an EpisodeOfCare record."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/evidence-quality"
        },
        "name" : "QualityOfEvidenceRating",
        "description" : "A rating system that describes the quality of evidence such as the GRADE, DynaMed, or Oxford CEBM systems."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ex-benefitcategory"
        },
        "name" : "Benefit Category Codes",
        "description" : "This value set includes examples of Benefit Category codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ex-diagnosis-on-admission"
        },
        "name" : "Example Diagnosis on Admission Codes",
        "description" : "This value set includes example Diagnosis on Admission codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ex-diagnosisrelatedgroup"
        },
        "name" : "Example Diagnosis Related Group Codes",
        "description" : "This value set includes example Diagnosis Related Group codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ex-diagnosistype"
        },
        "name" : "Example Diagnosis Type Codes",
        "description" : "This value set includes example Diagnosis Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ex-payee-resource-type"
        },
        "name" : "ClaimPayeeResourceType",
        "description" : "The type of Claim payee Resource."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ex-paymenttype"
        },
        "name" : "Example Payment Type Codes",
        "description" : "This value set includes example Payment Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ex-procedure-type"
        },
        "name" : "Example Procedure Type Codes",
        "description" : "This value set includes example Procedure Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ex-program-code"
        },
        "name" : "Example Program Reason Codes",
        "description" : "This value set includes sample Program Reason Span codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ex-revenue-center"
        },
        "name" : "Example Revenue Center Codes",
        "description" : "This value set includes sample Revenue Center codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/expansion-parameter-source"
        },
        "name" : "ExpansionParameterSource",
        "description" : "Declares what the source of a parameter is."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/expansion-processing-rule"
        },
        "name" : "ExpansionProcessingRule",
        "description" : "Defines how concepts are processed into the expansion when it's for UI presentation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/fhir-clinical-doc-information-recipient"
        },
        "name" : "FHIR Clinical Document Information Recipients Participant Types",
        "description" : "Subset of codes from v3-ParticipationType for use as Clinical Document Participant Type codes, which are specifically CDA information recipients."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/fhir-clinical-doc-participant"
        },
        "name" : "FHIR Clinical Document Participant Types Value set",
        "description" : "FHIR Clinical Document Participant Types. Author, Authenticator, Custodian, Legal Authenticator, Record Target and Subject are found in distinct, named fields in FHIR. Thus, these types are excluded."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/financial-taskcode"
        },
        "name" : "Financial Task Codes",
        "description" : "This value set includes Financial Task codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/financial-taskinputtype"
        },
        "name" : "Financial Task Input Type Codes",
        "description" : "This value set includes Financial Task Input Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/flag-category"
        },
        "name" : "Flag Category",
        "description" : "Example list of general categories for flagged issues. (Not complete or necessarily appropriate.)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/forms"
        },
        "name" : "Forms",
        "description" : "This value set includes a sample set of Forms codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/fundsreserve"
        },
        "name" : "Funds Reservation Codes",
        "description" : "This value set includes sample funds reservation type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/gender-identity"
        },
        "name" : "Gender Identity",
        "description" : "Codes that indicate a individual's gender identity. This value set is a minimum set of commonly used values.  It is expected and encouraged that specific jurisdictions or communities will use additional gender identity concepts that are relevant within their community."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/goal-acceptance-status"
        },
        "name" : "GoalAcceptanceStatus",
        "description" : "Codes indicating whether the goal has been accepted by a stakeholder."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/goal-achievement"
        },
        "name" : "Goal achievement status",
        "description" : "Describes the progression, or lack thereof, towards the goal against the target."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/goal-category"
        },
        "name" : "Goal category",
        "description" : "Example codes for grouping goals to use for filtering or presentation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/goal-priority"
        },
        "name" : "Goal priority",
        "description" : "Indicates the level of importance associated with reaching or sustaining a goal."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/goal-relationship-type"
        },
        "name" : "GoalRelationshipType",
        "description" : "Types of relationships between two goals."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/group-code"
        },
        "name" : "Group Code",
        "description" : "A code that describes the use of the group. The use of the group usually dictates what kind of entities can be members of the group"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/guide-parameter-code"
        },
        "name" : "GuideParameterCode",
        "description" : "Code of parameter that is input to the guide."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/handling-condition"
        },
        "name" : "HandlingConditionSet",
        "description" : "Set of handling instructions prior testing of the specimen."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/history-absent-reason"
        },
        "name" : "FamilyHistoryAbsentReason",
        "description" : "Codes describing the reason why a family member's history is not available."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hl7-work-group"
        },
        "name" : "HL7Workgroup",
        "description" : "An HL7 administrative unit that owns artifacts in the FHIR specification."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/immunization-evaluation-dose-status-reason"
        },
        "name" : "Immunization Evaluation Dose Status Reason codes",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why an administered dose has been assigned a particular status. Often, this reason describes why a dose is considered invalid. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/immunization-evaluation-dose-status"
        },
        "name" : "Immunization Evaluation Dose Status codes",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the validity of a dose relative to a particular recommended schedule. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/immunization-function"
        },
        "name" : "Immunization Function",
        "description" : "The value set defines the role that a performer has played in an immunization event. Core functions included in the value set including ordering and administering provider. If other concepts are necessary, the codes should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the function an individual or organization may play in the immunization event."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/immunization-funding-source"
        },
        "name" : "Immunization Funding Source",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the source of the vaccine administered. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/immunization-program-eligibility"
        },
        "name" : "Immunization Program Eligibility",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the patient's eligibility for a vaccination program. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/immunization-recommendation-status"
        },
        "name" : "Immunization Recommendation Status Codes",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the status of the patient towards perceived immunity against a vaccine preventable disease. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/immunization-subpotent-reason"
        },
        "name" : "Immunization Subpotent Reason",
        "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why a dose is considered to be subpotent. This value set is provided as a suggestive example."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/implantStatus"
        },
        "name" : "Implant Status",
        "description" : "A set codes that define the functional status of an implanted device."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/insurance-coverage-type"
        },
        "name" : "Insurance Coverage Type",
        "description" : "This value set defines a set of codes for Insurance Coverage Type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/insurance-product-type"
        },
        "name" : "Insurance Product Type",
        "description" : "This value set defines a set of codes for Insurance Product Type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/insuranceplan-applicability"
        },
        "name" : "Benefit cost applicability",
        "description" : "Whether the cost applies to in-network or out-of-network providers."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/insuranceplan-plan-type"
        },
        "name" : "Insuranceplan Plan Type",
        "description" : "This value set defines a set of codes for Insuranceplan Plan Type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/insuranceplan-type"
        },
        "name" : "Insurance plan type",
        "description" : "This example value set defines a set of codes that can be used to indicate a type of insurance plan."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/jurisdiction"
        },
        "name" : "Jurisdiction ValueSet",
        "description" : "This value set defines a base set of codes for country, country subdivision and region    for indicating where a resource is intended to be used.   \r\n   \r\n   Note: The codes for countries and country subdivisions are taken from    [ISO 3166](https://www.iso.org/iso-3166-country-codes.html)    while the codes for \"supra-national\" regions are from    [UN Standard country or area codes for statistical use (M49)](http://unstats.un.org/unsd/methods/m49/m49.htm)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/library-type"
        },
        "name" : "LibraryType",
        "description" : "The type of knowledge asset this library contains."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/list-empty-reason"
        },
        "name" : "List Empty Reasons",
        "description" : "General reasons for a list to be empty. Reasons are either related to a summary list (i.e. problem or medication list) or to a workflow related list (i.e. consultation list)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/list-example-codes"
        },
        "name" : "Example Use Codes for List",
        "description" : "Example use codes for the List resource - typical kinds of use."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/list-order"
        },
        "name" : "List Order Codes",
        "description" : "Base values for the order of item lists in resources."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/location-physical-type"
        },
        "name" : "Location type",
        "description" : "This example value set defines a set of codes that can be used to indicate the physical form of the Location."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/match-grade"
        },
        "name" : "MatchGrade",
        "description" : "A Master Patient Index (MPI) assessment of whether a candidate patient record is a match or not."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/measure-aggregate-method"
        },
        "name" : "Measure Aggregate Method",
        "description" : "Aggregation method for a measure (e.g. sum, average, median, minimum, maximum,    count)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/measure-data-usage"
        },
        "name" : "MeasureDataUsage",
        "description" : "The intended usage for supplemental data elements in the measure."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/measure-improvement-notation"
        },
        "name" : "MeasureImprovementNotation",
        "description" : "Observation values that indicate what change in a measurement value or score is indicative of an improvement in the measured item or scored issue."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/measure-population"
        },
        "name" : "MeasurePopulationType",
        "description" : "The type of population."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/measure-scoring"
        },
        "name" : "Measure Scoring",
        "description" : "The scoring type of the measure."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/measure-supplemental-data"
        },
        "name" : "Measure Supplemental Data",
        "description" : "Supplemental data in a population for measuring purposes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/measure-type"
        },
        "name" : "MeasureType",
        "description" : "The type of measure (includes codes from 2.16.840.1.113883.1.11.20368)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/med-admin-perform-function"
        },
        "name" : "Medication administration  performer  function  codes",
        "description" : "MedicationAdministration Performer Function Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medical-management-type"
        },
        "name" : "Medical Management Type",
        "description" : "This value set includes types of medical management requirements or processes used by health insurers (payers) that may impact whether a service or item is covered or reimbursement rates."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-admin-location"
        },
        "name" : "MedicationAdministrationLocation",
        "description" : "Direction in which lists of possible answers should be displayed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-usage-admin-location"
        },
        "name" : "MedicationUsageAdministrationLocation",
        "description" : "Direction in which lists of possible answers should be displayed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medicationdispense-performer-function"
        },
        "name" : "Medication dispense  performer  function  codes",
        "description" : "MedicationDispense Performer Function Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medicationknowledge-characteristic"
        },
        "name" : "Medication knowledge  characteristic  codes",
        "description" : "MedicationKnowledge Characteristic Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medicationknowledge-package-type"
        },
        "name" : "Medication knowledge  package  type  codes",
        "description" : "MedicationKnowledge Package Type Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medicationknowledge-status"
        },
        "name" : "Medication knowledge  status  codes",
        "description" : "MedicationKnowledge Status Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medicationrequest-admin-location"
        },
        "name" : "MedicationRequestAdministrationLocation",
        "description" : "Direction in which lists of possible answers should be displayed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medicationrequest-category"
        },
        "name" : "Medication request  category  codes",
        "description" : "MedicationRequest Category Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medicationrequest-course-of-therapy"
        },
        "name" : "Medication request  course of  therapy  codes",
        "description" : "MedicationRequest Course of Therapy Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medicationrequest-status-reason"
        },
        "name" : "Medication request  status  reason  codes",
        "description" : "MedicationRequest Status Reason Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/message-reason-encounter"
        },
        "name" : "Example Message Reason Codes",
        "description" : "Example Message Reasons. These are the set of codes that might be used an updating an encounter using admin-update."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/missing-tooth-reason"
        },
        "name" : "Missing Tooth Reason Codes",
        "description" : "This value set includes sample Missing Tooth Reason codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ndh-healthcare-service-category"
        },
        "name" : "NDH Healthcare Service Category",
        "description" : "This value set defines a set of codes for NDH Healthcare Service Category used in the National Directory of Healthcare Providers and Services (NDH)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nutrition-intake-category"
        },
        "name" : "Nutrition intake  category  codes",
        "description" : "NutritionIntake Category Codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/object-role"
        },
        "name" : "AuditEventEntityRole",
        "description" : "Code representing the role the entity played in the audit event."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/observation-category"
        },
        "name" : "Observation Category Codes",
        "description" : "Observation Category codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/observation-statistics"
        },
        "name" : "StatisticsCode",
        "description" : "The statistical operation parameter -\"statistic\" codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/organization-affiliation-role"
        },
        "name" : "Organization Affiliation Role",
        "description" : "This value set defines a set of codes that can be used to indicate an organization affiliation role."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/organization-alias-type"
        },
        "name" : "Organization Alias Type",
        "description" : "This value set defines a set of codes for indicating oranization alias type."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/organization-type"
        },
        "name" : "Organization type",
        "description" : "This example value set defines a set of codes that can be used to indicate a type of organization."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/parameter-group"
        },
        "name" : "DeviceDefinitionParameterGroup",
        "description" : "Codes identifying groupings of parameters; e.g. Cardiovascular."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/payeetype"
        },
        "name" : "Payee Type Codes",
        "description" : "Codes indicating the type of party to be reimbursed for cost of the products and service."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/payment-adjustment-reason"
        },
        "name" : "Payment Adjustment Reason Codes",
        "description" : "This value set includes smattering of Payment Adjustment Reason codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/payment-status"
        },
        "name" : "Payment Status Codes",
        "description" : "This value set includes a sample set of Payment Status codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/payment-type"
        },
        "name" : "Payment Type Codes",
        "description" : "This value set includes sample Payment Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/plan-definition-type"
        },
        "name" : "PlanDefinitionType",
        "description" : "The type of PlanDefinition."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/procedure-type"
        },
        "name" : "Procedure Type Codes",
        "description" : "This value set includes Procedure Type codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/process-priority"
        },
        "name" : "Process Priority Codes",
        "description" : "This value set includes the financial processing priority codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/professional-credential-status"
        },
        "name" : "rofessional Credential Status",
        "description" : "This code system establishes a series of codes designed to represent the status of professional credentials."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/program"
        },
        "name" : "Program",
        "description" : "This value set defines an example set of codes that could be can be used to classify groupings of service-types/specialties."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/pronouns"
        },
        "name" : "Personal Pronouns",
        "description" : "Codes that indicate the pronouns to be used when communicating with or about an individual."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/provenance-agent-type"
        },
        "name" : "Provenance participant type",
        "description" : "The type of participation a provenance participant."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/provider-qualification"
        },
        "name" : "Example Provider Qualification Codes",
        "description" : "This value set includes sample Provider Qualification codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/published-in-type"
        },
        "name" : "Published In Type",
        "description" : "The type of publication such as book, database, or journal."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/question-max-occurs"
        },
        "name" : "MaxOccurs",
        "description" : "Flags an element as having unlimited repetitions."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/questionnaire-usage-mode"
        },
        "name" : "QuestionnaireItemUsageMode",
        "description" : "Identifies the modes of usage of a questionnaire that should enable a particular questionnaire item."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/reaction-event-certainty"
        },
        "name" : "AllergyIntoleranceCertainty",
        "description" : "Statement about the degree of clinical certainty that a specific substance was the cause of the manifestation in a reaction event."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/reason-medication-given-codes"
        },
        "name" : "Reason Medication Given Codes",
        "description" : "This value set is provided as an example. The value set to instantiate this attribute should be drawn from a robust terminology code system that consists of or contains concepts to support the medication process."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/recommendation-strength"
        },
        "name" : "StrengthOfRecommendationRating",
        "description" : "A rating system that describes the strength of the recommendation, such as the GRADE, DynaMed, or HGPS systems."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/recorded-sex-or-gender-type"
        },
        "name" : "Recorded Sex Or Gender Type",
        "description" : "Codes that represent the type of the recorded sex and gender."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/referencerange-meaning"
        },
        "name" : "Observation Reference Range Meaning Codes",
        "description" : "This value set defines a set of codes that can be used to indicate the meaning/use of a reference range for a particular target population."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/rejection-criteria"
        },
        "name" : "RejectionCriterion",
        "description" : "Criterion for rejection of the specimen by laboratory."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/related-claim-relationship"
        },
        "name" : "Example Related Claim Relationship Codes",
        "description" : "This value set includes sample Related Claim Relationship codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/research-study-objective-type"
        },
        "name" : "ResearchStudyObjectiveType",
        "description" : "Codes for the kind of study objective."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/research-study-party-role"
        },
        "name" : "Research Study Party Role",
        "description" : "This is a ResearchStudy's party role."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/research-study-phase"
        },
        "name" : "ResearchStudyPhase",
        "description" : "Codes for the stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/research-study-prim-purp-type"
        },
        "name" : "ResearchStudyPrimaryPurposeType",
        "description" : "Codes for the main intent of the study."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/research-study-reason-stopped"
        },
        "name" : "ResearchStudyReasonStopped",
        "description" : "Codes for why the study ended prematurely."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/research-study-status"
        },
        "name" : "Research Study Status",
        "description" : "Codes that convey the current status of the research study."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/research-subject-milestone"
        },
        "name" : "ResearchSubjectMilestone",
        "description" : "Indicates the progression of a study subject through the study milestones.                 **Deprecation Information:** This valueSet is being replaced in favor of using NCI Thesaurus codes. [Research Subject Milestones](http://terminology.hl7.org/ValueSet/research-subject-milestones) should be used instead"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/research-subject-milestones"
        },
        "name" : "Research Subject Milestones",
        "description" : "A terminology codelist relevant to protocol-specified, point-in-time events during a study."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/research-subject-state-type"
        },
        "name" : "ResearchSubjectStateType",
        "description" : "Identifies the kind of state being refered to."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/research-subject-state"
        },
        "name" : "ResearchSubjectState",
        "description" : "Indicates the progression of a study subject through a study."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/resource-security-category"
        },
        "name" : "ResourceSecurityCategory",
        "description" : "Provides general guidance around the kind of access Control to Read, Search, Create, Update, or Delete a resource."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/resource-type-link"
        },
        "name" : "PayeeResourceType",
        "description" : "The type of payee Resource."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/risk-probability"
        },
        "name" : "Risk Probability",
        "description" : "Codes representing the likelihood of a particular outcome in a risk assessment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/service-category"
        },
        "name" : "Service category",
        "description" : "This value set defines an example set of codes that can be used to classify groupings of service-types/specialties."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/service-delivery-method"
        },
        "name" : "Service Delivery Method",
        "description" : "This value set defines a set of codes that can be used to indicate service delivery method."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/service-place"
        },
        "name" : "Example Service Place Codes",
        "description" : "This value set includes a smattering of Service Place codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/service-provision-conditions"
        },
        "name" : "ServiceProvisionConditions",
        "description" : "The code(s) that detail the conditions under which the healthcare service is available/offered."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/service-referral-method"
        },
        "name" : "ReferralMethod",
        "description" : "The methods of referral can be used when referring to a specific HealthCareService resource."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/service-type"
        },
        "name" : "Service type",
        "description" : "This value set defines an example set of codes of service-types."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/service-uscls"
        },
        "name" : "USCLS Codes",
        "description" : "This value set includes a smattering of USCLS codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/sex-parameter-for-clinical-use"
        },
        "name" : "Sex Parameter for Clinical Use",
        "description" : "A summary parameter that provides guidance on how a receiver should apply settings or reference ranges that are derived from observable information such as an organ inventory, recent hormone lab tests, genetic testing, menstrual status, obstetric history, etc.."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/smart-capabilities"
        },
        "name" : "SmartCapabilities",
        "description" : "Codes that define what the server is capable of."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/snomed-intl-gps"
        },
        "name" : "SNOMED International Global Patient Set (GPS)",
        "description" : "SNOMED International Global Patient Set (GPS) value set.    The value set includes all of the codes from the SNOMED International Global Patient Set (GPS)    subset of SNOMED CT.  The current version of the value set contains all concepts (26,158) from    the September 2020 release of the GPS (based on the July 2020 SNOMED CT International Edition    release).   \n\n   This value set is provided as a FHIR ValueSet resource instance for the convenience of implementers."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/software-system-type"
        },
        "name" : "Software System Type",
        "description" : "Types of software systems that support knowledge artifact authoring and evaluation (authoring, testing, tooling, evaluation)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/special-values"
        },
        "name" : "SpecialValues",
        "description" : "A set of generally useful codes defined so they can be included in value sets."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/standards-status"
        },
        "name" : "StandardsStatus",
        "description" : "HL7 Ballot/Standards status of artifact."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/state-change-reason"
        },
        "name" : "StateChangeReason",
        "description" : "Indicates why the state of the subject changed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/statistic-model-code"
        },
        "name" : "Statistic Model Code",
        "description" : "The handling of the variable in statistical analysis for exposures or outcomes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/statistic-type"
        },
        "name" : "StatisticStatisticType",
        "description" : "The type of a specific statistic."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/study-design"
        },
        "name" : "Study Design",
        "description" : "This is a set of terms for study design characteristics."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/study-type"
        },
        "name" : "StatisticStudyType",
        "description" : "The type of study a statistic was derived from."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/subscriber-relationship"
        },
        "name" : "SubscriberPolicyholder Relationship Codes",
        "description" : "This value set includes codes for the relationship between the Subscriber and the Beneficiary (insured/covered party/patient)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/subscription-channel-type"
        },
        "name" : "SubscriptionChannel Type Codes",
        "description" : "Codes to represent subscription error details"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/subscription-error"
        },
        "name" : "Subscription Error Codes",
        "description" : "Codes to represent subscription error details"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/subscription-status-at-event"
        },
        "name" : "SubscriptionStatusAtEvent",
        "description" : "A status code for the state of the Subscription."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/subscription-tag"
        },
        "name" : "SubscriptionTag",
        "description" : "Tags to put on a resource after subscriptions have been sent."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/substance-category"
        },
        "name" : "Substance Category Codes",
        "description" : "Substance category codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/supplydelivery-type"
        },
        "name" : "Supply Item Type",
        "description" : "This value sets refers to a specific supply item."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/supplyrequest-kind"
        },
        "name" : "Supply Type",
        "description" : "This value sets refers to a Category of supply."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/supplyrequest-reason"
        },
        "name" : "SupplyRequestReason",
        "description" : "The reason why the supply item was requested."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/surface"
        },
        "name" : "Surface Codes",
        "description" : "This value set includes a smattering of FDI tooth surface codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/synthesis-type"
        },
        "name" : "StatisticSynthesisType",
        "description" : "Types of combining results from a body of evidence (eg. summary data meta-analysis)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/testscript-operation-codes"
        },
        "name" : "Test script operation code",
        "description" : "This value set defines a set of codes that are used to indicate the supported operations of a testing engine or tool."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/testscript-profile-destination-types"
        },
        "name" : "Test script profile destination type",
        "description" : "This value set defines a set of codes that are used to indicate the profile type of a test system when acting as the destination within a TestScript."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/testscript-profile-origin-types"
        },
        "name" : "Test script profile origin type",
        "description" : "This value set defines a set of codes that are used to indicate the profile type of a test system when acting as the origin within a TestScript."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/time-period-ranges"
        },
        "name" : "Time Period Ranges",
        "description" : "All codes in the Time Period Ranges code system. Note that this value set is typically not expanded because the full set contains millions of codes, the set of all possible ranges of time periods expressible within the grammar."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/title-type"
        },
        "name" : "Title Type",
        "description" : "Used to express the reason and specific aspect for the variant title, such as language and specific language."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/tooth"
        },
        "name" : "Oral Site Codes",
        "description" : "This value set includes a smattering of FDI oral site codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ucum-common"
        },
        "name" : "Common UCUM units",
        "description" : "Commonly encountered UCUM units (for purposes of helping populate look ups)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ucum-units"
        },
        "name" : "UCUM Codes",
        "description" : "Unified Code for Units of Measure (UCUM). This value set includes all UCUM codes"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/usage-context-type"
        },
        "name" : "UsageContextType",
        "description" : "A code that specifies a type of context being specified by a usage context."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/variable-role-subtype"
        },
        "name" : "EvidenceVariableRoleSubtype",
        "description" : "The subclassification of the role that the assertion variable plays."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/variable-role"
        },
        "name" : "EvidenceVariableRole",
        "description" : "**Deprecation Information:** This CodeSystem/ValueSet was used in FHIR R5 for a CodeableConcept binding that was changed to a code binding in FHIR R6. The replacement CodeSystem/ValueSet is http://hl7.org/fhir/variable-role and http://hl7.org/fhir/ValueSet/variable-role."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/variant-state"
        },
        "name" : "sequenceStatus",
        "description" : "Codes providing the status of the variant test result."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/verificationresult-can-push-updates"
        },
        "name" : "Can-push-updates",
        "description" : "Ability of the primary source to push updates/alerts"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/verificationresult-communication-method"
        },
        "name" : "VerificationResult Communication Method",
        "description" : "Attested information may be validated by process that are manual or automated. For automated processes it may accomplished by the system of record reaching out through another system's API or information may be sent to the system of record. This value set defines a set of codes to describing the process, the how, a resource or data element is validated."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/verificationresult-failure-action"
        },
        "name" : "Failure-action",
        "description" : "The result if validation fails"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/verificationresult-need"
        },
        "name" : "Need",
        "description" : "The frequency with which the target must be validated"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/verificationresult-primary-source-type"
        },
        "name" : "Primary-source-type",
        "description" : "Type of the validation primary source"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/verificationresult-push-type-available"
        },
        "name" : "Push-type-available",
        "description" : "Type of alerts/updates the primary source can send"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/verificationresult-validation-process"
        },
        "name" : "Validation-process",
        "description" : "The primary process by which the target is validated"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/verificationresult-validation-status"
        },
        "name" : "Validation-status",
        "description" : "Status of the validation of the target against the primary source"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/verificationresult-validation-type"
        },
        "name" : "Validation-type",
        "description" : "What the target is validated against"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/virtual-healthcare-delivery-method"
        },
        "name" : "Virtual Healthcare Delivery Method",
        "description" : "This value set defines a set of codes for virtual healthcare service delivery method."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vision-product"
        },
        "name" : "Example Vision Prescription Product Codes",
        "description" : "This value set includes a smattering of Prescription Product codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/edible-substance-type"
        },
        "name" : "Types of Edible Substances",
        "description" : "This value set represents codes for types of edible substances and is provided as a suggestive example.  It include codes from [SNOMED CT](http://snomed.info/sct) where concept is-a 762766007 Edible Substance (substance)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/image-reference-type"
        },
        "name" : "Image Reference Type",
        "description" : "The type of image reference specified by an imaging selection."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-0"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-1"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-10"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-11"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg2-1-0-13"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-15"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-2"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-3"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-4"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-5"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-6"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-7"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-8"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-9"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg1-1-0-12"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/hxutg3-1-0-14"
        },
        "name" : "null (Bundle)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/insurance-benefit-type"
        },
        "name" : "Insurance Benefit Type",
        "description" : "This code system defines a set of codes for Insurance Benefit Type. This code system is being developed in the National Directory of Healthcare Providers & Services (NDH) Implementation Guide until it is mature enough to be moved to THO. The code system can be viewed in the IG here:  [https://build.fhir.org/ig/HL7/fhir-us-ndh/CodeSystem-NdhPayerCharacteristicsCS.html](https://build.fhir.org/ig/HL7/fhir-us-ndh/CodeSystem-NdhPayerCharacteristicsCS.html)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0005"
        },
        "name" : "PH_RaceAndEthnicity_CDC",
        "description" : "Code system of concepts specifying the patient's race.  Used in HL7 Version 2.x messages in the PID segment.\r\n\r\nThis code system includes codes used decades ago are are maintained here for historical purposes such as searching in past history records. These codes were formally deprecated in V2.9 and retired in THO in 2021. Please reference http://build.fhir.org/ig/HL7/UTG/CodeSystem-CDCREC for the current CDC Race and Ethnicity code system."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-HealthcareProviderTaxonomyHIPAA"
        },
        "name" : "Healthcare Provider Taxonomy HIPAA",
        "description" : "NUCC Healthcare Provider Taxonomy codes, as cited in US HIPAA regulations.  This HL7 copy of the content is made available by request of various HL7 Affiliates,so do have have direect access to the NUCC contnet as they are outside the US.  In additions, some concept have been added to this set that are pending being added to the NUCC master."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-CodeSystem"
        },
        "name" : "CodeSystem",
        "description" : "Code systems used in HL7 standards."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-CodeSystemType"
        },
        "name" : "HL7 Code System Type",
        "description" : "Retired code system for HL7 Code System Types. This description added to conform to shareable codesystem profile"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-ConceptCodeRelationship"
        },
        "name" : "Possible Concept Code Relationships",
        "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-ConceptGenerality"
        },
        "name" : "ConceptGenerality",
        "description" : "Indicates whether the concept that is the target should be interpreted as itself, or whether it should be expanded to include its child concepts, or both when it is included in the source domain/valueset.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-ConceptProperty"
        },
        "name" : "HL7 Value Set and Coded Concept Property Codes",
        "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-ConceptStatus"
        },
        "name" : "HL7 Coded Concept Status",
        "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-Country"
        },
        "name" : "Country",
        "description" : "The territory of a sovereign nation.\r\n\r\nNote that this has been deprecated in favor of using the ISO 3166 Country codes - 1.0.3166.1 iso3166-1"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-Currency"
        },
        "name" : "Currency",
        "description" : "The currency unit as defined in ISO 4217.\r\n\r\nCreated prior to ISO ruling on OIDs for ISO code tables defined in ISO standards. Retired. Replaced by 1.0.4217 iso4217."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-DataType"
        },
        "name" : "DataType",
        "description" : "Code system retired."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-EditStatus"
        },
        "name" : "EditStatus",
        "description" : "The status of an entry as it pertains to its review and incorporation into the HL7 domain specification database."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-EncounterAccident"
        },
        "name" : "EncounterAccident",
        "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. No content."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-EncounterAcuity"
        },
        "name" : "Encounter Acuity",
        "description" : "The level of resource intensiveness of patient care.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. No content."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-EncounterReferralSource"
        },
        "name" : "EncounterReferralSource",
        "description" : "This domain is defined in UB92 and applies to US realm only\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. We've deprecated all of the codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-HL7CommitteeIDInRIM"
        },
        "name" : "HL7CommitteeIDInRIM",
        "description" : "Holds the codes used to identify the committees and SIGS of HL7 in RIM repository tables.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-HL7ConformanceInclusion"
        },
        "name" : "HL7ConformanceInclusion",
        "description" : "These concepts represent theconformance requirments defined for including or valuing an element of an HL7 message. The concepts apply equally to conformance profiles defined for Version 2.x messgaes as defined by the Conformance SIG, and to the conformance columns for Version 3 messages as specified in the HMD.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-ISO3166-1retired"
        },
        "name" : "ISO 3166 2 Character Country Codes",
        "description" : "Two character country codes\r\n\r\nNote that this OID was erroneously entered into HL7 some years ago, and has recently been replaced by 1.0.3166.1 at the request of ISO."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-ISO3166-2retired"
        },
        "name" : "ISO 3166 3 Character Country Codes",
        "description" : "Three character country codes\r\n\r\nNote that this was erroneously entered into the HL7 system some years ago and has been replaced by 1.0.3166.1.2.3 at the request of ISO."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-ISO3166-3retired"
        },
        "name" : "ISO 3166 Numeric country Codes",
        "description" : "Numeric country codes\r\n\r\nNote that this was erroneously entered into the HL7 system some years ago and has been replaced by 1.0.3166.1.2.1 at the request of ISO."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-MDFAttributeType"
        },
        "name" : "MDFAttributeType",
        "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-MDFSubjectAreaPrefix"
        },
        "name" : "MDFSubjectAreaPrefix",
        "description" : "The standard prefixes used in Rose for RIM subject areas that determine the role or function of each subject area.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-MaterialForm"
        },
        "name" : "MaterialForm",
        "description" : "A value representing the state (solid, liquid, gas) and nature of the material.\r\n\r\n*Open Issue:*  There exist no codes in the repository for this coding system; should it be removed?"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-MaterialType"
        },
        "name" : "MaterialType",
        "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. This is outside the hierarchy and there's already an equivalent domain MaterialEntityClass in the right hierarchy. The corresponding code system is empty."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-MdfHmdMetSourceType"
        },
        "name" : "MdfHmdMetSourceType",
        "description" : "Code to identify the source of a Message Element Type represented in the 'of MET' column of an HMD.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-MdfHmdRowType"
        },
        "name" : "MdfHmdRowType",
        "description" : "The row type codes for the tabular representation of a Hierarchical Message Description.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-MdfRmimRowType"
        },
        "name" : "MdfRmimRowType",
        "description" : "The row types for the tabular representation of an R-MIM.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-MessageCondition"
        },
        "name" : "MessageCondition",
        "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used.This isn't referenced in the RIM and is a copy of old v2 codes. It's superseded by AcknowledgementDetailCode"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-OrganizationNameType"
        },
        "name" : "OrganizationNameType",
        "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. All of these are maintained under EntityNameType. This was created in error and should never be used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-ParameterizedDataType"
        },
        "name" : "ParameterizedDataType",
        "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-PostalAddressUse"
        },
        "name" : "PostalAddressUse",
        "description" : "*Deprecation Comment:* This code system was deprecated as of the November 2007 harmonization meeting. The content was folded into AddressUse (2.16.840.1.113883.5.1119), which replaces this code system."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-QueryQuantityUnit"
        },
        "name" : "QueryQuantityUnit",
        "description" : "Values in this domain specify the units of a query quantity limited request.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. This is a holdover. It is not referenced. It is superseded by QueryRequestLimit."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-TelecommunicationAddressUse"
        },
        "name" : "TelecommunicationAddressUse",
        "description" : "*Deprecation Comment:* This code system was deprecated as of the November 2007 harmonization meeting. The content was folded into AddressUse (2.16.840.1.113883.5.1119), which replaces this code system."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-VocabularyDomainQualifier"
        },
        "name" : "VocabularyDomainQualifier",
        "description" : "Vocabulary domain qualifiers are concepts that are used in domain constraints to specify behavior of the new domain.\r\n\r\nCode system retired."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-iso4217-HL7"
        },
        "name" : "ISO 4217 Currency code, HL7 use",
        "description" : "ISO 4217 currency code\r\n\r\nCreated prior to ISO ruling on OIDs for ISO code tables defined in ISO standards. Recommend using 1.0.4217 iso4217 code system instead."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActClassConditionNode"
        },
        "name" : "ActClassConditionNode",
        "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActClassLeftLateralDecubitus"
        },
        "name" : "ActClassLeftLateralDecubitus",
        "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActClassProne"
        },
        "name" : "ActClassProne",
        "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActClassReverseTrendelenburg"
        },
        "name" : "ActClassReverseTrendelenburg",
        "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActClassRightLateralDecubitus"
        },
        "name" : "ActClassRightLateralDecubitus",
        "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActClassSemiFowlers"
        },
        "name" : "ActClassSemiFowlers",
        "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActClassSitting"
        },
        "name" : "ActClassSitting",
        "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActClassStanding"
        },
        "name" : "ActClassStanding",
        "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActClassSubjectBodyPosition"
        },
        "name" : "ActClassSubjectBodyPosition",
        "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActClassSupine"
        },
        "name" : "ActClassSupine",
        "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActClassTrendelenburg"
        },
        "name" : "ActClassTrendelenburg",
        "description" : "**Deprecation Comment:** This value set has been deprecated because its root code was deprecated in an earlier vocabulary release."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActProcedureCodeCCI"
        },
        "name" : "Act Procedure Code CCI",
        "description" : "**** MISSING DESCRIPTION ****"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-ActRelationshipUpdate"
        },
        "name" : "ActRelationshipUpdate",
        "description" : "**Description:** \r\n\r\n**Deprecation Comment:** Was mis-named, and a proper representation has been provided. Replaced by value set ActRelationshipCompliesWith."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-CodeSystem"
        },
        "name" : "CodeSystem",
        "description" : "Code systems used in HL7 standards."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v3-HumanActSite"
        },
        "name" : "HumanActSite",
        "description" : "An anatomical location on a human which can be the focus of an act.\r\n\r\n*OpenIssue:* This value set was approved for **deletion** in November 2008, and was deleted at release \\#762. Subsequently, however, it was found that this deletion caused the legacy software embedded in the RMIM Designer in Visio to fail to show appropriate options for concepts in the subject area of this value set. For that reason, the value set was **re-added in releasse 813 and DEPRECATED from general use** at the same time. This value set should be deleted as soon as it is no longer required to support of the legacy software."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/v2-0719"
        },
        "name" : "InformationSensitivityPolicy",
        "description" : "Value Set of codes that specify the reason for the restricted access.\r\nSensitivity codes are not useful for interoperability outside of a policy domain because sensitivity policies are typically localized and vary drastically across policy domains even for the same information category because of differing organizational business rules, security policies, and jurisdictional requirements. For example, an \"employee\" sensitivity code would make little sense for use outside of a policy domain. \"Taboo\" would rarely be useful outside of a policy domain unless there are jurisdictional requirements requiring that a provider disclose sensitive information to a patient directly. Sensitivity codes may be more appropriate in a legacy system's Master Files in order to notify those who access a patient's orders and observations about the sensitivity policies that apply. Newer systems may have a security engine that uses a sensitivity policy's criteria directly. The specializable Sensitivity Act.code may be useful in some scenarious if used in combination with a sensitivity identifier and/or Act.titleValue Set of codes that specify the reason for the    restricted access.  Note that this resource was created in THO in error due to an oversight in the import processing."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hl7-work-group"
        },
        "name" : "HL7Workgroup",
        "description" : "An HL7 administrative unit that owns artifacts in the FHIR specification."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/conceptdomains"
        },
        "name" : "Concept Domains",
        "description" : "Concept Domains - includes both v2 abd v3 concept domains"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hl7TermMaintInfra"
        },
        "name" : "HL7 Terminology Maintenance Infrastructure Vocabulary",
        "description" : "Codes that may have been strings or other types of data in pre-existing tooling for V3 and V2 terminology maintenance, and moved to codes in this code system for proper handling in the FHIR based UTG maintenance facilities."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/utg-concept-properties"
        },
        "name" : "UTG Specific Concept Properties",
        "description" : "A set of concept properties used by UTG to maintain legacy terminology distribution systems"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/yes-no-unknown-not-applicable"
        },
        "name" : "Yes No Unknown NotApplicable",
        "description" : "This valueset contains the set of codes used to respond to any question that can be answered Yes, No, Unknown, or Not Applicable."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/yes-no-unknown-not-asked"
        },
        "name" : "Yes No Unknown NotAsked",
        "description" : "This value set contains 4 concepts commonly used as answers to items in a questionnaire."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/CMSPlaceOfServiceCodes"
        },
        "name" : "CMS Place of Service Codes (POS)",
        "description" : "This is the all codes value set for the CMS POS code system."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ILRSpeakingSkillScale"
        },
        "name" : "Interagency Language Roundtable Speaking Skill Scale",
        "description" : "This value set defines a set of codes for documenting spoken language proficiency based on the Interagency Language Roundtable scale of abilities to communicate in a language."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/Languages"
        },
        "name" : "Languages",
        "description" : "This value set defines a set of codes for the representation of the names of languages. It uses the list of ISO 639-2 concepts using the ISO 639-1 2-digit code for a concept where possible and the 3-digit terminological code where there is no  2-digit code."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/USPS-State"
        },
        "name" : "USPS Two Letter Alphabetic Codes",
        "description" : "This value set defines two letter USPS alphabetic codes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mif-conceptRelationshipKind"
        },
        "name" : "MIF Concept Relationship Kind",
        "description" : "Codes for use in the ext-mif-relationship-relationshipKind to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.relationshipKind values"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mif-conceptRelationshipReflexivity"
        },
        "name" : "MIF Concept Relationship Reflexivity",
        "description" : "Codes for use in the ext-mif-relationship-reflexivity to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.reflexivity values"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mif-conceptRelationshipSymmetry"
        },
        "name" : "MIF Concept Relationship Symmetry",
        "description" : "Codes for use in the ext-mif-relationship-symmetry to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.symmetry values"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mif-conceptRelationshipTransitivity"
        },
        "name" : "MIF Concept Relationship Transitivity",
        "description" : "Codes for use in the ext-mif-relationship-transitivity to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.transitivity values"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0001"
        },
        "name" : "administrativeSex",
        "description" : "Code system of concepts specifying a patient's sex for administrative purposes.  Used in HL7 Version 2.x messages in the PID segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0002"
        },
        "name" : "maritalStatus",
        "description" : "Code system of concepts specifying a person's marital (civil/legal) status.  Used in HL7 Version 2.x messages in the PID segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0003"
        },
        "name" : "event",
        "description" : "HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages.  Used in HL7 Version 2.x messaging in the MSH segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0004"
        },
        "name" : "patientClass",
        "description" : "Code system of concepts used by systems to categorize patients by site in HL7 Version 2.x interfaces in the PV1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0006"
        },
        "name" : "religion2",
        "description" : "Code system of concepts specifying a person's religion.    Used in HL7 Version 2.x messaging in the PID segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0007"
        },
        "name" : "admissionType",
        "description" : "Code system of concepts specifying the circumstances under which the patient was or will be admitted.  Used in HL7 Version 2.x messaging in the PV1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0008"
        },
        "name" : "acknowledgmentCodes",
        "description" : "HL7-defined code system of concepts specifying acknowledgment codes.  For details of usage, see message processing rules in the published Standard.  Used in HL7 Version 2.x messaging in the MSA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0009"
        },
        "name" : "ambulatoryStatus",
        "description" : "Code system of concepts specifying permanent or transient handicapped conditions of a person.  Used in HL7 Version 2.x messaging in the PV1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0012"
        },
        "name" : "stockLocation",
        "description" : "Code system of concepts specifying a stock location for older Version 2 messaging systems; not used after version 2.2 of the Standard."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0017"
        },
        "name" : "transactionType",
        "description" : "Code system of concepts specifying a type of financial transaction.  Used in HL7 Version 2.x messaging in the FT1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0027"
        },
        "name" : "priority",
        "description" : "HL7-defined code system of concepts specifying the allowed priorities for obtaining the specimen.  Used in HL7 Version 2.x messaging in the OM4 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0033"
        },
        "name" : "route",
        "description" : "HL7-defined code system of concepts that indicate a means of administrating a medication dose.  Used in HL7 Version 2 messaging in the RX1 segment (which was withdrawn after version 2.2). As of HL7 version 2.3, it was replaced by 2.16.840.1.113883.18.80 routeOfAdministration and 2.16.840.1.113883.18.83 administrationMethod.  Used in the RX1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0034"
        },
        "name" : "siteAdministered",
        "description" : "HL7-defined code system of concepts used for medication administration sites.   Used only in HL7 releases 2.1 and 2.2; as of 2.3 the model for this was changed and the field using this code system was removed from the Standard."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0038"
        },
        "name" : "orderStatus",
        "description" : "HL7-defined code system of concepts specifying the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action.  It is assumed that the order status value always reflects the status as it is known to the sending application at the time that a message is sent.  Only the filler can originate these values.  Used in HL7 Version 2.x messaging in the ORC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0048"
        },
        "name" : "whatSubjectFilter",
        "description" : "HL7-defined code system of concepts which specify the kind of information that is required to satisfy a query request.  The values define the type of transaction inquiry.  Used in HL7 Version 2 messaging in the URD segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0052"
        },
        "name" : "diagnosisType",
        "description" : "Code system of concepts specifying a type of diagnosis being sent.  Used in HL7 Version 2.x messaging in the DG1 segment.."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0061"
        },
        "name" : "checkDigitScheme",
        "description" : "HL7-defined code system of concepts specifying the check digit scheme employed.   Used in HL7 Version 2.x messaging in PPN, XCN and XON segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0062"
        },
        "name" : "eventReason",
        "description" : "Code system of concepts which specify the reason for an event.  Used in HL7 Version 2.x messaging in the EVN segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0063"
        },
        "name" : "relationship",
        "description" : "HL7-defined code system of concepts specifying an actual personal relationship that the next of kin/associated party has to a patient.  Used in HL7 Version 2.x messaging in the NK1 and IN1 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0065"
        },
        "name" : "specimenAction",
        "description" : "HL7-defined code system of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order.  The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx).  Used in HL7 Version 2.x messaging in the OBR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0066"
        },
        "name" : "employmentStatus",
        "description" : "HL7-defined code system of concepts which specify an employment status of a person. Used in HL7 Version 2 messaging in the GT1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0069"
        },
        "name" : "hospitalService",
        "description" : "Code system of concepts specifying the treatment or type of surgery the patient is scheduled to receive.   Used in HL7 Version 2.x messaging in the PV1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0070"
        },
        "name" : "specimenSourceCodes",
        "description" : "HL7-defined code system of concepts which specify sources for speciments for clinical testing.  These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in code system 2.16.840.1.133883.18.311 specimenType and code system 2.16.840.1.133883.18.312 specimenCollectionMethod as of version 2.5 and thereafter."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0074"
        },
        "name" : "diagnosticServiceSectionId",
        "description" : "HL7-defined code system of concepts which specify a section of a diagnostic service where the observation may be performed.  Used in HL7 Version 2.x messaging in the OBR and OM4 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0076"
        },
        "name" : "messageType",
        "description" : "HL7-defined code system of concepts which specify message types.  Used in HL7 Version 2.x messaging in the MSH segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0080"
        },
        "name" : "natureOfAbnormalTesting",
        "description" : "HL7-defined code system of concepts specifying the nature of an abnormal test.  Used in HL7 Version 2.x messaging in the OBX segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0083"
        },
        "name" : "outlierType",
        "description" : "HL7-defined code system of concepts specifying the type of outlier (i.e. period of care beyond DRG-standard stay in facility) that has been paid.   Used in HL7 Vesrion 2.x messaghing in the DRG segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0085"
        },
        "name" : "observationResultStatusCodesInterpretation",
        "description" : "HL7-defined code system of concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier.  Used in HL7 Version 2.x messaging in the OBX segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0091"
        },
        "name" : "queryPriority",
        "description" : "HL7-defined code system of concepts which specify a time frame in which a querry response is expected.  Used in HL7 Verson 2.x messaging in the RCP segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0092"
        },
        "name" : "re-admissionIndicator",
        "description" : "Code system of concepts which are used to specify that a patient is being re admitted to a healthcare facilityin from which they were discharged, and indicates the circumstances around such re-admission.  Used in HL7 Version 2.x messagine in the PV1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0098"
        },
        "name" : "typeOfAgreement",
        "description" : "Code system of concepts which specify codes to further identify an insurance plan.  Used in HL7 Version 2.x messaging in the IN1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0100"
        },
        "name" : "invocationEvent",
        "description" : "HL7-defined code system of concepts which specify codes for an event precipitating/triggering a charge activity.  Used in HL7 Version 2.x messaging in the CCD and BLG segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0102"
        },
        "name" : "delayedAcknowledgmentType",
        "description" : "HL7-defined code system of concepts which specify a response type used in deferred processing two phase reply for delayed acknowldgement mode of the original acknowledgement mechanism defined in HL7 Version 2.x messaging and used in the MSH segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0103"
        },
        "name" : "processingId",
        "description" : "HL7-defined code system of concepts which specify whether the message is part of a production, training or debugging system.  Used in HL7 Version 2.x messaging in the PT datatype."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0104"
        },
        "name" : "versionId",
        "description" : "HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x family of published standards.  Used in HL7 Version 2.x messaging in the VID segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0105"
        },
        "name" : "sourceOfComment",
        "description" : "HL7-defined code system of concepts which are used to specify the source of a comment.  Used in HL7 Version 2.x messaging in the NTE segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0106"
        },
        "name" : "queryResponseFormat",
        "description" : "HL7-defined code system of concepts which specify which of several types of formats for data to be returned in response to a query.  Used in HL7 Version 2 messaging in the EQL segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0107"
        },
        "name" : "deferredResponseType",
        "description" : "HL7-defined code system of concepts which specify which type of deferred query resonse is desired, as specified with the query parameters.   Used in HL7 Version 2 messaging in the QRD segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0108"
        },
        "name" : "queryResultsLevel",
        "description" : "HL7-defined code system of concepts which are used to control level of detail in query results.   Used in HL7 Version 2 messaging in the URD segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0109"
        },
        "name" : "reportPriority",
        "description" : "HL7-defined code system of concepts which specify the priority associated with a report or update run using a query.  Used in HL7 Version 2 messaging in the URD segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0116"
        },
        "name" : "bedStatus",
        "description" : "Code system of concepts which specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not.  Used in HL7 Version 2.x messaging in the DLD and PV1 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0119"
        },
        "name" : "orderControlCodes",
        "description" : "HL7-defined code system of concepts which are used to determine the function of the order segment.  Depending on the message, the action specified by one of these control codes may refer to an order or an individual service.  Used in Version 2.x messaging of orders in the ORC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0121"
        },
        "name" : "responseFlag",
        "description" : "HL7-defined code system of concepts allowing the placer (sending) application to determine the amount of information to be returned from the filler.  Used in HL7 Version 2.x messaging in the ORC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0122"
        },
        "name" : "chargeType",
        "description" : "HL7-defined code system of concepts which specify someone or something other than the patient to be billed for a service.  Used in HL7 Version 2.x messaging in the BLG segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0123"
        },
        "name" : "resultStatus",
        "description" : "HL7-defined code system of concepts which specify a status of results for an order.  Used in HL7 Version 2.x messaging in the OBR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0124"
        },
        "name" : "transportationMode",
        "description" : "HL7-defined code system of concepts which specify how (or whether) to transport a patient, when applicable, for an ordered service.  Used in HL7 Version 2.x messaging in the OBR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0126"
        },
        "name" : "quantityLimitedRequest",
        "description" : "HL7-defined code system of concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects.  Used in HL7 Version 2.x messaging in the RCP segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0127"
        },
        "name" : "allergenType",
        "description" : "Code system of concepts speciying a classification of general allergy categories (drug, food, pollen, etc.).  Used in HL7 Version 2.x messaging in the AL1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0128"
        },
        "name" : "allergySeverity",
        "description" : "Code system of concepts which specify the general severity of an allergy.  Used in HL7 Version 2.x messaging in the AL1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0130"
        },
        "name" : "visitUserCodes",
        "description" : "Code system of concepts which specify categories of a patient's visit with respect to an individual institution's needs, and is expected to be different on a site-specific basis.  Used in HL7 Version 2.x messaging in the PV2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0131"
        },
        "name" : "contactRole2",
        "description" : "Code system of concepts which specify a relationship role that the next of kin/associated parties plays with regard to the patient. Also used in referrals, for example, it may be necessary to identify the contact representative at the clinic that sent a referral. Used in HL7 Version 2 messaging in the NK1 and CTD segments after 2.5, when it replace 2.16.840.1.113883.18.57."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0133"
        },
        "name" : "procedurePractitionerIdentifierCodeType",
        "description" : "HL7-defined table of concepts which specify the different types of practitioners associated with this procedure.   This set of codes is known to be incomplete.  Note that as of v2.6, this table and the field(s) it was used in was replaced by table 443 used in the ROL segment.  Used in Version 2.x messaging in the PR1 segment, but was discontinued as of 2.6; usage replaced with code system 2.16.840.1.113883.18.283 providerRole."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0135"
        },
        "name" : "assignmentOfBenefits",
        "description" : "Code system of concepts which indicate whether an insured person agreed to assign the insurance benefits to the healthcare provider.  If so, the insurance will pay the provider directly.  Used in HL7 Version 2.x messaging in the IN1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0137"
        },
        "name" : "mailClaimParty",
        "description" : "Code system of concepts which specify a party to which a claim should be mailed when claims are sent by mail.  Used in HL7 Version 2.x messaging in the IN2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0140"
        },
        "name" : "militaryService",
        "description" : "Code system of concepts which specify the military branch.  This field is defined by CMS or other regulatory agencies.  Used in HL7 Version 2.x messaging in the PD1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0142"
        },
        "name" : "militaryStatus",
        "description" : "Code system of concepts  which specify the military status of the patient.  This field is defined by CMS or other regulatory agencies.  Used in HL7 Version 2.x messaging in the PD1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0144"
        },
        "name" : "eligibilitySource",
        "description" : "Code system of concepts  which specify the source of information about the insured's eligibility for benefits.  Used in HL7 Version 2.x messaging in the IN2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0145"
        },
        "name" : "roomType",
        "description" : "Code system of concepts  which specify the room type.  Used in HL7 Version 2.x messaging in the RMC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0146"
        },
        "name" : "amountType",
        "description" : "Code system of concepts  which specify amount quantity type.  Used in HL7 Version 2.x messaging in the RMC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0147"
        },
        "name" : "policyType",
        "description" : "Code system of concepts which specify the policy type.  Used in HL7 Version 2.x messaging in the PTA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0148"
        },
        "name" : "moneyOrPercentageIndicator",
        "description" : "HL7-defined code system of concepts  which specify whether the amount is currency or a percentage.  Used in HL7 Version 2.x messaging in the MOP segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0149"
        },
        "name" : "dayType",
        "description" : "Code system of concepts  which specify whether the days are denied, pending or approved.  Used in HL7 Version 2.x messaging in the DTN segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0150"
        },
        "name" : "certificationPatientType",
        "description" : "Code system of concepts  which specify the category or type of patient for which this certification is requested.  Used in HL7 Version 2.x messaging in the ICD segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0155"
        },
        "name" : "accept-applicationAcknowledgmentConditions",
        "description" : "HL7-defined code system of concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. Used in HL7 Versions 2 messaging in the MSH segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0156"
        },
        "name" : "whichDate-timeQualifier",
        "description" : "HL7-defined code system of concepts that specify a type of date referred to in query specifications.   Used in HL7 Version 2 messaging in the QRF segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0157"
        },
        "name" : "whichDate-timeStatusQualifier",
        "description" : "HL7-defined code system of concepts that specify the status type of objects selected in a date range.  Used in HL7 Vesion 2 messaging in the QRF segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0158"
        },
        "name" : "date-timeSelectionQualifier",
        "description" : "HL7-defined code system of conceptss that allow the specification of certain types of values within the date/time range. Used in HL7 Vesion 2 messaging in the QRF segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0159"
        },
        "name" : "dietCodeSpecificationType",
        "description" : "HL7-defined code system of concepts  which specify whether the type of diet.    Used in HL7 Version 2.x messaging in the ODS segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0160"
        },
        "name" : "trayType",
        "description" : "HL7-defined code system of concepts  which specify whether the type of diet.    Used in HL7 Version 2.x messaging in the ODT segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0161"
        },
        "name" : "allowSubstitution",
        "description" : "HL7-defined code system of concepts  which specify whether substitutions are allowed and, if so, the type of substitutions allowed.    Used in HL7 Version 2.x messaging in the RXO segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0162"
        },
        "name" : "routeOfAdministration",
        "description" : "Code system of concepts  which specify the route of administration.  Used in HL7 Version 2.x messaging in the RXR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0163"
        },
        "name" : "bodySite",
        "description" : "HL7-defined code system of concepts that specify a body site from which a specimen is obtained.  Used in HL7 Version 2.x messaging in the OBX and CH7 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0164"
        },
        "name" : "administrationDevice",
        "description" : "Code system of concepts  which specify the mechanical device used to aid in the administration of the drug or other treatment.  Common examples are IV-sets of different types.  Used in HL7 Version 2.x messaging in the RXR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0165"
        },
        "name" : "administrationMethod",
        "description" : "Code system of concepts  which specify the specific method requested for the administration of the drug or treatment to the patient.  Used in HL7 Version 2.x messaging in the RXR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0166"
        },
        "name" : "rxComponentType",
        "description" : "HL7-defined code system of concepts  which specify the RX component type.  Used in HL7 Version 2.x messaging in the RXC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0167"
        },
        "name" : "substitutionStatus",
        "description" : "HL7-defined code system of concepts  which specify the substitution status.  Used in HL7 Version 2.x messaging in the RXE, RXD, and RXG segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0168"
        },
        "name" : "processingPriority",
        "description" : "HL7-defined code system of concepts  which specify one or more available priorities for performing the observation or test.  Used in HL7 Version 2.x messaging in the OM1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0169"
        },
        "name" : "reportingPriority",
        "description" : "HL7-defined code system of concepts  which specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority.  Used in HL7 Version 2.x messaging in the OM1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0170"
        },
        "name" : "derivedSpecimen",
        "description" : "HL7-defined code system of concepts  which specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture).  The process also produces new \"specimens\" (e.g., pure culture of staphylococcus, and E. coli), and these are studied by a second order process (bacterial sensitivities). The parents (e.g., blood culture) and children (e.g., penicillin MIC) are identified in such cases.  Used in HL7 Version 2.x messaging in the OM4 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0173"
        },
        "name" : "coordinationOfBenefits",
        "description" : "Code system of concepts specifying whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient.  Used in HL7 Version 2.x messaging in the IN1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0174"
        },
        "name" : "natureOfServiceTestObservation",
        "description" : "Code system of concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files.  Used in HL7 Version 2.x messaging in the OM1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0175"
        },
        "name" : "masterFileIdentifierCodes",
        "description" : "HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Master Files.  Used in HL7 Version 2.x messaging in the MFI segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0177"
        },
        "name" : "confidentialityCodes",
        "description" : "Code system of concepts specifying the degree to which special confidentiality protection should be applied to the observation.  Used in HL7 Version 2.x messaging in the OM1 and ORC segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0178"
        },
        "name" : "file-levelEvent",
        "description" : "HL7-defined code system of concepts specifying file-level events for master files.  Used in HL7 Version 2 messaging in the MFI segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0179"
        },
        "name" : "responseLevel",
        "description" : "HL7-defined code system of concepts specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message.  Specifies additional detail (beyond MSH-15 - Accept Acknowledgment Type and MSH-16 - Application Acknowledgment Type) for application-level acknowledgment paradigms for Master Files transactions.  Used in HL7 Version 2.x messaging in the MFI segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0180"
        },
        "name" : "masterfileActionCode",
        "description" : "HL7-defined code system of concepts specifying an action for a master file record. Used in HL7 Version 2.x messaging in the MFE segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0181"
        },
        "name" : "mfnRecord-levelErrorReturn",
        "description" : "Code system of concepts specifying the status of the requested update.  Site-defined table, specific to each master file being updated via this transaction.  Used in HL7 Version 2.x messaging in the MFA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0183"
        },
        "name" : "active-inactive",
        "description" : "HL7-defined code system of concepts specifying whether a person is currently a valid staff member.  Used in HL7 Version 2.x messaging in the STF segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0185"
        },
        "name" : "preferredMethodOfContact",
        "description" : "HL7-defined code system of concepts specifying which of a group of multiple phone numbers is the preferred method of contact for this person.  Used in HL7 Version 2.x messaging in the STF, PRD, and CTD segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0187"
        },
        "name" : "providerBilling",
        "description" : "HL7-defined code system of concepts specifying how provider services are billed.  Used in HL7 Version 2.x messaging in the PRA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0189"
        },
        "name" : "ethnicGroup",
        "description" : "Code system of concepts further defining a patient's ancestry.  In the US, a current use is to use these codes to report ethnicity in line with US federal standards for Hispanic origin.  Used for HL7 Version 2 messaging in the PID segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0190"
        },
        "name" : "addressType",
        "description" : "HL7-defined code system of concepts specifying types or kinds of addresses.  Used in HL7 Version 2.x messaging in the XAD segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0191"
        },
        "name" : "typeOfReferencedData",
        "description" : "HL7-defined code system of concepts declaring the general type of media data that is encoded.  Used in v2.5.1 interfaces and earlier, and replaced with the full set of IANA media types as a standard coding system for this after HL7 version 2.6 (see value set 2.16.840.1.113883.21.425 hl7VS-mimeTypes for HL7 table 0834 built on MIME types).  More information may be found at http://www.iana.org/assignments/media-types/media-types.xhtml"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0193"
        },
        "name" : "amountClass",
        "description" : "Code system of concepts specifying the amount quantity class.  Used in HL7 Version 2.x messaging in the PTA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0200"
        },
        "name" : "nameType2",
        "description" : "HL7-defined code system of concepts for types of names for persons.  Used in HL7 Version 2.x messaging in the XPN, PPN, XCN, PID and MRG segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0201"
        },
        "name" : "telecommunicationUse",
        "description" : "HL7-defined code system of concepts for specifying a specific use of a telecommunication number.  Best practice is to use this concept whenever a telecommunication number or access string is specified.  Used in HL7 Version 2.x messaging in the XTN segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0202"
        },
        "name" : "telecommunicationEquipmentType",
        "description" : "HL7-defined code system of concepts  for specifying a type of telecommunication equipment.  Best practice is to use this concept whenever a telecommunication number or access string for particular equipment is specified.  Used in HL7 Version 2.x messaging in the XTN segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0203"
        },
        "name" : "identifierType",
        "description" : "HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messaging data types CX, PLN, PPN, XCN and XON."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0204"
        },
        "name" : "organizationalNameType",
        "description" : "Code system of concepts used to specify the type of name for an organization i.e., legal name, display name.   Used in HL7 Version 2.x messaging in the XON and PD1 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0205"
        },
        "name" : "priceType",
        "description" : "HL7-defined code system of concepts used to identify the intent for the dollar amount on a pricing transaction.  Used in HL7 Version 2.x messaging in the CP datatype."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0206"
        },
        "name" : "segmentAction",
        "description" : "HL7-defined code system of concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating in \"action code mode\" (a kind of update mode in the Standard).  Used in HL7 Version 2.x messaging in the RXA, RXV, LCH, IAM, ARV, IN1 and OH1 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0207"
        },
        "name" : "processingMode",
        "description" : "HL7-defined code system of concepts that indicate an archival process or an initial load process.  Used in HL7 Version 2.x messaging in the PT datatype."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0208"
        },
        "name" : "queryResponseStatus",
        "description" : "HL7-defined code system of concepts defining precise response status concepts in support of HL7 Version 2 query messaging.  It is commonly used to indicate no data is found that matches the query parameters, but no error.   Used in HL7 Version 2.x messaging in the QAK segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0209"
        },
        "name" : "relationalOperator",
        "description" : "HL7-defined code system of concepts used to define the relationship between HL7 segment field names identified in a query construct.  Used in HL7 Version 2.x messaging in the QSC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0210"
        },
        "name" : "relationalConjunction",
        "description" : "HL7-defined code system of concepts used with relationalOperator values to group more than one segment field name.   Used in HL7 Version 2.x messaging in the QSC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0211"
        },
        "name" : "alternateCharacterSets",
        "description" : "HL7-defined code system of concepts used to specify the character set(s) in use.  Includes both single-byte and double-byte characters sets, and used in Version 2.x messaging in the MSH segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0213"
        },
        "name" : "purgeStatus",
        "description" : "Code system of concepts used to define the state of a visit relative to its place in a purge workflow.  Used in HL7 Version 2.x messaging in the PV2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0214"
        },
        "name" : "specialProgram",
        "description" : "Code system of concepts used to record a health insurance program required for healthcare visit reimbursement.  Used in HL7 Version 2.x messaging in the PV2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0215"
        },
        "name" : "publicity",
        "description" : "Code system of concepts specifying a level of publicity of information about a patient for a specific visit.  Used in HL7 Version 2.x messaging in the PV2 and PD1 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0216"
        },
        "name" : "patientStatus",
        "description" : "Code system of concepts used to define the state of a care episode for a patient.  Used in HL7 Version 2.x messaging in the PV2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0217"
        },
        "name" : "visitPriority",
        "description" : "Code system of concepts used to define a relative level of urgency applied to a patient visit.  Used in HL7 Version 2.x messaging in the PV2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0220"
        },
        "name" : "livingArrangement",
        "description" : "Code system of concepts characterizing the situation that patient-associated parties live in at their residential address.  Used in HL7 Version 2.x messaging in the NK1 and PD1 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0223"
        },
        "name" : "livingDependency2",
        "description" : "HL7-defined code system of concepts that identify specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient’s healthcare needs.  This information can be used for discharge planning.  Examples might include Spouse Dependent, Medical Supervision Required, Small Children Dependent.  Used in Version 2.s messaging in the NK1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0224"
        },
        "name" : "transportArranged",
        "description" : "HL7-defined code system of concepts defining whether patient transportation preparations are in place.  Used in HL7 Version 2.x messaging in the OBR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0225"
        },
        "name" : "escortRequired",
        "description" : "HL7-defined code system of concepts defining whether patient transportation preparations are in place.  Used in HL7 Version 2.x messaging in the OBR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0228"
        },
        "name" : "diagnosisClassification",
        "description" : "Code system of concepts used to classify whether a patient visit can be related to a diagnosis.  Used in HL7 Version 2.x messaging in the DG1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0230"
        },
        "name" : "procedureFunctionalType",
        "description" : "Code system of concepts used to classify a procedure.  Used in HL7 Version 2.x messaging in the PR1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0231"
        },
        "name" : "studentStatus",
        "description" : "Code system of concepts used to designate whether a guarantor is a full or part time student.  Used in HL7 Version 2.x messaging in the GT1, NK1 and PD1 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0232"
        },
        "name" : "insuranceCompanyContactReason",
        "description" : "Code system of concepts used to describe why an insurance company has been contacted.  Used in HL7 Version 2.x messaging in the IN2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0234"
        },
        "name" : "reportTiming",
        "description" : "HL7-defined code system of concepts used to identify the time span of a report or the reason for a report sent to a regulatory agency.  Used in HL7 Version 2.x messaging in the PES segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0235"
        },
        "name" : "reportSource",
        "description" : "HL7-defined code system of concepts used to identify where a report sender learned about an event.  Used in HL7 Version 2.x messaging in the PES segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0236"
        },
        "name" : "eventReportedTo",
        "description" : "HL7-defined code system of concepts used to identify the type of entity to which the even has been reported.  Used in HL7 Version 2.x messaging in the PES segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0237"
        },
        "name" : "eventQualification",
        "description" : "HL7-defined code system of concepts used to qualify an event related to a product experience.  Used in HL7 Version 2.x messaging in the PEO segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0238"
        },
        "name" : "eventSeriousness",
        "description" : "HL7-defined code system of concepts used by a sender to designate an event as serious or significant.  Used in HL7 Version 2.x messaging in the PEO segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0239"
        },
        "name" : "eventExpected",
        "description" : "HL7-defined code system of concepts used to communicate whether an event has been judged to be expected or unexpected.  Used in HL7 Version 2.x messaging in the PEO segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0240"
        },
        "name" : "eventConsequence",
        "description" : "HL7-defined code system of concepts used to describe the impact of an event on a patient.  Used in HL7 Version 2.x messaging in the PEO segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0241"
        },
        "name" : "patientOutcome",
        "description" : "HL7-defined code system of concepts used to describe the overall state of a patient as a result of patient care.  Used in HL7 Version 2.x messaging in the PEO segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0242"
        },
        "name" : "primaryObserverQualification",
        "description" : "HL7-defined code system of concepts used to provide a general description of the kind of health care professional who provided the primary observation.  Used in HL7 Version 2.x messaging in the PEO and PCR segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0243"
        },
        "name" : "identityMayBeDivulged",
        "description" : "HL7-defined code system of concepts used to define whether the primary observer has given permission for their identification information to be provided to a product manufacturer.  Used in HL7 Version 2.x messaging in the PEO segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0247"
        },
        "name" : "statusOfEvaluation",
        "description" : "HL7-defined code system of concepts that describes the status of product evaluation.  Used in HL7 Version 2.x messaging in the PCR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0248"
        },
        "name" : "productSource",
        "description" : "HL7-defined code system of concepts used to describe the evaluation state of a product identified in an incident.  Used in HL7 Version 2.x messaging in the PCR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0250"
        },
        "name" : "relatednessAssessment",
        "description" : "HL7-defined code system of concepts used to provide an estimate of whether an issue with a  product was the cause of an event.  Used in HL7 Version 2.x messaging in the PCR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0251"
        },
        "name" : "actionTakenInResponseToTheEvent",
        "description" : "HL7-defined code system of concepts used to define the action taken as a result of an event related to a product issue.  Used in HL7 Version 2.x messaging in the PCR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0252"
        },
        "name" : "causalityObservations",
        "description" : "HL7-defined code system of concepts used to record event observations regarding what may have caused a product related event.  Used in HL7 Version 2.x messaging in the PCR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0253"
        },
        "name" : "indirectExposureMechanism",
        "description" : "HL7-defined code system of concepts used to identify the mechanism of product transmission when the product has not been directly applied to the patient.  Used in HL7 Version 2.x messaging in the PCR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0254"
        },
        "name" : "kindOfQuantity",
        "description" : "HL7 published code system of concepts that describe categories of an underlying kind of property represented by an observation.  These are intended to distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so forth.  These are discussed more fully in the LOINC Users’ Manual.   These defined categories are derived from the approach described in 1995 edition of the IUPAC Silver Book.  These distinctions are used in IUPAC and LOINC standard codes.  Needs review by OO and HTA to determined if this is a value set built on LOINC part codes or some other external vocabulary."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0255"
        },
        "name" : "durationCategories",
        "description" : "Code system of concepts used to classify an observation definition as intended to measure a patient's state at a point in time.  Used in HL7 Version 2.x messaging in the OM1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0256"
        },
        "name" : "timeDelayPostChallenge",
        "description" : "HL7-defined code system of concepts used to classify an observation definition as being a component of a challenge test.  Used in HL7 Version 2.x messaging in the OM1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0257"
        },
        "name" : "natureOfChallenge",
        "description" : "HL7-defined code system of concepts used to further describe an observation definition that is characterized as a challenge observation.  Used in HL7 Version 2.x messaging in the OM1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0258"
        },
        "name" : "relationshipModifier",
        "description" : "HL7-defined code system of concepts used in an observation definition to describe the subject of an observation in relation to a patient.  Used in HL7 Version 2.x messaging in the OM1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0260"
        },
        "name" : "patientLocationType",
        "description" : "Code system of concepts used to identify the kind of location described in the location definition.  Used in HL7 Version 2.x messaging in the LOC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0261"
        },
        "name" : "locationEquipment",
        "description" : "Code system of concepts used to identify the equipment available in a location definition identified as a room or bed.  Used in HL7 Version 2.x messaging in the LOC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0262"
        },
        "name" : "privacyLevel",
        "description" : "Code system of concepts used to identify the level of privacy a patient will be afforded when assigned to this location definition.  Used in HL7 Version 2.x messaging in the LCH segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0263"
        },
        "name" : "levelOfCare",
        "description" : "Code system of concepts used to identify the level of care a patient may be afforded when assigned to this location definition.  Used in HL7 Version 2.x messaging in the LCH segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0265"
        },
        "name" : "specialtyType",
        "description" : "Code system of concepts used to identify the specialty of the care professional who is supported when using this location definition.  Used in HL7 Version 2.x messaging in the LDP segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0267"
        },
        "name" : "daysOfTheWeek",
        "description" : "HL7-defined code system of concepts used to identify the day(s) of the week when a location may be scheduled for appointments.  Used in HL7 Version 2.x messaging in the UVC and LDP segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0268"
        },
        "name" : "override",
        "description" : "Code system of concepts used to define whether a Charge Description Master description may be overridden or if it must be overridden.  Used in HL7 Version 2.x messaging in the CDM and PRC segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0269"
        },
        "name" : "chargeOnIndicator",
        "description" : "Code system of concepts used to define the event upon which a charge should be generated.  Used in HL7 Version 2.x messaging in the PRC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0270"
        },
        "name" : "documentType",
        "description" : "Code system of concepts used to identify the kind of patient document.  Used in HL7 Version 2.x messaging in the TXA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0271"
        },
        "name" : "documentCompletionStatus",
        "description" : "HL7-defined code system of concepts used to record the state of a document in a workflow.  Used in HL7 Version 2.x messaging in the TXA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0272"
        },
        "name" : "documentConfidentialityStatus2",
        "description" : "HL7-defined code system of concetps used to identify the degree to which special confidentiality protection should be applied to this information.  Used in HL7 Version 2.x messaging in the TXA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0273"
        },
        "name" : "documentAvailabilityStatus",
        "description" : "HL7-defined code system of concepts used to define whether a patient document is appropriate or available for use in patient care.  Used in HL7 Version 2.x messaging in the TXA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0275"
        },
        "name" : "documentStorageStatus",
        "description" : "HL7-defined code system of concepts used to describe the availability of a document in relation to the type of storage.  Used in HL7 Version 2.x messaging in the TXA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0276"
        },
        "name" : "appointmentReason",
        "description" : "Code system of concepts used to describe the kind of appointment or the reason why an appointment has been scheduled.  Used in HL7 Version 2.x messaging in the ARQ segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0277"
        },
        "name" : "appointmentType",
        "description" : "Code system of concepts used in an appointment request to describe the kind of appointment.  Used in HL7 Version 2.x messaging in the ARQ segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0278"
        },
        "name" : "fillerStatus",
        "description" : "Code system of concepts used to describe an appointment status from the perspective of the entity assigned to fulfill the appointment.  Used in HL7 Version 2.x messaging in the SCH segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0279"
        },
        "name" : "allowSubstitution",
        "description" : "Code system of concepts used to indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment.  Used in HL7 Version 2.x messaging in the AIS and AIG segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0280"
        },
        "name" : "referralPriority",
        "description" : "Code system of concepts used to designate the urgency of a  referral.  Used in HL7 Version 2.x messaging in the RF1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0281"
        },
        "name" : "referralType",
        "description" : "Code system of concepts used to identify the general category of healthcare professional desired to satisfy a referral.  Used in HL7 Version 2.x messaging in the RF1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0282"
        },
        "name" : "referralDisposition",
        "description" : "Code system of concepts used to identify the expected response from the healthcare professional receiving a referral.  Used in HL7 Version 2.x messaging in the RF1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0283"
        },
        "name" : "referralStatus",
        "description" : "Code system of concepts used to define the state of a  referral.  Used in HL7 Version 2.x messaging in the RF1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0284"
        },
        "name" : "referralCategory",
        "description" : "Code system of concepts used to describe the patient care setting where a referral should take place.  Used in HL7 Version 2.x messaging in the RF1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0286"
        },
        "name" : "providerRole",
        "description" : "Code system of concepts used to define the relationship between a referral recipient and a patient or between a referral initiator and a patient.  Used in HL7 Version 2.x messaging in the PRD segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0287"
        },
        "name" : "problem-goalAction",
        "description" : "HL7-defined code system of concepts used in Patient Care for the intent of a problem or goal.  Used in HL7 Version 2.x messaging in the GOL, ROL, PRB and PTH segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0290"
        },
        "name" : "mimeBase64EncodingCharacters",
        "description" : "HL7-defined code system of concepts specifying the characters used in the MIME Base 64 encoding mechanism.  These are for reference only, as they are not carried as explicit code values in any HL7 coded field.  This table was published only in releases 2.3, 2.3.1, and 2.4 of the Standard, and was removed thereafter."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0291"
        },
        "name" : "subtypeOfReferencedData",
        "description" : "Code system of a subset of the media subtypes of binary data that are encoded in an ascii structure or stream.  Used in Version 2 messaging  ED and RP datatypes, but only in standard 2.5.1 and earlier; after that, it was recommended that the IANA media types be used instead of this short list of HL7-defined codes.   More information on the standard media types and subtypes may be found at http://www.iana.org/assignments/media-types/media-types.xhtml."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0294"
        },
        "name" : "timeSelectionCriteriaParameterClass",
        "description" : "Code system of concepts used to describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling.  Used in HL7 Version 2.x messaging in the SCV and APR segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0298"
        },
        "name" : "cpRangeType",
        "description" : "HL7-defined code system of concepts used to define a type of range used in composite pricing in financial transacxtions.  Used in HL7 Version 2 messaging in the CP datatype."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0299"
        },
        "name" : "encoding",
        "description" : "HL7-defined code system of concept identifying the type of encoding used to represent successive octets of binary data as displayable ASCII characters.  These are defined by IETF; more information may be found at https://www.ietf.org/rfc/rfc1521.txt.  Used in HL7 Version 2.x messaging in the ED datatypes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0301"
        },
        "name" : "universalIdType",
        "description" : "HL7-defined code system of types of UID (Universal Identifiers).   Used in HL7 Version 2.x messaging HD and EI datatypes."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0305"
        },
        "name" : "personLocationType",
        "description" : "Code system of concepts specifying the categorization of the person's location.  Used in HL7 Version 2.x messaging datatypes that contain location identifiers such as Person Location (PL), Location with address variation (LA) and Name with date and location (NDL)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0309"
        },
        "name" : "coverageType",
        "description" : "Code system of concepts specifying the type of insurance coverage or what types of services are covered for the purposes of a billing system.  For example, a physician billing system will only want to receive insurance information for plans that cover physician/professional charges.  Used in HL7 Version 2.x messaging in the Insurance (IN1) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0311"
        },
        "name" : "jobStatus",
        "description" : "HL7-defined code system of concepts specifying the next of kin/associated party's job status.  Used in HL7 Version 2.x messaging in the Next of Kin/Associated Parties (NK1) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0315"
        },
        "name" : "livingWillCodes",
        "description" : "Code system of concepts specifying whether or not the patient has a living will and, if so, whether a copy fo the living will is on file at the healthcare facility.  If the patient does not have a living will, the value of this field indicates whether the patient was provided information on living wills.  Used in HL7 Version 2.x messaging in the Patient Visit - Additional Information ( PV2) and Patient Additional Demographic (PD1) segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0316"
        },
        "name" : "organDonorCodes",
        "description" : "Code system of concepts specifying whether the patient wants to donate his/her organs and whether an organ donor card or similar documentation is on file with the healthcare organization.   Used in HL7 Version 2.x messaging in the Patient Visit - Additional Information ( PV2) and Patient Additional Demographic (PD1) segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0317"
        },
        "name" : "annotations",
        "description" : "Code system of concepts specifying the coded entry associated with a given point in time during the waveform recording.  Used in HL7 Version 2.x messaging in the Observation Result (OBX) Another Observation (ANO) segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0321"
        },
        "name" : "dispenseMethod",
        "description" : "HL7-definde code system of concepts specifying the method by which treatment is dispensed.  Used in HL7 Version 2.x messaging in the Pharmacy/Treatment Encoded order (RXE) and Pharmacy/Treatment dispense (RXD) segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0322"
        },
        "name" : "completionStatus",
        "description" : "HL7-defined code system of concepts specifying the status of the treatment administration event segment.  Used in HL7 Version 2.x messaging in the Pharmacy Order Administration (RXA) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0323"
        },
        "name" : "actionCodes",
        "description" : "HL7-defined code system ofstatus codes of record operation. Used in Version 2 messaging, these are used in the RXA segment in the vaccine messages, where a method of correcting vaccination information transmitted with incorrect patient identifying information is needed.  As of version 2.6, this table was replaced with table 0206, whose values are defined by code system xxxx."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0324"
        },
        "name" : "locationCharacteristic",
        "description" : "Code system of concepts specifying an identifier code to show which characteristic is being communicated with the segment.  Used in HL7 Version 2.x messaging in the Location Characteristic (LCH) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0325"
        },
        "name" : "locationRelationship",
        "description" : "Code system of concepts specifying an identifier code to show which relationship is being communicated with the segment.  Used in HL7 Version 2.x messaging in the Location Relationship (LRL) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0326"
        },
        "name" : "visitIndicator",
        "description" : "Code system of concepts specifying the level on which data are being sent.  It is the indicator used to send data at two levels, visit and account.  HL7 recommends sending an \"A\" or no value when the data in the message are at the account level or \"V\" to indicate that the data sent in the message are at the visit level.  Used in HL7 Version 2.x messaging in the Patient Visit (PV1) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0329"
        },
        "name" : "quantityMethod",
        "description" : "HL7-defined code system of concepts used to specify the method by which the quantity distributed is measured.   Used in HL7 Version 2.x messaging in the Product Summary Header (PSH) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0330"
        },
        "name" : "marketingBasis",
        "description" : "HL7-defined code system of concepts used to specify the basis for marketing approval.   Used in HL7 Version 2.x messaging in the Product Detail Country (PDC) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0331"
        },
        "name" : "facilityType",
        "description" : "HL7-defined code system of concepts used to specify the type of facility.   Used in HL7 Version 2.x messaging in the Facility (FAC) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0332"
        },
        "name" : "sourceType",
        "description" : "HL7-defined code system of concepts used to specify the type of facility.   Used in HL7 Version 2.x messaging in the Facility (FAC) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0334"
        },
        "name" : "disabilityInformationRelationship",
        "description" : "Code system of concepts used to specify to which person the disability information relates in the message.  For example, if the value is PT, the disability information relates to the patient.  Used in HL7 Version 2.x messaging in the Disability (DB1) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0335"
        },
        "name" : "repeatPattern",
        "description" : "Code system of concepts used to specify the interval between repeated services.  Used in HL7 Version 2.x messaging in the RI datatype and RPT segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0336"
        },
        "name" : "referralReason",
        "description" : "Code system of concepts used to specify the reason for which the referral will take place.  Used in HL7 Version 2.x messaging in the Referral Information (RF1) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0337"
        },
        "name" : "certificationStatus",
        "description" : "HL7-defined code system of concepts used to specify the status of the practitioner's speciality certification.  Used in HL7 Version 2.x messaging in the Specialty Description (SPD) value and Practitioner Detail (PRA) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0339"
        },
        "name" : "advancedBeneficiaryNotice",
        "description" : "Code system of concepts specifying the status of the patient's or the patient's representative's consent for responsibility to pay for potentially uninsured services. This element was introduced to satisfy CMS Medical Necessity requirements for outpatient services in the United States. Includes concepts such as (a) whether the associated diagnosis codes for the service are subject to medical necessity procedures, (b) whether, for this type of service, the patient has been informed that they may be responsible for payment for the service, and (c) whether the patient agrees to be billed for this service.  Used in HL7 Version 2.x messaging in the ORC and FT1 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0344"
        },
        "name" : "patientsRelationshipToInsured",
        "description" : "Code system of concepts used to specify the relationship of the patient to the insured, as defined by CMS or other regulatory agencies.  Used in HL7 Version 2.x messaging in the Insurance Additional Information (IN2) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0353"
        },
        "name" : "cweStatuses",
        "description" : "HL7-defined code system of comcepts that represent an exception identifier code; that is, a code that is not defined in the value set (either model or site-extended).  These are occationsally referred to a 'flavors of null' although this set of concepts is specific to the CWE datatype used in HL7 Version 2.x messaging, and the codes may be used in the 'identifier' component of the 'triplets' in that datatype."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0354"
        },
        "name" : "messageStructure",
        "description" : "HL7-defined code system of abstract message structure codes. Each code identifies a specific message structure abstract syntax as published in the HL7 Version 2 standard.  Used in HL7 Version 2.x messaging in the MSH segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0355"
        },
        "name" : "primaryKeyValueType",
        "description" : "HL7-defined code system of concepts used to specify the type for the master file record identifier.  Used in HL7 Version 2.x messaging in the Master File Entry (MFE) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0356"
        },
        "name" : "alternateCharacterSetHandlingScheme",
        "description" : "HL7-defined code system of concept that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed.  Used in HL7 Version 2.x messaging in the MSH segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0357"
        },
        "name" : "messageErrorCondition",
        "description" : "HL7-defined code system of concepts specifying the HL7 (communications) error code.  Used in the ERR segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0359"
        },
        "name" : "diagnosisPriority",
        "description" : "Code system of concepts that identify the significance or priority of the diagnosis code.  Note that the codes are numeric, and the number of the code represents the ordinal priority of the associated diagnosis.  Used in the DG1 segment in HL7 Version 2.x messaging. The predefined codes are the most common, and just a starter set, as the codes are an unbounded list; additional ranked procedures may be signified by incrementing the code value as needed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0360"
        },
        "name" : "degreeLicenseCertificate",
        "description" : "Code system of concepts specifying an educational degree (e.g., MD).  Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging.  Used in HL7 Version 2.x messaging in the CNN segment; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0364"
        },
        "name" : "commentType",
        "description" : "Code system of concepts that identify the type of comment text being sent in the specific comment record.  Used in the Notes and Comments (NTE) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0365"
        },
        "name" : "equipmentState",
        "description" : "HL7-defined code system of concepts that identify the status the equipment was in at the time the transaction was initiated.  Used in HL7 Version 2.x messaging in the EQU segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0366"
        },
        "name" : "local-remoteControlState",
        "description" : "HL7-defined code system of concepts that identify the current state of control associated with the equipment.   Equipment can either work autonomously ('Local' control state) or it can be controlled by another system, e.g., LAS computer ('Remote' control state).  Used in the Equipment Detail (EQU) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0367"
        },
        "name" : "alertLevel",
        "description" : "HL7-defined code system of concepts that identify the highest level of the alert state (e.g.,highest alert severity) that is associated with the indicated equipment (e.g. processing event, inventory event, QC event).  Used in the Equipment Detail (EQU) and Notification Detail (NDS) segments in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0368"
        },
        "name" : "remoteControlCommand",
        "description" : "Code system of concepts that identify the comment the component is to initiate.  Used in the Equipment Command (ECD) and Interaction Status Detail (ISD) segments in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0369"
        },
        "name" : "specimenRole",
        "description" : "HL7-defined code system of concepts that identify the role of a sample.  Used in HL7 Version 2.x messaging in the Specimen (SPM) and Observation Request (OBR) segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0370"
        },
        "name" : "containerStatus",
        "description" : "HL7-defined  code system of concepts that identify the status of the unique container in which the specimen resides at the time the transaction was initiated.  Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0371"
        },
        "name" : "additivePreservative",
        "description" : "HL7-defined code system of concepts specifying any additive introduced to the specimen before or at the time of collection.  These additives may be introduced in order to preserve, maintain or enhance the particular nature or component of the specimen.  Used in HL7 Version 2.x messaging in the SPM and SAC segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0372"
        },
        "name" : "specimenComponent",
        "description" : "Code system of concepts that identify the specimen component, e.g., supernatant, sediment, etc.  Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0373"
        },
        "name" : "treatment",
        "description" : "Code system of concepts that identify the specimen treatment performed during lab processing.  Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0374"
        },
        "name" : "systemInducedContaminants",
        "description" : "Code system of concepts that identify the specimen contaminant identifier associated with the specimen in the container.  Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0375"
        },
        "name" : "artificialBlood",
        "description" : "Code system of concepts that identify the artificial blood identifier associated with the specimen.  Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0376"
        },
        "name" : "specialHandling",
        "description" : "Code system of concepts describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing.  Used in HL7 Version 2.x messaging in the SPM, SAC, PAC and OM4 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0377"
        },
        "name" : "environmentalFactors",
        "description" : "Code system of concepts that identify the other environmental factors associated with the specimen in a specific container, e.g., atmospheric exposure.  Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0383"
        },
        "name" : "substanceStatus",
        "description" : "HL7-defined code system of concepts identifying the status of the inventoried item.  The status indicates the current status of the substance.  Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0384"
        },
        "name" : "substanceType",
        "description" : "HL7-defined  code system of concepts identifying the type of substance.  Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0387"
        },
        "name" : "commandResponse",
        "description" : "Code system of concepts identifying the response of the previously issued command.  Used in HL7 Version 2.x messaging in the Equipment Command Response (ECR) and Interaction Status Detail (ISD) segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0388"
        },
        "name" : "processingType",
        "description" : "HL7-defined code system of concepts identifying the processing type that applies to the test code.  If this attribute is omitted, then regular production is the default.  Used in HL7 Version 2.x messaging in the Test Code Configuration (TCC) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0389"
        },
        "name" : "analyteRepeatStatus",
        "description" : "HL7-defined code system of concepts identifying the repeat status for the analyte/result (e.g. original, rerun, repeat, reflex).  The following are assumptions regarding the table values:\r\nRepeated without dilution — performed usually to confirm correctness of results (e.g., in case of results flagged as \"Panic\" or mechanical failures).\r\nRepeated with dilution — performed usually in the case the original result exceeded the measurement range (technical limits).\r\nReflex test — this test is performed as the consequence of rules triggered based on other test result(s).  Used in HL7 Version 2.x messaging in the Test Code Detail (TCD) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0391"
        },
        "name" : "segmentGroup",
        "description" : "HL7-defined code system of concepts specifying the optional segment groups which are to be included in the response.  This is a repeating field, to accommodate inclusion of multiple segment groups. The default for this field, not present, means that all relevant groups are included.  Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0392"
        },
        "name" : "matchReason",
        "description" : "Code system of concepts identifying what search components (e.g., name, birthdate, social security number) of the record returned matched the original query where the responding system does not assign numeric match weights or confidence levels.  It provides a method for passing a descriptive indication of the reason a particular record was found.  Used in HL7 Version 2.x messaging in the Query Response Instance (QRI) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0393"
        },
        "name" : "matchAlgorithms",
        "description" : "Code system of concepts identifying the name or identity of the specific search algorithm to which the RCP-5 Search Confidence Threshold and the QRI-1 Candidate Confidence refer.  Used in HL7 Version 2.x messaging in the Query Response Instance (QRI) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0394"
        },
        "name" : "responseModality",
        "description" : "HL7-defined code system of concepts identifying the timing and grouping of the response message(s).  Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0395"
        },
        "name" : "modifyIndicator",
        "description" : "HL7-defined code system of concepts identifying whether the subscription is new or is being modified.  Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0396"
        },
        "name" : "codingSystem",
        "description" : "HL7-defined code system of concepts specifying the coding system.  This table is maintained outside of the published Version 2 standards, and may be found at http://www.hl7.org/Special/committees/vocab/table_0396/index.cfm.  Used in HL7 Version 2.x messaging in the CWE segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0397"
        },
        "name" : "sequencing",
        "description" : "HL7-defined code system of concepts identifying how the field or parameter will be sorted and, if sorted, whether the sort will be case sensitive (the default) or not.  Used in HL7 Version 2.x messaging in the Sort Order (SRT) value."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0398"
        },
        "name" : "continuationStyle",
        "description" : "HL7-defined code system of concepts identifying whether it is a fragmented message or part of an interactive continuation message.  Used in HL7 Version 2.x messaging in the Continuation Pointer (DSC) segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0401"
        },
        "name" : "governmentReimbursementProgram",
        "description" : "Code system of concepts which specify codes that indicate an agency that the practitioner is authorized to bill for medical services.  Existing codes only for use in the United States. Used in HL7 Version 2.x messaging in the PRA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0402"
        },
        "name" : "schoolType",
        "description" : "Code system of concepts which specify a categorization of an academic institution that grants a degree to a Staff Member.  Used in HL7 Version 2.x messaging in the EDU segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0403"
        },
        "name" : "languageAbility",
        "description" : "Code system of concepts which specify codes that indicate the ability that a Staff Member possesses with respect to the language. Used in HL7 Version 2.x messaging in the LAN segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0404"
        },
        "name" : "languageProficiency",
        "description" : "HL7-defined code system of concepts which specify a level of knowledge that a Staff Member possesses with respect to their language ability.  Used in HL7 Version 2 messaging in the LAN segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0406"
        },
        "name" : "organizationUnitType",
        "description" : "HL7-defined code system of concepts which identify an environment in which a provider acts in a specified role.  The provider environment is not the specialty for the provider.  This is intended to allow communication of this information when the provider information may not have been communicated previously in a master file, and is used to support international requirements.  Used in HL7 Version 2 messaging in the PRT and ROL segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0409"
        },
        "name" : "applicationChangeType",
        "description" : "HL7-defined code system of concepts which specify the type of change being requested (if NMR query) or announced (if NMD unsolicited update) during application status changes. It is assumed that a \"new\" version starts up with no loss or duplication of data as the \"old\" one is shutting down (if possible).  Used in HL7 Version 2 Messaging in the NSC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0415"
        },
        "name" : "drgTransferType",
        "description" : "HL7-defined code system of concepts which specify a type of hospital receiving a transfer patient, which affects how a facility is reimbursed under diagnosis related group (DRG’s), for example, exempt or non-exempt.  Used in HL7 Version 2 messaging in the DRG segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0416"
        },
        "name" : "procedureDrgType",
        "description" : "HL7-defined code system of concepts which specify a procedure’s priority ranking relative to its DRG.  Used in HL7 Version 2 messaging in the PR1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0417"
        },
        "name" : "tissueType",
        "description" : "HL7-defined code system of concepts which specify a type of tissue removed from a patient during a procedure. Used in HL7 Version 2 messaging in the PR1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0418"
        },
        "name" : "procedurePriority",
        "description" : "HL7-defined code system of concepts which specify the significance or priority of a procedure code.  Used in HL7 Version 2 messaging in the PR1 segment.  Note that this is a post-coordinated code system, where additional ordinal priorities are created by incrementing the numericinteger code value as needed.  Only the first 2 ordinal values are predefined in the code system."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0421"
        },
        "name" : "severityOfIllness",
        "description" : "HL7-defined code system of concepts which specify the ranking of a patient’s illness.  Used in HL7 Version 2 messaging in the ABS segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0422"
        },
        "name" : "triageType",
        "description" : "HL7-defined code system of concepts which specify a patient’s prioritization within the context of a transmitted abstract. Used in HL7 Version 2 messaging in the ABS segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0423"
        },
        "name" : "caseCategory",
        "description" : "HL7-defined code system of concepts which specify reasons that a non-urgent patient presents to the Emergency Room for treatment instead of a clinic or physician office.  Used in HL7 Version 2 messaging in the ABS segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0424"
        },
        "name" : "gestationCategory",
        "description" : "HL7-defined code system of concepts which specify the status of a birth in relation to the gestation.  Used in HL7 Version 2 messaging in the ABS segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0425"
        },
        "name" : "newbornType",
        "description" : "HL7-defined code system of concepts which specify whether the baby was born in or out of a specified facility.  Used in HL7 Version 2 messaging in the ABS segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0426"
        },
        "name" : "bloodProduct",
        "description" : "HL7-defined code system of concepts which specify a type of blood product.  Used in HL7 Version 2 messaging in the BLC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0427"
        },
        "name" : "riskManagementIncident",
        "description" : "HL7-defined code system of concepts which specify a type of incident that occurs during a patient’s stay.  Used in HL7 Version 2 messaging in the RMI segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0428"
        },
        "name" : "incidentType",
        "description" : "HL7-defined code system of concepts which specify a classification of types of incidents.  Used in HL7 Version 2 messaging in the RMI segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0429"
        },
        "name" : "productionClass",
        "description" : "Code system of concepts  specifying the code and/or text indicating the primary use for which the living subject was bred or grown.  Used in HL7 Version 2.x messaging in the PID segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0430"
        },
        "name" : "arrivalMode",
        "description" : "Code system of concepts specifying how the patient was brought to the healthcare facility.  Used in HL7 Version 2.x messaging in the PV2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0431"
        },
        "name" : "recreationalDrugType",
        "description" : "Code system of concepts specifying what recreational drugs the patient uses.  Used in HL7 Version 2.x messaging in the PV2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0432"
        },
        "name" : "admissionLevelOfCare",
        "description" : "Code system of concepts  specifying the acuity level assigned to the patient at the time of admission.  Used in HL7 Version 2.x messaging in the PV2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0433"
        },
        "name" : "precaution",
        "description" : "Code system of concepts  specifying non-clincal precautions that need to be taken with the patient.  Used in HL7 Version 2.x messaging in the PV2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0434"
        },
        "name" : "patientCondition",
        "description" : "Code system of concepts specifying the patient's current medical condition for the purpose of communicating to non-medical outside parties, e.g. family, employer, religious minister, media, etc.  Used in HL7 Version 2.x messaging in the PV2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0435"
        },
        "name" : "advanceDirective",
        "description" : "Code system of concepts specifying the patient's instructions to the healthcare facility.  Used in HL7 Version 2.x messaging in the PV2 and PD1 segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0436"
        },
        "name" : "sensitivityToCausativeAgent",
        "description" : "Code system of concepts specifying the reason the patient should not be exposed to a substance.  Used in HL7 Version 2.x messaging in the IAM segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0437"
        },
        "name" : "alertDevice",
        "description" : "Code system of concepts specifying any type of allergy alert device the patient may be carrying or wearing.  Used in HL7 Version 2.x messaging in the IAM segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0438"
        },
        "name" : "allergyClinicalStatus",
        "description" : "Code system of concepts specifying the verification status for the allergy.  Used in HL7 Version 2.x messaging in the IAM segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0440"
        },
        "name" : "dataTypes",
        "description" : "HL7-defined code system of concepts specifying the format of the observation value in the Observation Result (OBX).   Used in HL7 Version 2.x messaging in the OBX, OM1, OM3 and OMC segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0441"
        },
        "name" : "immunizationRegistryStatus",
        "description" : "Code system of concepts specifying the immunization registry status of the patient.  Used in HL7 Version 2.x messaging in the PD1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0442"
        },
        "name" : "locationServiceType",
        "description" : "Code system of concepts  specifying the types of services provided by the location.  Used in HL7 Version 2.x messaging in the LOC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0443"
        },
        "name" : "providerRole",
        "description" : "Code system of concepts specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).  Used in HL7 Version 2.x messaging in the ROL segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0444"
        },
        "name" : "nameAssemblyOrder",
        "description" : "Code system of concepts specifying the preferred display order of the components of this person name.  Used in HL7 Version 2.x messaging in the PPN, XCN and XPN segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0445"
        },
        "name" : "identityReliability",
        "description" : "Code system of concepts specifying the reliability of patient/person identifying data transmitted via a transaction.  Used in HL7 Version 2.x messaging in the PID segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0450"
        },
        "name" : "eventType",
        "description" : "HL7-defined code system of concepts specifying the type of event of the message.  Used in HL7 Version 2.x messaging in the EQP segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0457"
        },
        "name" : "overallClaimDisposition",
        "description" : "Code system of concepts specifying the final status of the claim.  Used in HL7 Version 2.x messaging in the GP1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0465"
        },
        "name" : "name-addressRepresentation",
        "description" : "HL7-defined code system of concepts specifying an indication of the representation provided by the data item.  Used in HL7 Version 2.x messaging in the PPN, XAD, XCN and XON segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0466"
        },
        "name" : "ambulatoryPaymentClassification",
        "description" : "Code system of concepts specifying the derived Ambulatory Payment Classification (APC) code.  Used in HL7 Version 2.x messaging in the GP2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0468"
        },
        "name" : "paymentAdjustmentInformation",
        "description" : "Code system of concepts specifying any payment adjustment due to drugs or medical devices.  Used in HL7 Version 2.x messaging in the GP2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0469"
        },
        "name" : "packagingStatus",
        "description" : "Code system of concepts specifying the packaging status of the service.  Used in HL7 Version 2.x messaging in the GP2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0470"
        },
        "name" : "reimbursementType",
        "description" : "Code system of concepts specifying the fee schedule reimbursement type applied to the line item.  Used in HL7 Version 2.x messaging in the GP2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0472"
        },
        "name" : "tqConjunctionId",
        "description" : "HL7-defined code system of concepts specifying that a second timing specification is to follow using the repeat delimiter.  Used in HL7 Version 2.x messaging in the TQ1 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0473"
        },
        "name" : "formularyStatus",
        "description" : "Code system of concepts specifying whether or not the service (pharmaceutical) is in the formulary.  Used in HL7 Version 2.x messaging in the OM7 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0474"
        },
        "name" : "organizationUnitType",
        "description" : "Code system of concepts specifying the classification of the organization unit.  Used in HL7 Version 2.x messaging in the ORG segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0475"
        },
        "name" : "chargeTypeReason",
        "description" : "Code system of concepts specifying the choice of, and providing the clinical rationale for, a selected charge type.  Used in HL7 Version 2.x messaging in the BLG segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0477"
        },
        "name" : "controlledSubstanceSchedule",
        "description" : "Code system of concepts specifying the class of the drug or other substance if its usage is controlled by legislation.  In the USA, such legislation includes the federal Controlled Substance Act (CSA) or a State Uniform Controlled Substance Act. Other countries should create their own versions of this table.  Used in HL7 Version 2.x messaging in the RXE segment.  The name of the table is taken from the Pharmacy Law Digest July 1988."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0478"
        },
        "name" : "formularyStatus",
        "description" : "HL7-defined code system of concepts specifying whether or not the pharmaceutical substance is part of the local formulary.  Used in HL7 Version 2.x messaging in the RXE segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0480"
        },
        "name" : "pharmacyOrderTypes",
        "description" : "HL7-defined code system of concepts specifying the general category of pharmacy order which may be used to determine the processing path the order will take.  Used in HL7 Version 2.x messaging in the RXO, RXE, RXD, RXG and RXA segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0482"
        },
        "name" : "orderType",
        "description" : "HL7-defined code system of concepts specifying whether the order is to be executed in an inpatient setting or an outpatient setting.  Used in HL7 Version 2.x messaging in the ORC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0483"
        },
        "name" : "authorizationMode",
        "description" : "HL7-defined code system of concepts of forms of authorization a recorder may receive from the responsible practitioner to create or change an order.  Used in HL7 Version 2.x messaging in the ORC segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0484"
        },
        "name" : "dispenseType",
        "description" : "Code system of concepts specifying the type of dispensing event that occurred.  Used in HL7 Version 2.x messaging in the RXD segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0485"
        },
        "name" : "extendedPriorityCodes",
        "description" : "Code system of concepts describing the urgency of a request carried in an order.  Used in HL7 Version 2.x messaging in timing/quantity; in older versions of the Standard was used in the TQ datatype, but in later versions it is used in the TQ1 segment (which replaced the TQ datatype which has been withdrawn)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0487"
        },
        "name" : "specimenType",
        "description" : "HL7-defined code system of concepts that describe the precise nature of an entity that may be used as the source material for an observation.  This is one of two code systems that are used instead of table 0070 (code system 2.16.840.1.113883.18.28) which conflated specimen types and specimen collection methods.   Used in HL7 Version 2.x messaging in the SPM segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0488"
        },
        "name" : "specimenCollectionMethod",
        "description" : "HL7-defined code system of concepts specifying the specimen collection method.  Used in HL7 Version 2.x messaging in the SPM segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0489"
        },
        "name" : "risks",
        "description" : "Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient.  Used in HL7 Version 2.x messaging in the SPM and PAC segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0490"
        },
        "name" : "specimenRejectReason",
        "description" : "HL7-defined code system of reasons a specimen may be rejected for a specified observation/result/analysis.  Used in HL7 Version 2.x messaging in the SPM segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0491"
        },
        "name" : "specimenQuality",
        "description" : "Code system of concepts specifying the degree or grade of excellence of the specimen at receipt.  Used in HL7 Version 2.x messaging in the SPM segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0492"
        },
        "name" : "specimenAppropriateness",
        "description" : "Code system of concepts specifying the suitability of the specimen for the particular planned use as determined by the filler.  Used in HL7 Version 2.x messaging in the SPM segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0493"
        },
        "name" : "specimenCondition",
        "description" : "Code system of concepts specifying a mode or state of being that describes the nature of the specimen.  Used in HL7 Version 2.x messaging in the SPM segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0494"
        },
        "name" : "specimenChildRole",
        "description" : "HL7-defined code system of concepts specifying for child specimens the relationship between this specimen and the parent specimen.  Used in HL7 Version 2.x messaging in the SPM segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0495"
        },
        "name" : "bodySiteModifier",
        "description" : "HL7-defined code system of concepts specifying the modifier for the body site.  Used in HL7 Version 2.x messaging in the RXR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0496"
        },
        "name" : "consentType",
        "description" : "Code system of concepts specifying to what the subject is consenting, i.e. what type of service, surgical procedure, information access/release or other event.  Used in HL7 Version 2.x messaging in the TXA and CON segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0497"
        },
        "name" : "consentMode",
        "description" : "HL7-defined code system of concepts specifying the method in which a subject provides consent.  Used in HL7 Version 2.x messaging in the TXA and CON segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0498"
        },
        "name" : "consentStatus",
        "description" : "HL7-code system of concepts specifying whether the consent has been sought and granted.  Used in HL7 Version 2.x messaging in the TXA and CON segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0499"
        },
        "name" : "consentBypassReason",
        "description" : "Code system of concepts specifying the reason the subject's consent was not sought.  Used in HL7 Version 2.x messaging in the CON segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0500"
        },
        "name" : "consentDisclosureLevel",
        "description" : "HL7-defined code system of concepts specifying how much information was disclosed to the subject as part of the informed consent process.  Used in HL7 Version 2.x messaging in the CON segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0501"
        },
        "name" : "consentNon-disclosureReason",
        "description" : "Code system of concepts used to specify a reason the subject did not receive full disclosure.  Used in the Consent (CON) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0502"
        },
        "name" : "non-subjectConsenterReason",
        "description" : "HL7-defined  code system of concepts used to specify a reason consent was granted by a person other than the subject of the consent.  Used in the Consent (CON) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0503"
        },
        "name" : "sequenceResultsFlag",
        "description" : "HL7-defined  code system of concepts used to specify the sequencing relationship between the current service request and the related service request(s) specified in this TQ2 segment.  Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0504"
        },
        "name" : "sequenceCondition",
        "description" : "HL7-defined code system of concepts used to specify the relationship between the start/end of the related service request(s) (from TQ2-3, TQ2-4 or TQ2-5) and the current service request from ORC-2, 3 or 4.  Used in HL7 Version 2.x messaging in the TQ2 segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0505"
        },
        "name" : "cyclicEntryExitIndicator",
        "description" : "HL7-defined code system of concepts used to specify if this service request is the first or last service request in a cyclic series of service requests.  Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0506"
        },
        "name" : "serviceRequestRelationship",
        "description" : "HL7-defined code system of concepts used to specify an additional or alternate relationship between this service request and other service requests.  Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0507"
        },
        "name" : "observationResultHandling",
        "description" : "Code system of concepts regarding the handling of a result.  For example, an order may specify that the result (e.g., an x-ray film) should be given to the patient for return to the requestor.   Used in HL7 Version 2.x messaging in the OBR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0508"
        },
        "name" : "bloodProductProcessingRequirements",
        "description" : "Code system of concepts used to specify additional information about the blood component class associated with the Universal Service ID.  The placer of the order can specify any required processing of the blood product that must be completed prior to transfusion to the intended recipient.  Used in the Blood Product Order (BPO) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0510"
        },
        "name" : "bloodProductDispenseStatus",
        "description" : "HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the filler or placer.  For example, the first status change of a product that may trigger a Blood Product Dispense Status Message occurs when it first becomes linked to a patient and is ready to dispense. The placer system may use the Blood Product Dispense Status Message to request the transfusion service to dispense the product.  When the blood product is delivered or issued to a patient, the status of the blood product would be changed to indicate that it has now been \"dispensed\".  Used in the Blood Product Dispense Status (BPX) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0511"
        },
        "name" : "bpObservationStatusCodesInterpretation",
        "description" : "HL7-defined code system of concepts used to specify the interpretation for the blood product observation status codes.  A status is considered preliminary until a blood product has reached a final disposition for the patient. For example, when the product is first cross-matched and a status message is sent, it would be considered preliminary. When the product is dispensed to the patient, that status would also be considered preliminary.  However, once the product is transfused, the status would be considered final.  Used in the Blood Product Dispense Status (BPX) and Blood Product Transfusion/Disposition (BTX) segments in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0513"
        },
        "name" : "bloodProductTransfusion-dispositionStatus",
        "description" : "HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the placer.  For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood component may have been entered, but the line was clogged and could not be used, in which case the component must be wasted. A final status would indicate that the product has actually been \"transfused.\"  Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0514"
        },
        "name" : "transfusionAdverseReaction",
        "description" : "Code system of concepts used to specify the type of adverse reaction that the recipient of the blood product experienced.  Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0516"
        },
        "name" : "errorSeverity",
        "description" : "HL7-defined code system of concepts specifying the severity of an application error as reported during acknowledgment of messages. Knowing if something is Error, Warning or Information is intrinsic to how an application handles the content and the information flow.  Used in HL7 Version 2.x messaging acknowledgment in the ERR segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0517"
        },
        "name" : "informInstructions",
        "description" : "Code system of concepts specifying who (if anyone) should or should not be informed of an error.  Used in the Error (ERR) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0518"
        },
        "name" : "overrideType",
        "description" : "Code system of concepts used to specify what type of override can be used to override the specific error identified.   Used in HL7 Version 2 messaging in the ERR and OVR segments."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0520"
        },
        "name" : "messageWaitingPriority",
        "description" : "HL7-defined code system of concepts which specify the disposition of the patient at time of discharge (i.e., discharged to home, expired, etc.).  Used in HL7 Version 2.x messaging in the MSA segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0523"
        },
        "name" : "computationType",
        "description" : "HL7-defined code system of concepts used to specify if the change is computed as a percent change or as an absolute change.  Used in the Delta (DLT) segment in HL7 Version 2.x messaging."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0524"
        },
        "name" : "sequenceCondition",
        "description" : "HL7-defined code system of concepts that identify whether sequence conditions or a repeating cycle of orders is defined.   This is part of the Order Sequence Definition used in HL7 Version 2.x messaaging in the OSD datatype."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0527"
        },
        "name" : "calendarAlignment",
        "description" : "HL7-defined code system of concepts used to specify an alignment of the repetition to a calendar (e.g., to distinguish every 30 days from \"the 5th of every month\").  Used in HL7 Version 2 messaging in the RPT segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0528"
        },
        "name" : "eventRelatedPeriod",
        "description" : "HL7-defined code system of concepts specifying a common (periodical) activity of daily living.  Used in HL7 Version 2 messaging in the RPT segment."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v2-0529"
        },
        "name" : "precision",
        "description" : "HL7-defined code system of concepts specifying the degree of precision of the time stamp (Y = year, L = month, D = day, H = hour, M = minute, S = second).  Used in HL7 Version 2 messaging in the TS datatype.  Note deprecated in 2.5.1 and retained only for backward compatibility, as the datatypes and architecture for the degree of precision for timestamps was changed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/t