# SnodentOralCavityAreaInternational - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SnodentOralCavityAreaInternational**

## ValueSet: SnodentOralCavityAreaInternational 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-SnodentOralCavityAreaInternational | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SnodentOralCavityAreaInternational |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20569 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The SNODENT identifiers for regions in the mouth utilized to calculate the Salzmann Malocclusion Severity Index. 
This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. 
http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent 
**Steward:** Attachments WG 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-SnodentOralCavityAreaInternational",
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "att"
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/v3-SnodentOralCavityAreaInternational",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20569"
    }
  ],
  "version" : "3.0.0",
  "name" : "SnodentOralCavityAreaInternational",
  "title" : "SnodentOralCavityAreaInternational",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The SNODENT identifiers for regions in the mouth utilized to calculate the Salzmann Malocclusion Severity Index.\r\n\r\nThis value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA.\r\n\r\nhttp://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent\r\n\r\n*Steward:* Attachments WG",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://www.ada.org/snodent",
        "concept" : [
          {
            "code" : "210963D"
          },
          {
            "code" : "210964D"
          },
          {
            "code" : "210965D"
          },
          {
            "code" : "210966D"
          }
        ]
      }
    ]
  }
}

```
