# QualityMeasureSectionType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QualityMeasureSectionType**

## ValueSet: QualityMeasureSectionType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-QualityMeasureSectionType | *Version*:3.0.0 | |
| Active as of 2014-03-14 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:QualityMeasureSectionType |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20364 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A type of document section within a health quality measure (aka eMeasure), used to cluster the various parts of the eMeasure into a more human navigable format. 

 **References** 

* Included into [DocumentSectionType](ValueSet-v3-DocumentSectionType.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-QualityMeasureSectionType",
  "url" : "http://terminology.hl7.org/ValueSet/v3-QualityMeasureSectionType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20364"
    }
  ],
  "version" : "3.0.0",
  "name" : "QualityMeasureSectionType",
  "title" : "QualityMeasureSectionType",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-14",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A type of document section within a health quality measure (aka eMeasure), used to cluster the various parts of the eMeasure into a more human navigable format.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "57025-9"
          },
          {
            "code" : "57026-7"
          },
          {
            "code" : "57027-5"
          }
        ]
      }
    ]
  }
}

```
