# NonDrugAgentEntity - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NonDrugAgentEntity**

## ValueSet: NonDrugAgentEntity 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-NonDrugAgentEntity | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:NonDrugAgentEntity |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.19699 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Indicates types of allergy and intolerance agents which are non-drugs. (E.g. foods, latex, etc.) 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-NonDrugAgentEntity",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-NonDrugAgentEntity",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.19699"
    }
  ],
  "version" : "3.0.0",
  "name" : "NonDrugAgentEntity",
  "title" : "NonDrugAgentEntity",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Indicates types of allergy and intolerance agents which are non-drugs. (E.g. foods, latex, etc.)",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityCode",
        "concept" : [
          {
            "code" : "NDA01"
          },
          {
            "code" : "NDA02"
          },
          {
            "code" : "NDA03"
          },
          {
            "code" : "NDA04"
          },
          {
            "code" : "NDA05"
          },
          {
            "code" : "NDA06"
          },
          {
            "code" : "NDA07"
          },
          {
            "code" : "NDA08"
          },
          {
            "code" : "NDA09"
          },
          {
            "code" : "NDA10"
          },
          {
            "code" : "NDA11"
          },
          {
            "code" : "NDA12"
          },
          {
            "code" : "NDA13"
          },
          {
            "code" : "NDA14"
          },
          {
            "code" : "NDA15"
          },
          {
            "code" : "NDA16"
          },
          {
            "code" : "NDA17"
          }
        ]
      }
    ]
  }
}

```
