# pan-Canadian Provider Types - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **pan-Canadian Provider Types**

## NamingSystem: pan-Canadian Provider Types 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-scptype | *Version*:3.1.0 | |
| Active as of 2019-03-20 | *Responsible:*Canada Health Infoway | *Computable Name*:Scptype |

 
SCPTYPE is used to encode and categorize an entity that delivers health care in an expected and professional manner to an entity in need of health care services. Examples: Registered Nurse, Chiropractor, Physician, Custodial Care Clinic. Allows for the implementation of role-based access to clinical functions and data. Provisioning of clinical services is based on the role that a provider may play in the health system. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-scptype",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-scptype",
  "version" : "3.1.0",
  "name" : "Scptype",
  "title" : "pan-Canadian Provider Types",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "Canada Health Infoway",
  "contact" : [
    {
      "name" : "Canada Health Infoway",
      "telecom" : [
        {
          "system" : "email",
          "value" : "standards@infoway-inforoute.ca"
        }
      ]
    }
  ],
  "responsible" : "Canada Health Infoway",
  "description" : "SCPTYPE is used to encode and categorize an entity that delivers health care in an expected and professional manner to an entity in need of health care services. Examples: Registered Nurse, Chiropractor, Physician, Custodial Care Clinic. Allows for the implementation of role-based access to clinical functions and data. Provisioning of clinical services is based on the role that a provider may play in the health system.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.2.20.5.3",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://fhir.infoway-inforoute.ca/CodeSystem/scptype",
      "preferred" : true
    }
  ]
}

```
