# Human Genome Variation Society nomenclature - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Human Genome Variation Society nomenclature**

## NamingSystem: Human Genome Variation Society nomenclature 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-hgvs | *Version*:2.1.0 | |
| Active as of 2019-03-20 | *Responsible:*HUGO Gene Nomenclature Committee | *Computable Name*:Hgvs |

 
HGVS nomenclatures are the guidelines for mutation nomenclature made by the Human Genome Variation Society. 

| | | | |
| :--- | :--- | :--- | :--- |
| HGVS nomenclature can be used with the HL7 coded data type (code data type that accepts expression data, or a coded expression data type). This coded data type should be able to distinguish expressions in HGVS nomenclature from coded concepts. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, HGVS nomenclature can be used to as the observation values for DNA sequence variations. For example, OBX | 1 | CWE | 48004-6^DNA Sequence Variation^LN |

 

| |
| :--- |
| c.1129C>T^^HGVS |

 
Versioning information: The HGVS nomenclature for the description of sequence variants was last modified Feb 20, 2008. The HGVS nomenclature for the description of protein sequence variants was last modified May 12, 2007. The HGVS nomenclature for the description of DNA sequence variants was last modified June 15, 2007 The HGVS nomenclature for the description of RNA sequence variants was last modified May 12, 2007 
HGVS nomenclatures can be used freely by the public. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-hgvs",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-hgvs",
  "version" : "2.1.0",
  "name" : "Hgvs",
  "title" : "Human Genome Variation Society nomenclature",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "HUGO Gene Nomenclature Committee",
  "responsible" : "HUGO Gene Nomenclature Committee",
  "description" : "HGVS nomenclatures are the guidelines for mutation nomenclature made by the Human Genome Variation Society.\r\n\r\nHGVS nomenclature can be used with the HL7 coded data type (code data type that accepts expression data, or a coded expression data type). This coded data type should be able to distinguish expressions in HGVS nomenclature from coded concepts. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, HGVS nomenclature can be used to as the observation values for DNA sequence variations. For example, OBX|1|CWE|48004-6^DNA Sequence Variation^LN||c.1129C>T^^HGVS|\r\n\r\nVersioning information: The HGVS nomenclature for the description of sequence variants was last modified Feb 20, 2008. The HGVS nomenclature for the description of protein sequence variants was last modified May 12, 2007. The HGVS nomenclature for the description of DNA sequence variants was last modified June 15, 2007 The HGVS nomenclature for the description of RNA sequence variants was last modified May 12, 2007\r\n\r\nHGVS nomenclatures can be used freely by the public.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.282",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://varnomen.hgvs.org",
      "preferred" : true
    }
  ]
}

```
