# Nursing Management Minimum Data Set - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nursing Management Minimum Data Set**

## NamingSystem: Nursing Management Minimum Data Set 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/nmmds | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*The University of Iowa, College of Nursing | *Computable Name*:Nmmds |

 
The NMMDS is the minimum set of items of information with uniform definitions and categories concerning the specific dimension of the context of patient care delivery. It represents the minimum data used to support the management and administration of patient/nursing care delivery across all types of settings. The NMMDS is composed of seventeen (17) data elements organized into three categories: environment, nurse resources, and financial resources. See Tables 1-3 for the elements and related definitions organized by each categories. The NMMDS most appropriately focuses at the first level of accountability for patient/client/family/community nursing care: this may be the delivery unit, service, or center of excellence level. The NMMDS supports numerous constructed variables as well as aggregation of data at the unit, institution, network, and system, etc levels. This minimum data set provides the structure for the collection of uniform information that influences quality of patient care, directly and indirectly. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "nmmds",
  "url" : "http://terminology.hl7.org/NamingSystem/nmmds",
  "version" : "2.1.0",
  "name" : "Nmmds",
  "title" : "Nursing Management Minimum Data Set",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "The University of Iowa, College of Nursing",
  "contact" : [
    {
      "name" : "Connie Delaney, PhD, RN, FAAN and Diane Huber, PhD, RN, FAAN"
    }
  ],
  "responsible" : "The University of Iowa, College of Nursing",
  "description" : "The NMMDS is the minimum set of items of information with uniform definitions and categories concerning the specific dimension of the context of patient care delivery. It represents the minimum data used to support the management and administration of patient/nursing care delivery across all types of settings. The NMMDS is composed of seventeen (17) data elements organized into three categories: environment, nurse resources, and financial resources. See Tables 1-3 for the elements and related definitions organized by each categories. The NMMDS most appropriately focuses at the first level of accountability for patient/client/family/community nursing care: this may be the delivery unit, service, or center of excellence level. The NMMDS supports numerous constructed variables as well as aggregation of data at the unit, institution, network, and system, etc levels. This minimum data set provides the structure for the collection of uniform information that influences quality of patient care, directly and indirectly.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.23",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/nmmds",
      "preferred" : true
    }
  ]
}

```
